/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.loginspector;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.loginspector.DateFilterPanel;
import oracle.dbtools.raptor.timesten.grid.loginspector.InstanceLogWrapper;
import oracle.dbtools.raptor.timesten.grid.loginspector.LogFilter;
import oracle.dbtools.raptor.timesten.grid.loginspector.MsgFilterPanel;
import oracle.dbtools.raptor.timesten.grid.loginspector.PIDFilterPanel;
import oracle.dbtools.raptor.timesten.grid.loginspector.ProgramNameFilterPanel;
import oracle.dbtools.raptor.timesten.grid.loginspector.SeverityFilterPanel;
import oracle.dbtools.raptor.timesten.grid.loginspector.TTLogEntryFilterPanel;
import oracle.javatools.icons.OracleIcons;

public class LogMainFilterPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected List<InstanceLogWrapper> instanceLogs;
    private JButton addFilter;
    private ArrayList<TTLogEntryFilterPanel> filters;
    private ArrayList<TTLogEntryFilterPanel> filtersApplied;
    private JComboBox<String> filterChoice;
    private JPanel filtersPanel;
    private JLabel filterOnLbl;
    private TTLogEntryFilterPanel severityFilter;
    private LogFilter latestFilter = LogFilter.getFilterObjectInstance();
    private JButton okBtn;
    private static final String[] FILTER_TYPES = new String[]{Messages.getString("TimesTenGrid.LogDate"), Messages.getString("TimesTenGrid.LogPID"), Messages.getString("TimesTenGrid.LogProgName"), Messages.getString("TimesTenGrid.LogMsg")};

    public JButton getOkBtn() {
        return this.okBtn;
    }

    public LogMainFilterPanel() {
        this.setLayout(new GridBagLayout());
        this.filters = new ArrayList();
        this.filtersApplied = new ArrayList();
        this.addFilter = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.filtersPanel = new JPanel(new GridBagLayout());
        this.filtersPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.filterChoice = new JComboBox();
        this.filterOnLbl = new JLabel(Messages.getString("TimesTenGrid.LogFilterOn"));
        this.okBtn = new JButton(Messages.getString("TimesTenGrid.validAttribute"));
        for (String string : FILTER_TYPES) {
            this.filterChoice.addItem(string);
        }
        this.add((Component)this.filterOnLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add(this.filterChoice, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.addFilter, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 24, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JScrollPane(this.filtersPanel), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addFilter.addActionListener(actionEvent2 -> {
            String string = this.filterChoice.getSelectedItem().toString();
            TTLogEntryFilterPanel tTLogEntryFilterPanel = null;
            if (string.equalsIgnoreCase(FILTER_TYPES[0])) {
                tTLogEntryFilterPanel = new DateFilterPanel();
            } else if (string.equalsIgnoreCase(FILTER_TYPES[1])) {
                tTLogEntryFilterPanel = new PIDFilterPanel();
            } else if (string.equalsIgnoreCase(FILTER_TYPES[2])) {
                tTLogEntryFilterPanel = new ProgramNameFilterPanel();
            } else if (string.equalsIgnoreCase(FILTER_TYPES[3])) {
                tTLogEntryFilterPanel = new MsgFilterPanel();
            }
            tTLogEntryFilterPanel.getRemoveThisFilterButton().addActionListener(actionEvent -> {
                TTLogEntryFilterPanel tTLogEntryFilterPanel = (TTLogEntryFilterPanel)((JButton)actionEvent.getSource()).getParent();
                this.removeFocusedFilterPanel(tTLogEntryFilterPanel);
            });
            this.filters.add(tTLogEntryFilterPanel);
            this.updateFilterPanel();
        });
        this.severityFilter = new SeverityFilterPanel();
        this.severityFilter.getRemoveThisFilterButton().setEnabled(false);
        this.filters.add(this.severityFilter);
        this.filtersApplied.add(this.severityFilter);
        this.updateFilterPanel();
        this.setNames();
    }

    private void removeFocusedFilterPanel(TTLogEntryFilterPanel tTLogEntryFilterPanel) {
        this.filters.remove(tTLogEntryFilterPanel);
        this.filtersPanel.remove(tTLogEntryFilterPanel);
        this.updateFilterPanel();
    }

    private void updateFilterPanel() {
        for (TTLogEntryFilterPanel tTLogEntryFilterPanel : this.filters) {
            this.filtersPanel.remove(tTLogEntryFilterPanel);
        }
        for (int i = 0; i < this.filters.size(); ++i) {
            this.filtersPanel.add((Component)this.filters.get(i), new GridBagConstraints(0, i, 1, 1, 1.0, i == this.filters.size() - 1 ? 1.0 : 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.filtersPanel.revalidate();
        this.filtersPanel.repaint();
    }

    protected boolean isValidFilter() {
        boolean bl = true;
        for (TTLogEntryFilterPanel tTLogEntryFilterPanel : this.filters) {
            if (!tTLogEntryFilterPanel.addFilterToLatest()) {
                tTLogEntryFilterPanel.setBorder(BorderFactory.createLineBorder(Color.red));
                bl = false;
                continue;
            }
            tTLogEntryFilterPanel.setBorder(BorderFactory.createEmptyBorder());
        }
        if (bl) {
            this.latestFilter.clearFilter();
            for (TTLogEntryFilterPanel tTLogEntryFilterPanel : this.filters) {
                if (!tTLogEntryFilterPanel.addFilterToLatest()) {
                    tTLogEntryFilterPanel.setBorder(BorderFactory.createLineBorder(Color.red));
                    bl = false;
                    continue;
                }
                tTLogEntryFilterPanel.setBorder(BorderFactory.createEmptyBorder());
            }
            this.filtersApplied.clear();
            this.filtersApplied.addAll(this.filters);
            this.latestFilter.saveFilter();
        }
        return bl;
    }

    public void restoreFilterPanels() {
        for (TTLogEntryFilterPanel tTLogEntryFilterPanel : this.filters) {
            this.filtersPanel.remove(tTLogEntryFilterPanel);
        }
        for (int i = 0; i < this.filtersApplied.size(); ++i) {
            this.filtersPanel.add((Component)this.filtersApplied.get(i), new GridBagConstraints(0, i, 1, 1, 1.0, i == this.filtersApplied.size() - 1 ? 1.0 : 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.filtersPanel.revalidate();
        this.filtersPanel.repaint();
        this.filters.clear();
        this.filters.addAll(this.filtersApplied);
    }

    protected void clearInvalidFilters() {
        for (int i = this.filters.size() - 1; i >= 0; --i) {
            TTLogEntryFilterPanel tTLogEntryFilterPanel = this.filters.get(i);
            if (tTLogEntryFilterPanel.addFilterToLatest()) continue;
            this.filters.remove(i);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    private void setNames() {
        this.addFilter.setName("addFilter");
        this.filterChoice.setName("filterChoice");
        this.filterOnLbl.setName(Messages.getString("TimesTenGrid.LogFilterOn"));
        this.okBtn.setName(Messages.getString("TimesTenGrid.validAttribute"));
    }
}

