/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.instance;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.logging.Logger;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.GridCommandExecutor;
import oracle.dbtools.raptor.timesten.grid.NewStandaloneHostPanel;
import oracle.dbtools.raptor.timesten.grid.TTGUIBasePanel;
import oracle.dbtools.raptor.timesten.grid.installations.InstallationCreatePanel;
import oracle.dbtools.raptor.timesten.grid.instance.NewInstancePanel;
import oracle.dbtools.raptor.timesten.grid.navigator.GridMouseListener;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstallationObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.nulls.NullPrintStream;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;

public class NewInstanceWizard
extends TTGUIBasePanel {
    private JLabel useExistingHostLbl;
    private JComboBox<HostObject> existingHostsCmb;
    private JButton newHostBtn;
    private JLabel useExistingInstallLbl;
    private JComboBox<InstallationObject> existingInstallCmb;
    private JButton newInstallBtn;
    private GridObject grid;
    private NewInstancePanel newInstancePanel;
    private NewStandaloneHostPanel newHostPanel;
    private InstallationCreatePanel newInstallPanel;
    private HostObject newHost;
    private InstallationObject newInstall;
    private Runnable updateInstallationsCmb;
    private InstallationObject dummy;
    private static final Logger _logger = Logger.getLogger(NewInstanceWizard.class.getName());
    private boolean createAsMgmtInstance;
    private boolean replaceMgmt;
    private boolean activeMgmt;
    private InstanceObject mgmtInstance;
    private InstanceObject mgmtStandby;
    private static final long serialVersionUID = 1L;

    public NewInstanceWizard(boolean bl) {
        this(bl, null);
    }

    public NewInstanceWizard(boolean bl, InstanceObject instanceObject) {
        this.replaceMgmt = instanceObject != null;
        this.mgmtInstance = instanceObject;
        this.createAsMgmtInstance = bl;
        this.dummy = new InstallationObject(null, " ");
        this.dummy.setLocation("");
        this.grid = TTGridRootNode.getInstance().getGrid(TTGridRootNode.getInstance().getCurrentGrid());
        this.initGUI();
        if (bl) {
            if (this.mgmtInstance != null) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)this, TimesTenHelpID.MGMT_INST_REPLACE.toString());
            } else {
                HelpSystem.getHelpSystem().registerTopic((JComponent)this, TimesTenHelpID.GRID_NEW_MGMT_INSTANCE.toString());
            }
        } else {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, TimesTenHelpID.GRID_NEW_DATA_INSTANCE.toString());
        }
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        this.newHost = new HostObject();
        this.newInstall = new InstallationObject(null, null);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.existingHostsCmb = new JComboBox();
        this.useExistingHostLbl = new JLabel(Messages.getString("TimesTenGrid.selectHost"));
        this.newHostBtn = new JButton(Messages.getString("TimesTenGrid.new"));
        for (HostObject object : this.grid.getHosts()) {
            this.existingHostsCmb.addItem(object);
        }
        jPanel.add((Component)this.useExistingHostLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add(this.existingHostsCmb, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 22, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.newHostBtn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 24, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.selectHost")));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.existingInstallCmb = new JComboBox();
        this.useExistingInstallLbl = new JLabel(Messages.getString("TimesTenGrid.selectInstallation"));
        this.newInstallBtn = new JButton(Messages.getString("TimesTenGrid.new"));
        for (InstallationObject installationObject : ((HostObject)this.existingHostsCmb.getSelectedItem()).getInstallations()) {
            this.existingInstallCmb.addItem(installationObject);
        }
        jPanel2.add((Component)this.useExistingInstallLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 25), 0, 0));
        jPanel2.add(this.existingInstallCmb, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 22, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.add((Component)this.newInstallBtn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 24, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.selectInstallation")));
        this.newInstancePanel = new NewInstancePanel((HostObject)this.existingHostsCmb.getSelectedItem(), this.createAsMgmtInstance);
        this.newHostBtn.addActionListener(actionEvent -> {
            this.newHostPanel = new NewStandaloneHostPanel();
            JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)this.newHostPanel, (String)Messages.getString("TimesTenGrid.newHost"), (ActionListener)this.newHostPanel);
            this.newHostPanel.setDialog(jEWTDialog);
            jEWTDialog.setButtonMask(6);
            Dimension dimension = new Dimension(450, 300);
            jEWTDialog.setSize(dimension);
            jEWTDialog.setMinimumSize(dimension);
            jEWTDialog.setPreferredSize(dimension);
            jEWTDialog.setMaximumSize(dimension);
            jEWTDialog.setDefaultCloseOperation(1);
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
            jEWTDialog.addCustomButton((Component)this.newHostPanel.getOkButton());
            this.newHostPanel.setHostInfo(this.newHost);
            this.newHostPanel.setIsStandAlone(false);
            jEWTDialog.setVisible(true);
            if (this.newHostPanel.isOkd()) {
                this.existingHostsCmb.removeAllItems();
                for (HostObject hostObject : this.grid.getHosts()) {
                    this.existingHostsCmb.addItem(hostObject);
                }
                this.existingHostsCmb.addItem(this.newHost);
                this.existingHostsCmb.setSelectedItem(this.newHost);
                this.updateInstallationsCmb.run();
                this.newInstancePanel.setDefaultInstanceInfo((HostObject)this.existingHostsCmb.getSelectedItem());
            }
        });
        this.existingHostsCmb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if ((HostObject)NewInstanceWizard.this.existingHostsCmb.getSelectedItem() != null) {
                    NewInstanceWizard.this.updateInstallationsCmb.run();
                    NewInstanceWizard.this.newInstancePanel.setDefaultInstanceInfo((HostObject)NewInstanceWizard.this.existingHostsCmb.getSelectedItem());
                }
            }
        });
        this.newInstallBtn.addActionListener(actionEvent -> {
            this.newInstallPanel = new InstallationCreatePanel((HostObject)this.existingHostsCmb.getSelectedItem());
            this.newInstall.setHost((HostObject)this.existingHostsCmb.getSelectedItem());
            JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)this.newInstallPanel, (String)Messages.getString("TimesTenGrid.newInstallation"), (ActionListener)this.newInstallPanel);
            this.newInstallPanel.setDialog(jEWTDialog);
            jEWTDialog.setButtonMask(6);
            Dimension dimension = new Dimension(500, 320);
            jEWTDialog.setSize(dimension);
            jEWTDialog.setMinimumSize(dimension);
            jEWTDialog.setPreferredSize(dimension);
            jEWTDialog.setMaximumSize(dimension);
            jEWTDialog.setDefaultCloseOperation(2);
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
            jEWTDialog.addCustomButton((Component)this.newInstallPanel.getOkButton());
            this.newInstallPanel.setInstallation(this.newInstall);
            jEWTDialog.setVisible(true);
            if (this.newInstallPanel.isOkd()) {
                this.updateInstallationsCmb.run();
                this.existingInstallCmb.addItem(this.newInstall);
                this.existingInstallCmb.setSelectedItem(this.newInstall);
            }
        });
        this.updateInstallationsCmb = () -> {
            this.existingInstallCmb.removeAllItems();
            if (!((HostObject)this.existingHostsCmb.getSelectedItem()).getInstallations().isEmpty()) {
                for (InstallationObject installationObject : ((HostObject)this.existingHostsCmb.getSelectedItem()).getInstallations()) {
                    this.existingInstallCmb.addItem(installationObject);
                }
            } else {
                this.existingInstallCmb.addItem(this.dummy);
            }
        };
        this.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.newInstancePanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 23, 1, new Insets(5, 5, 5, 5), 0, 0));
        if (this.replaceMgmt) {
            this.searchMgmtStandby();
        }
        this.setNames();
    }

    private void createInstance() {
        final CustomProgressMonitor customProgressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.creatingGridObjects"), MessageFormat.format(Messages.getString("TimesTenGrid.creatingGridObjects"), this.newInstancePanel.getName(), ((HostObject)this.existingHostsCmb.getSelectedItem()).getName()), null);
        customProgressMonitor.setCancellable(false);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
            boolean createDir;

            @Override
            protected Void doInBackground() throws Exception {
                customProgressMonitor.start();
                GridMouseListener.expander.saveExpansionState();
                HostObject hostObject = (HostObject)NewInstanceWizard.this.existingHostsCmb.getSelectedItem();
                InstallationObject installationObject = (InstallationObject)NewInstanceWizard.this.existingInstallCmb.getSelectedItem();
                boolean bl = hostObject == NewInstanceWizard.this.newHost;
                boolean bl2 = (InstallationObject)NewInstanceWizard.this.existingInstallCmb.getSelectedItem() == NewInstanceWizard.this.newInstall;
                this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.checkingInstanceLoc"));
                GridCommand gridCommand = GridCommand.PERL_CHECK_INSTANCE_LOCATION;
                gridCommand.prepareCommand(hostObject.getInternalAddress(), NewInstanceWizard.this.newInstancePanel.getInstanceLocation());
                try {
                    NewInstanceWizard.this.grid.getExecutor().executePerlScriptCommand(gridCommand, (OutputStream)new NullPrintStream());
                }
                catch (GridCommandException gridCommandException) {
                    int n = NewInstanceWizard.this.grid.getExecutor().getSSHChannel().getLastCommandExitStatus();
                    if (n == 4) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)MessageFormat.format(Messages.getString("TimesTenGrid.hostNotFoundNamed"), hostObject.getName()), (String)Messages.getString("TimesTenGrid.hostNotFoundTitle"), null);
                        this.firePropertyChange("error", null, Messages.getString("TimesTenGrid.hostNotFoundMessage"));
                        this.createDir = false;
                    } else {
                        this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.instanceLocError"));
                        this.createDir = TTGUIBasePanel.showLocationMissingWarning(NewInstanceWizard.this.newInstancePanel.getInstanceLocation(), hostObject.getName());
                    }
                    if (!this.createDir) {
                        this.cancel(true);
                        throw new Exception();
                    }
                    this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.creatingPath"), NewInstanceWizard.this.newInstancePanel.getInstanceLocation(), hostObject.getInternalAddress()));
                    gridCommand = GridCommand.CREATE_REMOTE_DIR;
                    gridCommand.prepareCommand(hostObject.getInternalAddress(), NewInstanceWizard.this.newInstancePanel.getInstanceLocation());
                    NewInstanceWizard.this.grid.getExecutor().executePerlScriptCommand(gridCommand, (OutputStream)new NullPrintStream());
                }
                try {
                    NewInstanceWizard.this._dialog.dispose();
                    if (bl) {
                        gridCommand = GridCommand.HOST_FULL_CREATE;
                        gridCommand.prepareHostCreateCommand(hostObject);
                        this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.creatingHost"), hostObject));
                        NewInstanceWizard.this.grid.getExecutor().executeCommandGetString(gridCommand, true);
                    }
                    if (bl2) {
                        this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.createinstallationcommand"));
                        gridCommand = GridCommand.INSTALLATION_CREATE_FULL;
                        gridCommand.prepareCommand(hostObject.getName(), installationObject.getLocation(), installationObject.getName(), installationObject.getSource());
                        NewInstanceWizard.this.grid.getExecutor().executeCommandGetString(gridCommand, false);
                    }
                    this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.executeCreateInstance"), NewInstanceWizard.this.newInstancePanel.getName()));
                    if (NewInstanceWizard.this.createAsMgmtInstance) {
                        gridCommand = GridCommand.MGMT_INSTANCE_CREATE;
                        gridCommand.prepareCommand(NewInstanceWizard.this.newInstancePanel.getName(), hostObject.getName(), NewInstanceWizard.this.newInstancePanel.getInstanceLocation(), installationObject.getName(), String.valueOf(NewInstanceWizard.this.newInstancePanel.getDaemonPort()), String.valueOf(NewInstanceWizard.this.newInstancePanel.getCSPort()), String.valueOf(NewInstanceWizard.this.newInstancePanel.getMgmtPort()));
                    } else {
                        gridCommand = GridCommand.INSTANCE_CREATE2;
                        gridCommand.prepareCommand(NewInstanceWizard.this.newInstancePanel.getName(), hostObject.getName(), NewInstanceWizard.this.newInstancePanel.getInstanceLocation(), installationObject.getName(), String.valueOf(NewInstanceWizard.this.newInstancePanel.getDaemonPort()), String.valueOf(NewInstanceWizard.this.newInstancePanel.getCSPort()));
                    }
                    NewInstanceWizard.this.grid.getExecutor().executeCommandGetString(gridCommand, true);
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.refreshingGrid"));
                    NewInstanceWizard.this.grid.refreshGridModels();
                    this.firePropertyChange("progress", null, 100);
                }
                catch (JsonException | GridCommandException throwable) {
                    this.firePropertyChange("error", null, throwable.getMessage());
                    this.cancel(true);
                }
                return null;
            }

            @Override
            protected void done() {
                customProgressMonitor.finish();
                if (!customProgressMonitor.successfulExecution() || this.isCancelled()) {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.instCreationCancelled"));
                    customProgressMonitor.updateMessage(Messages.getString("TimesTenGrid.instCreationCancelled"));
                } else {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskComplete"));
                    NewInstanceWizard.this.showModelNeedsApplyWarning();
                    GridMouseListener.expander.restoreExpansionState();
                }
            }
        };
        swingWorker.addPropertyChangeListener(customProgressMonitor);
        customProgressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    public void searchMgmtStandby() {
        final CustomProgressMonitor customProgressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), Messages.getString("TimestenGrid.SearchForStanby"), Messages.getString("TimestenGrid.searchStandby"), null);
        customProgressMonitor.setCancellable(false);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    customProgressMonitor.start();
                    this.firePropertyChange("message", null, Messages.getString("TimestenGrid.mgmtExamine"));
                    GridCommand gridCommand = GridCommand.MGMT_EXAMINE;
                    JsonObject jsonObject = NewInstanceWizard.this.grid.getExecutor().executeCommandGetJson(gridCommand, true);
                    NewInstanceWizard.this.grid.updateMgmInstancesModel(jsonObject);
                    if (NewInstanceWizard.this.grid.getAllMgmtInstances().size() < 2) {
                        NewInstanceWizard.this.mgmtStandby = null;
                    } else if (NewInstanceWizard.this.mgmtInstance.getType() != InstanceObject.ManagementInstanceRole.ACTIVE) {
                        NewInstanceWizard.this.mgmtStandby = NewInstanceWizard.this.grid.getNoActiveMgmt();
                        NewInstanceWizard.this.activeMgmt = false;
                    } else {
                        NewInstanceWizard.this.mgmtStandby = NewInstanceWizard.this.grid.getMgmtStandby();
                        NewInstanceWizard.this.activeMgmt = true;
                    }
                    if (NewInstanceWizard.this.mgmtStandby == null) {
                        throw new GridCommandException(Messages.getString("TimestenGrid.noActiveStandby"));
                    }
                    this.firePropertyChange("progress", null, 100);
                    customProgressMonitor.close();
                }
                catch (JsonException | GridCommandException throwable) {
                    this.firePropertyChange("error", null, throwable.getMessage());
                    customProgressMonitor.finish();
                    this.cancel(true);
                }
                return null;
            }

            @Override
            protected void done() {
                if (!customProgressMonitor.successfulExecution() || this.isCancelled()) {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskCancelled"));
                    customProgressMonitor.updateMessage(Messages.getString("TimesTenGrid.taskCancelled"));
                    NewInstanceWizard.this._dialog.dispose();
                }
            }
        };
        swingWorker.addPropertyChangeListener(customProgressMonitor);
        customProgressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    private void replaceMgmtInstance() {
        final CustomProgressMonitor customProgressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), Messages.getString("TimestenGrid.replaceMgmtTitle"), MessageFormat.format(Messages.getString("TimestenGrid.replacingMgmt"), this.mgmtInstance.getName()), null);
        customProgressMonitor.setCancellable(false);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
            boolean createDir;

            @Override
            protected Void doInBackground() throws Exception {
                customProgressMonitor.start();
                GridMouseListener.expander.saveExpansionState();
                HostObject hostObject = (HostObject)NewInstanceWizard.this.existingHostsCmb.getSelectedItem();
                InstallationObject installationObject = (InstallationObject)NewInstanceWizard.this.existingInstallCmb.getSelectedItem();
                boolean bl = hostObject == NewInstanceWizard.this.newHost;
                boolean bl2 = (InstallationObject)NewInstanceWizard.this.existingInstallCmb.getSelectedItem() == NewInstanceWizard.this.newInstall;
                GridCommandExecutor gridCommandExecutor = NewInstanceWizard.this.grid.getExecutor();
                GridCommandExecutor gridCommandExecutor2 = null;
                String string = null;
                char[] cArray = null;
                this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.checkingInstanceLoc"));
                GridCommand gridCommand = GridCommand.CHECK_REMOTE_DIR_IS_W;
                gridCommand.prepareCommand(hostObject.getInternalAddress(), NewInstanceWizard.this.newInstancePanel.getInstanceLocation());
                try {
                    gridCommandExecutor.executePerlScriptCommand(gridCommand, (OutputStream)new NullPrintStream());
                }
                catch (GridCommandException gridCommandException) {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.instanceLocError"));
                    this.createDir = TTGUIBasePanel.showLocationMissingWarning(NewInstanceWizard.this.newInstancePanel.getInstanceLocation(), hostObject.getName());
                    if (!this.createDir) {
                        this.cancel(true);
                        throw new Exception();
                    }
                    this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.creatingPath"), NewInstanceWizard.this.newInstancePanel.getInstanceLocation(), hostObject.getInternalAddress()));
                    gridCommand = GridCommand.CREATE_REMOTE_DIR;
                    gridCommand.prepareCommand(hostObject.getInternalAddress(), NewInstanceWizard.this.newInstancePanel.getInstanceLocation());
                    gridCommandExecutor.executePerlScriptCommand(gridCommand, (OutputStream)new NullPrintStream());
                }
                try {
                    NewInstanceWizard.this._dialog.dispose();
                    if (bl) {
                        gridCommand = GridCommand.HOST_FULL_CREATE;
                        gridCommand.prepareHostCreateCommand(hostObject);
                        this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.creatingHost"), hostObject));
                        gridCommandExecutor.executeCommandGetString(gridCommand, true);
                    }
                    if (bl2) {
                        this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.createinstallationcommand"));
                        gridCommand = GridCommand.INSTALLATION_CREATE_FULL;
                        gridCommand.prepareCommand(hostObject.getName(), installationObject.getLocation(), installationObject.getName(), installationObject.getSource());
                        gridCommandExecutor.executeCommandGetString(gridCommand, false);
                    }
                    if (NewInstanceWizard.this.activeMgmt) {
                        String string2 = NewInstanceWizard.this.mgmtStandby.getHost().getExternalAddress();
                        String string3 = NewInstanceWizard.this.mgmtStandby.getHome();
                        String string4 = NewInstanceWizard.this.grid.getExecutor().getWorkingHost().getInstanceAdmin();
                        cArray = NewInstanceWizard.this.grid.getExecutor().getWorkingHost().getPwd();
                        string = NewInstanceWizard.this.grid.getExecutor().getWorkingHost().getKeyFile();
                        gridCommandExecutor2 = GridCommandExecutor.getNewInstance(string2, string3, string4, cArray, string);
                        this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimestenGrid.mgmtActiveSwitch"), NewInstanceWizard.this.mgmtStandby.getName()));
                        gridCommand = GridCommand.MGMT_SWITCH;
                        gridCommandExecutor2.executeCommandGetJson(gridCommand, true);
                        NewInstanceWizard.this.grid.setExecutor(gridCommandExecutor2);
                        TTGridRootNode.getStorage().saveGrid(NewInstanceWizard.this.grid);
                    }
                    this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimestenGrid.executingDeleteInstance"), NewInstanceWizard.this.mgmtInstance.getName()));
                    gridCommand = GridCommand.INSTANCE_DELETE;
                    gridCommand.prepareCommand(NewInstanceWizard.this.mgmtInstance.getHost().getName(), NewInstanceWizard.this.mgmtInstance.getName());
                    if (NewInstanceWizard.this.activeMgmt) {
                        gridCommandExecutor2.executeCommandGetString(gridCommand, true);
                    } else {
                        gridCommandExecutor.executeCommandGetString(gridCommand, true);
                    }
                    this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.executeCreateInstance"), NewInstanceWizard.this.newInstancePanel.getName()));
                    gridCommand = GridCommand.MGMT_INSTANCE_CREATE;
                    gridCommand.prepareCommand(NewInstanceWizard.this.newInstancePanel.getName(), hostObject.getName(), NewInstanceWizard.this.newInstancePanel.getInstanceLocation(), installationObject.getName(), String.valueOf(NewInstanceWizard.this.newInstancePanel.getDaemonPort()), String.valueOf(NewInstanceWizard.this.newInstancePanel.getCSPort()), String.valueOf(NewInstanceWizard.this.newInstancePanel.getMgmtPort()));
                    if (NewInstanceWizard.this.activeMgmt) {
                        gridCommandExecutor2.executeCommandGetString(gridCommand, true);
                    } else {
                        gridCommandExecutor.executeCommandGetString(gridCommand, true);
                    }
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.refreshingGrid"));
                    if (NewInstanceWizard.this.activeMgmt) {
                        NewInstanceWizard.this.grid.setGridComponents(gridCommandExecutor2.executeCommandGetJson(GridCommand.EXPORT_MODEL, true), false);
                    } else {
                        NewInstanceWizard.this.grid.setGridComponents(gridCommandExecutor.executeCommandGetJson(GridCommand.EXPORT_MODEL, true), false);
                    }
                    this.firePropertyChange("progress", null, 100);
                }
                catch (JsonException | GridCommandException throwable) {
                    this.firePropertyChange("error", null, throwable.getMessage());
                    this.cancel(true);
                }
                return null;
            }

            @Override
            protected void done() {
                customProgressMonitor.finish();
                if (!customProgressMonitor.successfulExecution() || this.isCancelled()) {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskCancelled"));
                    customProgressMonitor.updateMessage(Messages.getString("TimesTenGrid.taskCancelled"));
                } else {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskComplete"));
                    customProgressMonitor.updateMessage(Messages.getString("TimesTenGrid.taskComplete"));
                    NewInstanceWizard.this.showModelNeedsApplyWarning();
                    GridMouseListener.expander.restoreExpansionState();
                }
            }
        };
        swingWorker.addPropertyChangeListener(customProgressMonitor);
        customProgressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._okButton) {
            boolean bl;
            if (!this.newInstancePanel.validInput()) {
                return;
            }
            if ((InstallationObject)this.existingInstallCmb.getSelectedItem() == this.dummy) {
                Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.installInvalid"));
                return;
            }
            boolean bl2 = bl = (InstallationObject)this.existingInstallCmb.getSelectedItem() == this.newInstall;
            if (bl && this.newInstall.getLocation().equalsIgnoreCase(this.newInstancePanel.getInstanceLocation())) {
                Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.sameInstDirInstallLoc"));
                return;
            }
            if (this.replaceMgmt) {
                this.replaceMgmtInstance();
            } else {
                this.createInstance();
            }
        }
    }

    private void setNames() {
        this.useExistingHostLbl.setName(Messages.getString("TimesTenGrid.selectHost"));
        this.existingHostsCmb.setName("existingHostsCmb");
        this.newHostBtn.setName(Messages.getString("TimesTenGrid.new"));
        this.useExistingInstallLbl.setName(Messages.getString("TimesTenGrid.selectInstallation"));
        this.existingInstallCmb.setName("existingInstallCmb");
        this.newInstallBtn.setName("newInstallBtn");
    }
}

