/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.editors;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;

public class InstanceStatusPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private InstanceObject instanceData;
    private final String[] HEADER = new String[]{Messages.getString("TimesTenGrid.attributeColumn"), Messages.getString("TimesTenGrid.valueColumn")};
    static final int INSTANCE_ROW = 0;
    static final int HOST_ROW = 1;
    static final int DAEMONS_ROW = 2;
    static final int SERVERS_ROW = 3;
    static final int ROLE_ROW = 4;
    static final int REPAGENTS_ROW = 5;
    static final int ATTR_COLUMN = 0;
    static final int VALUE_COLUMN = 1;
    static final int ROWS = 6;
    private SummaryTableModel _model;
    private JTable _table;
    private JScrollPane _scrollPane;
    private static final Logger logger = Logger.getLogger(InstanceStatusPanel.class.getName());

    public InstanceStatusPanel() {
        this.initGUI();
    }

    public void initGUI() {
        this.setLayout(new GridBagLayout());
        this._model = new SummaryTableModel();
        this._table = new JTable(this._model){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string = "";
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                try {
                    if (n2 < 1) {
                        string = InstanceStatusPanel.this._table.getValueAt(n, n2).toString();
                    } else {
                        switch (n) {
                            case 0: 
                            case 1: 
                            case 4: {
                                string = InstanceStatusPanel.this._table.getValueAt(n, n2).toString();
                                break;
                            }
                            case 2: 
                            case 3: {
                                string = n == 3 ? (!InstanceStatusPanel.this.instanceData.isStatusAvailable() ? Messages.getString("TimesTen.common.unavailable") : (InstanceStatusPanel.this.instanceData.getCSState() ? Messages.getString("TimesTenGrid.up") : Messages.getString("TimesTenGrid.down"))) : (!InstanceStatusPanel.this.instanceData.isStatusAvailable() ? Messages.getString("TimesTen.common.unavailable") : (InstanceStatusPanel.this.instanceData.getDaemonStatus() ? Messages.getString("TimesTenGrid.up") : Messages.getString("TimesTenGrid.down")));
                                break;
                            }
                            case 5: {
                                string = InstanceStatusPanel.this.instanceData.getRepAgentStatus().toString();
                            }
                        }
                    }
                }
                catch (RuntimeException runtimeException) {
                    logger.log(Level.SEVERE, runtimeException.getMessage());
                }
                return string;
            }
        };
        this._table.setAutoResizeMode(0);
        this._table.setRowSelectionAllowed(false);
        this._table.setColumnSelectionAllowed(false);
        TableColumnModel tableColumnModel = this._table.getColumnModel();
        tableColumnModel.getColumn(1).setCellRenderer(new IconTextCellRenderer());
        this._scrollPane = new JScrollPane(this._table);
        this.add((Component)this._scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
    }

    public void updateInstanceInfo(InstanceObject instanceObject) {
        this.instanceData = instanceObject;
        if (SwingUtilities.isEventDispatchThread()) {
            this._model.fireTableDataChanged();
            TableColumnSizer.setColumnsWidthToFit(this._table, true, true);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        InstanceStatusPanel.this._model.fireTableDataChanged();
                        TableColumnSizer.setColumnsWidthToFit(InstanceStatusPanel.this._table, true, true);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                logger.log(Level.SEVERE, exception.getMessage());
            }
        }
    }

    private class IconTextCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private IconTextCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            boolean bl3 = false;
            block0 : switch (n) {
                case 0: {
                    jLabel.setText(object.toString());
                    jLabel.setIcon(null);
                    break;
                }
                case 1: {
                    jLabel.setText(object.toString());
                    jLabel.setIcon(null);
                    break;
                }
                case 2: 
                case 3: {
                    if (InstanceStatusPanel.this.instanceData.isStatusAvailable()) {
                        bl3 = (Boolean)object;
                        jLabel.setText(bl3 ? Messages.getString("TimesTenGrid.up") : Messages.getString("TimesTenGrid.down"));
                        jLabel.setIcon(bl3 ? Common.UP_ICON : Common.DOWN_ICON);
                        break;
                    }
                    jLabel.setText(Messages.getString("TimesTen.common.unavailable"));
                    jLabel.setIcon(null);
                    break;
                }
                case 4: {
                    jLabel.setText(object.toString());
                    jLabel.setIcon(null);
                    break;
                }
                case 5: {
                    Common.RepAgentStatus repAgentStatus = (Common.RepAgentStatus)((Object)object);
                    jLabel.setText(repAgentStatus.toString());
                    switch (repAgentStatus) {
                        case UP: {
                            jLabel.setIcon(Common.UP_ICON);
                            break block0;
                        }
                        case DOWN: {
                            jLabel.setIcon(Common.DOWN_ICON);
                            break block0;
                        }
                    }
                    jLabel.setIcon(null);
                }
            }
            jLabel.setHorizontalAlignment(0);
            return jLabel;
        }
    }

    private class SummaryTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private SummaryTableModel() {
        }

        @Override
        public int getRowCount() {
            if (InstanceStatusPanel.this.instanceData != null && InstanceStatusPanel.this.instanceData.isMgmtInstance()) {
                return 6;
            }
            return 4;
        }

        @Override
        public int getColumnCount() {
            return InstanceStatusPanel.this.HEADER.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n) {
                case 0: {
                    return n2 == 0 ? Messages.getString("TimesTenGrid.instanceName") : InstanceStatusPanel.this.instanceData.getName();
                }
                case 1: {
                    return n2 == 0 ? Messages.getString("TimesTen.common.hostName") : InstanceStatusPanel.this.instanceData.getHost().getName();
                }
                case 3: {
                    return n2 == 0 ? Messages.getString("TimesTenGrid.serverstatus") : (InstanceStatusPanel.this.instanceData.isStatusAvailable() ? Boolean.valueOf(InstanceStatusPanel.this.instanceData.getCSState()) : Messages.getString("TimesTen.common.unavailable"));
                }
                case 2: {
                    return n2 == 0 ? Messages.getString("TimesTenGrid.daemonstatus") : (InstanceStatusPanel.this.instanceData.isStatusAvailable() ? Boolean.valueOf(InstanceStatusPanel.this.instanceData.getDaemonStatus()) : Messages.getString("TimesTen.common.unavailable"));
                }
                case 4: {
                    return n2 == 0 ? Messages.getString("TimesTenGrid.role") : InstanceStatusPanel.this.instanceData.getType();
                }
                case 5: {
                    return n2 == 0 ? Messages.getString("TimesTenGrid.repAgentStatus") : InstanceStatusPanel.this.instanceData.getRepAgentStatus();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            return InstanceStatusPanel.this.HEADER[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

