/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.database;

import java.text.MessageFormat;
import java.util.ArrayList;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.database.DBDefAttribute;

public class EnumAttribute
extends DBDefAttribute<String> {
    private boolean showDefinition;
    private ArrayList<String> values;
    private ArrayList<String> dbDefValues;

    public boolean isShowDefinition() {
        return this.showDefinition;
    }

    public void setShowDefinition(boolean bl) {
        this.showDefinition = bl;
    }

    public ArrayList<String> getDbDefValues() {
        return this.dbDefValues;
    }

    public ArrayList<String> getValues() {
        return this.values;
    }

    public EnumAttribute(String string, String string2, DBDefAttribute.DBDefAttributeType dBDefAttributeType, ArrayList<String> arrayList, ArrayList<String> arrayList2, String string3, boolean bl, boolean bl2) {
        super(string, string2, dBDefAttributeType, bl);
        this.dbDefValues = arrayList;
        this.values = arrayList2;
        this.showDefinition = bl2;
        this.value = string3;
        this.defaultValue = this.value;
    }

    public EnumAttribute(EnumAttribute enumAttribute) {
        super(enumAttribute);
        this.dbDefValues = enumAttribute.getDbDefValues();
        this.values = enumAttribute.getValues();
        this.defaultValue = enumAttribute.getDefaultValue();
        this.value = enumAttribute.getValue();
        this.showDefinition = enumAttribute.isShowDefinition();
    }

    @Override
    public boolean isValid() {
        return this.showDefinition && this.values.contains(this.getValue()) || !this.showDefinition && this.dbDefValues.contains(this.getValue());
    }

    @Override
    public String getValue() {
        return this.showDefinition ? this.getEnumValueDescription() : (String)this.value;
    }

    @Override
    public void setValue(String string) {
        int n;
        for (n = 0; n < this.values.size(); ++n) {
            if (!this.values.get(n).equalsIgnoreCase(string)) continue;
            this.value = this.dbDefValues.get(n);
            return;
        }
        for (n = 0; n < this.dbDefValues.size(); ++n) {
            if (!this.dbDefValues.get(n).equalsIgnoreCase(string)) continue;
            this.value = string;
            return;
        }
    }

    @Override
    public void setValueFromString(String string) {
        this.setValue(string);
    }

    @Override
    public String getValueAsString() {
        return this.getValue();
    }

    @Override
    public String getErrorMessage() {
        return MessageFormat.format(Messages.getString("TimesTenGrid.attributeEnumError"), this.attributeName);
    }

    @Override
    public String getDBDefValue() {
        return (String)this.value;
    }

    public String getEnumValueDescription() {
        for (int i = 0; i < this.dbDefValues.size(); ++i) {
            if (!this.dbDefValues.get(i).equalsIgnoreCase((String)this.value)) continue;
            return this.values.get(i);
        }
        return null;
    }
}

