/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.database;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.GridCommandExecutor;
import oracle.dbtools.raptor.timesten.grid.TTGUIBasePanel;
import oracle.dbtools.raptor.timesten.grid.database.DBDetailedConnectionsPanel;
import oracle.dbtools.raptor.timesten.grid.object.DatabaseObject;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.object.MySSHException;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;

public class DbDestroyDialog
extends TTGUIBasePanel {
    private static final String TITLE = Messages.getString("TimesTenGrid.destroyDBTitle");
    private static final String MESSAGE = Messages.getString("TimesTenGrid.destroyDBConfirmation");
    private static final String DESTROYDBDEF = Messages.getString("TimesTenGrid.destroyDBDefConfirmation");
    private static final Logger logger = Logger.getLogger(DbDestroyDialog.class.getName());
    private JCheckBox _destroyDbDefChk;
    private String dbName;
    private JTextField _instAdminTxtFld;

    private DbDestroyDialog(DatabaseObject databaseObject) {
        super(true);
        this.dbName = databaseObject.getName();
        this._destroyDbDefChk = new JCheckBox(DESTROYDBDEF);
        this._destroyDbDefChk.setName(DESTROYDBDEF);
        JTextPane jTextPane = new JTextPane();
        jTextPane.setOpaque(false);
        jTextPane.setEditable(false);
        jTextPane.setFocusable(false);
        jTextPane.setBackground(UIManager.getColor("Label.background"));
        jTextPane.setFont(UIManager.getFont("Label.font"));
        jTextPane.setBorder(UIManager.getBorder("Label.border"));
        StyledDocument styledDocument = jTextPane.getStyledDocument();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet, 3);
        styledDocument.setParagraphAttributes(0, styledDocument.getLength(), simpleAttributeSet, false);
        Common.replaceWithHyperlink(jTextPane, MESSAGE, 0, () -> DBDetailedConnectionsPanel.showDetailedConnections(databaseObject), databaseObject.getAppConnections(), databaseObject.getName());
        this._instAdminTxtFld = new JTextField(20);
        this._instAdminTxtFld.setName("_instAdminTxtFld");
        this.add((Component)jTextPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._instAdminTxtFld, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 5, 10, 5), 0, 0));
        this.add((Component)this._destroyDbDefChk, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DbDestroyDialog.this.deleteDatabaseAction();
            }
        };
        this._instAdminTxtFld.addActionListener(abstractAction);
    }

    @Override
    public void setDialog(JEWTDialog jEWTDialog) {
        this._dialog = jEWTDialog;
    }

    public String getInstanceAdmin() {
        return this._instAdminTxtFld.getText().trim();
    }

    public static void showDBDestroyDialog(GridObject gridObject, DatabaseObject databaseObject) {
        if (databaseObject.getDBStatus().isNonExistent()) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)Messages.getString("TimesTenGrid.dbdoesnotexists"), (String)Messages.getString("TimesTenGrid.stopDBConfirmTitle"), null);
            return;
        }
        DbDestroyDialog dbDestroyDialog = new DbDestroyDialog(databaseObject);
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)dbDestroyDialog, (String)TITLE, (ActionListener)dbDestroyDialog);
        dbDestroyDialog.setDialog(jEWTDialog);
        jEWTDialog.setButtonMask(6);
        jEWTDialog.addCustomButton((Component)dbDestroyDialog.getOkButton());
        Dimension dimension = new Dimension(325, 250);
        jEWTDialog.setSize(dimension);
        jEWTDialog.setMinimumSize(dimension);
        jEWTDialog.setDefaultCloseOperation(2);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.addActionListener((ActionListener)dbDestroyDialog);
        dbDestroyDialog.setDisposeDialog(false);
        dbDestroyDialog.getOkButton().addActionListener(actionEvent -> dbDestroyDialog.deleteDatabaseAction());
        HelpSystem.getHelpSystem().registerTopic((JComponent)dbDestroyDialog, TimesTenHelpID.DB_DESTROY.toString());
        jEWTDialog.setVisible(true);
    }

    public void deleteDatabaseAction() {
        String string = this.getInstanceAdmin();
        if (string.isEmpty()) {
            Common.displayErrorMsg((Component)this._dialog, Messages.getString("TimesTenGrid.noInstanceAdminError"));
            return;
        }
        if (!this.grid.getExecutor().getWorkingHost().getInstanceAdmin().equals(string)) {
            Common.displayErrorMsg((Component)this._dialog, Messages.getString("TimesTenGrid.dbdestroyInstAdminFail"));
            return;
        }
        final CustomProgressMonitor customProgressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TimesTenGrid.destroyingDB"), this.dbName), Messages.getString("TimesTen.common.pleaseWait"), null);
        final GridCommand gridCommand = GridCommand.PERL_DELETE_DATABASE;
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
            private GridCommandExecutor gridCmdExec;

            @Override
            protected Void doInBackground() throws GridCommandException, MySSHException {
                customProgressMonitor.start();
                try {
                    DbDestroyDialog.this._dialog.dispose();
                    this.gridCmdExec = DbDestroyDialog.this.grid.getExecutor();
                    gridCommand.prepareCommand(DbDestroyDialog.this.dbName, DbDestroyDialog.this._destroyDbDefChk.isSelected() ? "1" : "0");
                    this.gridCmdExec.executePerlScriptCommand(gridCommand, new OutputStream(){
                        private StringBuilder string = new StringBuilder();

                        @Override
                        public void write(int n) throws IOException {
                            try {
                                SwingUtilities.invokeAndWait(() -> {
                                    this.string.append(Character.toString((char)n));
                                    if (Character.toString((char)n).equalsIgnoreCase("\n")) {
                                        this.firePropertyChange("message", null, this.string.substring(0, this.string.length() - 1));
                                        logger.log(Level.INFO, this.string.substring(0, this.string.length() - 1));
                                        this.string.delete(0, this.string.length());
                                    }
                                });
                            }
                            catch (InterruptedException | InvocationTargetException exception) {
                                // empty catch block
                            }
                        }
                    });
                    if (DbDestroyDialog.this._destroyDbDefChk.isSelected()) {
                        this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.refreshingGrid"));
                        DbDestroyDialog.this.grid.setGridComponents(DbDestroyDialog.this.grid.getExecutor().executeCommandGetJson(GridCommand.EXPORT_MODEL, true), false);
                    } else {
                        DbDestroyDialog.this.grid.getDatabase(DbDestroyDialog.this.dbName).getDBStatus().setUnknown(true);
                    }
                    this.firePropertyChange("progress", null, 100);
                }
                catch (GridCommandException gridCommandException) {
                    logger.severe(gridCommandException.getMessage());
                    this.cancel(true);
                    throw gridCommandException;
                }
                return null;
            }

            @Override
            protected void done() {
                customProgressMonitor.finish();
                if (customProgressMonitor.isCancelled() || !customProgressMonitor.successfulExecution()) {
                    customProgressMonitor.updateMessage(Messages.getString("TimesTenGrid.dbdestroyCancelled"));
                    if (this.gridCmdExec != null) {
                        this.gridCmdExec.stopCurrentExecution();
                    }
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.dbdestroyCancelled"));
                } else {
                    this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.destroyDBCompleted"), DbDestroyDialog.this.dbName));
                    logger.log(Level.INFO, MessageFormat.format(Messages.getString("TimesTenGrid.destroyDBCompleted"), DbDestroyDialog.this.dbName));
                }
                if (DbDestroyDialog.this._destroyDbDefChk.isSelected()) {
                    DbDestroyDialog.this.showModelNeedsApplyWarning();
                }
            }
        };
        swingWorker.addPropertyChangeListener(customProgressMonitor);
        customProgressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }
}

