/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.database;

import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.database.DBDefAttribute;

public final class BooleanAttribute
extends DBDefAttribute<Boolean> {
    private final String YES_OPTION = Messages.getString("TimesTen.common.yes");
    private final String NO_OPTION = Messages.getString("TimesTen.common.no");

    public BooleanAttribute(String string, String string2, DBDefAttribute.DBDefAttributeType dBDefAttributeType, boolean bl, boolean bl2) {
        super(string, string2, dBDefAttributeType, bl2);
        this.value = bl;
        this.defaultValue = this.value;
    }

    public BooleanAttribute(BooleanAttribute booleanAttribute) {
        super(booleanAttribute);
        this.defaultValue = booleanAttribute.getDefaultValue();
        this.value = booleanAttribute.getValue();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public Boolean getValue() {
        return (Boolean)this.value;
    }

    @Override
    public void setValue(Boolean bl) {
        this.value = bl;
    }

    @Override
    public void setValueFromString(String string) {
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase(this.YES_OPTION) || string.equalsIgnoreCase("1")) {
            this.value = Boolean.TRUE;
        } else if (string.equalsIgnoreCase(this.NO_OPTION) || string.equalsIgnoreCase("0")) {
            this.value = Boolean.FALSE;
        }
    }

    @Override
    public String getValueAsString() {
        if (((Boolean)this.value).booleanValue()) {
            return this.YES_OPTION;
        }
        return this.NO_OPTION;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public String getDBDefValue() {
        if (((Boolean)this.value).booleanValue()) {
            return "1";
        }
        return "0";
    }
}

