/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.GridCommandExecutor;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.ide.Ide;

public class TTGridTextPane
extends JTextPane {
    private static final Logger LOGGER = Logger.getLogger(TTGridTextPane.class.getName());
    private GridCommandExecutor gridCmdExec;
    public static final String HTML_NORMAL_STYLE = "font-size:10px;";

    public TTGridTextPane() {
        this.init();
    }

    private void init() {
        this.setContentType("text/html");
        this.addHyperlinkListener(new HREFListener());
        this.setAutoscrolls(true);
        this.setEditable(false);
        this.setText("");
        JPopupMenu jPopupMenu = new JPopupMenu();
        final JMenuItem jMenuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        jMenuItem.setText(Messages.getString("TimesTenGrid.copy"));
        jPopupMenu.add(jMenuItem);
        this.setComponentPopupMenu(jPopupMenu);
        this.setEditingMenuItemsState(jMenuItem);
        this.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                TTGridTextPane.this.setEditingMenuItemsState(jMenuItem);
            }
        });
    }

    public void setEditingMenuItemsState(JMenuItem jMenuItem) {
        String string = this.getSelectedText();
        if (this == null) {
            string = null;
        }
        jMenuItem.setEnabled(string != null && !string.isEmpty());
    }

    public void setGridCommandExecutor(GridCommandExecutor gridCommandExecutor) {
        this.gridCmdExec = gridCommandExecutor;
    }

    private String addGridErrorLogHiperLinks(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string.replaceAll("(\n)", "<br/>"));
        String string3 = "(Detailed Log:|Failing command stdout:|Failing command stderr:)";
        Pattern pattern = Pattern.compile(string3 + "(.*?)\\.(log|out|err)");
        Matcher matcher = pattern.matcher(stringBuilder);
        int n = 0;
        while (matcher.find(n)) {
            String string4 = matcher.group(2).trim() + "." + matcher.group(3);
            string4 = matcher.group(1) + "<a href=\"" + string4 + "\">" + string4 + "</a>";
            stringBuilder.replace(matcher.start(), matcher.end(), string4);
            n = matcher.end();
            matcher = pattern.matcher(stringBuilder);
        }
        stringBuilder.insert(0, "<html><body>");
        stringBuilder.append("</body></html>");
        return stringBuilder.toString();
    }

    public void updateText(String string) {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)this.getEditorKit();
        try {
            hTMLEditorKit.insertHTML(hTMLDocument, hTMLDocument.getLength(), this.addGridErrorLogHiperLinks(string, HTML_NORMAL_STYLE), 0, 0, null);
            this.invalidate();
        }
        catch (IOException | BadLocationException exception) {
            LOGGER.log(Level.SEVERE, "Error on updating detail text area", exception);
        }
    }

    private class HREFListener
    implements HyperlinkListener {
        private HREFListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if (TTGridTextPane.this.gridCmdExec == null) {
                    TTGridTextPane.this.gridCmdExec = TTGridRootNode.getInstance().getGrid(TTGridRootNode.getInstance().getCurrentGrid()).getExecutor();
                    if (TTGridTextPane.this.gridCmdExec == null) {
                        LOGGER.log(Level.SEVERE, "Grid Command Executor not set. Cannot retrieve connection parameters");
                        return;
                    }
                }
                final GridCommandExecutor gridCommandExecutor = TTGridTextPane.this.gridCmdExec;
                final String string = hyperlinkEvent.getDescription();
                int n = hyperlinkEvent.getDescription().length();
                while (n > 0 && hyperlinkEvent.getDescription().charAt(--n) != '/') {
                }
                String string2 = hyperlinkEvent.getDescription().substring(++n);
                JFileChooser jFileChooser = new JFileChooser(TTGridRootNode.getInstance().getCurrentDirectory());
                jFileChooser.setSelectedFile(new File(string2));
                jFileChooser.setDialogTitle(Messages.getString("TimesTenGrid.saveErrorLog"));
                int n2 = 0;
                n2 = jFileChooser.showSaveDialog((Component)Ide.getMainWindow());
                if (n2 == 0) {
                    TTGridRootNode.getInstance().setCurrentDirectory(jFileChooser.getCurrentDirectory().getAbsolutePath());
                    final File file = jFileChooser.getSelectedFile();
                    RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("TimesTenGrid.timesTenGrid"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

                        protected Void doWork() throws TaskException {
                            try {
                                gridCommandExecutor.executeSCPRemote2Local(file.getCanonicalPath(), string);
                            }
                            catch (IOException | GridCommandException exception) {
                                Common.displayErrorMsg(null, exception.getMessage());
                                LOGGER.log(Level.SEVERE, exception.getMessage());
                            }
                            return null;
                        }
                    };
                    raptorTask.setCancellable(false);
                    raptorTask.setPausable(false);
                    raptorTask.setMessage(MessageFormat.format(Messages.getString("TimesTenGrid.saveErrorLogMsg"), string2));
                    RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
                }
            }
        }
    }
}

