/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CredentialsPanel;
import oracle.dbtools.raptor.timesten.grid.SSHChannel;
import oracle.dbtools.raptor.timesten.grid.object.MySSHException;

public class PasswordlessSSHTestPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static Logger _logger = Logger.getLogger(PasswordlessSSHTestPanel.class.getPackage().getName());
    private static final String SSH_TEST_CASES_VERSION = "oracle.dbtools.raptor.timesten.grid.ssh.test";
    private static SshTestType typeTest = SshTestType.FULL;
    private List<String> hostList;
    private List<Boolean> hostTypeList;
    private List<String> orderedHostList;
    private String firstHostAddress;
    private String firstMgmtHostAddress;
    private int firstMgmtHostIndex;
    private String admin;
    private char[] adminPass;
    private String keyFile;
    private List<String> testResultGlobalMsgList;
    private JEWTDialog _containerDialog;
    private JSplitPane _splitPane;
    private int selectedHostIdx;
    private boolean testRunning = false;
    private List<HostConnection> detailsHostList;
    private JButton _tryBtn;
    private JButton _applyBtn;
    private ConfigurationPanel configPanel;
    private DetailsPanel detailsPanel;

    public void setDialog(JEWTDialog jEWTDialog) {
        this._containerDialog = jEWTDialog;
        this._containerDialog.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PasswordlessSSHTestPanel.this.detailsPanel.cancelWorker();
                super.windowClosing(windowEvent);
            }
        });
        jEWTDialog.setSize(600, 700);
        this._tryBtn = new JButton(Messages.getString("TimesTenGrid.test"));
        this._tryBtn.setName(Messages.getString("TimesTenGrid.test"));
        this._applyBtn = new JButton(Messages.getString("TimesTenGrid.saveApplyDistribution"));
        this._applyBtn.setName(Messages.getString("TimesTenGrid.saveApplyDistribution"));
        this._tryBtn.addActionListener(this.detailsPanel);
        this._applyBtn.addActionListener(this.detailsPanel);
        jEWTDialog.addCustomButton((Component)this._tryBtn);
        jEWTDialog.addCustomButton((Component)this._applyBtn);
    }

    public PasswordlessSSHTestPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.configPanel = new ConfigurationPanel();
        this.detailsPanel = new DetailsPanel();
        this.detailsHostList = new ArrayList<HostConnection>();
        this.testResultGlobalMsgList = new ArrayList<String>();
        this._splitPane = new JSplitPane(0, this.configPanel, this.detailsPanel);
        this._splitPane.setDividerLocation(0.75);
        this._splitPane.setResizeWeight(0.75);
        this._splitPane.setOneTouchExpandable(true);
        this.add(this._splitPane);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    static {
        String string = System.getProperty(SSH_TEST_CASES_VERSION, SshTestType.FULL.toString());
        typeTest = string.equalsIgnoreCase(SshTestType.MGMTDATA.toString()) ? SshTestType.MGMTDATA : SshTestType.FULL;
    }

    private class HostConnection {
        private String name;
        private List<String> toHosts;
        private List<String> detailMessages;

        public HostConnection(String string) {
            this.name = string;
            this.toHosts = new ArrayList<String>();
            this.detailMessages = new ArrayList<String>();
        }

        public String getName() {
            return this.name;
        }

        public void addToHost(String string) {
            this.toHosts.add(string);
            this.detailMessages.add(new String(Messages.getString("TimesTenGrid.notTested")));
        }

        public void setMessage(int n, String string) {
            this.detailMessages.set(n, string);
        }

        public String getToHost(int n) {
            return this.toHosts.get(n);
        }

        public String getDetailMessage(int n) {
            return this.detailMessages.get(n);
        }

        public int getSize() {
            return this.toHosts.size();
        }
    }

    private class DetailsPanel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private JTable _detailsTable;
        private JScrollPane _scrollPane;
        private SwingWorker<Void, Void> wrkr;
        private int mgmtHostCount = 0;
        private ResultsTableModel _detailsTableModel;
        private final int FROM_COL = 0;
        private final int TO_COL = 1;
        private final int RES_COL = 2;
        private final String[] HEADER = new String[]{Messages.getString("TimesTenGrid.connFrom"), Messages.getString("TimesTenGrid.connTo"), Messages.getString("TimesTenGrid.resultCol")};

        public DetailsPanel() {
            this.init();
        }

        private void init() {
            this.setLayout(new GridBagLayout());
            this._detailsTableModel = new ResultsTableModel();
            this._detailsTable = new JTable(this._detailsTableModel){
                private static final long serialVersionUID = 1L;

                @Override
                public String getToolTipText(MouseEvent mouseEvent) {
                    String string = "";
                    Point point = mouseEvent.getPoint();
                    int n = this.rowAtPoint(point);
                    int n2 = this.columnAtPoint(point);
                    try {
                        switch (n2) {
                            case 0: 
                            case 1: {
                                string = DetailsPanel.this._detailsTable.getValueAt(n, n2).toString();
                                break;
                            }
                            case 2: {
                                string = n < PasswordlessSSHTestPanel.this.detailsHostList.get(PasswordlessSSHTestPanel.this.selectedHostIdx).getSize() ? PasswordlessSSHTestPanel.this.detailsHostList.get(PasswordlessSSHTestPanel.this.selectedHostIdx).getDetailMessage(n) : null;
                            }
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        _logger.log(Level.INFO, runtimeException.getMessage());
                    }
                    return string;
                }
            };
            this._detailsTable.getTableHeader().setReorderingAllowed(false);
            this._scrollPane = new JScrollPane(this._detailsTable);
            this._scrollPane.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.detailsLbl")));
            this.add((Component)this._scrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 15, 5, 15), 0, 0));
        }

        public boolean isInformationComplete() {
            int n;
            boolean bl3 = PasswordlessSSHTestPanel.this.hostList.stream().map(string -> !string.isEmpty()).reduce(true, (bl, bl2) -> bl != false && bl2 != false);
            boolean bl4 = (PasswordlessSSHTestPanel.this.configPanel.getAdminPass() != null || PasswordlessSSHTestPanel.this.configPanel.getKeyFile() != null) && PasswordlessSSHTestPanel.this.configPanel.getAdmin() != null && PasswordlessSSHTestPanel.this.hostList.size() > 0 && bl3;
            this.mgmtHostCount = 0;
            PasswordlessSSHTestPanel.this.orderedHostList.clear();
            PasswordlessSSHTestPanel.this.firstHostAddress = PasswordlessSSHTestPanel.this.hostList.get(0);
            PasswordlessSSHTestPanel.this.firstMgmtHostIndex = -1;
            for (n = 0; n < PasswordlessSSHTestPanel.this.hostTypeList.size(); ++n) {
                if (!PasswordlessSSHTestPanel.this.hostTypeList.get(n).booleanValue()) continue;
                if (PasswordlessSSHTestPanel.this.firstMgmtHostIndex == -1) {
                    PasswordlessSSHTestPanel.this.firstMgmtHostAddress = PasswordlessSSHTestPanel.this.hostList.get(n);
                    PasswordlessSSHTestPanel.this.firstMgmtHostIndex = n;
                }
                ++this.mgmtHostCount;
            }
            if (typeTest == SshTestType.MGMTDATA) {
                bl4 = bl4 && this.mgmtHostCount > 0 && this.mgmtHostCount <= 2;
            }
            for (n = 0; n < PasswordlessSSHTestPanel.this.hostList.size(); ++n) {
                PasswordlessSSHTestPanel.this.orderedHostList.add(PasswordlessSSHTestPanel.this.hostList.get(n));
            }
            PasswordlessSSHTestPanel.this.admin = PasswordlessSSHTestPanel.this.configPanel.getAdmin();
            PasswordlessSSHTestPanel.this.adminPass = PasswordlessSSHTestPanel.this.configPanel.getAdminPass();
            PasswordlessSSHTestPanel.this.keyFile = PasswordlessSSHTestPanel.this.configPanel.getKeyFile();
            return bl4;
        }

        private int getUnorderedHostsIdx(int n) {
            for (int i = 0; i < PasswordlessSSHTestPanel.this.hostList.size(); ++i) {
                if (!PasswordlessSSHTestPanel.this.hostList.get(i).equalsIgnoreCase(PasswordlessSSHTestPanel.this.orderedHostList.get(n))) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PasswordlessSSHTestPanel.this.testRunning) {
                return;
            }
            if (!this.isInformationComplete()) {
                if (typeTest == SshTestType.MGMTDATA) {
                    if (this.mgmtHostCount < 1) {
                        Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.infoNoMngmInstance"));
                    } else if (this.mgmtHostCount > 2) {
                        Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.infoTooManyMngmInstance"));
                    } else {
                        Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.infoEmpty"));
                    }
                } else {
                    Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.infoEmpty"));
                }
                return;
            }
            this.wrkr = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    int n;
                    PasswordlessSSHTestPanel.this._tryBtn.setEnabled(false);
                    PasswordlessSSHTestPanel.this._applyBtn.setEnabled(false);
                    PasswordlessSSHTestPanel.this.configPanel.getAddHostBtn().setEnabled(false);
                    PasswordlessSSHTestPanel.this.configPanel.getRemoveHostBtn().setEnabled(false);
                    PasswordlessSSHTestPanel.this.configPanel.clearResultMsgs();
                    PasswordlessSSHTestPanel.this.testRunning = true;
                    ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
                    PasswordlessSSHTestPanel.this.selectedHostIdx = PasswordlessSSHTestPanel.this.firstMgmtHostIndex;
                    PasswordlessSSHTestPanel.this.detailsHostList.clear();
                    for (int i = 0; i < PasswordlessSSHTestPanel.this.hostList.size(); ++i) {
                        HostConnection hostConnection = new HostConnection(PasswordlessSSHTestPanel.this.hostList.get(i));
                        PasswordlessSSHTestPanel.this.detailsHostList.add(hostConnection);
                    }
                    try {
                        PasswordlessSSHTestPanel.this.testResultGlobalMsgList.set(DetailsPanel.this.getUnorderedHostsIdx(PasswordlessSSHTestPanel.this.firstMgmtHostIndex), MessageFormat.format(Messages.getString("TimesTenGrid.testingFirstHostConn"), PasswordlessSSHTestPanel.this.firstMgmtHostAddress));
                        PasswordlessSSHTestPanel.this.configPanel.dataChanged();
                        SSHChannel.tryConnect(PasswordlessSSHTestPanel.this.firstMgmtHostAddress, PasswordlessSSHTestPanel.this.admin, PasswordlessSSHTestPanel.this.adminPass, PasswordlessSSHTestPanel.this.keyFile);
                        PasswordlessSSHTestPanel.this.testResultGlobalMsgList.set(DetailsPanel.this.getUnorderedHostsIdx(PasswordlessSSHTestPanel.this.firstMgmtHostIndex), Messages.getString("TimesTenGrid.firstHostConnOk"));
                        PasswordlessSSHTestPanel.this.configPanel.dataChanged();
                    }
                    catch (MySSHException mySSHException) {
                        _logger.log(Level.SEVERE, mySSHException.getMessage());
                        PasswordlessSSHTestPanel.this.testResultGlobalMsgList.set(DetailsPanel.this.getUnorderedHostsIdx(PasswordlessSSHTestPanel.this.firstMgmtHostIndex), MessageFormat.format(Messages.getString("TimesTenGrid.cantConnectToHost"), mySSHException.getMessage()));
                        PasswordlessSSHTestPanel.this.configPanel.dataChanged();
                        this.cancel(true);
                        return null;
                    }
                    HostConnection hostConnection = PasswordlessSSHTestPanel.this.detailsHostList.get(PasswordlessSSHTestPanel.this.firstMgmtHostIndex);
                    for (n = 0; n < PasswordlessSSHTestPanel.this.orderedHostList.size() && !this.isCancelled(); ++n) {
                        try {
                            hostConnection.addToHost(PasswordlessSSHTestPanel.this.orderedHostList.get(n));
                            hostConnection.setMessage(n, Messages.getString("TimesTenGrid.connectingLbl"));
                            SSHChannel.testPasswordless(PasswordlessSSHTestPanel.this.firstMgmtHostAddress, PasswordlessSSHTestPanel.this.admin, PasswordlessSSHTestPanel.this.adminPass, PasswordlessSSHTestPanel.this.keyFile, PasswordlessSSHTestPanel.this.orderedHostList.get(n));
                            hostConnection.setMessage(n, Messages.getString("TimesTenGrid.validAttribute"));
                            arrayList.add(true);
                        }
                        catch (MySSHException mySSHException) {
                            hostConnection.setMessage(n, MessageFormat.format(Messages.getString("TimesTenGrid.cantConnectToHost"), mySSHException.getMessage()));
                            arrayList.add(false);
                        }
                        PasswordlessSSHTestPanel.this.detailsPanel.detailsDataChanged();
                    }
                    if (arrayList.stream().reduce(true, (bl, bl2) -> bl != false && bl2 != false).booleanValue()) {
                        PasswordlessSSHTestPanel.this.testResultGlobalMsgList.set(DetailsPanel.this.getUnorderedHostsIdx(PasswordlessSSHTestPanel.this.firstMgmtHostIndex), Messages.getString("TimesTenGrid.validAttribute"));
                    } else {
                        PasswordlessSSHTestPanel.this.testResultGlobalMsgList.set(DetailsPanel.this.getUnorderedHostsIdx(PasswordlessSSHTestPanel.this.firstMgmtHostIndex), Messages.getString("TimesTenGrid.partFailed"));
                    }
                    for (n = 0; n < PasswordlessSSHTestPanel.this.orderedHostList.size(); ++n) {
                        if (n == PasswordlessSSHTestPanel.this.firstMgmtHostIndex) continue;
                        hostConnection = PasswordlessSSHTestPanel.this.detailsHostList.get(n);
                        PasswordlessSSHTestPanel.this.selectedHostIdx = n;
                        PasswordlessSSHTestPanel.this.testResultGlobalMsgList.set(DetailsPanel.this.getUnorderedHostsIdx(n), Messages.getString("TimesTenGrid.testingConnOther"));
                        PasswordlessSSHTestPanel.this.configPanel.dataChanged();
                        boolean bl3 = true;
                        int n2 = 0;
                        for (int i = 0; i < PasswordlessSSHTestPanel.this.orderedHostList.size() && !this.isCancelled(); ++i) {
                            if (!PasswordlessSSHTestPanel.this.hostTypeList.get(DetailsPanel.this.getUnorderedHostsIdx(n)).booleanValue() && !PasswordlessSSHTestPanel.this.hostTypeList.get(i).booleanValue() && DetailsPanel.this.getUnorderedHostsIdx(n) != i) {
                                PasswordlessSSHTestPanel.this.configPanel.dataChanged();
                                continue;
                            }
                            hostConnection.addToHost(PasswordlessSSHTestPanel.this.orderedHostList.get(i));
                            hostConnection.setMessage(n2, Messages.getString("TimesTenGrid.connectingLbl"));
                            PasswordlessSSHTestPanel.this.detailsPanel.detailsDataChanged();
                            if (((Boolean)arrayList.get(n)).booleanValue()) {
                                try {
                                    SSHChannel.testPasswordless(PasswordlessSSHTestPanel.this.firstHostAddress, PasswordlessSSHTestPanel.this.admin, PasswordlessSSHTestPanel.this.adminPass, PasswordlessSSHTestPanel.this.keyFile, PasswordlessSSHTestPanel.this.orderedHostList.get(n), PasswordlessSSHTestPanel.this.orderedHostList.get(i));
                                    hostConnection.setMessage(n2, Messages.getString("TimesTenGrid.validAttribute"));
                                    PasswordlessSSHTestPanel.this.configPanel.dataChanged();
                                    bl3 = bl3;
                                }
                                catch (MySSHException mySSHException) {
                                    hostConnection.setMessage(n2, MessageFormat.format(Messages.getString("TimesTenGrid.cantConnectToHost"), mySSHException.getMessage()));
                                    PasswordlessSSHTestPanel.this.configPanel.dataChanged();
                                    if (bl3) {
                                        // empty if block
                                    }
                                    bl3 = false;
                                }
                            } else {
                                hostConnection.setMessage(n2, MessageFormat.format(Messages.getString("TimesTenGrid.connFirstHostFailed"), PasswordlessSSHTestPanel.this.firstMgmtHostAddress));
                                if (bl3) {
                                    // empty if block
                                }
                                bl3 = false;
                            }
                            ++n2;
                            PasswordlessSSHTestPanel.this.detailsPanel.detailsDataChanged();
                        }
                        if (!((Boolean)arrayList.get(n)).booleanValue()) {
                            PasswordlessSSHTestPanel.this.testResultGlobalMsgList.set(DetailsPanel.this.getUnorderedHostsIdx(n), MessageFormat.format(Messages.getString("TimesTenGrid.connFirstHostFailed"), PasswordlessSSHTestPanel.this.firstMgmtHostAddress));
                        } else if (bl3) {
                            PasswordlessSSHTestPanel.this.testResultGlobalMsgList.set(DetailsPanel.this.getUnorderedHostsIdx(n), Messages.getString("TimesTenGrid.validAttribute"));
                        } else {
                            PasswordlessSSHTestPanel.this.testResultGlobalMsgList.set(DetailsPanel.this.getUnorderedHostsIdx(n), Messages.getString("TimesTenGrid.partFailed"));
                        }
                        PasswordlessSSHTestPanel.this.configPanel.dataChanged();
                    }
                    PasswordlessSSHTestPanel.this.configPanel.dataChanged();
                    return null;
                }

                @Override
                protected void done() {
                    PasswordlessSSHTestPanel.this._tryBtn.setEnabled(true);
                    PasswordlessSSHTestPanel.this._applyBtn.setEnabled(false);
                    PasswordlessSSHTestPanel.this.configPanel.getAddHostBtn().setEnabled(true);
                    PasswordlessSSHTestPanel.this.configPanel.getRemoveHostBtn().setEnabled(true);
                    PasswordlessSSHTestPanel.this.testRunning = false;
                }
            };
            this.wrkr.execute();
        }

        public void cancelWorker() {
            if (this.wrkr != null) {
                this.wrkr.cancel(true);
            }
        }

        public void detailsDataChanged() {
            if (SwingUtilities.isEventDispatchThread()) {
                this._detailsTableModel.fireTableDataChanged();
            } else {
                try {
                    SwingUtilities.invokeAndWait(() -> this._detailsTableModel.fireTableDataChanged());
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    _logger.log(Level.SEVERE, exception.getMessage());
                }
            }
        }

        private class ResultsTableModel
        extends AbstractTableModel {
            private static final long serialVersionUID = 1L;

            private ResultsTableModel() {
            }

            @Override
            public int getRowCount() {
                return PasswordlessSSHTestPanel.this.detailsHostList.size() < PasswordlessSSHTestPanel.this.selectedHostIdx || PasswordlessSSHTestPanel.this.detailsHostList.size() == 0 ? 0 : PasswordlessSSHTestPanel.this.detailsHostList.get(PasswordlessSSHTestPanel.this.selectedHostIdx).getSize();
            }

            @Override
            public int getColumnCount() {
                return DetailsPanel.this.HEADER.length;
            }

            @Override
            public String getColumnName(int n) {
                return DetailsPanel.this.HEADER[n];
            }

            @Override
            public Object getValueAt(int n, int n2) {
                switch (n2) {
                    case 0: {
                        return PasswordlessSSHTestPanel.this.detailsHostList.get(PasswordlessSSHTestPanel.this.selectedHostIdx).getName();
                    }
                    case 1: {
                        return PasswordlessSSHTestPanel.this.detailsHostList.get(PasswordlessSSHTestPanel.this.selectedHostIdx).getToHost(n);
                    }
                    case 2: {
                        return n < PasswordlessSSHTestPanel.this.detailsHostList.get(PasswordlessSSHTestPanel.this.selectedHostIdx).getSize() ? PasswordlessSSHTestPanel.this.detailsHostList.get(PasswordlessSSHTestPanel.this.selectedHostIdx).getDetailMessage(n) : Messages.getString("TimesTenGrid.notTested");
                    }
                }
                return null;
            }
        }
    }

    private class ConfigurationPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private static final int HOST_IP_COL = 0;
        private static final int HOST_MANAGEMENT_COL = 1;
        private static final int HOST_RESULT_COL = 2;
        private String[] HEADER = new String[]{Messages.getString("TimesTenGrid.hostAddress"), Messages.getString("TimesTenGrid.management"), Messages.getString("TimesTenGrid.testResult")};
        private JTable _table;
        private HostsTableModel _model;
        private JScrollPane _scrollPane;
        private JButton _addHost;
        private JButton _removeHost;
        private CredentialsPanel _credPanel;

        public ConfigurationPanel() {
            this.init();
        }

        public JButton getAddHostBtn() {
            return this._addHost;
        }

        public JButton getRemoveHostBtn() {
            return this._removeHost;
        }

        public void dataChanged() {
            if (SwingUtilities.isEventDispatchThread()) {
                this._model.fireTableDataChanged();
            } else {
                try {
                    SwingUtilities.invokeAndWait(() -> this._model.fireTableDataChanged());
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    _logger.severe(exception.getMessage());
                }
            }
        }

        private void init() {
            this.setLayout(new GridBagLayout());
            PasswordlessSSHTestPanel.this.hostList = new ArrayList<String>();
            PasswordlessSSHTestPanel.this.hostTypeList = new ArrayList<Boolean>();
            PasswordlessSSHTestPanel.this.orderedHostList = new ArrayList<String>();
            this._model = new HostsTableModel();
            this._table = new JTable(this._model){
                private static final long serialVersionUID = 1L;

                @Override
                public String getToolTipText(MouseEvent mouseEvent) {
                    String string = "";
                    Point point = mouseEvent.getPoint();
                    int n = this.rowAtPoint(point);
                    int n2 = this.columnAtPoint(point);
                    try {
                        string = ConfigurationPanel.this._table.getValueAt(n, n2).toString();
                    }
                    catch (RuntimeException runtimeException) {
                        _logger.log(Level.INFO, runtimeException.getMessage());
                    }
                    return string;
                }
            };
            this._table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
            this._table.setSelectionMode(0);
            this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    try {
                        for (int i = 0; i < PasswordlessSSHTestPanel.this.orderedHostList.size(); ++i) {
                            if (!PasswordlessSSHTestPanel.this.hostList.get(ConfigurationPanel.this._table.getSelectedRow()).equalsIgnoreCase(PasswordlessSSHTestPanel.this.orderedHostList.get(i))) continue;
                            PasswordlessSSHTestPanel.this.selectedHostIdx = i;
                            break;
                        }
                        PasswordlessSSHTestPanel.this.detailsPanel.detailsDataChanged();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this._table.getTableHeader().setReorderingAllowed(false);
            this._scrollPane = new JScrollPane(this._table);
            this._addHost = new JButton(Messages.getString("TimesTenGrid.addHost"));
            this._removeHost = new JButton(Messages.getString("TimesTenGrid.remHost"));
            this._credPanel = new CredentialsPanel(false);
            this._credPanel.initialize();
            this.add((Component)this._credPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 21, 2, new Insets(5, 15, 5, 0), 0, 0));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.add((Component)this._addHost, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 15, 5, 0), 0, 0));
            jPanel.add((Component)this._removeHost, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 15, 5, 0), 0, 0));
            jPanel.add((Component)this._scrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 15, 15, 15), 0, 0));
            jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.hostsLabel")));
            this.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 21, 1, new Insets(5, 15, 5, 0), 0, 0));
            this._addHost.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PasswordlessSSHTestPanel.this.hostList.add(new String());
                    PasswordlessSSHTestPanel.this.hostTypeList.add(true);
                    PasswordlessSSHTestPanel.this.testResultGlobalMsgList.add(new String());
                    ConfigurationPanel.this.clearResultMsgs();
                    PasswordlessSSHTestPanel.this.configPanel.dataChanged();
                }
            });
            this._removeHost.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = Arrays.copyOf(ConfigurationPanel.this._table.getSelectedRows(), ConfigurationPanel.this._table.getSelectedRows().length);
                    Arrays.sort(nArray);
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        PasswordlessSSHTestPanel.this.hostList.remove(nArray[i]);
                        PasswordlessSSHTestPanel.this.hostTypeList.remove(nArray[i]);
                        PasswordlessSSHTestPanel.this.testResultGlobalMsgList.remove(nArray[i]);
                    }
                    ConfigurationPanel.this.clearResultMsgs();
                    PasswordlessSSHTestPanel.this.configPanel.dataChanged();
                }
            });
            this.setNames();
        }

        public void clearResultMsgs() {
            int n;
            for (n = 0; n < PasswordlessSSHTestPanel.this.testResultGlobalMsgList.size(); ++n) {
                PasswordlessSSHTestPanel.this.testResultGlobalMsgList.set(n, Messages.getString("TimesTenGrid.notTested"));
            }
            for (n = 0; n < PasswordlessSSHTestPanel.this.detailsHostList.size(); ++n) {
                HostConnection hostConnection = PasswordlessSSHTestPanel.this.detailsHostList.get(n);
                for (int i = 0; i < hostConnection.getSize(); ++i) {
                    hostConnection.setMessage(i, Messages.getString("TimesTenGrid.notTested"));
                }
            }
        }

        private void setNames() {
            this._addHost.setName(Messages.getString("TimesTenGrid.addHost"));
            this._removeHost.setName(Messages.getString("TimesTenGrid.remHost"));
        }

        String getAdmin() {
            return this._credPanel.getInstanceAdmin();
        }

        char[] getAdminPass() {
            return this._credPanel.getPassword();
        }

        String getKeyFile() {
            return this._credPanel.getKeyFile();
        }

        private class HostsTableModel
        extends AbstractTableModel
        implements TableModelListener {
            private static final long serialVersionUID = 1L;

            public HostsTableModel() {
                this.addTableModelListener(this);
            }

            @Override
            public int getRowCount() {
                return PasswordlessSSHTestPanel.this.hostList.size();
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                if (typeTest == SshTestType.MGMTDATA) {
                    return n2 < 2 && !PasswordlessSSHTestPanel.this.testRunning;
                }
                return n2 == 0;
            }

            @Override
            public int getColumnCount() {
                if (typeTest == SshTestType.MGMTDATA) {
                    return ConfigurationPanel.this.HEADER.length;
                }
                return ConfigurationPanel.this.HEADER.length - 1;
            }

            @Override
            public String getColumnName(int n) {
                if (typeTest == SshTestType.MGMTDATA) {
                    return ConfigurationPanel.this.HEADER[n];
                }
                if (n == 1) {
                    return ConfigurationPanel.this.HEADER[2];
                }
                return ConfigurationPanel.this.HEADER[n];
            }

            @Override
            public Object getValueAt(int n, int n2) {
                try {
                    switch (n2) {
                        case 0: {
                            return PasswordlessSSHTestPanel.this.hostList.get(n);
                        }
                        case 1: {
                            if (typeTest == SshTestType.MGMTDATA) {
                                return PasswordlessSSHTestPanel.this.hostTypeList.get(n);
                            }
                            return PasswordlessSSHTestPanel.this.testResultGlobalMsgList.get(n);
                        }
                        case 2: {
                            return PasswordlessSSHTestPanel.this.testResultGlobalMsgList.get(n);
                        }
                    }
                }
                catch (Exception exception) {
                    _logger.severe("Error get value");
                }
                return null;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                switch (n2) {
                    case 0: {
                        PasswordlessSSHTestPanel.this.hostList.set(n, object.toString());
                        break;
                    }
                    case 1: {
                        if (typeTest != SshTestType.MGMTDATA) break;
                        PasswordlessSSHTestPanel.this.hostTypeList.set(n, (Boolean)object);
                        break;
                    }
                }
                this.fireTableCellUpdated(n, n2);
                this.fireTableDataChanged();
            }

            @Override
            public Class<?> getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                int n;
                int n2 = tableModelEvent.getColumn();
                int n3 = n = typeTest == SshTestType.MGMTDATA ? 2 : 1;
                if (n2 != n && n2 > 0) {
                    PasswordlessSSHTestPanel.this._applyBtn.setEnabled(true);
                }
            }
        }
    }

    private static enum SshTestType {
        FULL,
        MGMTDATA;

    }
}

