/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.editors;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.PieChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.ComboBox;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.util.Callback;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.javafx.ui.JFXPanelFactory;
import oracle.dbtools.raptor.oviewer.base.AsynchronousViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TimesTenPlugInDatabaseImpl;
import oracle.dbtools.raptor.timesten.ttdbobjects.TimestenElement;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Table;
import oracle.javatools.icons.OracleIcons;

public class TableDistributionFXTab
extends AsynchronousViewerEditor {
    private static final Logger LOGGER = Logger.getLogger(TableDistributionFXTab.class.getPackage().getName());
    private static final String SELECT_ROW_COUNT_GRID = "SELECT /*+ TT_PartialResult(1) TT_GRIDQUERYEXEC(GLOBAL) */  ELEMENTID# , count(*) from #owner#.#table# GROUP BY ELEMENTID# ORDER BY  ELEMENTID#;";
    static final int REFRESH_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"Refresh_TE_Editor");
    private static final String ELEMENT_STATUS_QUERY = "select /*+ TT_GridQueryExec(Global) TT_PartialResult(1) */ elementid# from sys.dual group by elementid#";
    private TabPane distributionTabPane;
    private TabPane distributionDetailsTabPane;
    private Tab distributionTab;
    private Tab detailsTab;
    private Tab detailsSummaryTab;
    private BorderPane mainFxPane;
    private final String DISTRIBUTION_QUERY = "SELECT MAPPEDELEMENTID, DATASPACE, REPSET, HOSTNAME, INSTANCENAME from SYS.V$DISTRIBUTION_CURRENT";
    private JFXPanel jfxPanel;
    private JPanel mainPane;
    private BarChart<String, Number> barChart;
    private PieChart pieChart;
    private String DATA_SPACE_GROUP = Messages.getString("PartitionTablePanel.dataspaceGroup");
    private String DATA_SPACE_GROUP_N = Messages.getString("TimesTenGrid.DBDSG");
    private String REPLICA_SET_N = Messages.getString("TimesTenGrid.DBReplicaSet");
    private HashMap<Integer, Long> dataspaceGroupCount = new HashMap();
    private final String DUPLICATE = Messages.getString("PartitionTablePanel.duplicate");
    private final String DISTRIBUTED_BY_HASH = Messages.getString("PartitionTablePanel.distributedByHash");
    private final String DISTRIBUTED_BY_REFERENCE = Messages.getString("PartitionTablePanel.distributedByReference");
    private final String NOT_DISTRIBUTED = Messages.getString("PartitionTablePanel.notDistributed");
    private final String NOT_SUPPORTED = Messages.getString("TimesTen.common.featureNotSupported");
    private IdeAction refreshAction;
    private BorderPane chartPane;
    private ComboBox<String> chartTypes;
    private ComboBox<String> replicaSetComboBox;
    private HashMap<Integer, HashMap<Integer, ElementInfo>> replicaDataSpaceInfo = new HashMap();
    private Boolean[] rowCountCompleteness;
    private ElementInfo[] subTotal = null;
    private int noReplicaSets;
    private int noDataSpaceGroups;
    private TableView<ElementInfo> tableView;
    private ObservableList<ElementInfo> tableData;
    private FilteredList<ElementInfo> filteredData;
    private SortedList<ElementInfo> sortedData;
    private TableView<ElementInfo> summaryTableView;
    private FilteredList<ElementInfo> summaryFilteredData;
    private SortedList<ElementInfo> summarySortedData;
    private TableColumn<ElementInfo, Integer> elementIdColumn;
    private TableColumn<ElementInfo, Integer> replicaSetColumn;
    private TableColumn<ElementInfo, Long> rowCountColumn;
    private TableColumn<ElementInfo, Double> distributionColumn;
    private TableColumn<ElementInfo, String> nameColumn;
    private TableColumn<ElementInfo, Integer> dataSpaceGroupColumn;
    private TableColumn<ElementInfo, Integer> summaryDataSpaceGroupColumn;
    private TableColumn<ElementInfo, Long> summaryRowCountColumn;
    private TableColumn<ElementInfo, Double> summaryDistributionColumn;
    private TimestenElement.TTPartitionType tablePartitionType;

    public TableDistributionFXTab() {
        this.setEditorAttribute("scrollable", false);
        this.refreshAction = IdeAction.findOrCreate((int)REFRESH_EDITOR_CMD_ID, null, (String)Messages.getString("TimestenGrid.refresh"), null, null, (Icon)OracleIcons.getIcon((String)"refresh.png"), null, (boolean)true).newLocalAction((View)this);
        this.refreshAction.addController(new Controller(){

            public boolean handleEvent(IdeAction ideAction, Context context) {
                TableDistributionFXTab.this.updateContent(true);
                return true;
            }

            public boolean update(IdeAction ideAction, Context context) {
                return false;
            }
        });
        TableDistributionFXTab.invokeLaterAfterRepaint((Runnable)new Runnable(){

            @Override
            public void run() {
                Toolbar toolbar = (Toolbar)UIUtils.findFirstOfType((JComponent)((JComponent)TableDistributionFXTab.this.getFixedTopMargin()), Toolbar.class);
                toolbar.add((ToggleAction)TableDistributionFXTab.this.refreshAction);
            }
        });
    }

    protected JComponent createViewerUI() {
        if (TimesTenPlugInDatabaseImpl.isGridDatabase(this.getCurrentConnection())) {
            if (this.jfxPanel == null) {
                this.createGridView();
            }
            return this.jfxPanel;
        }
        if (this.mainPane == null) {
            this.createClassicView();
        }
        return this.mainPane;
    }

    private void createClassicView() {
        this.mainPane = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(0));
        JLabel jLabel = new JLabel(this.NOT_SUPPORTED);
        jPanel.add(jLabel);
        this.mainPane.add(jPanel);
    }

    private void setupFX() {
        this.mainFxPane = new BorderPane();
        this.jfxPanel.setScene(new Scene((Parent)this.mainFxPane));
        this.distributionTab = new Tab(Messages.getString("PartitionTablePanel.distributionDetails"));
        this.distributionTab.setId("PartitionTablePanel.distributionDetails");
        this.distributionTab.setClosable(false);
        this.detailsTab = new Tab(Messages.getString("PartitionTablePanel.rowDistribution"));
        this.detailsTab.setId("PartitionTablePanel.rowDistribution");
        this.detailsTab.setClosable(false);
        SplitPane splitPane = new SplitPane();
        this.distributionTabPane = new TabPane(new Tab[]{this.distributionTab});
        this.distributionDetailsTabPane = new TabPane(new Tab[]{this.detailsTab});
        this.detailsSummaryTab = new Tab(Messages.getString("TimesTenGrid.summary"));
        this.detailsSummaryTab.setId("PartitionTablePanel.summary");
        this.detailsSummaryTab.setClosable(false);
        this.distributionDetailsTabPane.getTabs().add((Object)this.detailsSummaryTab);
        splitPane.setOrientation(Orientation.HORIZONTAL);
        splitPane.setDividerPosition(0, 0.35);
        SplitPane splitPane2 = new SplitPane();
        splitPane2.setOrientation(Orientation.VERTICAL);
        splitPane2.setDividerPosition(0, 0.25);
        this.chartPane = new BorderPane();
        splitPane2.getItems().addAll((Object[])new Node[]{this.distributionTabPane, this.distributionDetailsTabPane});
        splitPane.getItems().addAll((Object[])new Node[]{this.chartPane, splitPane2});
        HBox hBox = new HBox(15.0);
        Region region = new Region();
        HBox.setHgrow((Node)region, (Priority)Priority.ALWAYS);
        this.chartTypes = new ComboBox();
        this.replicaSetComboBox = new ComboBox();
        this.chartTypes.getItems().addAll((Object[])new String[]{Messages.getString("PartitionTablePanel.columnChart"), Messages.getString("PartitionTablePanel.pieChart")});
        this.chartTypes.getSelectionModel().select(0);
        this.chartTypes.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                TableDistributionFXTab.this.setChart();
            }
        });
        this.replicaSetComboBox.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                TableDistributionFXTab.this.changePie();
            }
        });
        hBox.getChildren().addAll((Object[])new Node[]{region, this.chartTypes, this.replicaSetComboBox});
        this.chartPane.setTop((Node)hBox);
        this.mainFxPane.setCenter((Node)splitPane);
    }

    private void fillInfo() {
        Table table = this.getTableObject();
        TimestenElement timestenElement = (TimestenElement)((Object)table.getProperty("TIMESTENELEMENT"));
        this.tablePartitionType = timestenElement.getTimestenPartitionType();
        this.chartTypes.setDisable(false);
        this.chartTypes.getItems().clear();
        this.chartTypes.getItems().addAll((Object[])new String[]{Messages.getString("PartitionTablePanel.columnChart"), Messages.getString("PartitionTablePanel.pieChart")});
        this.chartTypes.getSelectionModel().select(0);
        if (this.tablePartitionType == TimestenElement.TTPartitionType.DUPLICATE) {
            this.distributionTab.setContent(null);
            this.distributionTab.setText(this.DUPLICATE);
            this.chartTypes.getItems().clear();
            this.chartTypes.getItems().addAll((Object[])new String[]{Messages.getString("PartitionTablePanel.columnChart")});
            this.chartTypes.getSelectionModel().select(0);
        } else if (this.tablePartitionType == TimestenElement.TTPartitionType.HASH) {
            this.distributionTab.setText(this.DISTRIBUTED_BY_HASH);
            this.distributionTab.setContent(this.getHashTable(timestenElement));
        } else if (this.tablePartitionType == TimestenElement.TTPartitionType.REFERENCE) {
            this.distributionTab.setText(this.DISTRIBUTED_BY_REFERENCE);
            this.distributionTab.setContent(this.getReferenceTable(table, timestenElement));
        } else if (this.tablePartitionType == TimestenElement.TTPartitionType.NONE) {
            this.distributionTab.setText(this.NOT_DISTRIBUTED);
            this.distributionTab.setContent(null);
            this.chartTypes.getItems().clear();
            this.chartTypes.getSelectionModel().clearSelection();
            this.chartTypes.setDisable(true);
        }
        DataCollectionTask dataCollectionTask = new DataCollectionTask("Distribution Data", true, IRaptorTaskRunMode.IDE_STATUSBAR, this.tablePartitionType);
        RaptorTaskManager.getInstance().addTask((RaptorTask)dataCollectionTask);
    }

    private TableView<HashData> getHashTable(TimestenElement timestenElement) {
        TableView tableView = new TableView();
        tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        TableColumn tableColumn = new TableColumn(Messages.getString("PartitionTablePanel.selectedColumns"));
        tableColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<HashData, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<HashData, String> cellDataFeatures) {
                return new ReadOnlyObjectWrapper((Object)((HashData)cellDataFeatures.getValue()).getColumnName());
            }
        });
        tableView.getColumns().add((Object)tableColumn);
        for (Column column : timestenElement.getColumns()) {
            if (column == null) continue;
            tableView.getItems().add((Object)new HashData(column.getName()));
        }
        return tableView;
    }

    private TableView<ReferenceData> getReferenceTable(Table table, TimestenElement timestenElement) {
        TableView tableView = new TableView();
        tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        TableColumn tableColumn = new TableColumn(Messages.getString("PartitionTablePanel.localColumn"));
        tableColumn.setId("PartitionTablePanel.localColumn");
        tableColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ReferenceData, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ReferenceData, String> cellDataFeatures) {
                return new ReadOnlyObjectWrapper((Object)((ReferenceData)cellDataFeatures.getValue()).getLocal());
            }
        });
        TableColumn tableColumn2 = new TableColumn(Messages.getString("PartitionTablePanel.referencedColumn"));
        tableColumn2.setId("PartitionTablePanel.referencedColumn");
        tableColumn2.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ReferenceData, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ReferenceData, String> cellDataFeatures) {
                return new ReadOnlyObjectWrapper((Object)((ReferenceData)cellDataFeatures.getValue()).getRemote());
            }
        });
        tableView.getColumns().addAll((Object[])new TableColumn[]{tableColumn, tableColumn2});
        FKConstraint fKConstraint = (FKConstraint)table.getConstraint(timestenElement.getForeignKey());
        try {
            Column[] columnArray;
            PKConstraint pKConstraint = (PKConstraint)fKConstraint.getReferenceID().resolveID();
            Column[] columnArray2 = fKConstraint.getColumns();
            if (pKConstraint != null) {
                columnArray = pKConstraint.getColumns();
            } else {
                columnArray = new Column[columnArray2.length];
                for (int i = 0; i < columnArray2.length; ++i) {
                    columnArray[i] = new Column();
                    columnArray[i].setName(Messages.getString("TimesTen.common.unavailable"));
                }
                NameBasedID nameBasedID = (NameBasedID)fKConstraint.getReferenceID();
                String string = nameBasedID.getName();
                NameBasedID nameBasedID2 = (NameBasedID)nameBasedID.getParent();
                String string2 = nameBasedID2.getName();
                String string3 = nameBasedID2.getSchemaName();
                try {
                    String[] stringArray = this.getColumnsFromIndex(string3, string, string2);
                    if (stringArray != null) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            columnArray[i].setName(stringArray[i]);
                        }
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            for (int i = 0; i < columnArray2.length; ++i) {
                tableView.getItems().add((Object)new ReferenceData(columnArray2[i].getName(), columnArray[i].getName()));
            }
        }
        catch (DBException dBException) {
            dBException.printStackTrace();
        }
        return tableView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getColumnsFromIndex(String string, String string2, String string3) throws SQLException {
        Connection connection = null;
        try {
            String[] stringArray;
            byte[] byArray;
            int n;
            int n2;
            int n3;
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block13: {
                preparedStatement = null;
                connection = this.getCurrentConnection();
                Connections.getInstance().lock(connection);
                try {
                    preparedStatement = connection.prepareStatement("SELECT t.tblid, numcols, keycnt, keycols from sys.tables t, sys.indexes i where rtrim(ixname) = ? and rtrim(ixowner) = ? and tblname = ? and t.tblid = i.tblid");
                    preparedStatement.setString(1, string2);
                    preparedStatement.setString(2, string);
                    preparedStatement.setString(3, string3);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        n3 = resultSet.getInt(1);
                        n2 = resultSet.getInt(2);
                        n = resultSet.getInt(3);
                        byArray = resultSet.getBytes(4);
                        break block13;
                    }
                    String[] stringArray2 = null;
                    return stringArray2;
                }
                finally {
                    preparedStatement.close();
                }
            }
            String[] stringArray3 = new String[n2];
            try {
                preparedStatement = connection.prepareStatement("SELECT colnum, rtrim(COLNAME) from SYS.COLUMNS where ID= ?");
                preparedStatement.setInt(1, n3);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    stringArray3[resultSet.getInt((int)1) - 1] = resultSet.getString(2);
                }
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                byteBuffer.order(ByteOrder.nativeOrder());
                String[] stringArray4 = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray4[i] = stringArray3[byteBuffer.getShort() - 1];
                }
                stringArray = stringArray4;
            }
            catch (Throwable throwable) {
                preparedStatement.close();
                throw throwable;
            }
            preparedStatement.close();
            return stringArray;
        }
        finally {
            Connections.getInstance().unlock(connection);
        }
    }

    private void setupDistributionTable() {
        this.replicaSetComboBox.getItems().clear();
        final NumberFormat numberFormat = NumberFormat.getInstance();
        final NumberFormat numberFormat2 = NumberFormat.getPercentInstance();
        this.tableView = new TableView();
        this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.tableView.setRowFactory((Callback)new Callback<TableView<ElementInfo>, TableRow<ElementInfo>>(){

            public TableRow<ElementInfo> call(TableView<ElementInfo> tableView) {
                return new TableRow<ElementInfo>(){

                    protected void updateItem(ElementInfo elementInfo, boolean bl) {
                        super.updateItem((Object)elementInfo, bl);
                        this.setStyle("-fx-font-weight: normal;");
                        if (bl || elementInfo == null) {
                            return;
                        }
                        if (elementInfo.dataSpaceGroup > 0) {
                            return;
                        }
                        this.setStyle("-fx-font-weight: bold;");
                    }
                };
            }
        });
        this.tableData = FXCollections.observableArrayList();
        this.filteredData = new FilteredList(this.tableData);
        this.sortedData = new SortedList(this.filteredData);
        this.tableView.setOnSort(sortEvent -> this.filteredData.setPredicate(elementInfo -> {
            if (this.tableView.getSortOrder().contains(this.dataSpaceGroupColumn) || this.tableView.getSortOrder().isEmpty()) {
                return true;
            }
            return elementInfo.dataSpaceGroup > 0;
        }));
        this.tableView.setItems(this.sortedData);
        this.sortedData.comparatorProperty().bind((ObservableValue)this.tableView.comparatorProperty());
        this.summaryTableView = new TableView();
        this.summaryTableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.summaryFilteredData = new FilteredList(this.tableData, elementInfo -> elementInfo.dataSpaceGroup < 0);
        this.summarySortedData = new SortedList(this.summaryFilteredData);
        this.summaryTableView.setItems(this.summarySortedData);
        this.summarySortedData.comparatorProperty().bind((ObservableValue)this.summaryTableView.comparatorProperty());
        this.elementIdColumn = new TableColumn(Messages.getString("CountTableRows.elemenId"));
        this.elementIdColumn.setId("CountTableRows.elemenId");
        this.elementIdColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ElementInfo, Integer>, ObservableValue<Integer>>(){

            public ObservableValue<Integer> call(TableColumn.CellDataFeatures<ElementInfo, Integer> cellDataFeatures) {
                return new ReadOnlyObjectWrapper((Object)((ElementInfo)cellDataFeatures.getValue()).getElementId());
            }
        });
        this.replicaSetColumn = new TableColumn(Messages.getString("TimesTenGrid.replicaSet"));
        this.replicaSetColumn.setId("TimesTenGrid.replicaSet");
        this.replicaSetColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ElementInfo, Integer>, ObservableValue<Integer>>(){

            public ObservableValue<Integer> call(TableColumn.CellDataFeatures<ElementInfo, Integer> cellDataFeatures) {
                return new ReadOnlyObjectWrapper((Object)((ElementInfo)cellDataFeatures.getValue()).getReplicaSet());
            }
        });
        this.rowCountColumn = new TableColumn(Messages.getString("CountTableRows.rowCount"));
        this.rowCountColumn.setId("CountTableRows.rowCount");
        this.rowCountColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ElementInfo, Long>, ObservableValue<Long>>(){

            public ObservableValue<Long> call(TableColumn.CellDataFeatures<ElementInfo, Long> cellDataFeatures) {
                return new ReadOnlyObjectWrapper((Object)((ElementInfo)cellDataFeatures.getValue()).getValue());
            }
        });
        this.rowCountColumn.setCellFactory((Callback)new Callback<TableColumn<ElementInfo, Long>, TableCell<ElementInfo, Long>>(){

            public TableCell<ElementInfo, Long> call(TableColumn<ElementInfo, Long> tableColumn) {
                TableCell<ElementInfo, Long> tableCell = new TableCell<ElementInfo, Long>(){

                    protected void updateItem(Long l, boolean bl) {
                        super.updateItem((Object)l, bl);
                        this.setStyle("-fx-alignment: center-right;");
                        if (bl || l == null) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else if (l == -1L) {
                            this.setText(Messages.getString("TimesTen.common.unavailable"));
                        } else {
                            this.setText(numberFormat.format(l));
                        }
                    }
                };
                return tableCell;
            }
        });
        this.distributionColumn = new TableColumn(Messages.getString("CountTableRows.distribution"));
        this.distributionColumn.setId("CountTableRows.distribution");
        this.distributionColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ElementInfo, Double>, ObservableValue<Double>>(){

            public ObservableValue<Double> call(TableColumn.CellDataFeatures<ElementInfo, Double> cellDataFeatures) {
                return new ReadOnlyObjectWrapper((Object)((ElementInfo)cellDataFeatures.getValue()).getDistribution());
            }
        });
        this.distributionColumn.setCellFactory((Callback)new Callback<TableColumn<ElementInfo, Double>, TableCell<ElementInfo, Double>>(){

            public TableCell<ElementInfo, Double> call(TableColumn<ElementInfo, Double> tableColumn) {
                TableCell<ElementInfo, Double> tableCell = new TableCell<ElementInfo, Double>(){

                    protected void updateItem(Double d, boolean bl) {
                        super.updateItem((Object)d, bl);
                        if (bl || d == null) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else if (d < 0.0) {
                            this.setText(Messages.getString("TimesTen.common.unavailable"));
                        } else {
                            this.setText(numberFormat2.format(d));
                            this.setGraphic(null);
                        }
                    }
                };
                return tableCell;
            }
        });
        this.nameColumn = new TableColumn(Messages.getString("PartitionTablePanel.name"));
        this.nameColumn.setId("PartitionTablePanel.name");
        this.nameColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ElementInfo, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<ElementInfo, String> cellDataFeatures) {
                return new ReadOnlyObjectWrapper((Object)((ElementInfo)cellDataFeatures.getValue()).getName());
            }
        });
        this.dataSpaceGroupColumn = new TableColumn(this.DATA_SPACE_GROUP);
        this.dataSpaceGroupColumn.setId("PartitionTablePanel.dataspaceGroup");
        this.dataSpaceGroupColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ElementInfo, Integer>, ObservableValue<Integer>>(){

            public ObservableValue<Integer> call(TableColumn.CellDataFeatures<ElementInfo, Integer> cellDataFeatures) {
                return new ReadOnlyObjectWrapper((Object)((ElementInfo)cellDataFeatures.getValue()).getDataSpaceGroup());
            }
        });
        this.dataSpaceGroupColumn.setCellFactory((Callback)new Callback<TableColumn<ElementInfo, Integer>, TableCell<ElementInfo, Integer>>(){

            public TableCell<ElementInfo, Integer> call(TableColumn<ElementInfo, Integer> tableColumn) {
                return new TableCell<ElementInfo, Integer>(){

                    protected void updateItem(Integer n, boolean bl) {
                        super.updateItem((Object)n, bl);
                        if (bl || n == null) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else if (n < 0) {
                            this.setText(Messages.getString("TimesTenGrid.summary"));
                        } else {
                            this.setText(n.toString());
                        }
                    }
                };
            }
        });
        this.dataSpaceGroupColumn.setComparator((n, n2) -> {
            int n3;
            int n4 = Math.abs(n);
            if (n4 == (n3 = Math.abs(n2))) {
                if (this.dataSpaceGroupColumn.getSortType() == TableColumn.SortType.ASCENDING) {
                    return n2 - n;
                }
                return n - n2;
            }
            return n4 - n3;
        });
        this.summaryDataSpaceGroupColumn = new TableColumn(this.DATA_SPACE_GROUP);
        this.summaryDataSpaceGroupColumn.setId("PartitionTablePanel.dataspaceGroupSummary");
        this.summaryDataSpaceGroupColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ElementInfo, Integer>, ObservableValue<Integer>>(){

            public ObservableValue<Integer> call(TableColumn.CellDataFeatures<ElementInfo, Integer> cellDataFeatures) {
                return new ReadOnlyObjectWrapper((Object)((ElementInfo)cellDataFeatures.getValue()).getDataSpaceGroup());
            }
        });
        this.summaryDataSpaceGroupColumn.setCellFactory((Callback)new Callback<TableColumn<ElementInfo, Integer>, TableCell<ElementInfo, Integer>>(){

            public TableCell<ElementInfo, Integer> call(TableColumn<ElementInfo, Integer> tableColumn) {
                return new TableCell<ElementInfo, Integer>(){

                    protected void updateItem(Integer n, boolean bl) {
                        super.updateItem((Object)n, bl);
                        if (bl || n == null) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            int n2 = Math.abs(n);
                            this.setText(Integer.toString(n2));
                        }
                    }
                };
            }
        });
        this.summaryDataSpaceGroupColumn.setComparator((n, n2) -> {
            int n3 = Math.abs(n);
            int n4 = Math.abs(n2);
            return n3 - n4;
        });
        this.summaryRowCountColumn = new TableColumn(Messages.getString("CountTableRows.rowCount"));
        this.summaryRowCountColumn.setId("CountTableRows.rowCountSummary");
        this.summaryRowCountColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ElementInfo, Long>, ObservableValue<Long>>(){

            public ObservableValue<Long> call(TableColumn.CellDataFeatures<ElementInfo, Long> cellDataFeatures) {
                return new ReadOnlyObjectWrapper((Object)((ElementInfo)cellDataFeatures.getValue()).getValue());
            }
        });
        this.summaryRowCountColumn.setCellFactory((Callback)new Callback<TableColumn<ElementInfo, Long>, TableCell<ElementInfo, Long>>(){

            public TableCell<ElementInfo, Long> call(TableColumn<ElementInfo, Long> tableColumn) {
                TableCell<ElementInfo, Long> tableCell = new TableCell<ElementInfo, Long>(){

                    protected void updateItem(Long l, boolean bl) {
                        super.updateItem((Object)l, bl);
                        this.setStyle("-fx-alignment: center-right;");
                        if (bl || l == null) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else if (l == -1L) {
                            this.setText(Messages.getString("TimesTen.common.unavailable"));
                        } else {
                            this.setText(numberFormat.format(l));
                        }
                    }
                };
                return tableCell;
            }
        });
        this.summaryDistributionColumn = new TableColumn(Messages.getString("CountTableRows.distribution"));
        this.summaryDistributionColumn.setId("CountTableRows.distributionSummary");
        this.summaryDistributionColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ElementInfo, Double>, ObservableValue<Double>>(){

            public ObservableValue<Double> call(TableColumn.CellDataFeatures<ElementInfo, Double> cellDataFeatures) {
                return new ReadOnlyObjectWrapper((Object)((ElementInfo)cellDataFeatures.getValue()).getDistribution());
            }
        });
        this.summaryDistributionColumn.setCellFactory((Callback)new Callback<TableColumn<ElementInfo, Double>, TableCell<ElementInfo, Double>>(){

            public TableCell<ElementInfo, Double> call(TableColumn<ElementInfo, Double> tableColumn) {
                TableCell<ElementInfo, Double> tableCell = new TableCell<ElementInfo, Double>(){

                    protected void updateItem(Double d, boolean bl) {
                        super.updateItem((Object)d, bl);
                        if (bl || d == null) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else if (d < 0.0) {
                            this.setText(Messages.getString("TimesTen.common.unavailable"));
                        } else {
                            this.setText(numberFormat2.format(d));
                            this.setGraphic(null);
                        }
                    }
                };
                return tableCell;
            }
        });
        this.summaryTableView.getColumns().addAll((Object[])new TableColumn[]{this.summaryDataSpaceGroupColumn, this.summaryRowCountColumn, this.summaryDistributionColumn});
    }

    private TableView<ElementInfo> getDistributionTable(TimestenElement.TTPartitionType tTPartitionType) {
        if (this.tableView == null) {
            this.setupDistributionTable();
        }
        this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.tableView.getColumns().clear();
        this.tableData.clear();
        if (tTPartitionType == TimestenElement.TTPartitionType.DUPLICATE) {
            this.tableView.getColumns().addAll((Object[])new TableColumn[]{this.dataSpaceGroupColumn, this.replicaSetColumn, this.elementIdColumn, this.nameColumn, this.rowCountColumn});
        } else if (tTPartitionType == TimestenElement.TTPartitionType.NONE) {
            this.tableView.getColumns().addAll((Object[])new TableColumn[]{this.elementIdColumn, this.nameColumn, this.rowCountColumn});
        } else {
            this.tableView.getColumns().addAll((Object[])new TableColumn[]{this.dataSpaceGroupColumn, this.replicaSetColumn, this.elementIdColumn, this.nameColumn, this.rowCountColumn, this.distributionColumn});
        }
        this.replicaSetComboBox.getItems().clear();
        for (Integer n : this.dataspaceGroupCount.keySet()) {
            if (!this.rowCountCompleteness[n - 1].booleanValue()) continue;
            this.replicaSetComboBox.getItems().add((Object)(this.DATA_SPACE_GROUP + n));
        }
        for (int i = 1; i <= this.noDataSpaceGroups; ++i) {
            for (int j = 1; j <= this.noReplicaSets; ++j) {
                ElementInfo elementInfo = this.replicaDataSpaceInfo.get(j).get(i);
                this.tableData.add((Object)elementInfo);
            }
            if (tTPartitionType == TimestenElement.TTPartitionType.DUPLICATE || tTPartitionType == TimestenElement.TTPartitionType.NONE) continue;
            this.tableData.add((Object)this.subTotal[i - 1]);
        }
        return this.tableView;
    }

    private void changePie() {
        String string = (String)this.replicaSetComboBox.getSelectionModel().getSelectedItem();
        if (string != null) {
            String string2 = string.replace(this.DATA_SPACE_GROUP, "");
            if (!string2.isEmpty()) {
                this.createPieChart(Integer.parseInt(string2));
            }
        } else {
            this.cleanPieChart();
        }
    }

    private void setChart() {
        int n = this.chartTypes.getSelectionModel().getSelectedIndex();
        if (n == 0) {
            this.createBarchart();
            this.replicaSetComboBox.setDisable(true);
            this.chartPane.setCenter(this.barChart);
        } else if (n == 1) {
            this.replicaSetComboBox.getSelectionModel().select(0);
            this.replicaSetComboBox.setDisable(false);
            this.changePie();
            this.chartPane.setCenter((Node)this.pieChart);
        } else {
            this.chartPane.setCenter(null);
        }
    }

    private void createGridView() {
        this.jfxPanel = JFXPanelFactory.createJFXPanel();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TableDistributionFXTab.this.setupFX();
            }
        });
    }

    protected void updateContent(boolean bl) {
        if (TimesTenPlugInDatabaseImpl.isGridDatabase(this.getCurrentConnection())) {
            if (Platform.isFxApplicationThread()) {
                this.fillInfo();
                this.setChart();
            } else {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TableDistributionFXTab.this.fillInfo();
                        TableDistributionFXTab.this.setChart();
                    }
                });
            }
        }
    }

    protected void cleanUp() {
    }

    public Object getPrintable() {
        return null;
    }

    private void createBarchart() {
        CategoryAxis categoryAxis = new CategoryAxis();
        NumberAxis numberAxis = new NumberAxis();
        this.barChart = new BarChart((Axis)categoryAxis, (Axis)numberAxis);
        categoryAxis.setLabel(this.DATA_SPACE_GROUP);
        categoryAxis.setId("Dataspace Group");
        numberAxis.setLabel(Messages.getString("CountTableRows.rowCount"));
        numberAxis.setId("CountTableRows.rowCount");
        this.barChart.setTitle(MessageFormat.format(Messages.getString("PartitionTablePanel.tableDistributionEnhanced"), this.getViewerNode().getDBObject().getObjectName()));
        this.barChart.setId("PartitionTablePanel.tableDistributionEnhanced");
        this.barChart.getData().clear();
        for (Integer n : this.replicaDataSpaceInfo.keySet()) {
            HashMap<Integer, ElementInfo> hashMap = this.replicaDataSpaceInfo.get(n);
            XYChart.Series series = new XYChart.Series();
            series.setName(MessageFormat.format(this.REPLICA_SET_N, n));
            for (Integer n2 : hashMap.keySet()) {
                ElementInfo elementInfo = hashMap.get(n2);
                String string = MessageFormat.format(this.DATA_SPACE_GROUP_N, elementInfo.dataSpaceGroup);
                series.getData().add((Object)new XYChart.Data((Object)string, (Object)(elementInfo.value < 0L ? 0L : elementInfo.value)));
            }
            this.barChart.getData().add((Object)series);
        }
    }

    private void createPieChart(int n) {
        this.pieChart = new PieChart();
        this.pieChart.setLegendSide(Side.BOTTOM);
        ObservableList observableList = this.pieChart.getData();
        for (HashMap<Integer, ElementInfo> hashMap : this.replicaDataSpaceInfo.values()) {
            ElementInfo elementInfo = hashMap.get(n);
            String string = MessageFormat.format(this.REPLICA_SET_N, elementInfo.getReplicaSet());
            observableList.add((Object)new PieChart.Data(string, (double)elementInfo.getValue().longValue()));
        }
    }

    private void cleanPieChart() {
        if (this.pieChart == null || this.pieChart.getData() == null) {
            return;
        }
        this.pieChart.getData().clear();
    }

    private void setMaxBarWidth(double d, double d2, BarChart<String, Number> barChart, CategoryAxis categoryAxis, NumberAxis numberAxis) {
        double d3;
        double d4;
        double d5 = 0.0;
        do {
            if (!((d5 = (d4 = (d3 = categoryAxis.getCategorySpacing()) - (barChart.getCategoryGap() + barChart.getBarGap())) / (double)barChart.getData().size() - barChart.getBarGap()) > d)) continue;
            d4 = (d + barChart.getBarGap()) * (double)barChart.getData().size();
            barChart.setCategoryGap(d3 - d4 - barChart.getBarGap());
        } while (d5 > d);
        do {
            d3 = categoryAxis.getCategorySpacing();
            d4 = d3 - (d2 + barChart.getBarGap());
            d5 = Math.min(d, d4 / (double)barChart.getData().size() - barChart.getBarGap());
            d4 = (d5 + barChart.getBarGap()) * (double)barChart.getData().size();
            barChart.setCategoryGap(d3 - d4 - barChart.getBarGap());
        } while (d5 < d && barChart.getCategoryGap() > d2);
    }

    private ElementInfo getElementData(Integer n) {
        for (HashMap<Integer, ElementInfo> hashMap : this.replicaDataSpaceInfo.values()) {
            for (ElementInfo elementInfo : hashMap.values()) {
                if (!elementInfo.elementId.equals(n)) continue;
                return elementInfo;
            }
        }
        return null;
    }

    private Connection getCurrentConnection() {
        ViewerNode viewerNode = this.getViewerNode();
        DBObject dBObject = viewerNode.getDBObject();
        return dBObject.getConnection();
    }

    private Table getTableObject() {
        ViewerNode viewerNode = this.getViewerNode();
        DBObject dBObject = viewerNode.getDBObject();
        if (dBObject.getObjectType().equalsIgnoreCase("MATERIALIZED VIEW")) {
            try {
                TimesTenPlugInDatabaseImpl timesTenPlugInDatabaseImpl = (TimesTenPlugInDatabaseImpl)dBObject.getDatabase();
                return (Table)timesTenPlugInDatabaseImpl.createSchemaObject(dBObject.getSchemaName(), dBObject.getObjectName(), dBObject.getObjectType());
            }
            catch (DBException dBException) {
                LOGGER.log(Level.SEVERE, "Internal error, cannot get schema object", dBException);
                return null;
            }
        }
        return (Table)dBObject.getSchemaObject();
    }

    public class ReferenceData {
        String local;
        String remote;

        public ReferenceData(String string, String string2) {
            this.local = string;
            this.remote = string2;
        }

        public String getLocal() {
            return this.local;
        }

        public String getRemote() {
            return this.remote;
        }
    }

    public class HashData {
        private String columnName;

        public HashData(String string) {
            this.columnName = string;
        }

        public String getColumnName() {
            return this.columnName;
        }
    }

    private class DataCollectionTask
    extends RaptorTask<Void> {
        private TableView<ElementInfo> dataModel;
        private final TimestenElement.TTPartitionType partitionType;

        public DataCollectionTask(String string, boolean bl, IRaptorTaskRunMode iRaptorTaskRunMode, TimestenElement.TTPartitionType tTPartitionType) {
            super(string, bl, iRaptorTaskRunMode);
            this.partitionType = tTPartitionType;
            this.addListener();
        }

        protected Void doWork() throws TaskException {
            this.checkDistribution();
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkDistribution() {
            TableDistributionFXTab.this.dataspaceGroupCount.clear();
            TableDistributionFXTab.this.replicaDataSpaceInfo.clear();
            ViewerNode viewerNode = TableDistributionFXTab.this.getViewerNode();
            DBObject dBObject = viewerNode.getDBObject();
            Connection connection = null;
            try {
                Object object;
                Serializable serializable2;
                int n;
                connection = dBObject.getConnection();
                Connections.getInstance().lock(connection);
                String string = TableDistributionFXTab.SELECT_ROW_COUNT_GRID.replace("#owner#", dBObject.getSchemaName()).replace("#table#", dBObject.getObjectName());
                long l = System.currentTimeMillis();
                PreparedStatement preparedStatement = null;
                try {
                    preparedStatement = connection.prepareStatement("SELECT MAPPEDELEMENTID, DATASPACE, REPSET, HOSTNAME, INSTANCENAME from SYS.V$DISTRIBUTION_CURRENT");
                    ResultSet resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        n = resultSet.getInt(1);
                        int n2 = resultSet.getInt(2);
                        int n3 = resultSet.getInt(3);
                        String object22 = resultSet.getString(4);
                        String string2 = resultSet.getString(5);
                        serializable2 = TableDistributionFXTab.this.replicaDataSpaceInfo.get(n3);
                        if (serializable2 == null) {
                            serializable2 = new HashMap();
                            TableDistributionFXTab.this.replicaDataSpaceInfo.put(n3, (HashMap<Integer, ElementInfo>)serializable2);
                        }
                        ElementInfo elementInfo = new ElementInfo();
                        elementInfo.dataSpaceGroup = n2;
                        elementInfo.elementId = n;
                        elementInfo.replicaSet = n3;
                        elementInfo.name = object22 + "." + string2;
                        elementInfo.value = 0L;
                        serializable2.put(n2, elementInfo);
                    }
                }
                catch (SQLException sQLException) {
                    LOGGER.log(Level.WARNING, "Cannot get element names", sQLException.getLocalizedMessage());
                }
                finally {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                LOGGER.finest("Elapsed time for distribution map query: " + (double)(System.currentTimeMillis() - l) / 1000.0);
                TableDistributionFXTab.this.noReplicaSets = TableDistributionFXTab.this.replicaDataSpaceInfo.values().size();
                TableDistributionFXTab.this.noDataSpaceGroups = TableDistributionFXTab.this.replicaDataSpaceInfo.get(1).keySet().size();
                LOGGER.finest("No. of replica sets: " + TableDistributionFXTab.this.noReplicaSets + " No. of data space groups: " + TableDistributionFXTab.this.noDataSpaceGroups);
                int n4 = 0;
                for (n = 1; n <= TableDistributionFXTab.this.noDataSpaceGroups; ++n) {
                    TableDistributionFXTab.this.dataspaceGroupCount.put(n, 0L);
                }
                try {
                    preparedStatement = connection.prepareStatement(string);
                    object = preparedStatement.executeQuery();
                    while (object.next()) {
                        ++n4;
                        Integer n5 = object.getInt(1);
                        ElementInfo elementInfo = TableDistributionFXTab.this.getElementData(n5);
                        if (elementInfo == null) {
                            LOGGER.warning("Element : " + n5 + " is not available; it may be down");
                            continue;
                        }
                        elementInfo.value = object.getLong(2);
                        Long l2 = TableDistributionFXTab.this.dataspaceGroupCount.get(elementInfo.dataSpaceGroup);
                        if (l2 == null) {
                            TableDistributionFXTab.this.dataspaceGroupCount.put(elementInfo.dataSpaceGroup, elementInfo.value);
                            continue;
                        }
                        TableDistributionFXTab.this.dataspaceGroupCount.put(elementInfo.dataSpaceGroup, l2 + elementInfo.value);
                    }
                }
                catch (SQLException sQLException) {
                    LOGGER.log(Level.SEVERE, "Cannot obtain row count for table, " + sQLException.getLocalizedMessage(), sQLException);
                }
                finally {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                LOGGER.finest("Elapsed time for count query: " + (double)(System.currentTimeMillis() - l) / 1000.0);
                LOGGER.finest("No. of row count reporting elements: " + n4);
                TableDistributionFXTab.this.rowCountCompleteness = new Boolean[TableDistributionFXTab.this.noDataSpaceGroups];
                Arrays.fill((Object[])TableDistributionFXTab.this.rowCountCompleteness, Boolean.TRUE);
                if (n4 != TableDistributionFXTab.this.noReplicaSets * TableDistributionFXTab.this.noDataSpaceGroups) {
                    object = null;
                    try {
                        object = connection.createStatement();
                        ResultSet resultSet = object.executeQuery(TableDistributionFXTab.ELEMENT_STATUS_QUERY);
                        while (resultSet.next()) {
                            ElementInfo elementInfo = TableDistributionFXTab.this.getElementData(resultSet.getInt(1));
                            elementInfo.active = Boolean.TRUE;
                        }
                        for (HashMap<Integer, ElementInfo> hashMap : TableDistributionFXTab.this.replicaDataSpaceInfo.values()) {
                            for (Serializable serializable2 : hashMap.values()) {
                                if (((ElementInfo)((Object)serializable2)).active != null) continue;
                                TableDistributionFXTab.this.rowCountCompleteness[((ElementInfo)((Object)serializable2)).dataSpaceGroup.intValue() - 1] = Boolean.FALSE;
                                LOGGER.warning("Row count information is not available for element: " + ((ElementInfo)((Object)serializable2)).elementId + " ; element may be down");
                                ((ElementInfo)((Object)serializable2)).value = -1L;
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        LOGGER.log(Level.SEVERE, "Cannot ascertain element status", sQLException);
                    }
                    finally {
                        try {
                            if (object != null) {
                                object.close();
                            }
                        }
                        catch (SQLException sQLException) {}
                    }
                    LOGGER.finest("Elapsed time for element status query: " + (double)(System.currentTimeMillis() - l) / 1000.0);
                }
                object = new double[TableDistributionFXTab.this.noDataSpaceGroups];
                for (HashMap<Integer, ElementInfo> hashMap : TableDistributionFXTab.this.replicaDataSpaceInfo.values()) {
                    for (ElementInfo elementInfo : hashMap.values()) {
                        if (!TableDistributionFXTab.this.rowCountCompleteness[elementInfo.dataSpaceGroup - 1].booleanValue()) {
                            elementInfo.distribution = -1.0;
                            Object object2 = object;
                            int n2 = elementInfo.dataSpaceGroup - 1;
                            object2[n2] = object2[n2] + elementInfo.distribution;
                            continue;
                        }
                        serializable2 = TableDistributionFXTab.this.dataspaceGroupCount.get(elementInfo.dataSpaceGroup);
                        elementInfo.distribution = serializable2 == null || (Long)serializable2 <= 0L ? Double.valueOf(0.0) : Double.valueOf((double)elementInfo.value.longValue() / (double)((Long)serializable2).longValue());
                        Object object3 = object;
                        int n3 = elementInfo.dataSpaceGroup - 1;
                        object3[n3] = object3[n3] + elementInfo.distribution;
                    }
                }
                if (TableDistributionFXTab.this.subTotal == null) {
                    TableDistributionFXTab.this.subTotal = new ElementInfo[TableDistributionFXTab.this.noDataSpaceGroups];
                }
                for (int i = 1; i <= TableDistributionFXTab.this.noDataSpaceGroups; ++i) {
                    if (this.partitionType == TimestenElement.TTPartitionType.DUPLICATE || this.partitionType == TimestenElement.TTPartitionType.NONE) continue;
                    TableDistributionFXTab.this.subTotal[i - 1] = new ElementInfo();
                    TableDistributionFXTab.this.subTotal[i - 1].dataSpaceGroup = -i;
                    if (TableDistributionFXTab.this.rowCountCompleteness[i - 1].booleanValue()) {
                        TableDistributionFXTab.this.subTotal[i - 1].value = TableDistributionFXTab.this.dataspaceGroupCount.get(i);
                        TableDistributionFXTab.this.subTotal[i - 1].distribution = (double)object[i - 1];
                        continue;
                    }
                    TableDistributionFXTab.this.subTotal[i - 1].value = -1L;
                    TableDistributionFXTab.this.subTotal[i - 1].distribution = -1.0;
                }
            }
            finally {
                if (connection != null) {
                    Connections.getInstance().unlock(connection);
                }
            }
        }

        private void addListener() {
            RaptorTaskAdapter raptorTaskAdapter = new RaptorTaskAdapter(){

                public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                    super.taskCancelled(raptorTaskEvent);
                }

                public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                    super.taskFailed(raptorTaskEvent);
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    if (Platform.isFxApplicationThread()) {
                        DataCollectionTask.this.updateDistributionView();
                    } else {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                DataCollectionTask.this.updateDistributionView();
                            }
                        });
                    }
                }
            };
            this.getDescriptor().addListener((IRaptorTaskListener)raptorTaskAdapter);
        }

        private void updateDistributionView() {
            this.dataModel = TableDistributionFXTab.this.getDistributionTable(this.partitionType);
            TableDistributionFXTab.this.detailsTab.setContent(this.dataModel);
            TableDistributionFXTab.this.detailsSummaryTab.setContent(TableDistributionFXTab.this.summaryTableView);
            TableDistributionFXTab.this.setChart();
        }
    }

    public class ElementInfo {
        Integer elementId;
        Long value;
        Integer replicaSet;
        Integer dataSpaceGroup;
        String name;
        Double distribution;
        Boolean active;

        public Double getDistribution() {
            return this.distribution;
        }

        public Integer getElementId() {
            return this.elementId;
        }

        public Long getValue() {
            return this.value;
        }

        public Integer getReplicaSet() {
            return this.replicaSet;
        }

        public Integer getDataSpaceGroup() {
            return this.dataSpaceGroup;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "ElementInfo [elementId=" + this.elementId + ", value=" + this.value + ", replicaSet=" + this.replicaSet + ", dataSpaceGroup=" + this.dataSpaceGroup + ", name=" + this.name + ", distribution=" + this.distribution + "]";
        }
    }
}

