/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.editors;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.timesten.editors.TTTableViewer;
import oracle.dbtools.raptor.utils.DBObject;

public class MVLogColumns
extends TTTableViewer {
    private static final Logger _logger = Logger.getLogger(MVLogColumns.class.getPackage().getName());
    private MyTableModel _model;

    @Override
    protected final String GetPurposeTxt() {
        return "mvlog columns";
    }

    @Override
    protected void createTableModel() throws Exception {
        if (this._model == null) {
            this._model = new MyTableModel(this._dbObject);
            this._table.setModel(this._model);
        } else {
            this._model.init(this._dbObject);
        }
        this._model.fireTableDataChanged();
    }

    public static class MyTableModel
    extends AbstractTableModel {
        private List<Object[]> theRows = new ArrayList<Object[]>(32);
        private String[] theViewInfoColumnNames = new String[]{"COLUMN NAME", "DATA TYPE", "NULLABLE", "COLUMN ID", "PRIMARY KEY"};
        private int theNoColumnsInViewInfo = this.theViewInfoColumnNames.length;

        private MyTableModel(DBObject dBObject) throws Exception {
            try {
                this.init(dBObject);
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Cannot process view information " + sQLException.toString());
                throw sQLException;
            }
        }

        private void init(Connection connection, String string, String string2) throws SQLException {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                this.theRows.clear();
                String string3 = "select  \n rtrim(c.colname) \"Column Name\",\n case \n  when c.coltype = 1 then decode(m.type_mode,  0, 'TT_SMALLINT', 'SMALLINT')\n  when c.coltype = 2 then decode(m.type_mode, 0, 'TT_INTEGER',  'INTEGER')\n  when c.coltype = 3 then decode(m.type_mode,  0, 'BINARY_FLOAT', 'REAL')\n  when c.coltype = 4 then decode(m.type_mode, 0, 'BINARY_DOUBLE', 'DOUBLE')\n  when c.coltype = 5 then decode(m.type_mode, 0, 'TT_CHAR(', 'CHAR(') || to_char(c.type_attr) || ' ' ||\n    decode(c.char_used, 'C', 'CHAR','BYTE') || ')'\n  when c.coltype = 6 then decode(m.type_mode, 0, 'TT_VARCHAR(', 'VARCHAR(') || to_char(c.type_attr) || ' ' ||\n    decode(c.char_used, 'C', 'CHAR','BYTE') || ')'\n  when c.coltype = 7 then 'BINARY(' || to_char(c.collen) || ')'\n  when c.coltype = 8 then 'VARBINARY(' || to_char(c.collen) || ')'\n  when c.coltype = 11 then decode(m.type_mode, 0, 'TT_DECIMAL(', 'DECIMAL(') || \n    to_char(c.sys9) || ',' || to_char(c.sys10) || ')'\n  when c.coltype = 12 then decode(m.type_mode, 0, 'TT_NCHAR(', 'NCHAR(') || to_char(c.type_attr) || ')'\n  when c.coltype = 13 then decode(m.type_mode, 0, 'TT_NVARCHAR(', 'NVARCHAR(') || to_char(c.type_attr) || ')'\n  when c.coltype = 14 then decode(m.type_mode, 0, 'TT_DATE', 'DATE')\n  when c.coltype = 15 then decode(m.type_mode, 0, 'TT_TIME', 'TIME')\n  when c.coltype = 16 then decode(m.type_mode, 0, 'TT_TIMESTAMP', 'TIMESTAMP')\n  when c.coltype = 20 then decode(m.type_mode, 0, 'TT_TINYINT', 'TINYINT')\n  when c.coltype = 21 then decode(m.type_mode, 0, 'TT_BIGINT', 'BIGINT')\n  when c.coltype = 22 then decode(m.type_mode, 0, 'TT_VARCHAR(', 'VARCHAR(') || \n    to_char(c.type_attr) || ' ' || decode(c.char_used, 'C', 'CHAR','BYTE') || ') inline'\n  when c.coltype = 23 then 'VARBINARY(' || to_char(c.collen) || ') inline'\n  when c.coltype = 24 then decode(m.type_mode, 0, 'TT_NVARCHAR(', 'NVARCHAR(') || \n    to_char(c.type_attr) || ') inline'\n  when c.coltype = 25 and c.type_attr = 0 then concat('NUMBER', \n    case\n      when c.sys9 = 39 and c.sys10 = 128 then ''\n      when c.sys10 = 0 then '(' || to_char(c.sys9) || ')'\n      else '(' || to_char(c.sys9) || ',' || to_char(c.sys10) || ')'\n    end   \n    )\n  when c.coltype = 25 then decode(m.type_mode, 0, 'FLOAT(', 'ORA_FLOAT(') || to_char(c.type_attr) || ')'     \n  when c.coltype = 26 then decode(m.type_mode, 0, 'CHAR(', 'ORA_CHAR(') || to_char(c.type_attr) || ' ' || \n    decode(c.char_used, 'C', 'CHAR','BYTE') || ')'\n  when c.coltype = 27  then 'VARCHAR2(' || to_char(c.type_attr) || ' ' || \n    decode(c.char_used, 'C', 'CHAR', 'BYTE') || ')'\n  when c.coltype = 28 then decode(m.type_mode, 0, 'NCHAR(', 'ORA_NCHAR(') || to_char(c.type_attr) || ')'\n  when c.coltype = 29 then 'NVARCHAR2(' || to_char(c.type_attr) || ')'\n  when c.coltype = 30 then decode(m.type_mode, 0, 'DATE', 'ORA_DATE')\n  when c.coltype = 31 then decode(m.type_mode, 0, 'TIMESTAMP(', 'ORA_TIMESTAMP(') || to_char(c.sys10) || ')'\n  when c.coltype = 32 then 'VARCHAR2(' || to_char(c.type_attr) || ' ' || \n    decode(c.char_used, 'C', 'CHAR', 'BYTE') || ') inline'  \n  when c.coltype = 33 then 'NVARCHAR2(' || to_char(c.type_attr) || ') inline'\n  when c.coltype = 34 then decode(m.type_mode, 0, 'ROWID', 'ROWID')\n  when c.coltype = 36 then decode(m.type_mode, 0, 'CLOB', 'CLOB')\n  when c.coltype = 37 then decode(m.type_mode, 0, 'NCLOB', 'NCLOB')\n  when c.coltype = 38 then decode(m.type_mode, 0, 'BLOB', 'BLOB')\n\n  else concat('Unknown type ', to_char(c.coltype))\n end \"Data Type\",\n\n\n case \n  when cast(c.coloptions as char(1)) = 0x04 then 'Yes'\n  when cast(c.coloptions as char(1)) = 0x05 then 'Yes'\n  when cast(c.coloptions as char(1)) = 0x06 then 'Yes'\n  when cast(c.coloptions as char(1)) = 0x0C then 'Yes'\n  else 'No'\n end \"Nullable\",\n nvl(c.defaultvalstr, '(null)') \"Data Default\",\n c.colnum \"COLUMN ID\",\n case\n  when cast(c.coloptions as char(1)) = 0x01 then 'Yes'\n  when cast(c.coloptions as char(1)) = 0x03 then 'Yes'\n  when cast(c.coloptions as char(1)) = 0x05 then 'Yes'\n  when cast(c.coloptions as char(1)) = 0x09 then 'Yes'\n  else 'No'\n end \"Primary Key\"\nfrom sys.tables t, sys.columns c, sys.monitor m\nwhere\n t.tblid = c.id \n and  t.tblowner = '" + string + "' and t.tblname = '" + string2 + "' order by c.colnum";
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string3);
                while (resultSet.next()) {
                    Object[] objectArray = new Object[this.theNoColumnsInViewInfo];
                    objectArray[0] = resultSet.getString(1);
                    objectArray[1] = resultSet.getString(2);
                    objectArray[2] = resultSet.getString(3);
                    objectArray[3] = resultSet.getString(4);
                    objectArray[4] = resultSet.getString(5);
                    this.theRows.add(objectArray);
                }
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Cannot process information " + sQLException.toString());
                throw sQLException;
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }

        private String getMVLogName(Connection connection, String string) throws SQLException {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                this.theRows.clear();
                String string2 = "SELECT CONCAT('MVLOG$_',to_char(TBLID)) FROM SYS.TABLES WHERE TBLNAME='" + string + "'";
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string2);
                if (resultSet.next()) {
                    String string3 = resultSet.getString(1);
                    return string3;
                }
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Cannot process information " + sQLException.toString());
                throw sQLException;
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            return "";
        }

        private void init(DBObject dBObject) throws SQLException {
            String string = dBObject.getSchemaName();
            String string2 = dBObject.getObjectName();
            Connection connection = dBObject.getConnection();
            String string3 = this.getMVLogName(connection, string2);
            this.init(connection, string, string3);
        }

        @Override
        public final int getColumnCount() {
            return this.theViewInfoColumnNames.length;
        }

        @Override
        public final int getRowCount() {
            return this.theRows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n > this.theRows.size() || n2 > this.theNoColumnsInViewInfo) {
                return null;
            }
            return this.theRows.get(n)[n2];
        }

        @Override
        public final String getColumnName(int n) {
            return this.theViewInfoColumnNames[n];
        }
    }
}

