/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.editors;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.timesten.AgingInfo;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.editors.TTTableViewer;

public final class AgingAttributes
extends TTTableViewer {
    private MyTableModel _model;
    private static final Logger _logger = Logger.getLogger(AgingAttributes.class.getPackage().getName());

    @Override
    protected final String GetPurposeTxt() {
        return "aging attributes";
    }

    @Override
    protected void createTableModel() throws Exception {
        _logger.log(Level.INFO, "AgingAttributes createTableModel");
        if (this._model == null) {
            this._model = new MyTableModel();
            this._table.setModel(this._model);
        } else {
            this._model.init();
        }
        this._model.fireTableDataChanged();
    }

    @Override
    protected void postCreateHook() {
        this._table.setAutoResizeMode(3);
    }

    private class MyTableModel
    extends AbstractTableModel {
        static final int numCols = 2;
        private List<Object[]> theRows = new ArrayList<Object[]>(32);

        private MyTableModel() throws Exception {
            try {
                this.init();
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Cannot process " + AgingAttributes.this.GetPurposeTxt() + " " + sQLException.toString());
                throw sQLException;
            }
        }

        private void init() throws Exception {
            Connection connection = AgingAttributes.this._dbObject.getConnection();
            String string = AgingAttributes.this._dbObject.getSchemaName();
            String string2 = AgingAttributes.this._dbObject.getObjectName();
            Hashtable<String, String> hashtable = null;
            try {
                hashtable = AgingInfo.getAgingInfo(AgingAttributes.this._dbObject);
                this.theRows.clear();
                String string3 = Messages.getString("AgingAttributes.type");
                String string4 = Messages.getString("AgingAttributes.state");
                if (hashtable.get("TYPE") == null) {
                    this.theRows.add(new Object[]{string3, Messages.getString("AgingAttributes.noAgingCriterionSpecified")});
                } else {
                    this.theRows.add(new Object[]{string3, hashtable.get("TYPE")});
                    this.theRows.add(new Object[]{string4, hashtable.get("STATE")});
                    String[] stringArray = hashtable.get("DETAILS").split("#");
                    for (int i = 0; i < stringArray.length; i += 2) {
                        this.theRows.add(new Object[]{stringArray[i], stringArray[i + 1]});
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                if (hashtable == null) {
                    _logger.log(Level.SEVERE, "AgingInfo.getAgingInfo returned null");
                }
                throw nullPointerException;
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "Generating " + AgingAttributes.this.GetPurposeTxt() + " failed", exception);
                throw exception;
            }
        }

        @Override
        public final int getColumnCount() {
            return 2;
        }

        @Override
        public final int getRowCount() {
            return this.theRows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n > this.theRows.size() || n2 > 2) {
                return null;
            }
            return this.theRows.get(n)[n2];
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("TimesTen.common.attribute");
            }
            if (n == 1) {
                return Messages.getString("TimesTen.common.value");
            }
            return null;
        }
    }
}

