/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.lfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriter;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TimesTenPassthrough;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.ClosableEscMenuItem;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.Common;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.Constraint;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.IndexInfo;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadOptions;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadSelectedTraversablePanel;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadTableRow;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoaderPanel;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.TableRefresher;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.tablemodels.LoadTableModel;
import oracle.dbtools.raptor.timesten.utils.ButtonCellEditor;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.LanguageModule;

public class LoadTablesTable
extends JTable
implements ActionListener,
TableRefresher {
    private static final long serialVersionUID = 1L;
    private AbstractTableModel _model;
    private List<LoadTableRow> _data;
    private JPopupMenu _popupMenu;
    private JMenuItem _delete;
    private JMenuItem _deleteAll;
    private JMenuItem _count;
    private JMenuItem _countAll;
    private LoaderPanel _loaderPanel;
    private DBObject _dbObject;
    private boolean gridTable;
    private boolean editable;

    public LoadTablesTable(LoaderPanel loaderPanel, DBObject dBObject) {
        this(loaderPanel, dBObject, true);
    }

    public LoadTablesTable(LoaderPanel loaderPanel, DBObject dBObject, final boolean bl) {
        this._dbObject = dBObject;
        this.editable = bl;
        this._data = new LinkedList<LoadTableRow>();
        this.gridTable = Common.isGrid();
        this._model = new LoadTableModel(this._data, bl, this.gridTable);
        this._popupMenu = new JPopupMenu();
        this._loaderPanel = loaderPanel;
        this.setModel(this._model);
        this.setRowHeight(this.getRowHeight() + 8);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.isPopupTrigger() && bl) {
                    LoadTablesTable.this.doRightClick(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.isPopupTrigger() && bl) {
                    LoadTablesTable.this.doRightClick(mouseEvent);
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                int n = LoadTablesTable.this.rowAtPoint(point);
                int n2 = LoadTablesTable.this.columnAtPoint(point);
                if (mouseEvent.getClickCount() > 0 && mouseEvent.getClickCount() == 1 && LoadTablesTable.this.gridTable && n2 == Common.ColIdx.DISTRIBUTION.getValue()) {
                    LoadTablesTable.this.doClickOnDistribution(n);
                }
                if (mouseEvent.getClickCount() > 1) {
                    if (n2 == Common.ColIdx.QUERY.getValue()) {
                        LoadTablesTable.this.doDoubleClickOnSelectQuery(n, n2);
                    } else if (n2 == Common.ColIdx.CREATE.getValue()) {
                        LoadTablesTable.this.doDoubleClickOnCreateStatement(n, n2);
                    }
                }
            }
        });
        this.setupMenuItems();
        this.setupColumnsWidth();
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(121, 1, true);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(525, 0);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(27, 0);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoadTablesTable.this.displayPopup();
            }
        };
        this.registerKeyboardAction(actionListener, keyStroke, 0);
        this.registerKeyboardAction(actionListener, keyStroke2, 0);
        this._popupMenu.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoadTablesTable.this._popupMenu.setVisible(false);
            }
        }, keyStroke3, 0);
        DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)this.getTableHeader().getDefaultRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        DefaultTableCellRenderer defaultTableCellRenderer2 = new DefaultTableCellRenderer();
        defaultTableCellRenderer2.setHorizontalAlignment(0);
        for (int i = 0; i < this._model.getColumnCount(); ++i) {
            if (i == Common.ColIdx.USERNAME.getValue() || i == Common.ColIdx.TABLENAME.getValue()) {
                this.getColumnModel().getColumn(i).setCellRenderer(defaultTableCellRenderer2);
                this.getColumnModel().getColumn(i).setCellEditor(new CustomCellEditor(this));
                continue;
            }
            if (i == Common.ColIdx.QUERY.getValue() || i == Common.ColIdx.ROWCOUNT.getValue() || i == Common.ColIdx.CREATE.getValue()) {
                this.getColumnModel().getColumn(i).setCellRenderer(defaultTableCellRenderer2);
                continue;
            }
            if (this.gridTable && i == Common.ColIdx.DISTRIBUTION.getValue()) {
                new ButtonCellEditor(this, null, i);
                continue;
            }
            if (i != Common.ColIdx.STATUS.getValue() && (this.gridTable || i + 1 != Common.ColIdx.STATUS.getValue())) continue;
            IconTextCellRenderer iconTextCellRenderer = new IconTextCellRenderer();
            iconTextCellRenderer.setHorizontalAlignment(0);
            this.getColumnModel().getColumn(i).setCellRenderer(iconTextCellRenderer);
        }
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    private void setupColumnsWidth() {
        TableColumnSizer.setColumnsWidthToFit(this, true, true);
    }

    private void setupMenuItems() {
        this._count = new ClosableEscMenuItem(Messages.getString("LoadTablesFromOracle.count"), this._popupMenu);
        this._countAll = new ClosableEscMenuItem(Messages.getString("LoadTablesFromOracle.countAll"), this._popupMenu);
        this._delete = new ClosableEscMenuItem(Messages.getString("LoadTablesFromOracle.delete"), this._popupMenu);
        this._deleteAll = new ClosableEscMenuItem(Messages.getString("LoadTablesFromOracle.deleteAll"), this._popupMenu);
        this._count.addActionListener(this);
        this._countAll.addActionListener(this);
        this._delete.addActionListener(this);
        this._deleteAll.addActionListener(this);
        this._popupMenu.add(this._count);
        this._popupMenu.add(this._countAll);
        this._popupMenu.add(this._delete);
        this._popupMenu.add(this._deleteAll);
    }

    private void doDoubleClickOnSelectQuery(int n, int n2) {
        LoadTableRow loadTableRow = this._data.get(n);
        EditQueryPanel editQueryPanel = new EditQueryPanel();
        String string = loadTableRow.getSelectQuery().trim();
        editQueryPanel.setSQL(string);
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)editQueryPanel, (String)Messages.getString("LoadTablesFromOracle.editSelectQuery"), null);
        jEWTDialog.setButtonMask(3);
        if (jEWTDialog.runDialog()) {
            String string2 = editQueryPanel.getSQL();
            if (!Common.validQuery(string2)) {
                loadTableRow.setParallelLoads(1);
            }
            loadTableRow.setSelectQuery(editQueryPanel.getSQL());
            this._model.fireTableCellUpdated(n, n2);
        }
    }

    private void doDoubleClickOnCreateStatement(int n, int n2) {
        LoadTableRow loadTableRow = this._data.get(n);
        CreateQueryPanel createQueryPanel = new CreateQueryPanel();
        createQueryPanel.setSQL(this.gridTable ? loadTableRow.getCreateGridTableStatement() : loadTableRow.getCreateTableStatement());
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)createQueryPanel, (String)Messages.getString("LoadTablesFromOracle.createStatement"), null);
        jEWTDialog.setButtonMask(1);
        if (jEWTDialog.runDialog()) {
            // empty if block
        }
    }

    private void doClickOnDistribution(int n) {
        final LoadTableRow loadTableRow = this._data.get(n);
        final Constraint.DistributionPanel distributionPanel = new Constraint.DistributionPanel(loadTableRow);
        if (!this.editable) {
            distributionPanel.setEnabled(false);
        }
        final JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)distributionPanel, (String)Messages.getString("LoadTablesFromOracle.distScheme"), null);
        if (this.editable) {
            jEWTDialog.setButtonMask(10);
        } else {
            jEWTDialog.setButtonMask(3);
        }
        jEWTDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!LoadTablesTable.this.editable) {
                    return;
                }
                if (distributionPanel.validTableDistribution()) {
                    int n;
                    Constraint.TableDistribution tableDistribution = distributionPanel.getTableDistribution();
                    if (loadTableRow.getTableDistribution().getDistributionType() == Constraint.DistributionType.REFERENCE && tableDistribution.getDistributionType() != Constraint.DistributionType.REFERENCE && (n = MessageDialog.confirmOrCancel((Component)distributionPanel, (Object)Messages.getString("LoadTablesFromOracle.changeDistSchemeWarning"), (String)Messages.getString("TimesTen.common.warning"))) != 1) {
                        return;
                    }
                    loadTableRow.setTableDistribution(tableDistribution);
                    jEWTDialog.dispose();
                }
            }
        });
        jEWTDialog.setPreferredSize(new Dimension(400, 400));
        jEWTDialog.runDialog();
    }

    private void doRightClick(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.rowAtPoint(point);
        this.getSelectionModel().setSelectionInterval(n, n);
        this._popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private void displayPopup() {
        Rectangle rectangle = this.getCellRect(this.getSelectedRow(), this.getSelectedColumn(), false);
        this._popupMenu.show(this, rectangle.x, rectangle.y);
    }

    public void addRow(LoadTableRow loadTableRow) {
        this._data.add(loadTableRow);
        if (SwingUtilities.isEventDispatchThread()) {
            this._model.fireTableRowsInserted(this._data.size() - 1, this._data.size() - 1);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LoadTablesTable.this._model.fireTableRowsInserted(LoadTablesTable.this._data.size() - 1, LoadTablesTable.this._data.size() - 1);
                }
            });
        }
    }

    private void countRows(final boolean bl) {
        final IndeterminateProgressMonitor indeterminateProgressMonitor = new IndeterminateProgressMonitor((Component)this, Messages.getString("TimesTen.common.pleaseWait"));
        final TimesTenPassthrough timesTenPassthrough = new TimesTenPassthrough(this._dbObject);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                indeterminateProgressMonitor.display();
                if (bl) {
                    for (LoadTableRow loadTableRow : LoadTablesTable.this._data) {
                        Long l = timesTenPassthrough.executeTableCountOnOracle(loadTableRow.getSelectCountSQL());
                        loadTableRow.setRowCount(l);
                    }
                } else {
                    for (int n : LoadTablesTable.this.getSelectedRows()) {
                        LoadTableRow loadTableRow = LoadTablesTable.this._data.get(n);
                        Long l = timesTenPassthrough.executeTableCountOnOracle(loadTableRow.getSelectCountSQL());
                        loadTableRow.setRowCount(l);
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                indeterminateProgressMonitor.close();
                LoadTablesTable.this._model.fireTableDataChanged();
            }
        };
        swingWorker.execute();
    }

    private void deleteSelectedRows() {
        int[] nArray = this.getSelectedRows();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int n : nArray) {
            arrayList.add(this._data.get(n).getOracleTable());
            this._data.remove(n);
        }
        if (Common.isGrid().booleanValue() && !arrayList.isEmpty()) {
            this.refreshConstToBeAdded(arrayList);
        }
        this._model.fireTableDataChanged();
    }

    public void deleteAllRows() {
        this._data.clear();
        this._model.fireTableDataChanged();
    }

    public List<LoadTableRow> getData() {
        return this._data;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        if (this._count == actionEvent.getSource()) {
            this.countRows(false);
            return;
        }
        if (this._countAll == actionEvent.getSource()) {
            if (MessageDialog.confirm((Component)this, (Object)Messages.getString("LoadTablesFromOracle.countAllQuestion"), (String)Messages.getString("LoadTablesFromOracle.confirmCount"), null)) {
                this.countRows(true);
            }
            return;
        }
        if (this._delete == actionEvent.getSource()) {
            if (MessageDialog.confirm((Component)this, (Object)Messages.getString("LoadTablesFromOracle.deleteRowQuestion"), (String)Messages.getString("LoadTablesFromOracle.confirmDelete"), null)) {
                this.deleteSelectedRows();
            }
            return;
        }
        if (this._deleteAll == actionEvent.getSource()) {
            if (MessageDialog.confirm((Component)this, (Object)Messages.getString("LoadTablesFromOracle.deleteAllRowsQuestion"), (String)Messages.getString("LoadTablesFromOracle.confirmDelete"), null)) {
                this.deleteAllRows();
            }
            return;
        }
    }

    public void refreshStatusCell(int n) {
    }

    @Override
    public void refreshTheCompleteTable() {
        this._model.fireTableDataChanged();
    }

    @Override
    public void refreshRow(int n) {
        this._model.fireTableRowsUpdated(n, n);
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        this.setEnabledComponents(n2 != Common.ColIdx.USERNAME.getValue() && n2 != Common.ColIdx.TABLENAME.getValue());
        return super.prepareEditor(tableCellEditor, n, n2);
    }

    public void setEnabledComponents(boolean bl) {
        if (this._loaderPanel instanceof LoadSelectedTraversablePanel) {
            ((LoadSelectedTraversablePanel)this._loaderPanel).setEnabledComponents(bl);
        }
    }

    public void saveJsonProfile(File file) {
        try {
            JsonWriter jsonWriter = Json.createWriter((Writer)new PrintWriter(file, "UTF-8"));
            jsonWriter.writeObject(this.getJsonProfile());
            jsonWriter.close();
        }
        catch (Exception exception) {
            MessageDialog.error((Component)this, (Object)(MessageFormat.format(Messages.getString("LoadTablesFromOracle.saveFileError"), file.getName()) + "\n" + exception.getMessage()), (String)Messages.getString("TimesTen.common.error"), null);
        }
    }

    private JsonObject getJsonProfile() {
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        ArrayList<LoadTableRow> arrayList = new ArrayList<LoadTableRow>();
        LoadOptions loadOptions = this._loaderPanel.getLoadOptions();
        loadOptions.setIgnoreDuplicates(true);
        for (LoadTableRow object : this._data) {
            if (object.getStatus() != Common.LoadStatus.ERROR && object.getStatus() != Common.LoadStatus.LOADED_ERROR && object.getStatus() != Common.LoadStatus.FATAL_ERROR || object.getCreateTableOnly()) continue;
            arrayList.add(object);
        }
        jsonObjectBuilder.add("connectionName", Connections.getDisplayName((String)this._dbObject.getConnectionName()));
        jsonObjectBuilder.add("indexCreationPolicy", loadOptions.getIndexCreationtPolicy().toString());
        jsonObjectBuilder.add("createIndexesIfNoErrors", loadOptions.createIndexesIfNoErrors());
        jsonObjectBuilder.add("numberOfThreads", loadOptions.getNumberOfThreads());
        jsonObjectBuilder.add("loadOptions", loadOptions.toString());
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        for (LoadTableRow loadTableRow : arrayList) {
            JsonObjectBuilder jsonObjectBuilder2 = Json.createObjectBuilder();
            jsonObjectBuilder2.add("query", loadTableRow.getSelectQuery());
            jsonObjectBuilder2.add("rowCount", String.valueOf(loadTableRow.getRowCount()));
            jsonObjectBuilder2.add("createTableStmt", Common.isGrid() != false ? loadTableRow.getCreateGridTableStatement() : loadTableRow.getCreateTableStatement());
            jsonObjectBuilder2.add("ttUser", loadTableRow.getTimesTenUser());
            jsonObjectBuilder2.add("ttTable", loadTableRow.getTimesTenTable());
            jsonObjectBuilder2.add("oracleUser", loadTableRow.getOracleUser());
            jsonObjectBuilder2.add("oracleTable", Common.getOracleTableFromQuery(loadTableRow.getSelectQuery()));
            jsonObjectBuilder2.add("oracleSCN", loadTableRow.getLoadDataResult().getOracleSCN());
            jsonObjectBuilder2.add("status", loadTableRow.getLoadDataResult().getErrorCode());
            jsonArrayBuilder.add(jsonObjectBuilder2);
        }
        jsonObjectBuilder.add("loads", jsonArrayBuilder);
        return jsonObjectBuilder.build();
    }

    private void refreshConstToBeAdded(List<String> list) {
        for (LoadTableRow loadTableRow : this._data) {
            if (loadTableRow.getConstraints() == null) continue;
            for (Constraint constraint : loadTableRow.getConstraints()) {
                if (constraint.getConstraintType() != IndexInfo.ConstraintType.FOREIGN || !constraint.addConstraint() || !list.contains(constraint.getRTableName())) continue;
                constraint.setAddConstraint(false);
                loadTableRow.setTableDistribution(new Constraint.TableDistribution(Constraint.DistributionType.HASH));
            }
        }
    }

    private class CreateQueryPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private BasicEditorPane _editor;
        private JLabel _text;

        public CreateQueryPanel() {
            this.setLayout(new BorderLayout());
            this._text = new JLabel(Messages.getString("LoadTablesFromOracle.createStatement"));
            this._editor = EditorFactory.createIdeEditorPane();
            BasicDocument basicDocument = (BasicDocument)this._editor.getDocument();
            basicDocument.setLanguageSupport(LanguageModule.createSupportForFileType((String)".sql"));
            this._editor.setPreferredSize(new Dimension(300, 400));
            this._text.setVerticalAlignment(1);
            this._text.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.add((Component)this._text, "West");
            this.add((Component)new JScrollPane((Component)this._editor, 20, 30), "Center");
        }

        public void setSQL(String string) {
            this._editor.setText(string);
            this._editor.setEditable(false);
        }
    }

    private class EditQueryPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private BasicEditorPane _editor;
        private JLabel _text;

        public EditQueryPanel() {
            this.setLayout(new BorderLayout());
            this._text = new JLabel(Messages.getString("LoadTablesFromOracle.selectQuery"));
            this._editor = EditorFactory.createIdeEditorPane();
            BasicDocument basicDocument = (BasicDocument)this._editor.getDocument();
            basicDocument.setLanguageSupport(LanguageModule.createSupportForFileType((String)".sql"));
            this._editor.setPreferredSize(new Dimension(300, 400));
            this._text.setVerticalAlignment(1);
            this._text.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.add((Component)this._text, "West");
            this.add((Component)new JScrollPane((Component)this._editor, 20, 30), "Center");
        }

        public String getSQL() {
            return this._editor.getText();
        }

        public void setSQL(String string) {
            this._editor.setText(string);
            this._editor.setEditable(LoadTablesTable.this.editable);
        }
    }

    private class CustomCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        JComponent component;
        Border defaultBorder;
        LoadTablesTable _table;

        public CustomCellEditor(LoadTablesTable loadTablesTable2) {
            this._table = loadTablesTable2;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.component = new JTextField();
            ((JTextField)this.component).setText(String.valueOf(object));
            ((JTextField)this.component).setHorizontalAlignment(0);
            this.defaultBorder = ((JTextField)this.component).getBorder();
            return this.component;
        }

        @Override
        public boolean stopCellEditing() {
            ((JTextField)this.component).setBorder(this.defaultBorder);
            LoadTablesTable.this.setEnabledComponents(true);
            return super.stopCellEditing();
        }

        @Override
        public Object getCellEditorValue() {
            return ((JTextField)this.component).getText().trim();
        }
    }

    private class IconTextCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private IconTextCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Image image = Common.iconToImage(Common.ERROR_ICON);
            Image image2 = image.getScaledInstance(12, 12, 4);
            ImageIcon imageIcon = new ImageIcon(image2);
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setText(object.toString());
            jLabel.setToolTipText(object.toString());
            if (LoadTablesTable.this._data.get(n).getStatus().getValue() == Common.LoadStatus.LOADED.getValue()) {
                jLabel.setIcon(Common.OK_ICON);
            } else if (LoadTablesTable.this._data.get(n).getStatus().getValue() == Common.LoadStatus.FATAL_ERROR.getValue() || LoadTablesTable.this._data.get(n).getStatus().getValue() == Common.LoadStatus.ERROR.getValue() || LoadTablesTable.this._data.get(n).getStatus().getValue() == Common.LoadStatus.LOADED_ERROR.getValue() || LoadTablesTable.this._data.get(n).getStatus().getValue() == Common.LoadStatus.SQL_EXCEPTION.getValue()) {
                jLabel.setIcon(imageIcon);
            } else {
                jLabel.setIcon(null);
            }
            return jLabel;
        }
    }
}

