/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.lfo;

import java.awt.Component;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.TimesTenPassthrough;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadSelectedTraversablePanel;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.SchemaProvider;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;

public class LoadSchema
implements SchemaProvider {
    private static Logger _logger = Logger.getLogger(LoadSchema.class.getPackage().getName());
    private DBObject _dbObject;
    private TimesTenPassthrough _passthrough;

    public LoadSchema(DBObject dBObject) {
        this._dbObject = dBObject;
        this._passthrough = new TimesTenPassthrough(this._dbObject);
    }

    @Override
    public void getSchemas(final List<Object> list, final JPanel jPanel) {
        final String string = this._dbObject.getSchemaName();
        final IndeterminateProgressMonitor indeterminateProgressMonitor = new IndeterminateProgressMonitor((Component)jPanel, Messages.getString("TimesTen.common.pleaseWait"));
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                indeterminateProgressMonitor.display();
                try {
                    String string3 = "SELECT owner FROM sys.all_objects WHERE owner     <> 'SYS' AND owner       <> 'SYSTEM' AND owner       <> 'CTXSYS' AND owner       <> 'DBSNMP' AND owner       <> 'DMSYS' AND owner       <> 'EXFSYS' AND owner       <> 'MDDATA' AND owner       <> 'MDSYS' AND owner       <> 'OLAPSYS' AND owner       <> 'ORDPLUGINS' AND owner       <> 'ORDSYS' AND owner       <> 'OUTLN' AND owner       <> 'SI_INFORMTN_SCHEMA' AND owner       <> 'SYSMAN' AND owner       <> 'TSMSYS' AND owner       <> 'WKSYS' AND owner       <> 'WMSYS' AND owner       <> 'XDB' AND object_type IN ('TABLE') AND object_name NOT LIKE '%_AGENT_STATUS' AND object_name NOT LIKE '%_REPACTIVESTANDBY' AND object_name NOT LIKE '%_USER_COUNT' AND object_name NOT LIKE '%_SYNC_OBJS' AND object_name NOT LIKE '%_REPPEERS' group by owner;";
                    List<Object[]> list2 = LoadSchema.this._passthrough.executeQueryOnOracle(string3);
                    for (Object[] objectArray : list2) {
                        String string2 = objectArray[0].toString();
                        if (string.equalsIgnoreCase(string2)) continue;
                        list.add(string2);
                    }
                }
                catch (SQLException sQLException) {
                    _logger.log(Level.SEVERE, "Error while loading tables into schema", sQLException);
                    MessageDialog.error(null, (Object)TTSQLExceptionScrubber.getInstance().getMessage(LoadSchema.this._passthrough.getConnection(), LoadSchema.this._passthrough.getLastError(), sQLException), (String)Messages.getString("TimesTen.common.error"), null);
                }
                return null;
            }

            @Override
            protected void done() {
                ((LoadSelectedTraversablePanel)((Object)jPanel)).loadSchema(list);
                indeterminateProgressMonitor.close();
            }
        };
        swingWorker.execute();
    }

    @Override
    public void closeConnection() {
        try {
            if (!this._passthrough.getConnection().isClosed()) {
                this._passthrough.getConnection().close();
            }
        }
        catch (SQLException sQLException) {
            _logger.log(Level.SEVERE, "Can't close connection", sQLException);
        }
    }
}

