/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.lfo;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.Common;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadOptions;

public class LoadOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private LoadOptions _loadOptions;
    private JLabel _parallelLoadsLabel;
    private JLabel _numberThreadsLabel;
    private JLabel _errorThresholdLabel;
    private JLabel _ignoreDuplicatesLabel;
    private JLabel _resumeSCNLabel;
    private JLabel _directLoadLabel;
    private JLabel _localOnlyLabel;
    private JLabel _fetcherLabel;
    private JLabel _inserterLabel;
    private JTextField _parallelLoads;
    private JTextField _numberThreads;
    private JTextField _errorThreshold;
    private JCheckBox _ignoreDuplicates;
    private JTextField _resumeSCN;
    private JCheckBox _directLoad;
    private JCheckBox _localOnly;
    private JTextField _fetcher;
    private JTextField _inserter;

    public LoadOptionsPanel(LoadOptions loadOptions) {
        this._loadOptions = loadOptions;
        this.setLayout(new GridBagLayout());
        this.init();
    }

    private void init() {
        this._parallelLoads = new JTextField();
        this._parallelLoads.setText(String.valueOf(this._loadOptions.getParallelLoads()));
        this._parallelLoadsLabel = new JLabel(Messages.getString("LoadTablesFromOracle.parallelLoad"));
        this._parallelLoadsLabel.setLabelFor(this._parallelLoads);
        this._numberThreads = new JTextField();
        this._numberThreads.setText(String.valueOf(this._loadOptions.getNumberOfThreads()));
        this._numberThreadsLabel = new JLabel(Messages.getString("LoadTablesFromOracle.numberThreads"));
        this._numberThreadsLabel.setLabelFor(this._numberThreads);
        this._errorThreshold = new JTextField();
        this._errorThreshold.setText(String.valueOf(this._loadOptions.getErrorThreshold()));
        this._errorThresholdLabel = new JLabel(Messages.getString("LoadTablesFromOracle.errorThreshold"));
        this._errorThresholdLabel.setLabelFor(this._errorThreshold);
        this._ignoreDuplicates = new JCheckBox();
        this._ignoreDuplicates.setSelected(this._loadOptions.isIgnoreDuplicates());
        this._ignoreDuplicatesLabel = new JLabel(Messages.getString("LoadTablesFromOracle.ignoreDuplicates"));
        this._ignoreDuplicatesLabel.setLabelFor(this._ignoreDuplicates);
        this._resumeSCN = new JTextField();
        this._resumeSCN.setText(String.valueOf(this._loadOptions.getResumeFromSCN()));
        this._resumeSCNLabel = new JLabel(Messages.getString("LoadTablesFromOracle.resumeSCN"));
        this._resumeSCNLabel.setLabelFor(this._resumeSCN);
        this._directLoad = new JCheckBox();
        this._directLoad.setSelected(this._loadOptions.isDirectLoad());
        this._directLoadLabel = new JLabel(Messages.getString("LoadTablesFromOracle.directLoad"));
        this._directLoadLabel.setLabelFor(this._directLoad);
        this._localOnly = new JCheckBox();
        this._localOnly.setSelected(this._loadOptions.isLocalOnly());
        this._localOnlyLabel = new JLabel(Messages.getString("LoadTablesFromOracle.localOnly"));
        this._localOnlyLabel.setLabelFor(this._localOnly);
        this._fetcher = new JTextField();
        this._fetcher.setText(String.valueOf(this._loadOptions.getReaders()));
        this._fetcherLabel = new JLabel(Messages.getString("LoadTablesFromOracle.fetcherThreads"));
        this._fetcherLabel.setLabelFor(this._fetcher);
        this._inserter = new JTextField();
        this._inserter.setText(String.valueOf(this._loadOptions.getNumberOfThreads() - this._loadOptions.getReaders()));
        this._inserterLabel = new JLabel(Messages.getString("LoadTablesFromOracle.inserterThreads"));
        this._inserterLabel.setLabelFor(this._inserter);
        this.showGUIComponents();
    }

    private void showGUIComponents() {
        if (!Common.isAcadia().booleanValue()) {
            this.add((Component)this._parallelLoadsLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 45, 5, 3), 0, 0));
            this.add((Component)this._parallelLoads, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 25, 5, 45), 0, 0));
            this.add((Component)this._numberThreadsLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 45, 5, 3), 0, 0));
            this.add((Component)this._numberThreads, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 25, 5, 45), 0, 0));
        } else if (Common.isGrid().booleanValue()) {
            this.add((Component)this._inserterLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 45, 5, 3), 0, 0));
            this.add((Component)this._inserter, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 25, 5, 45), 0, 0));
            this.add((Component)this._fetcherLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 45, 5, 3), 0, 0));
            this.add((Component)this._fetcher, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 25, 5, 45), 0, 0));
            this.add((Component)this._errorThresholdLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 45, 5, 3), 0, 0));
            this.add((Component)this._errorThreshold, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 25, 5, 45), 0, 0));
            this.add((Component)this._resumeSCNLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 45, 5, 3), 0, 0));
            this.add((Component)this._resumeSCN, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 25, 5, 45), 0, 0));
            this.add((Component)this._ignoreDuplicatesLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 45, 5, 3), 0, 0));
            this.add((Component)this._ignoreDuplicates, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 25, 5, 45), 0, 0));
            this.add((Component)this._localOnlyLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 45, 5, 3), 0, 0));
            this.add((Component)this._localOnly, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 25, 5, 45), 0, 0));
        } else {
            this.add((Component)this._inserterLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 45, 5, 3), 0, 0));
            this.add((Component)this._inserter, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 25, 5, 45), 0, 0));
            this.add((Component)this._fetcherLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 45, 5, 3), 0, 0));
            this.add((Component)this._fetcher, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 25, 5, 45), 0, 0));
            this.add((Component)this._errorThresholdLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 45, 5, 3), 0, 0));
            this.add((Component)this._errorThreshold, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 25, 5, 45), 0, 0));
            this.add((Component)this._resumeSCNLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 45, 5, 3), 0, 0));
            this.add((Component)this._resumeSCN, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 25, 5, 45), 0, 0));
            this.add((Component)this._ignoreDuplicatesLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 45, 5, 3), 0, 0));
            this.add((Component)this._ignoreDuplicates, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 25, 5, 45), 0, 0));
            this.add((Component)this._directLoadLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 45, 5, 3), 0, 0));
            this.add((Component)this._directLoad, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 25, 5, 45), 0, 0));
        }
    }

    public void validInput() throws NumberFormatException {
        block19: {
            int n;
            String string = this._parallelLoads.getText().trim();
            String string2 = this._numberThreads.getText().trim();
            String string3 = this._errorThreshold.getText().trim();
            String string4 = this._resumeSCN.getText().trim();
            String string5 = this._fetcher.getText().trim();
            String string6 = this._inserter.getText().trim();
            if (!Common.isAcadia().booleanValue()) {
                int n2;
                try {
                    n2 = Integer.parseInt(string2);
                    if (n2 < 2) {
                        throw new NumberFormatException(Messages.getString("LoadTablesFromOracle.invalidNumberThreads"));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new NumberFormatException(Messages.getString("LoadTablesFromOracle.invalidNumberThreads"));
                }
                try {
                    n2 = Integer.parseInt(string);
                    if (n2 < 1 || n2 > 16) {
                        throw new NumberFormatException(Messages.getString("LoadTablesFromOracle.invalidNumberParallelLoads"));
                    }
                    break block19;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new NumberFormatException(Messages.getString("LoadTablesFromOracle.invalidNumberParallelLoads"));
                }
            }
            try {
                n = Integer.parseInt(string6);
                if (n < 1) {
                    throw new NumberFormatException(MessageFormat.format(Messages.getString("LoadTablesFromOracle.invalidNumberInserterThreads"), Integer.MAX_VALUE));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException(MessageFormat.format(Messages.getString("LoadTablesFromOracle.invalidNumberInserterThreads"), Integer.MAX_VALUE));
            }
            try {
                n = Integer.parseInt(string3);
                if (n < 1) {
                    throw new NumberFormatException(MessageFormat.format(Messages.getString("LoadTablesFromOracle.invalidErrorThreshold"), Integer.MAX_VALUE));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException(MessageFormat.format(Messages.getString("LoadTablesFromOracle.invalidErrorThreshold"), Integer.MAX_VALUE));
            }
            try {
                Long l;
                if (!string4.isEmpty() && (l = Long.valueOf(Long.parseLong(string4))) < 0L) {
                    throw new NumberFormatException(Messages.getString("LoadTablesFromOracle.invalidResumeSCN"));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException(Messages.getString("LoadTablesFromOracle.invalidResumeSCN"));
            }
            try {
                int n3 = Integer.parseInt(string5);
                if (n3 < 1) {
                    throw new NumberFormatException(Messages.getString("LoadTablesFromOracle.invalidFetcher"));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException(Messages.getString("LoadTablesFromOracle.invalidFetcher"));
            }
        }
        this.setLoadOptionsParam();
    }

    public void setLoadOptionsParam() {
        if (this._loadOptions == null) {
            this._loadOptions = new LoadOptions();
        }
        this._loadOptions.setParallelLoads(Integer.parseInt(this._parallelLoads.getText().trim()));
        this._loadOptions.setErrorThreshold(Integer.parseInt(this._errorThreshold.getText().trim()));
        this._loadOptions.setIgnoreDuplicates(this._ignoreDuplicates.isSelected());
        this._loadOptions.setResumeFromSCN(this._resumeSCN.getText().trim().isEmpty() ? null : Long.valueOf(Long.parseLong(this._resumeSCN.getText().trim())));
        this._loadOptions.setDirectLoad(this._directLoad.isSelected());
        this._loadOptions.setLocalOnly(this._localOnly.isSelected());
        this._loadOptions.setReaders(Integer.parseInt(this._fetcher.getText().trim()));
        if (!Common.isAcadia().booleanValue()) {
            this._loadOptions.setNumberOfThreads(Integer.parseInt(this._numberThreads.getText().trim()));
        } else {
            this._loadOptions.setNumberOfThreads(Integer.parseInt(this._inserter.getText().trim()) + Integer.parseInt(this._fetcher.getText().trim()));
        }
    }

    public void setDefaultValues() {
        this._loadOptions.setDefaultValues();
        this.setLoadOptions();
    }

    public void showEmptyOptions() {
        this._numberThreads.setText("");
        this._errorThreshold.setText("");
        this._ignoreDuplicates.setSelected(false);
        this._resumeSCN.setText("");
        this._directLoad.setSelected(false);
        this._localOnly.setSelected(false);
        this._fetcher.setText("");
        this._inserter.setText("");
        this.enableLoadOptions(false);
    }

    private void enableLoadOptions(boolean bl) {
        this._numberThreads.setEnabled(bl);
        this._errorThreshold.setEnabled(bl);
        this._ignoreDuplicates.setEnabled(bl);
        this._resumeSCN.setEnabled(bl);
        this._directLoad.setEnabled(bl);
        this._localOnly.setEnabled(bl);
        this._fetcher.setEnabled(bl);
        this._inserter.setEnabled(bl);
    }

    public void setLoadOptions(LoadOptions loadOptions) {
        this._loadOptions = loadOptions;
        this.enableLoadOptions(false);
        this.setLoadOptions();
    }

    private void setLoadOptions() {
        this._parallelLoads.setText(String.valueOf(this._loadOptions.getParallelLoads()));
        this._numberThreads.setText(String.valueOf(this._loadOptions.getNumberOfThreads()));
        this._errorThreshold.setText(String.valueOf(this._loadOptions.getErrorThreshold()));
        this._ignoreDuplicates.setSelected(this._loadOptions.isIgnoreDuplicates());
        this._resumeSCN.setText(this._loadOptions.getResumeFromSCN() != null ? String.valueOf(this._loadOptions.getResumeFromSCN()) : "");
        this._directLoad.setSelected(this._loadOptions.isDirectLoad());
        this._localOnly.setSelected(this._loadOptions.isLocalOnly());
        this._fetcher.setText(String.valueOf(this._loadOptions.getReaders()));
        this._inserter.setText(String.valueOf(this._loadOptions.getNumberOfThreads() - this._loadOptions.getReaders()));
    }
}

