/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.lfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.AnalysisParam;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.Common;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadOptions;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadOptionsPanel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class AdvancedConfigTraversablePanel
extends DefaultTraversablePanel
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private JLabel _inlineColsLabel;
    private JLabel _numberLabel;
    private JLabel _rawLabel;
    private JLabel _timestampLabel;
    private JLabel _varchar2Label;
    private JLabel _lobLabel;
    private JLabel _tmPaddingLabel;
    private JLabel _compressionLabel;
    private JLabel _comPaddingLabel;
    private JLabel _minComRatioLabel;
    private JLabel _minNumRowsLabel;
    private JComboBox<String> _numberComboBox;
    private JComboBox<String> _rawComboBox;
    private JComboBox<String> _longRawComboBox;
    private JComboBox<String> _timestampComboBox;
    private JComboBox<String> _varchar2ComboBox;
    private JComboBox _lobComboBox;
    private JComboBox<String> _compressionComboBox;
    private JRadioButton _stopRadioButton;
    private JRadioButton _skipRadioButton;
    private ButtonGroup _group2;
    private JButton _restoreButton;
    private JTextField _inlineColsTxtField;
    private JTextField _tmPaddingTxtField;
    private JTextField _comPaddingTxtField;
    private JTextField _minComRatioTxtField;
    private JTextField _minNumRowsTxtField;
    private JLabel _indexLabel;
    private JComboBox<LoadOptions.IndexCreationPolicy> _indexComboBox;
    private JCheckBox _indexCreationCheckBox;
    private JPanel _southPanel;
    private JPanel _centerPanel;
    private JPanel _basicPanel;
    private JPanel _basicTMPanel;
    private JPanel _basicComPanel;
    private JPanel _loadOptionsPanel;
    private JPanel _analysisParamPanel;
    private LoadOptionsPanel _LOpanel;
    private JPanel _indexPanel;
    private JTabbedPane _tabbedPane;
    private boolean initialized;
    private AnalysisParam ap;
    private LoadOptions loadOptions;

    public void init() {
        this._numberComboBox = new JComboBox<String>(Common.NUMBER_OPT);
        this._rawComboBox = new JComboBox<String>(Common.RAW_LOB_TYPES_OPT);
        this._longRawComboBox = new JComboBox<String>(Common.RAW_LOB_TYPES_OPT);
        this._timestampComboBox = new JComboBox<String>(Common.TIMESTAMP_OPT);
        this._varchar2ComboBox = new JComboBox<String>(Common.VARCHAR2_OPT);
        this._lobComboBox = new JComboBox();
        this._lobComboBox.addItem(Common.RAW_LOB_TYPES_OPT[1]);
        this._compressionComboBox = new JComboBox<String>(Common.COMPRESSION_OPT);
        this._compressionComboBox.addActionListener(this);
        this._stopRadioButton = new JRadioButton("Stop on Any Bad Type");
        this._skipRadioButton = new JRadioButton("Skip Columns with Bad Types");
        this._skipRadioButton.setSelected(true);
        this._group2 = new ButtonGroup();
        this._group2.add(this._stopRadioButton);
        this._group2.add(this._skipRadioButton);
        this._restoreButton = new JButton(Messages.getString("LoadTablesFromOracle.restore"));
        this._restoreButton.addActionListener(this);
        this._inlineColsTxtField = new JTextField(15);
        this._tmPaddingTxtField = new JTextField(15);
        this._comPaddingTxtField = new JTextField(15);
        this._minComRatioTxtField = new JTextField(15);
        this._minNumRowsTxtField = new JTextField(15);
        this._inlineColsLabel = new JLabel("Inline Columns Size Limit:");
        this._inlineColsLabel.setLabelFor(this._inlineColsTxtField);
        this._numberLabel = new JLabel("NUMBER:");
        this._numberLabel.setLabelFor(this._numberComboBox);
        this._rawLabel = new JLabel("RAW data types:");
        this._rawLabel.setLabelFor(this._rawComboBox);
        this._timestampLabel = new JLabel("TIMESTAMP with TIME ZONE:");
        this._timestampLabel.setLabelFor(this._timestampComboBox);
        this._varchar2Label = new JLabel("VARCHAR2:");
        this._varchar2Label.setLabelFor(this._varchar2ComboBox);
        this._lobLabel = new JLabel("LOB data types:");
        this._lobLabel.setLabelFor(this._lobComboBox);
        this._tmPaddingLabel = new JLabel("Padding Factor:");
        this._tmPaddingLabel.setLabelFor(this._tmPaddingTxtField);
        this._compressionLabel = new JLabel("Type of Compression:");
        this._compressionLabel.setLabelFor(this._compressionComboBox);
        this._comPaddingLabel = new JLabel("Padding Factor:");
        this._comPaddingLabel.setLabelFor(this._comPaddingTxtField);
        this._minComRatioLabel = new JLabel("Minimum Compression Ratio:");
        this._minComRatioLabel.setLabelFor(this._minComRatioTxtField);
        this._minNumRowsLabel = new JLabel("Minimum Number of Rows:");
        this._minNumRowsLabel.setLabelFor(this._minNumRowsTxtField);
        this._indexComboBox = new JComboBox();
        this._indexComboBox.addItem(LoadOptions.IndexCreationPolicy.COPY_ALL_IDXS);
        this._indexComboBox.addItem(LoadOptions.IndexCreationPolicy.COPY_UNIQUE_IDXS);
        this._indexComboBox.addItem(LoadOptions.IndexCreationPolicy.NO_COPY_IDXS);
        this._indexComboBox.setSelectedIndex(0);
        this._indexComboBox.addActionListener(this);
        this._indexCreationCheckBox = new JCheckBox(Messages.getString("LoadTablesFromOracle.indexCreationCond"));
        this._indexCreationCheckBox.setSelected(this.loadOptions.createIndexesIfNoErrors());
        this._indexLabel = new JLabel(Messages.getString("LoadTablesFromOracle.indexCreationLabel"));
        this._indexLabel.setLabelFor(this._indexComboBox);
        this.initialized = true;
        this.showGUIComponents();
        this.setDefaultValues();
    }

    private void showGUIComponents() {
        this.setLayout(new GridBagLayout());
        this.initCenterPanel();
        this.initSouthPanel();
    }

    private void initCenterPanel() {
        this._tabbedPane = new JTabbedPane();
        this.initMappingCompressionPanel();
        this.initLoadOptionsPanel();
        this._tabbedPane.addTab(Messages.getString("LoadTablesFromOracle.mappingCompression"), this._basicPanel);
        this._tabbedPane.addTab(Messages.getString("LoadTablesFromOracle.options"), this._loadOptionsPanel);
        this._centerPanel = new JPanel(new BorderLayout());
        this._centerPanel.add((Component)this._tabbedPane, "Center");
        this.add(this._centerPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void initMappingCompressionPanel() {
        int n = 2;
        this._basicPanel = new JPanel(new GridBagLayout());
        this._basicTMPanel = new JPanel(new GridBagLayout());
        this._basicTMPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("LoadTablesFromOracle.typeMapping")));
        this._basicTMPanel.add((Component)this._numberLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(3, 45, 3, 3), 0, 0));
        this._basicTMPanel.add(this._numberComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(3, 25, 3, 45), 0, 0));
        this._basicTMPanel.add((Component)this._varchar2Label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 0, new Insets(3, 45, 3, 3), 0, 0));
        this._basicTMPanel.add(this._varchar2ComboBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 23, 2, new Insets(3, 25, 3, 45), 0, 0));
        this._basicTMPanel.add((Component)this._timestampLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, new Insets(3, 45, 3, 3), 0, 0));
        this._basicTMPanel.add(this._timestampComboBox, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 23, 2, new Insets(3, 25, 3, 45), 0, 0));
        this._basicTMPanel.add((Component)this._lobLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 23, 0, new Insets(3, 45, 3, 3), 0, 0));
        this._basicTMPanel.add((Component)this._lobComboBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 23, 2, new Insets(3, 25, 3, 45), 0, 0));
        this._basicTMPanel.add((Component)this._rawLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 23, 0, new Insets(3, 45, 3, 3), 0, 0));
        this._basicTMPanel.add(this._rawComboBox, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 23, 2, new Insets(3, 25, 3, 45), 0, 0));
        this._basicTMPanel.add((Component)this._inlineColsLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(3, 3, 3, 3), 0, 0));
        this._basicTMPanel.add((Component)this._inlineColsTxtField, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(3, 25, 3, 45), 0, 0));
        this._basicTMPanel.add((Component)this._tmPaddingLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 23, 0, new Insets(3, 3, 3, 3), 0, 0));
        this._basicTMPanel.add((Component)this._tmPaddingTxtField, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 23, 2, new Insets(3, 25, 3, 45), 0, 0));
        if (!Common.isGrid().booleanValue()) {
            this._basicComPanel = new JPanel(new GridBagLayout());
            this._basicComPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("LoadTablesFromOracle.compression")));
            this._basicComPanel.add((Component)this._compressionLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(3, 45, 3, 3), 0, 0));
            this._basicComPanel.add(this._compressionComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(3, 25, 3, 45), 0, 0));
            this._basicComPanel.add((Component)this._comPaddingLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 0, new Insets(3, 45, 3, 3), 0, 0));
            this._basicComPanel.add((Component)this._comPaddingTxtField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 23, 2, new Insets(3, 25, 3, 45), 0, 0));
            this._basicComPanel.add((Component)this._minComRatioLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, new Insets(3, 45, 3, 3), 0, 0));
            this._basicComPanel.add((Component)this._minComRatioTxtField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 23, 2, new Insets(3, 25, 3, 45), 0, 0));
            this._basicComPanel.add((Component)this._minNumRowsLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 23, 0, new Insets(3, 45, 3, 3), 0, 0));
            this._basicComPanel.add((Component)this._minNumRowsTxtField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 23, 2, new Insets(3, 25, 3, 45), 0, 0));
        }
        this._analysisParamPanel = new JPanel(new GridBagLayout());
        this._analysisParamPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("LoadTablesFromOracle.analysisParameters")));
        this._analysisParamPanel.add((Component)this._stopRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._analysisParamPanel.add((Component)this._skipRadioButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._basicPanel.add((Component)this._basicTMPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
        if (!Common.isGrid().booleanValue()) {
            this._basicPanel.add((Component)this._basicComPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
        } else {
            --n;
        }
        this._basicPanel.add((Component)this._analysisParamPanel, new GridBagConstraints(0, n, 2, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void initLoadOptionsPanel() {
        this._loadOptionsPanel = new JPanel(new GridBagLayout());
        this._LOpanel = new LoadOptionsPanel(this.loadOptions);
        this._LOpanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("LoadTablesFromOracle.loadOptionsConfiguration")));
        this._indexPanel = new JPanel(new GridBagLayout());
        this._indexPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("LoadTablesFromOracle.indexCreation")));
        if (!Common.isAcadia().booleanValue()) {
            this._indexPanel.add((Component)this._indexLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 45, 5, 3), 0, 0));
            this._indexPanel.add(this._indexComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 25, 5, 45), 0, 0));
        } else if (Common.isGrid().booleanValue()) {
            this._indexPanel.add((Component)this._indexLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 45, 5, 3), 0, 0));
            this._indexPanel.add(this._indexComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 25, 5, 45), 0, 0));
            this._indexPanel.add((Component)this._indexCreationCheckBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 25, 5, 45), 0, 0));
        } else {
            this._indexPanel.add((Component)this._indexLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 45, 5, 3), 0, 0));
            this._indexPanel.add(this._indexComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 25, 5, 45), 0, 0));
            this._indexPanel.add((Component)this._indexCreationCheckBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 25, 5, 45), 0, 0));
        }
        this._loadOptionsPanel.add((Component)this._LOpanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._loadOptionsPanel.add((Component)this._indexPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void initSouthPanel() {
        this._southPanel = new JPanel(new GridBagLayout());
        this._southPanel.add((Component)this._restoreButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this._southPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.loadOptions = (LoadOptions)traversableContext.get("LOAD_OPTIONS");
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        if (!this.initialized) {
            this.init();
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        int n;
        if (traversableContext.getDirection() == 2) {
            return;
        }
        String string = this._inlineColsTxtField.getText().trim();
        String string2 = this._tmPaddingTxtField.getText().trim();
        String string3 = this._comPaddingTxtField.getText().trim();
        String string4 = this._minComRatioTxtField.getText().trim();
        String string5 = this._minNumRowsTxtField.getText().trim();
        try {
            n = Integer.parseInt(string);
            if (n < 0 || n > 32768) {
                throw new TraversalException(Messages.getString("LoadTablesFromOracle.invalidInlineColsSize"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new TraversalException(Messages.getString("LoadTablesFromOracle.invalidInlineColsSize"));
        }
        try {
            n = Integer.parseInt(string2);
            if (n < 0 || n > 1000) {
                throw new TraversalException(Messages.getString("LoadTablesFromOracle.invalidTPaddingFactor"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new TraversalException(Messages.getString("LoadTablesFromOracle.invalidTPaddingFactor"));
        }
        try {
            n = Integer.parseInt(string3);
            if (n < 0 || n > 1000) {
                throw new TraversalException(Messages.getString("LoadTablesFromOracle.invalidCPaddingFactor"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new TraversalException(Messages.getString("LoadTablesFromOracle.invalidCPaddingFactor"));
        }
        try {
            n = Integer.parseInt(string4);
            if (n < 1 || n > 100) {
                throw new TraversalException(Messages.getString("LoadTablesFromOracle.invalidMinCompressionRatio"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new TraversalException(Messages.getString("LoadTablesFromOracle.invalidMinCompressionRatio"));
        }
        try {
            n = Integer.parseInt(string5);
            if (n < 1) {
                throw new TraversalException(MessageFormat.format(Messages.getString("LoadTablesFromOracle.invalidMinNumRows"), Integer.MAX_VALUE));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new TraversalException(MessageFormat.format(Messages.getString("LoadTablesFromOracle.invalidMinNumRows"), Integer.MAX_VALUE));
        }
        try {
            this._LOpanel.validInput();
        }
        catch (NumberFormatException numberFormatException) {
            throw new TraversalException(numberFormatException.getMessage());
        }
        this.setAnalysisParam();
        traversableContext.put("ANALYSISPARAM", (Object)this.ap);
        this.setIndexParam();
        traversableContext.put("LOAD_OPTIONS", (Object)this.loadOptions);
    }

    private void setAnalysisParam() {
        if (this.ap == null) {
            this.ap = new AnalysisParam();
        }
        if (this._stopRadioButton.isSelected()) {
            this.ap.setOnBadType(0);
        } else {
            this.ap.setOnBadType(1);
        }
        String string = (String)this._numberComboBox.getSelectedItem();
        this.ap.setNumberMapping(1);
        if (string.equals(Common.NUMBER_OPT[0])) {
            this.ap.setNumberMapping(0);
        } else if (string.equals(Common.NUMBER_OPT[2])) {
            this.ap.setNumberMapping(2);
        }
        string = (String)this._varchar2ComboBox.getSelectedItem();
        this.ap.setVarchar2Mapping(0);
        if (string.equals(Common.VARCHAR2_OPT[1])) {
            this.ap.setVarchar2Mapping(1);
        }
        string = (String)this._rawComboBox.getSelectedItem();
        this.ap.setRawMapping(1);
        if (string.equals(Common.RAW_LOB_TYPES_OPT[0])) {
            this.ap.setRawMapping(0);
        }
        this.ap.setLOBMapping(1);
        string = (String)this._timestampComboBox.getSelectedItem();
        this.ap.setTimestampMapping(1);
        if (string.equals(Common.TIMESTAMP_OPT[0])) {
            this.ap.setTimestampMapping(0);
        }
        this.ap.setTypeMappingPadding(Integer.parseInt(this._tmPaddingTxtField.getText().trim()));
        string = (String)this._compressionComboBox.getSelectedItem();
        this.ap.setCompression(0);
        if (string.equals(Common.COMPRESSION_OPT[1])) {
            this.ap.setCompression(1);
        } else if (string.equals(Common.COMPRESSION_OPT[2])) {
            this.ap.setCompression(2);
        }
        this.ap.setCompressionPadding(Integer.parseInt(this._comPaddingTxtField.getText().trim()));
        this.ap.setCompressionFactor(Integer.parseInt(this._minComRatioTxtField.getText().trim()));
        this.ap.setCompressionMinimumRows(Long.parseLong(this._minNumRowsTxtField.getText().trim()));
        this.ap.setInlineLimit(Integer.parseInt(this._inlineColsTxtField.getText().trim()));
    }

    private void setIndexParam() {
        this.loadOptions.setIndexCreationPolicy((LoadOptions.IndexCreationPolicy)((Object)this._indexComboBox.getSelectedItem()));
        this.loadOptions.setCreateIndexesIfNoErrors(this._indexCreationCheckBox.isSelected());
    }

    public Object getExitTransition() {
        return "LoadSelected";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._restoreButton) {
            this.setDefaultValues();
        } else if (actionEvent.getSource() == this._compressionComboBox) {
            this._comPaddingTxtField.setEnabled(this._compressionComboBox.getSelectedIndex() != 0);
            this._minComRatioTxtField.setEnabled(this._compressionComboBox.getSelectedIndex() != 0);
            this._minNumRowsTxtField.setEnabled(this._compressionComboBox.getSelectedIndex() != 0);
        } else if (actionEvent.getSource() == this._indexComboBox) {
            this._indexCreationCheckBox.setEnabled(this._indexComboBox.getSelectedIndex() != 2);
            if (!this._indexCreationCheckBox.isEnabled()) {
                this._indexCreationCheckBox.setSelected(false);
            }
        }
    }

    private void setDefaultValues() {
        this._skipRadioButton.setSelected(true);
        this._inlineColsTxtField.setText("128");
        this._numberComboBox.setSelectedItem(Common.NUMBER_OPT[1]);
        this._rawComboBox.setSelectedItem(Common.RAW_LOB_TYPES_OPT[1]);
        this._longRawComboBox.setSelectedItem(Common.RAW_LOB_TYPES_OPT[1]);
        this._timestampComboBox.setSelectedItem(Common.TIMESTAMP_OPT[1]);
        this._varchar2ComboBox.setSelectedItem(Common.VARCHAR2_OPT[0]);
        this._lobComboBox.setSelectedItem(Common.RAW_LOB_TYPES_OPT[1]);
        this._tmPaddingTxtField.setText("0");
        this._compressionComboBox.setSelectedItem(Common.COMPRESSION_OPT[0]);
        this._comPaddingTxtField.setText("0");
        this._comPaddingTxtField.setEnabled(false);
        this._minComRatioTxtField.setText("70");
        this._minComRatioTxtField.setEnabled(false);
        this._minNumRowsTxtField.setText("1024");
        this._minNumRowsTxtField.setEnabled(false);
        this._LOpanel.setDefaultValues();
        this._indexComboBox.setSelectedIndex(0);
        this._indexCreationCheckBox.setSelected(this.loadOptions.createIndexesIfNoErrors());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
    }
}

