/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.computesize;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.dialogs.table.computesize.ComputeSizeReportPanel;
import oracle.dbtools.raptor.timesten.dialogs.table.computesize.ComputeSizeSQLPanel;
import oracle.dbtools.raptor.timesten.dialogs.table.computesize.ComputeTableSizePanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.MessageDialog;

public class ComputeTableSize
extends AbstractMenuAction {
    private ComputeSizeSQLPanel _sqlPanel;
    private ComputeTableSizePanel _tableSizePanel;
    private JEWTDialog dialog;
    private boolean executed;
    private static Logger _logger = Logger.getLogger(ComputeTableSize.class.getPackage().getName());

    public void launch() {
        DBObject dBObject = this.getDBObject();
        this._sqlPanel = new ComputeSizeSQLPanel();
        this._tableSizePanel = new ComputeTableSizePanel(dBObject, this._sqlPanel);
        JPanel[] jPanelArray = new JPanel[2];
        jPanelArray[1] = this._sqlPanel;
        jPanelArray[0] = this._tableSizePanel;
        String[] stringArray = new String[]{Messages.getString("TTJpanel.prompts"), Messages.getString("TTJpanel.SQL")};
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        this.dialog = UIUtils.createTabbedPanelDialog((JPanel[])jPanelArray, (String[])stringArray, (String)Messages.getString("ComputeTableSize.computeTableSize"), (ActionListener)actionListener);
        this.dialog.setButtonMask(6);
        JButton jButton = new JButton(Messages.getString("ComputeTableSize.apply"));
        this.dialog.addCustomButton((Component)jButton);
        this.dialog.setPreferredSize(400, 200);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._tableSizePanel, "f1_ott_table_compute_size_html");
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._tableSizePanel, "f1_ott_table_compute_size_html");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComputeTableSize.this.calculateSize();
            }
        });
        this.dialog.runDialog();
    }

    private void calculateSize() {
        this.executed = false;
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Void doInBackground() throws Exception {
                Connection connection = null;
                Statement statement = null;
                try {
                    connection = ComputeTableSize.this.getDBObject().getConnection();
                    statement = connection.createStatement();
                    Connections.getInstance().lock(connection);
                    statement.execute(ComputeTableSize.this._sqlPanel.getSQLText());
                    ComputeTableSize.this.executed = true;
                }
                catch (SQLException sQLException) {
                    ComputeTableSize.this.executed = false;
                    _logger.log(Level.SEVERE, "Couldn't get table size", sQLException);
                    MessageDialog.error(null, (Object)TTSQLExceptionScrubber.getInstance().getMessage(connection, statement.toString(), sQLException), (String)Messages.getString("TimesTen.common.error"), null);
                }
                finally {
                    if (connection != null) {
                        Connections.getInstance().unlock(connection);
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {
                            _logger.log(Level.SEVERE, "Couldn't close statement", sQLException);
                        }
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                if (ComputeTableSize.this.executed) {
                    JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)new ComputeSizeReportPanel(ComputeTableSize.this.getDBObject()), (String)Messages.getString("ComputeTableSize.tableResults"), null);
                    jEWTDialog.setButtonMask(1);
                    jEWTDialog.setSize(400, 215);
                    jEWTDialog.setPreferredSize(400, 215);
                    jEWTDialog.runDialog();
                    ComputeTableSize.this.dialog.dispose();
                } else {
                    ComputeTableSize.this.dialog.dispose();
                }
            }
        };
        swingWorker.execute();
    }
}

