/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.profile;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.sql.Connection;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.utils.OutputRedirector;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.profile.TTSqlProfilePanel;
import oracle.dbtools.raptor.timesten.dialogs.user.TTResultPanel;

public class TTDropProfileDialog {
    private TTDropProfilePanel dropProfilePanel;
    private TTSqlProfilePanel sqlPanel;
    private TTResultPanel resPanel;
    private static final String DROP_PROFILE_FORMAT = "drop profile \"{0}\" cascade";

    public void showDialog(final Connection connection, String string, final ObjectActionController.ObjectActionPostProcess objectActionPostProcess) {
        this.dropProfilePanel = new TTDropProfilePanel(string);
        this.sqlPanel = new TTSqlProfilePanel();
        this.resPanel = new TTResultPanel();
        JPanel[] jPanelArray = new JPanel[3];
        String[] stringArray = new String[3];
        stringArray[0] = Messages.getString("TTProfile.prompt");
        jPanelArray[0] = this.dropProfilePanel;
        Dimension dimension = new Dimension(350, 200);
        this.dropProfilePanel.setPreferredSize(dimension);
        this.dropProfilePanel.setMinimumSize(dimension);
        stringArray[1] = Messages.getString("TTCreateProfile.sql");
        jPanelArray[1] = this.sqlPanel;
        this.sqlPanel.setPreferredSize(dimension);
        this.sqlPanel.setMinimumSize(dimension);
        this.sqlPanel.updateSQL(MessageFormat.format(DROP_PROFILE_FORMAT, string));
        stringArray[2] = Messages.getString("TTCreateProfile.results");
        jPanelArray[2] = this.resPanel;
        this.resPanel.setPreferredSize(dimension);
        this.resPanel.setMinimumSize(dimension);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PipedInputStream pipedInputStream = new PipedInputStream();
                TTDropProfileDialog.this.resPanel.getSqlPane().setEditable(true);
                TTDropProfileDialog.this.resPanel.getSqlPane().setText("");
                TTDropProfileDialog.this.resPanel.getSqlPane().setEditable(false);
                JTabbedPane jTabbedPane = (JTabbedPane)TTDropProfileDialog.this.resPanel.getParent();
                jTabbedPane.setSelectedIndex(2);
                ScriptExecutor scriptExecutor = new ScriptExecutor(TTDropProfileDialog.this.sqlPanel.getSQLEditorPane().getText(), connection);
                ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
                scriptExecutor.setScriptRunnerContext(scriptRunnerContext);
                OutputRedirector outputRedirector = new OutputRedirector(pipedInputStream, TTDropProfileDialog.this.resPanel.getSqlPane().getDocument(), TTDropProfileDialog.this.resPanel.getSqlPane());
                outputRedirector.setName(Messages.getString("TTCreateProfile.general"));
                outputRedirector.start();
                try {
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new PipedOutputStream(pipedInputStream));
                    scriptExecutor.setOut(bufferedOutputStream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                scriptExecutor.start();
                if (!Boolean.TRUE.equals(scriptRunnerContext.getProperty("sqldev.error"))) {
                    objectActionPostProcess.run();
                }
            }
        };
        UIUtils.showPanelAsTabbedDialog2((JPanel[])jPanelArray, (String[])stringArray, (String)Messages.getString("TTProfile.dropProfile"), (ActionListener)actionListener, null, null);
    }

    private static class TTDropProfilePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JLabel label;

        public TTDropProfilePanel(String string) {
            this.init(string);
        }

        private void init(String string) {
            this.setLayout(new GridBagLayout());
            this.label = new JLabel();
            this.label.setText(MessageFormat.format(Messages.getString("TTDropProfile.confirmation"), string));
            this.add(this.label);
        }
    }
}

