/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.connection;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TimesTenUtil;
import oracle.dbtools.raptor.timesten.dialogs.connection.ConnectionCapturePanels;
import oracle.dbtools.raptor.timesten.dialogs.connection.MessageIndeterminateProgressMonitor;
import oracle.dbtools.raptor.timesten.dialogs.connection.TableStatistics;
import oracle.dbtools.raptor.timesten.utils.TTIsql;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.MessageDialog;

public class ConnectionCapture
extends AbstractMenuAction {
    private static Logger LOGGER = Logger.getLogger(ConnectionCapture.class.getPackage().getName());
    private static String MESSAGE = "message";
    private static String PROGRESS = "progress";
    private JEWTDialog _dialog;
    private ConnectionCapturePanels _ccp;
    private JPanel[] _panels;
    private MessageIndeterminateProgressMonitor _progressMonitor;
    private ProgressMonitor _pm;
    private JButton _startStopButton;
    private boolean _errorOnSql = false;
    private TTIsql _ttisqCommand;
    private DBObject _dbObject = this.getDBObject();
    public static final String[] _indexAdviceBounds = new String[]{"-- >>>>> START ttIndexAdviceCaptureOutput", "-- <<<<< END ttIndexAdviceCaptureOutput"};
    public static final String[] _tableStatisticsBounds = new String[]{"-- >>>>> START ttOptStatsExport", "-- >>>>> END ttOptStatsExport"};

    public void launch() {
        ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)this.getObjectAction(), (DBObject)this._dbObject);
        this.setBlockOACRefresh(true);
        this._ccp = new ConnectionCapturePanels(this._dialog, this.getDBObject());
        this._ttisqCommand = new TTIsql(this.getDBObject());
        this._panels = this._ccp.getPanels();
        MyActionListener myActionListener = new MyActionListener();
        this._dialog = UIUtils.createTabbedPanelDialog2((JPanel[])this._panels, (String[])this._ccp.getTitles(), (String)Messages.getString("IndexAdvisor.connectionLevelCaptureTitle"), (ActionListener)myActionListener, null, null);
        this._dialog.setSize(new Dimension(700, 675));
        this._dialog.setButtonMask(20);
        TableStatistics tableStatistics = new TableStatistics(this.getDBObject().getConnection(), (Dialog)this._dialog);
        int n = tableStatistics.displayWarning();
        if (n != 1) {
            this._dialog.closeDialog(true);
            this._dialog.dispose();
            return;
        }
        this._startStopButton = new JButton(StringUtils.stripMnemonic((String)Messages.getString("IndexAdvisor.start")));
        this._startStopButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("IndexAdvisor.start")));
        this._startStopButton.addActionListener(myActionListener);
        this._dialog.addCustomButton((Component)this._startStopButton);
        JTabbedPane jTabbedPane = (JTabbedPane)this._dialog.getContent();
        jTabbedPane.setEnabledAt(1, false);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._panels[0], "f1_ott_index_advisor_conn_capture_workload_html");
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._panels[1], "f1_ott_index_advisor_conn_capture_workload_html");
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._panels[2], "f1_ott_index_advisor_conn_capture_workload_html");
        this._dialog.setVisible(true);
    }

    public void setCaptureLevel() {
        this._ccp.getIndexAdvicePanel().setCaptureLevel(0);
    }

    private void generateAdvice(String string) {
        this._ccp.getIndexAdvicePanel().generateAdvice(string);
    }

    private void enableTabs() {
        JTabbedPane jTabbedPane = (JTabbedPane)this._dialog.getContent();
        jTabbedPane.setEnabledAt(1, true);
    }

    private String[] setupTTISQLScript() {
        this._ttisqCommand.executeOnTTIsql(this.createIndexAdvisorScript());
        if (this._ttisqCommand.getError() != null) {
            MessageDialog.error(null, (Object)this._ttisqCommand.getError(), (String)Messages.getString("TimesTen.common.error"), null);
            this._errorOnSql = true;
        } else {
            this._errorOnSql = false;
        }
        return this._ttisqCommand.getOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createIndexAdvisorScript() {
        File file = null;
        File file2 = null;
        BufferedWriter bufferedWriter = null;
        String string = System.getProperty("java.io.tmpdir");
        String string2 = this._ccp.getSqlScript();
        int n = 0;
        int n2 = this._ccp.getCaptureMode();
        try {
            file = new File(string);
            String string3 = System.getProperty("pid");
            file2 = File.createTempFile("SQD-IA", ".sql", file);
            file2.delete();
            file2.createNewFile();
            file2.deleteOnExit();
            FileWriter fileWriter = new FileWriter(file2);
            bufferedWriter = new BufferedWriter(fileWriter);
            fileWriter.write("-- Wrap the user script with calls to Index advisor\n");
            fileWriter.write("CALL ttIndexAdviceCaptureStart(" + n + "," + n2 + ");\n");
            if (this._ccp.includeOlapOptimizerHints()) {
                fileWriter.write(this._ccp.getHints());
            }
            if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                fileWriter.write("run \"" + string2 + "\";\n");
            } else {
                fileWriter.write("run " + string2 + ";\n");
            }
            fileWriter.write("CALL ttIndexAdviceCaptureEnd(" + n + ");\n");
            fileWriter.write("-- Capture output\n");
            fileWriter.write(_indexAdviceBounds[0] + "\n");
            fileWriter.write("CALL ttIndexAdviceCaptureOutput(" + n + ");\n");
            fileWriter.write(_indexAdviceBounds[1] + "\n");
            fileWriter.write("-- Table statistics\n");
            fileWriter.write("-- >>>>> START ttOptStatsExport\n");
            fileWriter.write("CALL ttOptStatsExport();\n");
            fileWriter.write("-- <<<<< END ttOptStatsExport\n");
            fileWriter.write("-- Drop capture information.\n");
            fileWriter.write("CALL ttIndexAdviceCaptureDrop;\n");
            String string4 = file2.getAbsolutePath();
            return string4;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Can't write to file while creating index advisor script", iOException);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public boolean isEnabled(Context context) {
        return TimesTenUtil.isMenuEnabledForGridDatatabase(context);
    }

    private class IndexAdvisorWorker
    extends SwingWorker<Void, Void> {
        private JTextPane _pane = new JTextPane();
        private JScrollPane _scrollPane = new JScrollPane(this._pane);

        private IndexAdvisorWorker() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            String[] stringArray = ConnectionCapture.this.setupTTISQLScript();
            if (!ConnectionCapture.this._errorOnSql) {
                this.firePropertyChange(MESSAGE, null, stringArray);
                this.setProgress(100);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionCapture.this._progressMonitor.close();
                    }
                });
            }
            return null;
        }

        @Override
        protected void done() {
            if (!ConnectionCapture.this._errorOnSql) {
                ConnectionCapture.this._startStopButton.setEnabled(false);
                if (!ConnectionCapture.this._ccp.getIndexAdvicePanel().isRecommendationAvailable()) {
                    MessageDialog.information((Component)ConnectionCapture.this._dialog, (Object)Messages.getString("IndexAdvisor.noIndexRecommendation"), (String)Messages.getString("IndexAdvisor.noIndexRecommendationTitle"), null);
                }
                ConnectionCapture.this.enableTabs();
            }
        }
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() != ConnectionCapture.this._startStopButton) {
                return;
            }
            ConnectionCapture.this._progressMonitor = new MessageIndeterminateProgressMonitor((Component)ConnectionCapture.this._dialog, Messages.getString("IndexAdvisor.assistantProgress"), Messages.getString("IndexAdvisor.assistantProgress"), null);
            ConnectionCapture.this._progressMonitor.addCancellationListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    ConnectionCapture.this._progressMonitor.close();
                }
            });
            ConnectionCapture.this.setCaptureLevel();
            final IndexAdvisorWorker indexAdvisorWorker = new IndexAdvisorWorker();
            indexAdvisorWorker.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Object var2_2 = null;
                    if (PROGRESS.equals(propertyChangeEvent.getPropertyName())) {
                        int n = (Integer)propertyChangeEvent.getNewValue();
                        String string = String.format(Messages.getString("IndexAdvisor.pertentageComplete"), n);
                        ConnectionCapture.this._progressMonitor.updateMessage(string);
                        if (ConnectionCapture.this._progressMonitor.isCanceled() || indexAdvisorWorker.isDone()) {
                            Toolkit.getDefaultToolkit().beep();
                            if (ConnectionCapture.this._progressMonitor.isCanceled()) {
                                indexAdvisorWorker.cancel(true);
                            } else {
                                ConnectionCapture.this._progressMonitor.finish();
                            }
                        }
                    } else if (MESSAGE.equals(propertyChangeEvent.getPropertyName())) {
                        String[] stringArray = (String[])propertyChangeEvent.getNewValue();
                        for (int i = 0; i < stringArray.length; ++i) {
                            ConnectionCapture.this._progressMonitor.updateTextArea(stringArray[i]);
                        }
                        ConnectionCapture.this.generateAdvice(stringArray[0]);
                        ConnectionCapture.this.enableTabs();
                    }
                }
            });
            indexAdvisorWorker.execute();
            ConnectionCapture.this._progressMonitor.start();
        }
    }
}

