/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.cache;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCPanel;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableColsTableModel;
import oracle.dbtools.raptor.timesten.dialogs.cache.LOBDialog;
import oracle.dbtools.raptor.timesten.dialogs.cache.MenuRenderer;
import oracle.ide.dialogs.DialogUtil;

class TTTypeEditor
extends DefaultCellEditor
implements ItemListener {
    CGCTableColsTableModel _tm;
    MenuRenderer _menuRenderer;
    JComboBox _cb = null;
    int _r;

    public TTTypeEditor(CGCTableColsTableModel cGCTableColsTableModel) {
        super(new JComboBox<String>(new String[]{""}));
        this._tm = cGCTableColsTableModel;
        this._menuRenderer = new MenuRenderer(cGCTableColsTableModel);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (this._cb == null) {
            this._cb = (JComboBox)super.getTableCellEditorComponent(jTable, object, false, n, n2);
            this._cb.addItemListener(this);
            this._cb.setRenderer(this._menuRenderer);
            this._cb.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    TTTypeEditor.this._cb.setPopupVisible(true);
                }
            });
        }
        Object[] objectArray = this._tm.getTTTypeNames(n);
        boolean bl2 = this._tm.getCol(this._r).getOraTypeName().endsWith("LOB");
        if (bl2) {
            this._menuRenderer.setDefault(objectArray[0]);
        } else {
            this._menuRenderer.setDefault(this._tm.getTTTypeNameDefault(n));
        }
        this._cb.setModel(new DefaultComboBoxModel(objectArray){});
        this._cb.setSelectedItem(this._tm.getTTTypeName(n));
        this._r = n;
        return this._cb;
    }

    LOBDialog getLOBDialog(int n) {
        Dialog dialog = DialogUtil.getAncestorDialog((Component)CGCPanel.theDialog.getTablePanel());
        LOBDialog lOBDialog = new LOBDialog(dialog, this._tm, n);
        lOBDialog.setLocationRelativeTo(dialog);
        return lOBDialog;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        JComboBox jComboBox = (JComboBox)itemEvent.getSource();
        Object object = itemEvent.getItem();
        if (itemEvent.getStateChange() == 1 && object.toString().equals(Messages.getString("CGCColInfo.Change"))) {
            LOBDialog lOBDialog = this.getLOBDialog(this._r);
            lOBDialog.show();
            if (!lOBDialog.isCancelled()) {
                long l = lOBDialog.getLOBSize();
                String string = lOBDialog.getLOBUnit();
                String string2 = this._tm.getCol(this._r).setLOBSize(l, string);
                this._tm.setValueAt(string2, this._r, 2);
                Vector<String> vector = new Vector<String>(2);
                vector.add(string2);
                vector.add(Messages.getString("CGCColInfo.Change"));
                jComboBox.setModel(new DefaultComboBoxModel(vector){});
            }
            jComboBox.setSelectedIndex(0);
        }
    }
}

