/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.cache;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableColsTableModel;

class CheckBoxHeaderRenderer
extends JCheckBox
implements TableCellRenderer,
MouseListener,
ItemListener {
    protected int _colClicked = -1;
    boolean _marching = true;
    int _column;
    JTable _table;
    CGCTableColsTableModel _model;
    TableColumnModel _columnModel;
    boolean _skipItemStateChangedCB;
    Component _checkbox = null;
    boolean mouseClickProcessed = false;

    void setMarching(boolean bl) {
        this._marching = bl;
        if (!bl && this.isSelected()) {
            this.setSelectedNoInform(false);
        }
    }

    public CheckBoxHeaderRenderer(JTable jTable, int n) {
        this.addItemListener(this);
        this._table = jTable;
        this._model = (CGCTableColsTableModel)this._table.getModel();
        this._column = n;
        this.setSelectedNoInform(true);
    }

    void setSelectedNoInform(boolean bl) {
        this._skipItemStateChangedCB = true;
        this.setSelected(bl);
        this._model.fireTableDataChanged();
        this._columnModel = this._table.getColumnModel();
        JTableHeader jTableHeader = this._table.getTableHeader();
        jTableHeader.repaint();
        this._skipItemStateChangedCB = false;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JTableHeader jTableHeader = jTable.getTableHeader();
        TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
        this._checkbox = tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, 1, n2);
        this.setForeground(jTableHeader.getForeground());
        this.setBackground(jTableHeader.getBackground());
        this.setBorderPainted(true);
        this.setBorder(jTableHeader.getBorder());
        this.setFont(jTableHeader.getFont());
        this.setSelected(this._marching);
        jTableHeader.addMouseListener(this);
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.setText((String)object);
        return this;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseClickProcessed = false;
        this._colClicked = -1;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.handleClickEvent(mouseEvent);
        ((JTableHeader)mouseEvent.getSource()).repaint();
    }

    protected void handleClickEvent(MouseEvent mouseEvent) {
        if (this._colClicked == -1 && !this.mouseClickProcessed) {
            int n;
            this.mouseClickProcessed = true;
            int n2 = n = this._columnModel.getColumnIndexAtX(mouseEvent.getX());
            if (n == n2 && mouseEvent.getClickCount() == 1 && n2 != -1) {
                this._colClicked = n2;
                this.doClick();
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this._skipItemStateChangedCB) {
            return;
        }
        if (itemEvent.getSource() != this) {
            return;
        }
        if (this._colClicked != this._column) {
            return;
        }
        boolean bl = itemEvent.getStateChange() == 1;
        int n = this._model.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (!this._model.isCellEditable(i, this._column)) continue;
            this._model.setValueAt(new Boolean(bl), i, this._column);
        }
        this._model.fireTableDataChanged();
    }
}

