/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.cache;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.raptor.timesten.SimpleQuery;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCColInfo;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCFKCol;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCIndexCol;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCPanel;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableColsTableModel;
import oracle.dbtools.raptor.utils.DBObject;

public class CGCTableTreeNode
extends DefaultMutableTreeNode {
    boolean _isTable;
    boolean _isRootTable;
    boolean _isOrphan = false;
    boolean _isNoIndex = false;
    CGCTableTreeNode _parentTable = null;
    boolean _isInCG = false;
    String _realName;
    String _owner;
    String _table;
    String _realOwner;
    String _realTable;
    CGCTableColsTableModel _model = null;
    int _nIndices = -1;
    CGCColInfo[] _cols = null;
    HashMap _map = null;
    int _isCachable = 0;
    CGCFKCol[] _FKCols = null;
    CGCIndexCol[] _PKCols = null;
    CGCIndexCol[] _IndicesNoFloat = null;
    CGCIndexCol[] _Indices = null;
    boolean _refuseDrop = false;

    public void setTableModel(CGCTableColsTableModel cGCTableColsTableModel) {
        this._model = cGCTableColsTableModel;
    }

    CGCTableColsTableModel getTableModel() {
        return CGCPanel.theDialog.getTableModel(this);
    }

    public void startOver() {
        if (this._model != null) {
            this._model.startOver();
        }
    }

    void setCachable(boolean bl) {
        this._isCachable = bl ? 1 : -1;
    }

    void setCachable(int n) {
        this._isCachable = n;
    }

    int getCachable() {
        return this._isCachable;
    }

    public CGCTableTreeNode(String string) {
        this(string, false);
    }

    public CGCTableTreeNode(String string, String string2) {
        this(string, false);
        this._isTable = true;
        this._owner = string2;
    }

    public CGCTableTreeNode(String string, boolean bl) {
        super(string);
        this._realName = string;
        this._owner = null;
        this._table = null;
        this._isRootTable = bl;
        this._isTable = bl;
        try {
            String[] stringArray = string.split("\\.");
            this._owner = stringArray[0];
            this._table = stringArray[1];
            this._isTable = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this._isTable) {
            this._refuseDrop = true;
        }
        this._realOwner = null;
    }

    public String getOwnerName() {
        return this._owner;
    }

    public String getTableName() {
        return this._table;
    }

    public String getRealOwnerName() {
        return this._realOwner;
    }

    public String getRealTableName() {
        return this._realTable;
    }

    public void handleSynonym(DBObject dBObject) {
        if (this._realOwner != null) {
            return;
        }
        String string = this._owner;
        String string2 = this._table;
        HashSet<CallSite> hashSet = new HashSet<CallSite>();
        String string3 = string + "." + string2;
        hashSet.add((CallSite)((Object)string3));
        while (true) {
            String[] stringArray;
            if ((stringArray = SimpleQuery.getSynonymInfo(dBObject, string, string2, true)) == null || stringArray[2] == null) {
                this._realOwner = string;
                this._realTable = string2;
                break;
            }
            string = stringArray[2];
            string2 = stringArray[3];
            string3 = string + "." + string2;
            if (hashSet.contains(string3)) {
                this._realOwner = "";
                break;
            }
            hashSet.add((CallSite)((Object)string3));
        }
    }

    public boolean isTable() {
        return this._isTable;
    }

    public boolean isRootTable() {
        return this._isRootTable;
    }

    public void unsetIsRootTable() {
        this._isRootTable = false;
    }

    public String getRealName() {
        return this._realName;
    }

    public boolean isOrphan() {
        return this._isOrphan;
    }

    public void setOrphan(boolean bl) {
        this._isOrphan = bl;
    }

    public boolean isNoIndex() {
        return this._isNoIndex;
    }

    public void setNoIndex(boolean bl) {
        this._isNoIndex = bl;
    }

    public boolean isNoParentTable() {
        return this._parentTable == null;
    }

    CGCTableTreeNode getParentTable() {
        return this._parentTable;
    }

    void setParentTable(CGCTableTreeNode cGCTableTreeNode) {
        this._parentTable = cGCTableTreeNode;
        if (this._model != null) {
            this._model.setParentTable(cGCTableTreeNode);
        }
    }

    public boolean isInCG() {
        return this._isInCG;
    }

    public void setInCG(boolean bl) {
        this._isInCG = bl;
    }

    public boolean allowDrag() {
        return this.isTable() && !this.isNoIndex() && !this.isRootTable() && !this.isInCG();
    }

    void setRefuseDrop(boolean bl) {
        this._refuseDrop = bl;
    }

    public boolean allowDrop() {
        return !this._refuseDrop && !this.isNoIndex() && !this.isInCG();
    }

    public void setCols(CGCColInfo[] cGCColInfoArray) {
        this._cols = cGCColInfoArray;
        this._map = new HashMap();
        for (int i = 0; i < cGCColInfoArray.length; ++i) {
            CGCColInfo cGCColInfo = cGCColInfoArray[i];
            this._map.put(cGCColInfo.getColName(), cGCColInfo);
        }
    }

    public CGCColInfo[] getCols() {
        return this._cols;
    }

    public CGCColInfo getCol(String string) {
        return (CGCColInfo)this._map.get(string);
    }

    public void setFKCols(CGCFKCol[] cGCFKColArray) {
        this._FKCols = cGCFKColArray;
        this.getTableModel().setFKCols(cGCFKColArray);
    }

    public CGCFKCol[] getFKCols() {
        return this._FKCols;
    }

    public CGCIndexCol[] getPKCols() {
        return this._PKCols;
    }

    private void doPKCols(CGCIndexCol[] cGCIndexColArray) {
        int n;
        if (this._PKCols != null) {
            return;
        }
        int n2 = 0;
        for (n = 0; n < cGCIndexColArray.length; ++n) {
            if (!cGCIndexColArray[n].isPK()) continue;
            ++n2;
        }
        if (n2 > 0) {
            this._PKCols = new CGCIndexCol[n2];
            n2 = 0;
            for (n = 0; n < cGCIndexColArray.length; ++n) {
                CGCIndexCol cGCIndexCol = cGCIndexColArray[n];
                if (!cGCIndexCol.isPK()) continue;
                this._PKCols[n2++] = cGCIndexColArray[n];
                this.getCol(cGCIndexCol.getColName()).setIsPK();
            }
        }
        if (this._model != null) {
            this._model.setPKCols(this._PKCols);
        }
    }

    public void setIndexWithoutFloat(CGCIndexCol[] cGCIndexColArray) {
        if (cGCIndexColArray != null) {
            this._IndicesNoFloat = cGCIndexColArray;
        }
        this.doPKCols(cGCIndexColArray);
    }

    public CGCIndexCol[] getIndexWithoutFloat() {
        CGCIndexCol[] cGCIndexColArray = this._IndicesNoFloat;
        return this._IndicesNoFloat;
    }

    public void setIndexWithFloat(CGCIndexCol[] cGCIndexColArray) {
        this._Indices = cGCIndexColArray;
        this.doPKCols(cGCIndexColArray);
    }

    public CGCIndexCol[] getIndexWithFloat() {
        CGCIndexCol[] cGCIndexColArray = this._Indices;
        return this._Indices;
    }

    public void setNumIndices(int n) {
        this._nIndices = n;
    }

    public int getNumIndices() {
        return this._nIndices;
    }

    public void getSql(StringBuffer stringBuffer) {
        CGCTableColsTableModel cGCTableColsTableModel = this.getTableModel();
        cGCTableColsTableModel.getSql(stringBuffer);
    }

    @Override
    public String toString() {
        if (this._table == null) {
            return this._owner;
        }
        return this._owner.equals(CGCPanel.theDialog.getUserName()) ? this._table : this._table + " [" + this._owner + "]";
    }
}

