/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.cache;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.text.NumberFormatter;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.DialogBase;
import oracle.dbtools.raptor.timesten.dialogs.TTDialog;
import oracle.dbtools.raptor.timesten.dialogs.TTJPanel;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCFKDialog;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCPKDialog;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCPanel;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableColsTableModel;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableTreeNode;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTreeNodeSelectionListener;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.dialogs.DialogUtil;
import oracle.javatools.dialogs.MessageDialog;

public final class CGCTableAttrPanel
extends DialogBase
implements CGCTreeNodeSelectionListener,
ItemListener,
FocusListener,
ActionListener {
    CGCTableColsTableModel _model = null;
    TTJPanel _thisPanel;
    TTJPanel _pkPanel;
    TTJPanel _yesPKPanel;
    TTJPanel _noPKPanel;
    TTJPanel _fkPanel;
    TTJPanel _yesFKPanel;
    TTJPanel _noFKPanel;
    TTJPanel _tableStatusPanel;
    TTJPanel _manualTablesMgmnPanel;
    TTJPanel _wherePanel;
    TTJPanel _ropaPanel;
    Container _rangeHashGroup;
    JCheckBox _hashType;
    JLabel _hashSizingPolicy;
    JComboBox _pageRow;
    Object _page;
    Object _row;
    Object _current;
    JFormattedTextField _n;
    JLabel _alreadyCachedInfo;
    JComboBox _pkMenu;
    JComboBox _fkMenu;
    JLabel _pkLabel;
    JLabel _fkLabel;
    JButton _PKButton;
    JButton _FKButton;
    JCheckBox _fkCheckBox;
    JTextArea _where;
    JTextField _ropaType;
    Container _ropaContainer;
    CGCFKDialog _FKdialog;
    CGCPKDialog _PKdialog;

    public void startOver() {
        this.nodeSelected(null);
    }

    public CGCTableAttrPanel(DBObject dBObject, String string, List<JComponent> list) {
        super(dBObject, string, "CGCTableAttrPanel", list);
        CGCTableAttrPanel.LOUD("1 > right > right");
    }

    @Override
    protected void initGUI() {
        this._thisPanel = new TTJPanel();
        this._pkPanel = new TTJPanel(Messages.getString("TimesTen.common.PK"));
        this._yesPKPanel = new TTJPanel();
        this._pkMenu = TTDialog.createMenu(new String[]{""});
        this._textValues.add(this._pkMenu);
        this._yesPKPanel.addRow(this._pkMenu);
        this._pkLabel = new JLabel();
        this._pkLabel.setBorder(new EtchedBorder());
        this._yesPKPanel.addRow(this._pkLabel);
        this._pkMenu.addItemListener(this);
        int n = 0;
        this._rangeHashGroup = TTDialog.createRadioButtonGroup(new String[]{Messages.getString("CGCTableAttrPanel.useRange"), Messages.getString("CGCTableAttrPanel.useHash")}, n, new ActionListener[]{new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CGCTableAttrPanel.this._hashType.setSelected(false);
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CGCTableAttrPanel.this._hashType.setSelected(true);
            }
        }}, false);
        JPanel jPanel = new JPanel();
        this._hashType = new JCheckBox(Messages.getString("CGCTableAttrPanel.useHash") + " ", true);
        this._hashType.addItemListener(this);
        this._hashSizingPolicy = new JLabel(Messages.getString("CGCTableAttrPanel.hashSizingPolicy") + " ");
        this._pageRow = TTDialog.createMenu(new String[]{Messages.getString("CGCTableAttrPanel.useCurrentRowCount"), Messages.getString("CGCTableAttrPanel.userSpecifiedRowCount"), Messages.getString("CGCTableAttrPanel.userSpecifiedPageCount")}, this);
        this._current = this._pageRow.getItemAt(HASH_TYPE.CURRENT.ordinal());
        this._row = this._pageRow.getItemAt(HASH_TYPE.ROW.ordinal());
        this._page = this._pageRow.getItemAt(HASH_TYPE.PAGE.ordinal());
        this._pageRow.setSelectedIndex(HASH_TYPE.CURRENT.ordinal());
        DecimalFormat decimalFormat = new DecimalFormat("#0");
        this._n = new JFormattedTextField(new NumberFormatter(decimalFormat));
        this._n.setFocusLostBehavior(1);
        this._n.addFocusListener(this);
        this._n.setEnabled(false);
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(this._hashSizingPolicy);
        jPanel.add(this._pageRow);
        jPanel.add(new JLabel(" : "));
        jPanel.add(this._n);
        this._textValues.add(this._hashType);
        this._textValues.add(this._pageRow);
        this._textValues.add(this._n);
        this._yesPKPanel.addRow(Messages.getString("CGCTableAttrPanel.keyIndexType") + " ", (Component)this._rangeHashGroup);
        this._yesPKPanel.addRow("", (Component)jPanel);
        this._yesPKPanel.setAlignmentX(0.0f);
        this._noPKPanel = new TTJPanel();
        this._noPKPanel.addRow(new JLabel("<html>" + Messages.getString("TimesTen.common.none") + "<br><br><br>"));
        this._noPKPanel.setAlignmentX(0.0f);
        this._pkPanel.setAlignmentX(0.0f);
        this._pkPanel.addRow(this._yesPKPanel);
        this._pkPanel.addRow(this._noPKPanel);
        this._thisPanel.addRow(this._pkPanel);
        this._pkPanel.setVisible(false);
        this._fkPanel = new TTJPanel(Messages.getString("TimesTen.common.FK"));
        this._yesFKPanel = new TTJPanel();
        this._fkMenu = TTDialog.createMenu(new String[]{""});
        this._textValues.add(this._fkMenu);
        this._yesFKPanel.addRow(this._fkMenu);
        this._fkLabel = new JLabel();
        this._fkLabel.setBorder(new EtchedBorder());
        this._yesFKPanel.addRow(this._fkLabel);
        this._fkMenu.addItemListener(this);
        this._fkCheckBox = new JCheckBox(Messages.getString("CGCTableAttrPanel.cascadeDeleteForeignKey"), false);
        this._textValues.add(this._fkCheckBox);
        this._fkCheckBox.addItemListener(this);
        this._yesFKPanel.addRow(" ", (Component)this._fkCheckBox);
        this._yesFKPanel.setAlignmentX(0.0f);
        this._noFKPanel = new TTJPanel();
        this._noFKPanel.addRow(new JLabel("<html>" + Messages.getString("TimesTen.common.none") + "<br><br><br>"));
        this._noFKPanel.setAlignmentX(0.0f);
        this._fkPanel.setAlignmentX(0.0f);
        this._fkPanel.addRow(this._yesFKPanel);
        this._fkPanel.addRow(this._noFKPanel);
        this._thisPanel.addRow(this._fkPanel);
        this._fkPanel.setVisible(false);
        this._ropaPanel = new TTJPanel(Messages.getString("CGCTableAttrPanel.propagationType"));
        this._ropaContainer = TTDialog.createRadioButtonGroup(new String[]{Messages.getString("TimesTen.common.readOnly"), Messages.getString("CGCTableAttrPanel.propagate"), Messages.getString("CGCTableAttrPanel.neither")}, 2, new ActionListener[]{new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CGCTableAttrPanel.this._model == null) {
                    return;
                }
                CGCTableAttrPanel.this._model.setROPA(0);
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CGCTableAttrPanel.this._model == null) {
                    return;
                }
                CGCTableAttrPanel.this._model.setROPA(1);
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CGCTableAttrPanel.this._model == null) {
                    return;
                }
                CGCTableAttrPanel.this._model.setROPA(2);
            }
        }});
        this._ropaPanel.addRow(this._ropaContainer);
        this._ropaType = new JTextField("");
        this._textValues.add(this._ropaType);
        this._thisPanel.addRow(this._ropaPanel);
        this._ropaPanel.setVisible(false);
        this._wherePanel = new TTJPanel(Messages.getString("CGCTableAttrPanel.whereClause"));
        this._where = new JTextArea(10, 20);
        this._textValues.add(this._where);
        this._where.addFocusListener(this);
        JComponent jComponent = new JScrollPane(this._where, 20, 30);
        this._wherePanel.addFull(jComponent);
        this.c.new_row();
        this.c.anchor = 15;
        this.c.weighty = 1.0;
        this.gridbag.setConstraints(this._wherePanel, this.c);
        this.add(this._wherePanel);
        this._wherePanel.setVisible(false);
        this._manualTablesMgmnPanel = new TTJPanel(Messages.getString("CGCTableAttrPanel.manualTableManagement"));
        this._PKButton = new JButton(Messages.getString("CGCTableAttrPanel.redefinePK"));
        this._PKButton.addActionListener(this);
        this._FKButton = new JButton(Messages.getString("CGCTableAttrPanel.redefineFK"));
        this._FKButton.addActionListener(this);
        jComponent = new JPanel();
        jComponent.setLayout(new BoxLayout(jComponent, 2));
        jComponent.add(this._PKButton);
        jComponent.add(this._FKButton);
        this._manualTablesMgmnPanel.addRow(jComponent);
        this._manualTablesMgmnPanel.setAlignmentX(0.0f);
        this._thisPanel.addRow(this._manualTablesMgmnPanel);
        this._manualTablesMgmnPanel.setVisible(false);
        this._tableStatusPanel = new TTJPanel(Messages.getString("CGCTableAttrPanel.tableStatus"));
        this._alreadyCachedInfo = new JLabel();
        this._tableStatusPanel.addRow(this._alreadyCachedInfo);
        this._tableStatusPanel.setAlignmentX(0.0f);
        this._thisPanel.addRow(this._tableStatusPanel);
        this._tableStatusPanel.setVisible(false);
        this._thisPanel.setAlignmentX(0.0f);
        this.addFull(this._thisPanel);
    }

    protected CGCFKDialog getFKDialog() {
        if (this._FKdialog == null) {
            Dialog dialog = DialogUtil.getAncestorDialog((Component)this);
            this._FKdialog = new CGCFKDialog(dialog, Messages.getString("CGCTableAttrPanel.defineFKS"));
        }
        if (this._FKdialog.init(this._model, this._model.getParentTable(), this._dbObject)) {
            return null;
        }
        return this._FKdialog;
    }

    private void showFKDialog() {
        Dialog dialog = DialogUtil.getAncestorDialog((Component)this);
        CGCFKDialog cGCFKDialog = this.getFKDialog();
        if (cGCFKDialog == null) {
            return;
        }
        cGCFKDialog.setLocationRelativeTo(dialog);
        cGCFKDialog.show();
        if (cGCFKDialog.isCancelled()) {
            return;
        }
        String[] stringArray = cGCFKDialog.getFKs();
        if (stringArray != null) {
            this._model.addFK(stringArray);
            this.updateFKPanel();
            this.updateProblems();
        }
    }

    protected CGCPKDialog getPKDialog() {
        this._PKdialog = null;
        if (this._PKdialog == null) {
            Dialog dialog = DialogUtil.getAncestorDialog((Component)this);
            this._PKdialog = new CGCPKDialog(this._model, dialog, Messages.getString("CGCTableAttrPanel.definePKS"));
        }
        if (this._PKdialog.init(this._model)) {
            return null;
        }
        return this._PKdialog;
    }

    private void showPKDialog() {
        Dialog dialog = DialogUtil.getAncestorDialog((Component)this);
        CGCPKDialog cGCPKDialog = this.getPKDialog();
        if (cGCPKDialog == null) {
            String[] stringArray = this._model.getPKStrings();
            String string = stringArray != null && stringArray.length != 0 ? Messages.getString("CGCTableAttrPanel.noUniqueColsOtherThanPK") : Messages.getString("CGCTableAttrPanel.noUniqueCols");
            MessageDialog.error((Component)this, (Object)string, (String)Messages.getString("TimesTen.common.error"), null);
            return;
        }
        cGCPKDialog.setLocationRelativeTo(dialog);
        cGCPKDialog.pack();
        cGCPKDialog.show();
        if (cGCPKDialog.isCancelled()) {
            return;
        }
        String[] stringArray = cGCPKDialog.getPKs();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this._model.addPK(stringArray);
            }
            String string = this._model.getPKString();
            this.updatePKPanel();
            this.updateProblems();
        }
    }

    @Override
    public void nodeSelected(CGCTableTreeNode cGCTableTreeNode) {
        CGCTableAttrPanel.LOUD("CGCTableAttrPanel CGCTreeNodeSelectionListener");
        if (cGCTableTreeNode == null) {
            this._pkPanel.setVisible(false);
            this._fkPanel.setVisible(false);
            this._tableStatusPanel.setVisible(false);
            this._manualTablesMgmnPanel.setVisible(false);
            this._wherePanel.setVisible(false);
            this._ropaPanel.setVisible(false);
            return;
        }
        CGCPanel cGCPanel = CGCPanel.theDialog;
        CGCTableColsTableModel cGCTableColsTableModel = cGCPanel.getTableModel(cGCTableTreeNode);
        if (this._model != null) {
            this.focusLost(null);
        }
        this._model = cGCTableColsTableModel;
        CGCTableAttrPanel.LOUD("update PK");
        this.updatePKPanel();
        CGCTableAttrPanel.LOUD("..done update PK");
        CGCTableAttrPanel.LOUD("update key index");
        boolean bl = cGCTableColsTableModel.getKeyIdxUseHash();
        this._hashType.setSelected(bl);
        JRadioButton jRadioButton = (JRadioButton)this._rangeHashGroup.getComponent(bl ? KEY_INDEX_TYPE.HASH.ordinal() : KEY_INDEX_TYPE.RANGE.ordinal());
        jRadioButton.setSelected(true);
        boolean bl2 = this._model.getKeyIdxPage();
        int n = this._model.getKeyIdxN();
        if (n >= 0) {
            this._n.setValue(n);
        } else {
            this._n.setText(null);
        }
        CGCTableAttrPanel.LOUD("..done update update key index");
        CGCTableAttrPanel.LOUD("update FK");
        this.updateFKPanel();
        CGCTableAttrPanel.LOUD("..done update FK");
        this._manualTablesMgmnPanel.setVisible(true);
        this._FKButton.setEnabled(!cGCTableTreeNode.isRootTable() || cGCTableColsTableModel.getParentTable() != null);
        this._PKButton.setEnabled(cGCTableTreeNode.isLeaf());
        this._tableStatusPanel.setVisible(true);
        this.fixupWhereBox();
        CGCTableAttrPanel.LOUD("update problems");
        this.updateProblems();
        CGCTableAttrPanel.LOUD("..done update problems");
        CGCTableAttrPanel.LOUD("..done CGCTableAttrPanel CGCTreeNodeSelectionListener");
    }

    void updatePKPanel() {
        boolean bl;
        this._pkPanel.setVisible(true);
        boolean bl2 = bl = this._model.getPKCols() != null;
        if (bl) {
            this._pkMenu.removeAllItems();
            String[] stringArray = this._model.getPKStrings();
            this._pkMenu.removeItemListener(this);
            for (int i = 0; i < stringArray.length; ++i) {
                this._pkMenu.addItem(stringArray[i]);
            }
            this._pkMenu.addItemListener(this);
            String string = this._model.getPKString();
            this._pkMenu.setSelectedItem(string);
            this._pkLabel.setText(string);
            boolean bl3 = stringArray.length > 1;
            this._pkMenu.setVisible(bl3);
            this._pkLabel.setVisible(!bl3);
        }
        this._yesPKPanel.setVisible(bl);
        this._noPKPanel.setVisible(!bl);
    }

    void updateFKPanel() {
        boolean bl;
        this._fkPanel.setVisible(true);
        boolean bl2 = bl = this._model.getFKCols() != null;
        if (bl) {
            this._fkMenu.removeAllItems();
            String[] stringArray = this._model.getFKStrings();
            this._fkMenu.removeItemListener(this);
            for (int i = 0; i < stringArray.length; ++i) {
                this._fkMenu.addItem(stringArray[i]);
            }
            this._fkMenu.addItemListener(this);
            String string = this._model.getFKString();
            this._fkMenu.setSelectedItem(string);
            this._fkLabel.setText(string);
            this._fkCheckBox.setSelected(this._model.getCascadeDelete());
            boolean bl3 = stringArray.length > 1;
            this._fkMenu.setVisible(bl3);
            this._fkLabel.setVisible(!bl3);
        }
        this._yesFKPanel.setVisible(bl);
        this._noFKPanel.setVisible(!bl);
    }

    void updateProblems() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        CGCTableTreeNode cGCTableTreeNode = this._model.getNode();
        if (cGCTableTreeNode.isInCG()) {
            string = CGCPanel.theDialog.getTablesCacheGroup(cGCTableTreeNode.getRealName());
            stringBuffer.append(String.format(Messages.getString("CGCTableAttrPanel.alreadyBelongToCG"), string));
        }
        if (this._model.getPKCols() == null) {
            stringBuffer.append(Messages.getString("CGCTableAttrPanel.noPK"));
        }
        string = "";
        if (stringBuffer.length() > 0) {
            stringBuffer.append(Messages.getString("CGCTableAttrPanel.asSuchIsNotCachable"));
            string = stringBuffer.toString();
        } else {
            string = cGCTableTreeNode.isNoParentTable() && !cGCTableTreeNode.isRootTable() ? Messages.getString("CGCTableAttrPanel.hasNoFK") : Messages.getString("CGCTableAttrPanel.noProblem");
        }
        this._alreadyCachedInfo.setText("<html>" + string + "<br><br><br>");
    }

    public void fixupWhereBox() {
        if (this._model == null) {
            return;
        }
        this._wherePanel.setVisible(true);
        CGCPanel cGCPanel = CGCPanel.theDialog;
        boolean bl = false;
        if (!cGCPanel.isAWT() && !cGCPanel.isSWT()) {
            CGCTableAttrPanel.LOUD("update WHERE box");
            this._where.setText(this._model.getWhere());
            bl = true;
            CGCTableAttrPanel.LOUD("..done update WHERE box");
        } else {
            this._where.setText("");
        }
        CGCTableTreeNode cGCTableTreeNode = this._model.getNode();
        if (cGCTableTreeNode.isNoParentTable()) {
            // empty if block
        }
        JTextField jTextField = new JTextField();
        jTextField.setEditable(bl);
        this._where.setEditable(bl);
        this._where.setBackground(jTextField.getBackground());
        if (cGCPanel.getCGType() == 6) {
            this._ropaPanel.setVisible(true);
            int n = this._model.getROPA();
            JRadioButton jRadioButton = (JRadioButton)this._ropaContainer.getComponent(n);
            jRadioButton.setSelected(true);
        } else {
            this._ropaPanel.setVisible(false);
        }
        this._ropaType.setText(this._ropaType.getText() + ".");
    }

    @Override
    public boolean validateValues() {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer(128);
        if (this._hashType.isSelected()) {
            int n = this._model.getKeyIdxN();
            String string = (String)this._pageRow.getSelectedItem();
            if (n < 0) {
                stringBuffer.append(String.format(Messages.getString("CGCTableAttrPanel.wrongNumPageRow"), string));
            }
        }
        if ((stringArray = this._model.getPKStrings()) == null || stringArray.length == 0) {
            stringBuffer.append(String.format(Messages.getString("CGCTableColsPanel.rootTableNoPK"), this._model.getTableName(), Messages.getString("TimesTen.common.tableAttribs")));
        }
        if (stringBuffer.length() > 0) {
            MessageDialog.error((Component)this, (Object)stringBuffer.toString(), (String)Messages.getString("TimesTen.common.error"), null);
            return false;
        }
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        Object object = itemEvent.getSource();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (this._model == null) {
            return;
        }
        if (object == this._fkCheckBox) {
            this._model.setCascadeDelete(bl);
        } else if (object == this._hashType) {
            this._hashSizingPolicy.setEnabled(bl);
            this._pageRow.setEnabled(bl);
            if (this._pageRow.getSelectedIndex() != HASH_TYPE.CURRENT.ordinal()) {
                this._n.setEnabled(bl);
            }
            this._model.setKeyIdxUseHash(bl);
        } else if (object == this._fkMenu && bl) {
            this._model.handleMenuChangeFK((String)itemEvent.getItem());
        } else if (object == this._pkMenu && bl) {
            this._model.handleMenuChangePK((String)itemEvent.getItem());
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        int n;
        Object object;
        if (focusEvent == null) {
            this._model.setWhere(this._where.getText().trim());
            try {
                this._n.commitEdit();
                int n2 = ((Number)this._n.getValue()).intValue();
                this._model.setKeyIdxN(n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (focusEvent.isTemporary()) {
            return;
        }
        try {
            object = this._n.getText();
            n = Integer.valueOf((String)object);
            if (n <= 0) {
                int n3 = this._model.getKeyIdxN();
                this._n.setText((String)(n3 > 0 ? "" + n3 : ""));
                return;
            }
            this._n.commitEdit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = focusEvent.getSource();
        if (object == this._where) {
            this._model.setWhere(this._where.getText().trim());
        }
        if (object == this._n) {
            try {
                n = ((Number)this._n.getValue()).intValue();
                this._model.setKeyIdxN(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this._model == null) {
            return;
        }
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand().toLowerCase();
        if (string.startsWith("combobox")) {
            ItemSelectable itemSelectable = (ItemSelectable)actionEvent.getSource();
            Object[] objectArray = itemSelectable.getSelectedObjects();
            if (objectArray.length == 0) {
                return;
            }
            this._n.setEnabled(true);
            if (objectArray[0] == this._page) {
                this._model.setKeyIdxPage(true);
            } else if (objectArray[0] == this._row) {
                this._model.setKeyIdxPage(false);
            } else if (objectArray[0] == this._current) {
                this._model.setKeyIdxPage(false);
                this._n.setEnabled(false);
                this._n.setText("");
            }
        } else if (object == this._FKButton) {
            this.showFKDialog();
        } else if (object == this._PKButton) {
            this.showPKDialog();
        }
        this._ropaType.setText(string);
    }

    static enum HASH_TYPE {
        CURRENT,
        ROW,
        PAGE;

    }

    static enum KEY_INDEX_TYPE {
        RANGE,
        HASH;

    }
}

