/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTextField;
import oracle.dbtools.raptor.timesten.AgingInfo;
import oracle.dbtools.raptor.timesten.CacheInfo;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.TTJPanel;
import oracle.dbtools.raptor.timesten.dialogs.sql.ISqlPromptPanel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.db.Database;

public abstract class DialogBase
extends TTJPanel
implements ISqlPromptPanel {
    static long lastTime = 0L;
    protected String _mode = null;
    public static final String CACHE = "cache";
    public static final String AGING = "aging";
    public static final String NONE = "none";
    protected boolean is_table;
    protected String THING;
    protected String ROOT;
    protected String _rootTableFullname;
    protected final Map<String, Object> _dict;
    protected final DBObject _dbObject;
    protected final Database _database;
    protected final String _conn;
    protected List<JComponent> _textValues;
    protected Hashtable<String, String> _model = null;
    protected String _arg = null;
    protected final Logger _logger;

    protected DialogBase(DBObject dBObject, String string, String string2) {
        this(dBObject, string, string2, NONE, null);
    }

    protected DialogBase(DBObject dBObject, String string, String string2, List<JComponent> list) {
        this(dBObject, string, string2, NONE, list);
    }

    public String getUserName() {
        return this._dict.get("OBJECT_OWNER").toString();
    }

    public String getObjectName() {
        return this._dict.get("OBJECT_NAME").toString();
    }

    protected DialogBase(DBObject dBObject, String string, String string2, String string3) {
        this(dBObject, string, string2, string3, null);
        if (string3 != null && string3 == AGING) {
            try {
                Hashtable<String, String> hashtable = CacheInfo.getCacheInfo(this._dbObject);
                String string4 = hashtable.get("ROOT SCHEMA NAME");
                String string5 = hashtable.get("ROOT TABLE NAME");
                if (string4 == null) {
                    string4 = dBObject.getSchemaName();
                }
                if (string5 == null) {
                    string5 = dBObject.getObjectName();
                }
                this._rootTableFullname = "\"" + string4 + "\".\"" + string5 + "\"";
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected DialogBase(DBObject dBObject, String string, String string2, String string3, List<JComponent> arrayList) {
        this._logger = Logger.getLogger(string2);
        this._dbObject = dBObject;
        this._dict = dBObject.getDictionary();
        this._conn = dBObject.getConnectionName();
        this._database = dBObject.getDatabase();
        this._arg = string;
        this._mode = string3;
        this._textValues = arrayList != null ? arrayList : new ArrayList();
        this.is_table = true;
        this.THING = Messages.getString("TimesTen.common.table");
        this.ROOT = "";
        if (string != null) {
            if (string.startsWith(CACHE)) {
                this.is_table = false;
                this.THING = Messages.getString("TimesTen.common.cacheGroup");
                this.ROOT = Messages.getString("TimesTen.common.root");
            } else if (string.startsWith(NONE)) {
                this.is_table = false;
                this.THING = "";
                this.ROOT = "";
            }
        }
        this.initModel(dBObject);
        this.otherInit(string);
        this._applicable = this.applicable(dBObject);
        if (this._applicable) {
            this.initHiddens();
            ProgressRunnable progressRunnable = new ProgressRunnable(){

                protected Object doWork() throws Exception {
                    DialogBase.this.initGUI();
                    return null;
                }
            };
            progressRunnable.setTitle(Messages.getString("TimesTen.common.pleaseWait"));
            progressRunnable.setCancelable(false);
            try {
                progressRunnable.start(true);
            }
            catch (ProgressException progressException) {
                // empty catch block
            }
        }
    }

    protected void initGUI() {
    }

    protected void otherInit(String string) {
    }

    public void idleInit() {
    }

    @Override
    public boolean applicable(DBObject dBObject) {
        return true;
    }

    protected void initHiddens() {
        if (this._mode.equalsIgnoreCase(AGING)) {
            String string = this._model.get("ROOT_TABLE");
            if (string == null) {
                string = this._dict.get("OBJECT_NAME").toString();
            }
            this._textValues.add(new JTextField(string));
        }
    }

    protected void initModel(DBObject dBObject) {
        try {
            if (this._mode.equalsIgnoreCase(AGING)) {
                this._model = AgingInfo.getAgingInfo(dBObject);
            } else if (this._mode.equalsIgnoreCase(CACHE)) {
                this._model = CacheInfo.getCacheInfo(dBObject);
            }
        }
        catch (Exception exception) {
            this._logger.log(Level.SEVERE, "Getting " + this._mode + " info failed");
            this._logger.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public static String getCaller() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        String string = stackTraceElementArray[2].toString();
        return string;
    }

    public static boolean isInt(JTextField jTextField) {
        boolean bl = true;
        String string = jTextField.getText();
        try {
            Integer.parseInt(string);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static void LOUD(String string) {
        Logger.getLogger("DialogBase").log(Level.INFO, string);
    }

    @Override
    public String getSql() {
        return "";
    }

    @Override
    public boolean validateValues() {
        return true;
    }

    @Override
    public Map<String, Object> getDictionary() {
        return this._dict;
    }

    @Override
    public List<JComponent> getTextValues() {
        return this._textValues;
    }

    @Override
    public List<String> getValues() {
        return new ArrayList<String>();
    }

    @Override
    public DBObject getDbObject() {
        return this._dbObject;
    }
}

