/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.rules.parser;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.raptor.migration.applications.rules.parser.Regex;
import oracle.dbtools.raptor.utils.XMLHelper;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class RuleSet {
    private ArrayList<Regex> m_expressions = new ArrayList();
    private String m_name;
    private String m_description;
    private String m_type;
    private String m_target;
    private boolean m_enable;
    private String m_source = "ANY";
    private String m_codeType;
    private boolean m_recognizer = false;
    private Regex m_required;

    public RuleSet(Node node) {
        this.setType(XMLHelper.getAttributeNode((Node)node, (String)"type"));
        this.setTarget(XMLHelper.getAttributeNode((Node)node, (String)"target"));
        this.setEnabled(XMLHelper.getAttributeNode((Node)node, (String)"enable"));
        this.setSource(XMLHelper.getAttributeNode((Node)node, (String)"source"));
        this.setName(XMLHelper.getAttributeNode((Node)node, (String)"name"));
        this.setCodeType(XMLHelper.getAttributeNode((Node)node, (String)"description"));
        this.setDescription(XMLHelper.getAttributeNode((Node)node, (String)"codetype"));
        if (XMLHelper.getChildNode((Node)node, (String)"required") == null) {
            System.err.println("Missing required xml element");
            throw new RuntimeException("No Required Regex in xml");
        }
        this.setRequiredExpression(new Regex(XMLHelper.getChildNode((Node)node, (String)"required").getFirstChild()));
        if (node.hasChildNodes()) {
            NodeList nodeList = XMLHelper.getChildNode((Node)node, (String)"rules").getChildNodes();
            Regex regex = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!nodeList.item(i).getNodeName().equals("regex")) continue;
                regex = new Regex(nodeList.item(i));
                this.addExpression(regex);
            }
        }
    }

    public final String getName() {
        return this.m_name;
    }

    public final void setName(String string) {
        this.m_name = string;
    }

    public final String getDescription() {
        return this.m_description;
    }

    public final void setDescription(String string) {
        this.m_description = string;
    }

    public final String getType() {
        return this.m_type;
    }

    public final void setType(String string) {
        this.m_type = string;
    }

    public final String getTarget() {
        return this.m_target;
    }

    public final void setTarget(String string) {
        this.m_target = string;
    }

    public final boolean isEnabled() {
        return this.m_enable;
    }

    public final void setEnabled(boolean bl) {
        this.m_enable = bl;
    }

    public final void setEnabled(String string) {
        this.m_enable = string.toLowerCase().trim().equals("true");
    }

    public final String getSource() {
        return this.m_source;
    }

    public final void setSource(String string) {
        this.m_source = string;
    }

    public final String getCodeType() {
        return this.m_codeType;
    }

    public final void setCodeType(String string) {
        this.m_codeType = string;
    }

    public final ArrayList<Regex> getExpressions() {
        return this.m_expressions;
    }

    public final void setExpressions(ArrayList<Regex> arrayList) {
        this.m_expressions = arrayList;
    }

    public final Regex getRequiredExpression() {
        return this.m_required;
    }

    public final void setRequiredExpression(Regex regex) {
        this.m_required = regex;
    }

    public final void addExpression(Regex regex) {
        this.m_expressions.add(regex);
    }

    public final ArrayList<Regex> getExpressions(boolean bl) {
        ArrayList<Regex> arrayList = new ArrayList<Regex>();
        for (Regex regex : this.getExpressions()) {
            if (bl && regex.isRecognizer()) {
                arrayList.add(regex);
            }
            if (bl || regex.isRecognizer()) continue;
            arrayList.add(regex);
        }
        return arrayList;
    }

    public void compileExpressions() {
        Iterator<Regex> iterator = this.getExpressions().iterator();
        while (iterator.hasNext()) {
            iterator.next().generatePattern();
        }
    }

    public void setRecognizer(String string) {
        this.m_recognizer = string != null && string.toLowerCase().trim().equals("true");
    }

    public final boolean isRecognizer() {
        return this.m_recognizer;
    }
}

