/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.cmdline;

import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.MigrationCmd;
import oracle.dbtools.migration.command_line.MigrationDetails;
import oracle.dbtools.raptor.migration.applications.addin.ProcessorException;
import oracle.dbtools.raptor.migration.applications.cmdline.ScannerDetails;
import oracle.dbtools.raptor.migration.applications.cmdline.UsageHelp;
import oracle.dbtools.raptor.migration.applications.report.ReportEngine;
import oracle.dbtools.raptor.migration.applications.report.ReportEngineFactory;
import oracle.dbtools.raptor.migration.applications.report.Summary;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessor;

public class ScannerCmd
extends MigrationCmd {
    private ScannerDetails m_scannerDetails;
    public static final String CMDNAME = "scan";

    public ScannerCmd() {
    }

    public ScannerCmd(MigrationDetails migrationDetails, CMDOut cMDOut, boolean bl) {
        super(CMDNAME, migrationDetails, cMDOut, bl);
        this.m_scannerDetails = ScannerDetails.getInstance();
        this.m_scannerDetails.setOptions(migrationDetails);
    }

    protected void executeImpl() {
        try {
            this.m_scannerDetails = ScannerDetails.getInstance();
            this.m_scannerDetails.setOptions(this.getMigrationDetails());
            if (this.m_scannerDetails.isValid()) {
                this.runScan();
            } else if (this.m_scannerDetails.isHelpSpecified()) {
                this.m_scannerDetails.help();
            } else {
                this.m_scannerDetails.usage(this.m_scannerDetails.getError_message());
            }
        }
        catch (ProcessorException processorException) {
            UsageHelp.usage(processorException.getMessage(), this.getCmdout());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void runScan() throws ProcessorException {
        FileProcessor fileProcessor = new FileProcessor(this.m_scannerDetails);
        ReportEngine reportEngine = ReportEngineFactory.getEngine(this.m_scannerDetails);
        fileProcessor.addListener(reportEngine);
        Summary summary = null;
        if (this.m_scannerDetails.isAnalysisRequired()) {
            summary = new Summary();
            fileProcessor.addListener(summary);
        }
        fileProcessor.process();
        reportEngine.generateReport(summary);
        fileProcessor.removeListener(reportEngine);
        fileProcessor.removeListener(summary);
    }

    private ScannerDetails getScannerDetails() {
        return this.m_scannerDetails;
    }
}

