/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.svg.batik;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import oracle.dss.presutil.XMLWriter;
import oracle.dss.util.renderers.MDOXMLRenderer;
import oracle.dss.util.shapes.CommonRenderer;
import oracle.dss.util.shapes.DrawableObject;
import oracle.dss.util.shapes.Graphics2DRenderer;
import oracle.dss.util.svg.batik.DVTGraphics2D;
import oracle.dss.util.svg.batik.ext.bridge.DVTBridgeContext;
import oracle.javatools.annotations.Concealed;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.w3c.dom.Document;

public class DVTTranscoder
extends SVGAbstractTranscoder {
    DVTGraphics2D _graphics;
    Class _rendererClass;

    public DVTTranscoder() {
        this(Graphics2DRenderer.class);
    }

    public DVTTranscoder(Class renderer_) {
        this._rendererClass = renderer_;
        this._graphics = new DVTGraphics2D();
    }

    public void transcode(TranscoderInput transcoderInput) throws TranscoderException {
        super.transcode(transcoderInput, null);
    }

    public void transcode(TranscoderInput transcoderInput, TranscoderOutput transcoderOutput) throws TranscoderException {
        this.transcode(transcoderInput);
        this.render(transcoderOutput);
    }

    public Rectangle2D getFullBounds() {
        Rectangle rect = new Rectangle(0, 0, (int)this.ctx.getDocumentSize().getWidth(), (int)this.ctx.getDocumentSize().getHeight());
        return rect;
    }

    public List<DrawableObject> getDrawables() {
        return this._graphics.getDrawables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Concealed
    public void render(TranscoderOutput output) {
        if (this._rendererClass == Graphics2DRenderer.class) {
            BufferedImage image = new BufferedImage((int)this.ctx.getDocumentSize().getWidth(), (int)this.ctx.getDocumentSize().getHeight(), 2);
            Graphics2DRenderer _renderer = new Graphics2DRenderer((Graphics2D)image.getGraphics(), null);
            this.renderAll(_renderer);
            try {
                ImageIO.write((RenderedImage)image, "PNG", output.getOutputStream());
                output.getOutputStream().flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    output.getOutputStream().close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (this._rendererClass == MDOXMLRenderer.class) {
            ByteArrayOutputStream sw = new ByteArrayOutputStream();
            XMLWriter xw = new XMLWriter(sw, null);
            MDOXMLRenderer _renderer = new MDOXMLRenderer(xw);
            this.renderAll(_renderer);
            try {
                xw.flush();
                output.getOutputStream().write(sw.toByteArray());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    output.getOutputStream().close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void renderAll(CommonRenderer renderer) {
        List<DrawableObject> list = this.getDrawables();
        for (DrawableObject draw : list) {
            renderer.drawShape(draw);
        }
    }

    protected void transcode(Document document, String uri, TranscoderOutput output) throws TranscoderException {
        super.transcode(document, uri, output);
        this.root.paint((Graphics2D)((Object)this._graphics));
    }

    protected BridgeContext createBridgeContext() {
        return this.createBridgeContext("1.x");
    }

    public BridgeContext createBridgeContext(String version) {
        return new DVTBridgeContext(this.userAgent);
    }
}

