/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.svg.batik;

import java.awt.Color;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import oracle.dss.presutil.GradientObj;
import oracle.dss.util.shapes.DrawableObject;
import oracle.dss.util.shapes.Fill;
import oracle.dss.util.shapes.FillColor;
import oracle.dss.util.shapes.FillGradient;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.ext.awt.RadialGradientPaint;

public class DVTGraphics2DUtils {
    public static Fill handleFill(Paint paint, DrawableObject obj) {
        Fill fill = DVTGraphics2DUtils.convertFill(paint, obj);
        if (fill != null) {
            return fill;
        }
        Color color = new Color(255, 255, 255, 0);
        FillColor fc = new FillColor(color);
        return fc;
    }

    private static Fill convertFill(Paint paint, DrawableObject obj) {
        if (paint == null) {
            return null;
        }
        if (paint instanceof Color) {
            return new FillColor((Color)paint);
        }
        if (paint instanceof MultipleGradientPaint) {
            MultipleGradientPaint gradient = (MultipleGradientPaint)paint;
            FillGradient fillGrad = DVTGraphics2DUtils.convertGradient(gradient, obj);
            return fillGrad;
        }
        System.out.println("Paint not handled: " + paint.toString());
        return null;
    }

    private static FillGradient convertGradient(MultipleGradientPaint gradient, DrawableObject obj) {
        if (gradient == null) {
            return null;
        }
        GradientObj gradObj = null;
        if (gradient instanceof LinearGradientPaint) {
            LinearGradientPaint linear = (LinearGradientPaint)gradient;
            Point2D start = linear.getStartPoint();
            Point2D end = linear.getEndPoint();
            gradObj = new GradientObj();
            gradObj.setDirectionConstant(20);
            gradObj.setStartPoint(start);
            gradObj.setEndPoint(end);
        } else if (gradient instanceof RadialGradientPaint) {
            RadialGradientPaint radial = (RadialGradientPaint)gradient;
            gradObj = new GradientObj();
            gradObj.setDirectionConstant(9);
            Point2D center = radial.getCenterPoint();
            Point2D focus = radial.getFocusPoint();
            double radius = radial.getRadius();
            gradObj.setCenter(center);
            gradObj.setRadius(radius);
            gradObj.setFocus(focus);
        }
        if (gradObj != null) {
            float[] fractions;
            Color[] colors = gradient.getColors();
            if (colors.length == (fractions = gradient.getFractions()).length) {
                for (int i = 0; i < colors.length; ++i) {
                    gradObj.insertPin(fractions[i], colors[i]);
                }
            }
            if (gradient.getCycleMethod() == MultipleGradientPaint.NO_CYCLE) {
                gradObj.setCycleMethod(MultipleGradientPaint.CycleMethod.NO_CYCLE);
            } else if (gradient.getCycleMethod() == MultipleGradientPaint.REFLECT) {
                gradObj.setCycleMethod(MultipleGradientPaint.CycleMethod.REFLECT);
            } else if (gradient.getCycleMethod() == MultipleGradientPaint.REPEAT) {
                gradObj.setCycleMethod(MultipleGradientPaint.CycleMethod.REPEAT);
            }
            AffineTransform at = gradient.getTransform();
            at.preConcatenate(obj.getTransform());
            gradObj.setTransform(at);
        }
        return new FillGradient(gradObj);
    }
}

