/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.svg.batik;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import oracle.dss.util.shapes.DrawableObject;
import oracle.dss.util.shapes.Fill;
import oracle.dss.util.shapes.FillColor;
import oracle.dss.util.shapes.Label;
import oracle.dss.util.shapes.Path;
import oracle.dss.util.shapes.Stroke;
import oracle.dss.util.svg.batik.DVTGraphics2DUtils;
import org.apache.batik.ext.awt.g2d.AbstractGraphics2D;
import org.apache.batik.ext.awt.g2d.GraphicContext;

public class DVTGraphics2D
extends AbstractGraphics2D {
    protected List<DrawableObject> drawables;

    public DVTGraphics2D() {
        super(false);
        this.gc = new GraphicContext();
        this.drawables = new ArrayList<DrawableObject>();
    }

    public DVTGraphics2D(DVTGraphics2D graphics) {
        super((AbstractGraphics2D)graphics);
        this.gc = (GraphicContext)graphics.gc.clone();
        this.drawables = graphics.drawables;
    }

    private DrawableObject _getDrawable(Shape s, AffineTransform t) {
        DrawableObject obj = new Path();
        obj.setShape(s);
        obj.setTransform(t);
        int idx = this.drawables.indexOf(obj);
        if (idx >= 0) {
            obj = this.drawables.get(idx);
        } else {
            this.drawables.add(obj);
        }
        return obj;
    }

    public List<DrawableObject> getDrawables() {
        return this.drawables;
    }

    public void draw(Shape s) {
        DrawableObject obj = this._getDrawable(s, this.gc.getTransform());
        Stroke stroke = new Stroke(this.gc.getStroke());
        if (this.gc.getPaint() instanceof Color) {
            stroke.setColor((Color)this.gc.getPaint());
        } else {
            stroke.setColor(Color.BLACK);
        }
        obj.setStroke(stroke);
        obj.setTransform(this.gc.getTransform());
        obj.setClipPath(this.gc.getClip());
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        System.out.println("RIMAGE1");
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        System.out.println("RIMAGE2");
    }

    public void drawString(String str, float x, float y) {
        Label label = new Label(str, x, y, 0.0, 0.0, this.gc.getFont(), this.gc.getColor());
        label.setTransform(this.gc.getTransform());
        this.drawables.add(label);
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        System.out.println("TEXT2");
    }

    public void fill(Shape s) {
        Color color;
        DrawableObject obj = this._getDrawable(s, this.gc.getTransform());
        obj.setTransform(this.gc.getTransform());
        obj.setClipPath(this.gc.getClip());
        Fill fill = DVTGraphics2DUtils.handleFill(this.gc.getPaint(), obj);
        Composite composite = this.gc.getComposite();
        if (composite instanceof AlphaComposite && fill instanceof FillColor && (color = ((FillColor)fill).getColor()).getAlpha() == 255) {
            AlphaComposite alpha = (AlphaComposite)composite;
            fill = new FillColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(alpha.getAlpha() * 255.0f)));
        }
        obj.setFill(fill);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    public Graphics create() {
        return new DVTGraphics2D(this);
    }

    public void setXORMode(Color c1) {
    }

    public FontMetrics getFontMetrics(Font f) {
        return null;
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        System.out.println("IMAGE1");
        return false;
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        System.out.println("IMAGE2");
        return false;
    }

    public void dispose() {
    }
}

