/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.shapes;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import oracle.dss.util.shapes.Fill;
import oracle.dss.util.shapes.Filter;
import oracle.dss.util.shapes.Stroke;

public abstract class DrawableObject {
    protected Shape m_shape;
    protected AffineTransform m_transform;
    protected Fill m_fill;
    protected Stroke m_stroke;
    protected Filter m_filter;
    protected Map m_properties;
    protected String m_id;
    protected Shape m_clipPath;

    public DrawableObject(Shape shape) {
        this.m_shape = shape;
        this.m_transform = null;
        this.m_fill = null;
        this.m_stroke = null;
        this.m_filter = null;
        this.m_clipPath = null;
        this.m_properties = new HashMap();
    }

    public DrawableObject(Shape shape, HashMap map) {
        this.m_shape = shape;
        this.m_transform = null;
        this.m_fill = null;
        this.m_stroke = null;
        this.m_filter = null;
        this.m_properties = map;
    }

    public boolean contains(double x, double y) {
        return this.m_shape.contains(x, y);
    }

    public Rectangle2D getBounds() {
        return this.m_shape.getBounds2D();
    }

    public Point2D getCenter() {
        Rectangle2D bounds = this.getBounds();
        double x = bounds.getX() + bounds.getWidth() / 2.0;
        double y = bounds.getY() + bounds.getHeight() / 2.0;
        return new Point2D.Double(x, y);
    }

    public Shape getShape() {
        return this.m_shape;
    }

    public void setTransform(AffineTransform at) {
        this.m_transform = at;
    }

    public AffineTransform getTransform() {
        return this.m_transform;
    }

    public Map getProperties() {
        return this.m_properties;
    }

    public void setProperty(Object key, Object value) {
        this.m_properties.put(key, value);
    }

    public Object getProperty(Object key) {
        return this.m_properties.get(key);
    }

    public boolean hasFill() {
        return this.m_fill != null;
    }

    public boolean hasStroke() {
        return this.m_stroke != null;
    }

    public boolean hasFilter() {
        return this.m_filter != null;
    }

    public Fill getFill() {
        return this.m_fill;
    }

    public Stroke getStroke() {
        return this.m_stroke;
    }

    public Filter getFilter() {
        return this.m_filter;
    }

    public String getID() {
        return this.m_id;
    }

    public Shape getClipPath() {
        return this.m_clipPath;
    }

    public void setFill(Fill fill) {
        this.m_fill = fill;
    }

    public void setStroke(Stroke stroke) {
        this.m_stroke = stroke;
    }

    public void setFilter(Filter filter) {
        this.m_filter = filter;
    }

    public void setShape(Shape shape) {
        this.m_shape = shape;
    }

    public void setID(String id) {
        this.m_id = id;
    }

    public void setClipPath(Shape path) {
        this.m_clipPath = path;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DrawableObject)) {
            return false;
        }
        DrawableObject dObj = (DrawableObject)obj;
        if (dObj.getShape() != this.m_shape) {
            return false;
        }
        if (dObj.getTransform() != null) {
            if (this.m_transform != null) {
                return dObj.getTransform().equals(this.m_transform);
            }
            return false;
        }
        return this.m_transform == null;
    }
}

