/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.renderers;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import oracle.dss.presutil.XMLWriter;
import oracle.dss.util.renderers.MDOXMLRenderer;
import oracle.dss.util.shapes.Fill;
import oracle.dss.util.shapes.FillColor;
import oracle.dss.util.shapes.Label;
import oracle.dss.util.shapes.Stroke;

public class SVGRenderer
extends MDOXMLRenderer {
    protected String ATTRIB_STROKE = "stroke";

    public SVGRenderer(XMLWriter writer) {
        super(writer);
        this.ELEM_PATH = "path";
        this.ATTRIB_FILL = "fill";
    }

    @Override
    public void renderFill(Fill fill, Shape shape) {
        if (fill == null) {
            fill = new FillColor(Color.WHITE);
        }
        this.handleFill(fill, (Object)shape);
    }

    public void renderStroke(Stroke stroke) {
        if (stroke == null) {
            try {
                this.m_writer.writeAttribute("stroke", "#000000");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void handleDrawable(Label label) throws Exception {
        AffineTransform at = label.getTransform();
        if (at != null) {
            label.setShape(at.createTransformedShape(label.getShape()).getBounds());
        }
        this.m_writer.startElement("text");
        this.m_writer.writeAttribute("x", label.getX());
        this.m_writer.writeAttribute("y", label.getY());
        this.m_writer.writeText(label.toString());
        this.m_writer.endElement();
    }

    @Override
    public void handleFill(FillColor fill, Shape shape) throws Exception {
        this.m_writer.writeAttribute(this.ATTRIB_FILL, XMLWriter.colorToHexWithAlpha(fill.getColor()));
    }
}

