/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.legend.impl;

import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import oracle.dss.legend.LabelPosition;
import oracle.dss.legend.LegendItem;
import oracle.dss.legend.impl.LegendMarker;
import oracle.dss.legend.impl.LegendText;
import oracle.dss.util.shapes.DrawableObject;
import oracle.dss.util.shapes.Fill;

public class ListLegendItem
extends LegendItem {
    protected LabelPosition m_labelPosition = LabelPosition.END;
    protected LegendText m_label;
    protected LegendItem m_marker;
    protected int m_markerSize = 10;
    protected int m_minGap = 3;

    public ListLegendItem(LegendMarker marker, LegendText label) {
        this.m_marker = marker;
        this.m_label = label;
    }

    public ListLegendItem(LegendMarker.MarkerShape shape, Fill fill, String label) {
        this.m_marker = new LegendMarker(shape);
        this.m_marker.setFill(fill);
        this.setLabel(label);
    }

    public ListLegendItem(Shape path, Fill fill, String label) {
        this.m_marker = new LegendMarker(path);
        this.m_marker.setFill(fill);
        this.setLabel(label);
    }

    public ListLegendItem(String imageUrl, String label) {
        this.m_marker = new LegendMarker(imageUrl);
        this.setLabel(label);
    }

    @Override
    public void calc() {
        if (this.m_marker == null && this.m_label == null) {
            return;
        }
        this.m_marker.setWidth(this.m_markerSize);
        this.m_marker.setHeight(this.m_markerSize);
        this.m_label.setWidth(this.m_width - this.m_markerSize - 2 * this.m_minGap);
        this.m_marker.calc();
        this.m_label.calc();
        this.m_width = Math.min(this.m_marker.getWidth() + 2 * this.m_minGap + this.m_label.getWidth(), this.m_width);
        this.m_height = Math.max(this.m_marker.getHeight(), this.m_label.getHeight());
    }

    @Override
    public void calcFinal() {
        if (this.m_marker == null && this.m_label == null) {
            return;
        }
        this.m_label.setHeight(this.m_height);
        this.m_label.calcFinal();
        this.m_height = Math.max(this.m_marker.getHeight(), this.m_label.getHeight());
    }

    @Override
    public List<DrawableObject> render() {
        LegendItem top = null;
        LegendItem bottom = null;
        LegendItem left = null;
        LegendItem right = null;
        LabelPosition labelPosition = this.getLabelPosition();
        if (labelPosition == LabelPosition.TOP) {
            top = this.m_label;
            bottom = this.m_marker;
        } else if (labelPosition == LabelPosition.BOTTOM) {
            top = this.m_marker;
            bottom = this.m_label;
        } else if (labelPosition == LabelPosition.LEFT) {
            left = this.m_label;
            right = this.m_marker;
        } else {
            left = this.m_marker;
            right = this.m_label;
        }
        if (top != null && bottom != null) {
            top.setPosition(this.m_x, this.m_y);
            bottom.setPosition(this.m_x, this.m_y + top.getHeight() + this.m_minGap);
        } else if (left != null && right != null) {
            left.setPosition(this.m_x + this.m_minGap, this.m_y);
            right.setPosition(this.m_x + left.getWidth() + 2 * this.m_minGap, this.m_y);
        }
        if (this.m_marker.getHeight() < this.m_height) {
            int markerY = this.m_marker.getY() - this.m_marker.getHeight() / 2 + this.m_height / 2;
            this.m_marker.setPosition(this.m_marker.getX(), markerY);
        }
        if (this.m_label.getHeight() < this.m_height) {
            int labelY = this.m_label.getY() - this.m_label.getHeight() / 2 + this.m_height / 2;
            this.m_label.setPosition(this.m_label.getX(), labelY);
        }
        ArrayList<DrawableObject> listItem = new ArrayList<DrawableObject>();
        if (this.m_marker != null) {
            listItem.addAll(this.m_marker.render());
        }
        if (this.m_label != null) {
            listItem.addAll(this.m_label.render());
        }
        return listItem;
    }

    public void setLabel(String label) {
        this.m_label = new LegendText(label == null ? "" : label);
    }

    public void setLabelPosition(LabelPosition labelPosition) {
        this.m_labelPosition = labelPosition;
    }

    public LabelPosition getLabelPosition() {
        LabelPosition labelPosition = this.m_labelPosition;
        if (this.m_labelPosition == LabelPosition.START) {
            labelPosition = this.isBiDiLocale() ? LabelPosition.RIGHT : LabelPosition.LEFT;
        } else if (this.m_labelPosition == LabelPosition.END) {
            labelPosition = this.isBiDiLocale() ? LabelPosition.LEFT : LabelPosition.RIGHT;
        }
        return labelPosition;
    }
}

