/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.png;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import oracle.dss.graph.pfj.png.PNGChunk;
import oracle.dss.graph.pfj.png.PNGInfo;

class PNGTimeChunk
extends PNGChunk {
    PNGTimeChunk() {
    }

    @Override
    int getDataLength() {
        return 7;
    }

    @Override
    String getChunkType() {
        return "tIME";
    }

    @Override
    byte[] getData() {
        PNGInfo info = this.getPNGInfo();
        Date date = info.getCreationDate();
        if (date == null) {
            return new byte[0];
        }
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        Calendar calendar = null;
        calendar = Locale.getDefault().getLanguage().compareTo("th") == 0 && Locale.getDefault().getCountry().compareTo("TH") == 0 ? new GregorianCalendar(gmt) : Calendar.getInstance(gmt);
        calendar.setTime(date);
        byte[] data = new byte[7];
        short year = (short)calendar.get(1);
        data[0] = (byte)(year >> 8);
        data[1] = (byte)year;
        data[2] = (byte)(calendar.get(2) + 1);
        data[3] = (byte)calendar.get(5);
        data[4] = (byte)calendar.get(11);
        data[5] = (byte)calendar.get(12);
        data[6] = (byte)calendar.get(13);
        return data;
    }

    @Override
    boolean isCriticalChunk() {
        return false;
    }
}

