/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.png;

import oracle.dss.graph.pfj.png.PNGChunk;
import oracle.dss.graph.pfj.png.PNGInfo;

class PNGHeaderChunk
extends PNGChunk {
    PNGHeaderChunk() {
    }

    @Override
    int getDataLength() {
        return 13;
    }

    @Override
    String getChunkType() {
        return "IHDR";
    }

    @Override
    byte[] getData() {
        byte[] headerData = new byte[13];
        PNGInfo info = this.getPNGInfo();
        byte[] imgWidth = this.toByteArray(info.getImageWidth());
        byte[] imgHeight = this.toByteArray(info.getImageHeight());
        System.arraycopy(imgWidth, 0, headerData, 0, 4);
        System.arraycopy(imgHeight, 0, headerData, 4, 4);
        headerData[8] = info.getBitsPerPixel();
        headerData[9] = info.getColorType();
        headerData[10] = info.getCompressionType();
        headerData[11] = info.getFilterType();
        headerData[12] = info.getInterlaceType();
        return headerData;
    }

    @Override
    boolean isCriticalChunk() {
        return true;
    }
}

