/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.png;

import java.awt.Image;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import oracle.dss.graph.pfj.png.PNGChunk;
import oracle.dss.graph.pfj.png.PNGDataChunk;
import oracle.dss.graph.pfj.png.PNGEndChunk;
import oracle.dss.graph.pfj.png.PNGException;
import oracle.dss.graph.pfj.png.PNGHeaderChunk;
import oracle.dss.graph.pfj.png.PNGInfo;
import oracle.dss.graph.pfj.png.PNGInvalidParameterException;
import oracle.dss.graph.pfj.png.PNGTextChunk;
import oracle.dss.graph.pfj.png.PNGTimeChunk;
import oracle.javatools.mt.annotation.CodeSharingSafe;

public class PNGEncoder {
    @CodeSharingSafe(value="StaticField")
    private static final byte[] pngFileSignature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    @CodeSharingSafe(value="StaticField")
    private static Class[] pngChunkTypes = new Class[]{PNGHeaderChunk.class, PNGTimeChunk.class, PNGTextChunk.class, PNGDataChunk.class, PNGEndChunk.class};
    private Image pngImage;
    private String imageText;
    private PNGInfo pngInfo;
    private OutputStream pngStream;
    private PrintStream warningStream;
    private boolean isFile = false;

    public PNGEncoder(Image img, File file) throws PNGInvalidParameterException {
        this(img, file, null);
    }

    public PNGEncoder(Image img, OutputStream stream) throws PNGInvalidParameterException {
        this(img, stream, null);
    }

    public PNGEncoder(Image img, File file, PrintStream warning) throws PNGInvalidParameterException {
        if (img == null) {
            throw new PNGInvalidParameterException(this, 0, "PNGEncoder(Image, File, PrintStream)", "null Image parameter");
        }
        if (file == null) {
            throw new PNGInvalidParameterException(this, 0, "PNGEncoder(Image, File, PrintStream)", "null File parameter");
        }
        this.warningStream = warning;
        this.pngImage = img;
        try {
            this.pngStream = new FileOutputStream(file);
        }
        catch (IOException err) {
            throw new PNGInvalidParameterException(this, 2, "PNGEncoder(Image, File, PrintStream)", "Invalid File parameter", err);
        }
        this.isFile = true;
    }

    public PNGEncoder(Image img, OutputStream stream, PrintStream warning) throws PNGInvalidParameterException {
        if (img == null) {
            throw new PNGInvalidParameterException(this, 0, "PNGEncoder(Image, OutputStream, PrintStream)", "null Image parameter");
        }
        if (stream == null) {
            throw new PNGInvalidParameterException(this, 0, "PNGEncoder(Image, OutputStream, PrintStream)", "null OutputStream parameter");
        }
        this.pngImage = img;
        this.pngStream = stream;
        this.warningStream = warning;
    }

    private PNGEncoder() {
    }

    public void setImageText(String text) {
        this.imageText = text;
    }

    public void setPNGChunkTypes(Class[] chunkTypes) throws PNGInvalidParameterException {
        if (chunkTypes == null) {
            throw new PNGInvalidParameterException(this, 0, "setPNGChunkTypes(Class[])", "null parameter");
        }
        int len = chunkTypes.length;
        if (len == 0) {
            throw new PNGInvalidParameterException(this, 1, "setPNGChunkTypes(Class[])", "array length == 0");
        }
        for (int i = 0; i < len; ++i) {
            if (chunkTypes[i] == null) {
                throw new PNGInvalidParameterException(this, 1, "setPNGChunkTypes(Class[])", "index " + i + " in array is null");
            }
            if (PNGChunk.class.isAssignableFrom(chunkTypes[i])) continue;
            throw new PNGInvalidParameterException(this, 1, "setPNGChunkTypes(Class[])", "index " + i + " in array is  of type " + chunkTypes[i].getName() + "; must derive from PNGChunk");
        }
        pngChunkTypes = chunkTypes;
    }

    public final void encode() throws PNGException {
        this.encode((byte)6);
    }

    public final void encode(byte imageType) throws PNGException {
        int width = this.pngImage.getWidth(null);
        int height = this.pngImage.getHeight(null);
        if (width == 0 || height == 0) {
            throw new PNGException(this, 3, "encode()", "image width == 0 || image height == 0");
        }
        this.pngInfo = new PNGInfo(this.pngImage, width, height, this.imageText, new Date(), 8, imageType, 0, 0, 0);
        try {
            this.pngStream.write(pngFileSignature);
        }
        catch (IOException err) {
            throw new PNGException(this, 5, "encode()", "unable to write PNG file signature", err);
        }
        int len = pngChunkTypes.length;
        DataOutputStream dataStream = new DataOutputStream(this.pngStream);
        for (int i = 0; i < len; ++i) {
            PNGChunk chunk = null;
            try {
                chunk = (PNGChunk)pngChunkTypes[i].newInstance();
            }
            catch (InstantiationException err) {
                throw new PNGException(this, 4, "encode()", "error instantiating PNGChunk", err);
            }
            catch (IllegalAccessException err) {
                throw new PNGException(this, 4, "encode()", "error instantiating PNGChunk", err);
            }
            try {
                chunk.setPNGInfo(this.pngInfo);
            }
            catch (PNGInvalidParameterException err) {
                // empty catch block
            }
            try {
                chunk.write(dataStream);
                continue;
            }
            catch (PNGException err) {
                if (chunk.isCriticalChunk()) {
                    throw err;
                }
                if (err.getNestedException() instanceof IOException) {
                    throw err;
                }
                this.log("Error writing ancillary chunk; skipping chunk: " + chunk.getClass().getName() + "; Exception detail: " + err.getMessage());
                continue;
            }
            catch (Exception err) {
                throw new PNGException(this, 7, "encode()", "unknown Exception thrown when writing chunk", err);
            }
        }
        try {
            dataStream.flush();
        }
        catch (IOException err) {
            this.log("Unable to flush() the .png stream; Exception detail: " + err.toString());
        }
        if (this.isFile) {
            try {
                this.pngStream.close();
            }
            catch (IOException err) {
                this.log("Unable to close() the .png file output stream; Exception detail: " + err.toString());
            }
        }
    }

    private void log(String logStr) {
        if (this.warningStream != null) {
            if (logStr == null) {
                logStr = "null";
            }
            this.warningStream.println(this.getClass().getName() + ": Warning: " + logStr);
        }
    }
}

