/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;

public class RotateImageFilter
extends ImageFilter {
    private int m_nAngle;
    private int m_nWidth;
    private int m_nHeight;

    public RotateImageFilter(Color maskColor) {
        this(0);
    }

    public RotateImageFilter(int nAngle) {
        this.m_nAngle = nAngle == 90 || nAngle == 270 ? nAngle : 0;
    }

    @Override
    public void setDimensions(int width, int height) {
        this.m_nWidth = width;
        this.m_nHeight = height;
        if (this.m_nAngle == 90 || this.m_nAngle == 270) {
            this.consumer.setDimensions(height, width);
        } else {
            this.consumer.setDimensions(width, height);
        }
    }

    @Override
    public void setHints(int hints) {
        this.consumer.setHints(hints & 0xFFFFFFF9);
    }

    @Override
    public void setPixels(int x, int y, int width, int height, ColorModel model, int[] pixels, int offset, int scansize) {
        int[] m_Pixels = new int[this.m_nWidth * this.m_nHeight];
        switch (this.m_nAngle) {
            default: {
                this.consumer.setPixels(y, x, height, width, model, pixels, 0, height);
                break;
            }
            case 90: {
                for (int ry = 1; ry <= height; ++ry) {
                    for (int rx = 1; rx <= width; ++rx) {
                        int nOldIdx = ry * scansize - rx + offset;
                        int nNewIdx = (rx - 1) * height - 1 + ry;
                        m_Pixels[nNewIdx] = pixels[nOldIdx];
                    }
                }
                this.consumer.setPixels(y, x, height, width, model, m_Pixels, 0, height);
                break;
            }
            case 270: {
                for (int ry = 1; ry <= height; ++ry) {
                    for (int rx = 1; rx <= width; ++rx) {
                        int nOldIdx = ry * scansize - rx + offset;
                        int nNewIdx = scansize - rx;
                        m_Pixels[nNewIdx] = pixels[nOldIdx];
                    }
                }
                int nNewY = this.m_nHeight - y - 1;
                this.consumer.setPixels(nNewY, x, height, width, model, m_Pixels, 0, height);
            }
        }
    }

    @Override
    public void setPixels(int x, int y, int width, int height, ColorModel model, byte[] pixels, int offset, int scansize) {
        byte[] m_xPixels = new byte[this.m_nWidth * this.m_nHeight];
        switch (this.m_nAngle) {
            default: {
                this.consumer.setPixels(y, x, height, width, model, pixels, 0, height);
                break;
            }
            case 90: {
                for (int ry = 1; ry <= height; ++ry) {
                    for (int rx = 1; rx <= width; ++rx) {
                        int nOldIdx = ry * scansize - rx + offset;
                        int nNewIdx = (rx - 1) * height - 1 + ry;
                        m_xPixels[nNewIdx] = pixels[nOldIdx];
                    }
                }
                this.consumer.setPixels(y, x, height, width, model, m_xPixels, 0, height);
                break;
            }
            case 270: {
                for (int ry = 1; ry <= height; ++ry) {
                    for (int rx = 1; rx <= width; ++rx) {
                        int nOldIdx = ry * scansize - rx + offset;
                        int nNewIdx = scansize - rx;
                        m_xPixels[nNewIdx] = pixels[nOldIdx];
                    }
                }
                int nNewY = this.m_nHeight - y - 1;
                this.consumer.setPixels(nNewY, x, height, width, model, m_xPixels, 0, height);
            }
        }
    }
}

