/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterGraphics;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.draw.FillObj;
import oracle.dss.graph.pfj.draw.FillSfxObj;

public class FillTextureObj
extends FillSfxObj {
    private static final long serialVersionUID = 1L;
    public static final int DISPLAY_TILE = 0;
    public static final int DISPLAY_STRETCH = 1;
    public static final int FLIP_NORMAL = 0;
    public static final int FLIP_VERTICAL = 1;
    public static final int FLIP_HORIZONTAL = 2;
    public static final int FLIP_BOTH = 3;
    public static final int ROTATION_NONE = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    private int m_nTilingMode;
    private int m_nFlippingMode;
    private int m_nRotation;
    private Perspective m_Perspective;
    private transient Image m_Texture;

    public FillTextureObj() {
        this.m_nTilingMode = 0;
        this.m_nFlippingMode = 0;
        this.m_nRotation = 0;
        this.m_Texture = null;
    }

    public FillTextureObj(Perspective p, Image texture, int nTilingMode, int nFlippingMode, int nRotation) {
        this.m_nTilingMode = nTilingMode;
        this.m_nFlippingMode = nFlippingMode;
        this.m_nRotation = nRotation;
        this.m_Texture = texture;
        this.m_Perspective = p;
    }

    @Override
    public void copy(FillObj fo) {
        this.m_nTilingMode = ((FillTextureObj)fo).m_nTilingMode;
        this.m_nFlippingMode = ((FillTextureObj)fo).m_nFlippingMode;
        this.m_nRotation = ((FillTextureObj)fo).m_nRotation;
        this.m_Texture = ((FillTextureObj)fo).m_Texture;
    }

    public boolean equals(Object obj) {
        boolean bEqual;
        if (obj instanceof FillTextureObj) {
            FillTextureObj fto = (FillTextureObj)obj;
            boolean bl = bEqual = this.m_nTilingMode == fto.m_nTilingMode && this.m_nFlippingMode == fto.m_nFlippingMode && this.m_nRotation == fto.m_nRotation;
            if (bEqual) {
                if (this.m_Texture == null != (fto.m_Texture == null)) {
                    bEqual = false;
                }
                if (this.m_Texture != null && fto.m_Texture != null && !this.m_Texture.equals(fto.m_Texture)) {
                    bEqual = false;
                }
            }
        } else {
            bEqual = false;
        }
        return bEqual;
    }

    public boolean is2DTech(Graphics g) {
        boolean tech2D = false;
        if (g instanceof PrinterGraphics) {
            if (this.m_Perspective.isSFXPrintingSmooth()) {
                tech2D = true;
            }
        } else if (g instanceof Graphics2D) {
            tech2D = true;
        }
        return tech2D;
    }

    @Override
    public void fillPolygon(Graphics g, Perspective c, Area area) {
        if (this.is2DTech(g)) {
            this.fill((Graphics2D)g, c, area, false);
        } else {
            super.fillPolygon(g, c, area);
        }
    }

    public void fillPolygon(Graphics g, Perspective c, Arc2D arc) {
        if (this.is2DTech(g)) {
            this.fill((Graphics2D)g, c, arc, false);
        } else {
            super.fillPolygon(g, c, arc);
        }
    }

    @Override
    public void fillPolygon(Graphics g, Perspective c, Polygon p) {
        if (this.is2DTech(g)) {
            this.fill((Graphics2D)g, c, p, false);
        } else {
            super.fillPolygon(g, c, p);
        }
    }

    @Override
    public void fillPolygon(Graphics g, Perspective c, GeneralPath p, Rectangle r) {
        if (this.is2DTech(g)) {
            this.fill((Graphics2D)g, c, p, false);
        } else {
            super.fillPolygon(g, c, p, r);
        }
    }

    @Override
    public void fillRect(Graphics g, Perspective c, Rectangle r) {
        if (this.is2DTech(g)) {
            this.fill((Graphics2D)g, c, r, false);
        } else {
            super.fillRect(g, c, r);
        }
    }

    @Override
    public void fillOval(Graphics g, Perspective c, Rectangle r) {
        if (this.is2DTech(g)) {
            this.fill((Graphics2D)g, c, r, true);
        } else {
            super.fillOval(g, c, r);
        }
    }

    public void fill(Graphics2D g, Perspective c, Shape shape, boolean oval) {
        if (!this.waitForImage(c, this.m_Texture)) {
            return;
        }
        int imgHeight = this.m_Texture.getHeight(null);
        int imgWidth = this.m_Texture.getWidth(null);
        BufferedImage image = new BufferedImage(imgWidth, imgHeight, 2);
        Graphics2D outContext = image.createGraphics();
        outContext.drawImage(this.m_Texture, 0, 0, null);
        outContext.dispose();
        Rectangle r = shape instanceof Arc2D ? shape.getBounds2D().getBounds() : shape.getBounds();
        if (r.width <= 0 || r.height <= 0) {
            return;
        }
        TexturePaint paintObj = this.m_nTilingMode == 1 ? new TexturePaint(image, new Rectangle(r.x, r.y, r.width, r.height)) : new TexturePaint(image, new Rectangle(0, 0, imgWidth, imgWidth));
        g.setPaint(paintObj);
        if (oval) {
            Rectangle rect = (Rectangle)shape;
            g.fillOval(rect.x, rect.y, rect.width, rect.height);
        } else {
            g.fill(shape);
        }
    }

    @Override
    protected void fillSfxRect(Graphics g, Perspective c, int x, int y, int width, int height, RectangularShape shape, Rectangle r) {
        boolean bImageReady = false;
        if (!this.waitForImage(c, this.m_Texture)) {
            return;
        }
        int imgHeight = this.m_Texture.getHeight(null);
        int imgWidth = this.m_Texture.getWidth(null);
        if (this.m_nTilingMode == 0) {
            for (int i = 0; i < width; i += imgWidth) {
                int j = 0;
                block1: while (j < height) {
                    for (int l = 0; l < 10000; ++l) {
                        if (this.m_nFlippingMode == 0) {
                            bImageReady = g.drawImage(this.m_Texture, i, j, imgWidth, imgHeight, null);
                        } else if (this.m_nFlippingMode == 1) {
                            bImageReady = g.drawImage(this.m_Texture, i, j, i + imgWidth, j + imgHeight, 0, imgHeight, imgWidth, 0, null);
                        } else if (this.m_nFlippingMode == 2) {
                            bImageReady = g.drawImage(this.m_Texture, i, j, i + imgWidth, j + imgHeight, imgHeight, 0, 0, imgWidth, null);
                        } else if (this.m_nFlippingMode == 3) {
                            bImageReady = g.drawImage(this.m_Texture, i, j, i + imgWidth, j + imgHeight, imgWidth, imgHeight, 0, 0, null);
                        }
                        if (!bImageReady) continue;
                        j += imgHeight;
                        continue block1;
                    }
                }
            }
        } else {
            boolean b = false;
            do {
                if (this.m_nFlippingMode == 0) {
                    b = g.drawImage(this.m_Texture, x, y, width, height, null);
                    continue;
                }
                if (this.m_nFlippingMode == 1) {
                    b = g.drawImage(this.m_Texture, x, y, x + width, y + height, y, y + imgHeight, x + imgWidth, x, null);
                    continue;
                }
                if (this.m_nFlippingMode == 2) {
                    b = g.drawImage(this.m_Texture, x, y, x + width, y + height, y + imgHeight, y, x, x + imgWidth, null);
                    continue;
                }
                if (this.m_nFlippingMode != 3) continue;
                b = g.drawImage(this.m_Texture, x, y, x + width, y + height, x + imgWidth, y + imgHeight, x, y, null);
            } while (!b);
        }
    }
}

