/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.List;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.draw.FillObj;
import oracle.dss.graph.pfj.draw.FillSfxObj;
import oracle.dss.presutil.GradientObj;
import oracle.dss.presutil.GradientStopObj;

public class FillGradientObj
extends FillSfxObj {
    private static final long serialVersionUID = 1L;
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    public static final int DOWN = 3;
    public static final int UP = 4;
    public static final int DOWN_LEFT = 5;
    public static final int UP_LEFT = 6;
    public static final int DOWN_RIGHT = 7;
    public static final int UP_RIGHT = 8;
    public static final int RADIAL = 9;
    public static final int RADIAL_TOPLEFT = 10;
    public static final int RADIAL_TOPRIGHT = 11;
    public static final int RADIAL_BOTTOMLEFT = 12;
    public static final int RADIAL_BOTTOMRIGHT = 13;
    public static final int RECTANGULAR = 14;
    private static final int GRADIENT_MAX = 14;
    private GradientObj m_gradient;
    private Perspective m_Perspective;
    private Rectangle2D m_boundingBox;
    private static final int DEFAULT_DIRECTION = 3;

    public FillGradientObj() {
        this.m_gradient = new GradientObj(3);
    }

    public FillGradientObj(Perspective p, int nGradientDirection) {
        this.m_gradient = new GradientObj(nGradientDirection);
        this.m_Perspective = p;
    }

    public FillGradientObj(GradientObj gradient) {
        this.m_gradient = gradient;
    }

    @Override
    public void copy(FillObj fo) {
        this.m_gradient.copy(((FillGradientObj)fo).m_gradient);
    }

    public boolean equals(Object obj) {
        boolean bEqual;
        if (obj instanceof FillGradientObj) {
            FillGradientObj fgo = (FillGradientObj)obj;
            bEqual = this.m_gradient.equals(fgo.m_gradient);
        } else {
            bEqual = false;
        }
        return bEqual;
    }

    @Override
    public void fillPolygon(Graphics g, Perspective c, Area area) {
        this.fill((Graphics2D)g, c, area, false);
    }

    @Override
    public void fillPolygon(Graphics g, Perspective c, RectangularShape shape) {
        this.fill((Graphics2D)g, c, shape, false);
    }

    @Override
    public void fillPolygon(Graphics g, Perspective c, Polygon p) {
        this.fill((Graphics2D)g, c, p, false);
    }

    @Override
    public void fillPolygon(Graphics g, Perspective c, GeneralPath p, Rectangle r) {
        this.fill((Graphics2D)g, c, p, false);
    }

    @Override
    public void fillRect(Graphics g, Perspective c, Rectangle r) {
        this.fill((Graphics2D)g, c, r, false);
    }

    @Override
    public void fillOval(Graphics g, Perspective c, Rectangle r) {
        this.fill((Graphics2D)g, c, r, true);
    }

    public void fill(Graphics2D g, Perspective c, Shape shape, boolean oval) {
        Rectangle r = shape instanceof Arc2D || shape instanceof Ellipse2D ? shape.getBounds2D().getBounds() : shape.getBounds();
        if (r.width <= 0 || r.height <= 0) {
            return;
        }
        Rectangle2D bounds = shape.getBounds2D();
        if (this.m_boundingBox != null) {
            bounds = this.m_boundingBox;
        }
        Paint paint = this.m_gradient.getPaint(bounds);
        g.setPaint(paint);
        if (oval) {
            Rectangle rect = (Rectangle)shape;
            g.fillOval(rect.x, rect.y, rect.width, rect.height);
        } else {
            g.fill(shape);
        }
    }

    @Override
    public void fillSfxRect(Graphics g, Perspective c, int x, int y, int width, int height, RectangularShape shape, Rectangle r) {
        this.fill((Graphics2D)g, c, new Rectangle(x, y, width, height), false);
    }

    public void insertPin(double fPosition, Color leftColor, Color rightColor) {
        this.m_gradient.insertPin(fPosition, leftColor, rightColor);
    }

    public void setDirection(int nDirection) {
        if (nDirection < 1 || nDirection > 14) {
            throw new AssertionException(1, 14, nDirection);
        }
        this.m_gradient.setDirectionConstant(nDirection);
    }

    public int getDirection() {
        return this.m_gradient.getDirectionConstant();
    }

    public void setBoundingBox(Rectangle2D box) {
        this.m_boundingBox = box;
    }

    public Rectangle2D getBoundingBox() {
        return this.m_boundingBox;
    }

    public List<GradientStopObj> getStopList() {
        return this.m_gradient.getStopList();
    }

    public Color getColorAt(double fValue) {
        Color color = this.m_gradient.getColorAt(fValue);
        return color;
    }
}

