/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;

public class ExtractPixelsImageFilter
extends ImageFilter {
    private int m_nAngle = 0;
    private int[] m_mask;

    public ExtractPixelsImageFilter(int[] mask) {
        this.m_mask = mask;
    }

    @Override
    public void setDimensions(int width, int height) {
        if (this.m_nAngle == 90 || this.m_nAngle == 270) {
            this.consumer.setDimensions(height, width);
        }
    }

    @Override
    public void setHints(int hints) {
        this.consumer.setHints(hints & 0xFFFFFFFB);
    }

    @Override
    public void setPixels(int x, int y, int width, int height, ColorModel model, int[] pixels, int offset, int scansize) {
        for (int i = 0; i < height; ++i) {
            int destLineOffset = (y + i) * width;
            int srcLineOffset = i * scansize + offset;
            for (int j = 0; j < width; ++j) {
                int pixel = pixels[srcLineOffset + j];
                this.m_mask[destLineOffset + x + j] = model.getRGB(pixel);
            }
        }
    }
}

