/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.GraphExportXMLWriter;
import oracle.dss.graph.pfj.GraphSVGWriter;
import oracle.dss.graph.pfj.JChart_2D;
import oracle.dss.graph.pfj.MathExt;
import oracle.dss.graph.pfj.ObjClassID;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetMarker;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.math.FP;

public class DetLine
extends DetObj {
    private static final long serialVersionUID = 1L;
    protected static final int SLOP_FACTOR = 40;
    public static final int THIN_LINE = 0;
    protected Point2D m_pt1;
    protected Point2D m_pt2;
    protected Polygon m_polyLine;
    protected int m_nLineWidth;
    protected int m_lineStyle = 0;
    protected boolean m_isMarker = false;

    public DetLine(Detectiv m_Detectiv, IdentObj id, int ptx1, int pty1, int ptx2, int pty2, BlackBoxIF blackBox, Rectangle clipRect, int nLineWidth) {
        super(m_Detectiv, id, blackBox, false, true, true);
        this.m_pt1 = new Point(ptx1, pty1);
        this.m_pt2 = new Point(ptx2, pty2);
        this.m_nLineWidth = nLineWidth;
        this.m_polyLine = null;
        this.m_blackBox.setTransparentBorderColor(false);
        if (this.m_nLineWidth != 0) {
            this.m_blackBox.setFillColor(this.m_blackBox.getBorderColor());
            this.m_blackBox.setTransparentFillColor(this.m_blackBox.getTransparentBorderColor());
        }
        if (id.getObjectID() == 504) {
            this.m_isMarker = true;
        } else if (id.getObjectID() == 13) {
            this.setVisualEffectsMap(JChart_2D.getLineEffectsMap(nLineWidth, true));
        } else if (id.getObjectID() == 258) {
            this.setVisualEffectsMap(JChart_2D.getLineEffectsMap(nLineWidth, false));
        }
    }

    public DetLine(Detectiv m_Detectiv, IdentObj id, double ptx1, double pty1, double ptx2, double pty2, BlackBoxIF blackBox, Rectangle clipRect, int nLineWidth) {
        super(m_Detectiv, id, blackBox, false, true, true);
        this.m_pt1 = new Point2D.Double(ptx1, pty1);
        this.m_pt2 = new Point2D.Double(ptx2, pty2);
        this.m_nLineWidth = nLineWidth;
        this.m_polyLine = null;
        if (this.m_nLineWidth != 0) {
            this.m_blackBox.setFillColor(this.m_blackBox.getBorderColor());
            this.m_blackBox.setTransparentFillColor(this.m_blackBox.getTransparentBorderColor());
        }
        if (id.getObjectID() == 504) {
            this.m_isMarker = true;
        } else if (id.getObjectID() == 13) {
            this.setVisualEffectsMap(JChart_2D.getLineEffectsMap(nLineWidth, true));
        } else if (id.getObjectID() == 258) {
            this.setVisualEffectsMap(JChart_2D.getLineEffectsMap(nLineWidth, false));
        }
    }

    public DetLine(Detectiv m_Detectiv, IdentObj id, int ptx1, int pty1, int ptx2, int pty2, BlackBoxIF blackBox, Rectangle clipRect, int nLineWidth, int nLineStyle) {
        this(m_Detectiv, id, ptx1, pty1, ptx2, pty2, blackBox, clipRect, nLineWidth);
        this.m_lineStyle = nLineStyle;
    }

    public DetLine(Detectiv m_Detectiv, IdentObj id, int ptx1, int pty1, int ptx2, int pty2, BlackBoxIF blackBox, Rectangle clipRect, boolean bMoveable, boolean bDetectable) {
        this(m_Detectiv, id, ptx1, pty1, ptx2, pty2, blackBox, clipRect, bMoveable, bDetectable, 0);
    }

    public DetLine(Detectiv m_Detectiv, IdentObj id, int ptx1, int pty1, int ptx2, int pty2, BlackBoxIF blackBox, Rectangle clipRect, boolean bMoveable, boolean bDetectable, int nLineWidth) {
        super(m_Detectiv, id, blackBox, bMoveable, bDetectable, true);
        this.m_pt1 = new Point(ptx1, pty1);
        this.m_pt2 = new Point(ptx2, pty2);
        this.m_nLineWidth = nLineWidth;
        this.m_polyLine = null;
        if (this.m_nLineWidth != 0) {
            this.m_blackBox.setFillColor(this.m_blackBox.getBorderColor());
            this.m_blackBox.setTransparentFillColor(this.m_blackBox.getTransparentBorderColor());
        }
        if (id.getObjectID() == 504) {
            this.m_isMarker = true;
        } else if (id.getObjectID() == 13) {
            this.setVisualEffectsMap(JChart_2D.getLineEffectsMap(nLineWidth, true));
        } else if (id.getObjectID() == 258) {
            this.setVisualEffectsMap(JChart_2D.getLineEffectsMap(nLineWidth, false));
        }
    }

    public DetLine(Detectiv m_Detectiv, IdentObj id, int ptx1, int pty1, int ptx2, int pty2, BlackBoxIF blackBox, Rectangle clipRect, boolean bMoveable, boolean bDetectable, int nLineWidth, int nLineStyle) {
        this(m_Detectiv, id, ptx1, pty1, ptx2, pty2, blackBox, clipRect, bMoveable, bDetectable, nLineWidth);
        this.m_lineStyle = nLineStyle;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DetLine)) {
            return false;
        }
        DetLine detLine = (DetLine)obj;
        return this.m_id.equals(detLine.m_id);
    }

    public Point2D getBeginPoint() {
        return this.m_pt1;
    }

    public Point2D getEndPoint() {
        return this.m_pt2;
    }

    @Override
    public Rectangle getBounds() {
        if (this.m_pt1 instanceof Point && this.m_pt2 instanceof Point) {
            return new Rectangle(Math.min(((Point)this.m_pt1).x, ((Point)this.m_pt2).x), Math.min(((Point)this.m_pt1).y, ((Point)this.m_pt2).y), Math.abs(((Point)this.m_pt1).x - ((Point)this.m_pt2).x), Math.abs(((Point)this.m_pt1).y - ((Point)this.m_pt2).y));
        }
        return new Rectangle((int)Math.round(Math.min(this.m_pt1.getX(), this.m_pt2.getX())), (int)Math.round(Math.min(this.m_pt1.getY(), this.m_pt2.getY())), (int)Math.round(Math.abs(this.m_pt1.getX() - this.m_pt2.getX())), (int)Math.round(Math.abs(this.m_pt1.getY() - this.m_pt2.getY())));
    }

    @Override
    public void hilite(Graphics g, VC vc) {
        Point pt1 = null;
        Point pt2 = null;
        Point2D pt2d1 = null;
        Point2D pt2d2 = null;
        if (this.m_pt1 instanceof Point && this.m_pt2 instanceof Point) {
            pt1 = vc.virtToDest(new Point(((Point)this.m_pt1).x, ((Point)this.m_pt1).y));
            pt2 = vc.virtToDest(new Point(((Point)this.m_pt2).x, ((Point)this.m_pt2).y));
        } else {
            pt2d1 = vc.virtToDest(new Point2D.Double(this.m_pt1.getX(), this.m_pt1.getY()));
            pt2d2 = vc.virtToDest(new Point2D.Double(this.m_pt2.getX(), this.m_pt2.getY()));
        }
        g.setXORMode(Color.yellow);
        if (pt1 != null && pt2 != null) {
            g.drawLine(pt1.x, pt1.y, pt2.x, pt2.y);
        } else {
            Graphics2D g2 = (Graphics2D)g;
            Object oldHint = g2.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
            Object oldRenderingHint = g2.getRenderingHint(RenderingHints.KEY_RENDERING);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            Line2D.Double line = new Line2D.Double(pt2d1, pt2d2);
            g2.draw(line);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, oldHint);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, oldRenderingHint);
        }
        g.setPaintMode();
    }

    @Override
    public boolean isPointInObj(int x, int y, VC vc) {
        if (!this.m_bDetectable) {
            return false;
        }
        if (this.m_polyLine == null) {
            this.m_polyLine = this.calcLine(Math.max(this.m_nLineWidth, 5), vc, false);
        }
        return this.m_polyLine.contains(x, y);
    }

    @Override
    public boolean isPointInObj(Point pt, VC vc) {
        return this.isPointInObj(pt.x, pt.y, vc);
    }

    @Override
    public void paintIt(Graphics g, VC vc) {
        switch (this.m_nLineWidth) {
            case 0: 
            case 1: {
                if (this.m_lineStyle == 0) {
                    if (this.m_pt1 instanceof Point && this.m_pt2 instanceof Point) {
                        this.m_blackBox.paint(g, vc.virtToDest((Point)this.m_pt1), vc.virtToDest((Point)this.m_pt2));
                        break;
                    }
                    this.m_blackBox.paint(g, vc.virtToDest(this.m_pt1), vc.virtToDest(this.m_pt2));
                    break;
                }
                if (this.m_pt1 instanceof Point && this.m_pt2 instanceof Point) {
                    this.m_blackBox.paint(g, vc.virtToDest((Point)this.m_pt1), vc.virtToDest((Point)this.m_pt2), 1, this.m_lineStyle, this.m_isMarker);
                    break;
                }
                this.m_blackBox.paint(g, vc.virtToDest(this.m_pt1), vc.virtToDest(this.m_pt2), 1, this.m_lineStyle, this.m_isMarker);
                break;
            }
            default: {
                if (this.m_pt1 instanceof Point && this.m_pt2 instanceof Point) {
                    this.m_blackBox.paint(g, vc.virtToDest((Point)this.m_pt1), vc.virtToDest((Point)this.m_pt2), this.m_nLineWidth, this.m_lineStyle, this.m_isMarker);
                    break;
                }
                this.m_blackBox.paint(g, vc.virtToDest(this.m_pt1), vc.virtToDest(this.m_pt2), this.m_nLineWidth, this.m_lineStyle, this.m_isMarker);
            }
        }
        this.m_polyLine = null;
    }

    @Override
    public void renderItToSVG(Map context) throws IOException, Exception {
        boolean bOnMouseOverOutPresent;
        boolean bOnClickPresent;
        GraphSVGWriter writer = (GraphSVGWriter)context.get("svgWriter");
        VC vc = (VC)context.get("svgVC");
        int mode = (Integer)context.get("svgMode");
        boolean bTooltips = (mode & 2) != 0;
        String[] tooltipsArray = null;
        if (bTooltips) {
            tooltipsArray = this.m_Detectiv.getPerspective().getUserTooltipStrings(this);
        }
        boolean bShapeAttributes = (mode & 0x10) != 0;
        String clickEventJS = null;
        boolean bl = bOnClickPresent = bShapeAttributes && writer.isOnClickPresent();
        if (bShapeAttributes && !bOnClickPresent) {
            clickEventJS = writer.getClickEventJS();
        }
        boolean bl2 = bOnMouseOverOutPresent = bShapeAttributes && writer.isOnMouseOverOutPresent();
        if (bOnMouseOverOutPresent) {
            bTooltips = false;
        }
        String saAlt = null;
        String saTitle = null;
        String saHRef = null;
        String saTarget = null;
        if (bShapeAttributes) {
            saAlt = writer.getShapeAttributesAlt();
            saTitle = writer.getShapeAttributesTitle();
            if (!bOnClickPresent) {
                saHRef = writer.getShapeAttributesHRef();
            }
            saTarget = writer.getShapeAttributesTarget();
        }
        boolean bDrilling = (mode & 4) != 0;
        bDrilling = bDrilling && !bOnClickPresent && clickEventJS == null;
        String drillJS = null;
        String link = null;
        boolean bLink = this.m_Detectiv.getPerspective().isDataLinkEnabled();
        if (bLink && ((link = writer.getLink(this)) == null || link.length() < 1)) {
            bLink = false;
        }
        if (bDrilling && ((drillJS = writer.getDrillJS(this)) == null || drillJS.length() < 1)) {
            bDrilling = false;
        }
        if (bTooltips) {
            if (saAlt != null) {
                tooltipsArray = new String[]{saAlt};
            } else if (saTitle != null) {
                tooltipsArray = new String[]{saTitle};
            }
        }
        if (bDrilling && bTooltips && tooltipsArray == null) {
            tooltipsArray = new String[]{writer.getDrillTooltip(this)};
        }
        bTooltips = bTooltips && tooltipsArray != null && tooltipsArray.length > 0;
        boolean bStartA = bDrilling || bOnClickPresent || clickEventJS != null || saHRef != null || bLink;
        boolean bAnchorGroup = false;
        if (bStartA) {
            writer.startElement("a");
            String href = "";
            if (clickEventJS == null && !bDrilling && saHRef != null) {
                href = saHRef;
            } else if (clickEventJS == null && !bDrilling && bLink) {
                href = link;
            }
            writer.writeAttribute("xlink:href", href);
            if (saTarget != null) {
                writer.writeAttribute("target", saTarget);
            }
            String strOnclick = null;
            if (clickEventJS != null) {
                strOnclick = clickEventJS;
            } else if (bDrilling) {
                strOnclick = drillJS;
            }
            if (strOnclick != null) {
                bAnchorGroup = true;
                writer.startElement("g");
                writer.writeAttribute("onclick", strOnclick);
            }
        }
        boolean bElementStarted = false;
        switch (this.m_nLineWidth) {
            case 0: 
            case 1: {
                if (this.m_lineStyle == 0) {
                    if (this.m_pt1 instanceof Point && this.m_pt2 instanceof Point) {
                        bElementStarted = writer.startElement(this.m_id, this.m_blackBox, vc.virtToDest((Point)this.m_pt1), vc.virtToDest((Point)this.m_pt2));
                        break;
                    }
                    bElementStarted = writer.startElement(this.m_id, this.m_blackBox, vc.virtToDest(this.m_pt1), vc.virtToDest(this.m_pt2));
                    break;
                }
                if (this.m_pt1 instanceof Point && this.m_pt2 instanceof Point) {
                    bElementStarted = writer.startElement(this.m_id, this.m_blackBox, vc.virtToDest((Point)this.m_pt1), vc.virtToDest((Point)this.m_pt2), 1, this.m_lineStyle, this.m_isMarker);
                    break;
                }
                bElementStarted = writer.startElement(this.m_id, this.m_blackBox, vc.virtToDest(this.m_pt1), vc.virtToDest(this.m_pt2), 1, this.m_lineStyle, this.m_isMarker);
                break;
            }
            default: {
                bElementStarted = this.m_pt1 instanceof Point && this.m_pt2 instanceof Point ? writer.startElement(this.m_id, this.m_blackBox, vc.virtToDest((Point)this.m_pt1), vc.virtToDest((Point)this.m_pt2), this.m_nLineWidth, this.m_lineStyle, this.m_isMarker) : writer.startElement(this.m_id, this.m_blackBox, vc.virtToDest(this.m_pt1), vc.virtToDest(this.m_pt2), this.m_nLineWidth, this.m_lineStyle, this.m_isMarker);
            }
        }
        if (bElementStarted) {
            if (this.m_id.getObjectID() == 357) {
                writer.writeAttribute("id", writer.getReferenceObjectId(this.m_id.getMiscID()));
                int graphID = this.m_Detectiv.getPerspective().getReferenceAssociation(this.m_id);
                int display = this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID);
                if (display == 2) {
                    writer.writeAttribute("visibility", "hidden");
                }
                writer.writeAttribute("pointer-events", "none");
            }
            if (bShapeAttributes) {
                writer.writeShapeAttributes();
            }
            if (bTooltips) {
                int rbMode;
                List l;
                String onMouseOverJS = null;
                String onMouseOutJS = null;
                int graphID = this.m_Detectiv.getPerspective().getReferenceObjectGraphID(this.m_id.getObjectID());
                if (graphID != -1 && this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID) == 2 && (l = writer.getReferenceObjects(this.m_id)) != null) {
                    context.put("svgHasReferenceObj", Boolean.TRUE);
                    StringBuilder strBuf = new StringBuilder("evt,");
                    for (int i = 0; i < l.size() - 1; ++i) {
                        strBuf.append("'" + (String)l.get(i) + "',");
                    }
                    strBuf.append("'" + (String)l.get(l.size() - 1) + "'");
                    onMouseOverJS = "bi_refObj_show_mOver(" + strBuf.toString() + ");";
                    onMouseOutJS = "bi_refObj_hide_mOut(" + strBuf.toString() + ");";
                }
                if ((rbMode = this.m_Detectiv.getPerspective().getIntegerProp(Attr.SeriesRolloverBehavior)) != 0) {
                    String shfOver = new String("bi_rollover(evt, true, '" + writer.getSimpleBeanName() + "');");
                    String shfOut = new String("bi_rollover(evt, false, '" + writer.getSimpleBeanName() + "');");
                    onMouseOverJS = onMouseOverJS != null ? onMouseOverJS + shfOver : shfOver;
                    onMouseOutJS = onMouseOutJS != null ? onMouseOutJS + shfOut : shfOut;
                }
                boolean shfOver = writer.writeTooltip(tooltipsArray, onMouseOverJS, onMouseOutJS);
            } else {
                List l;
                int graphID;
                String onMouseOverJS = null;
                String onMouseOutJS = null;
                int rbMode = this.m_Detectiv.getPerspective().getIntegerProp(Attr.SeriesRolloverBehavior);
                if (rbMode != 0 && this.m_id.isSeriesRelated()) {
                    String shfOver = new String("bi_rollover(evt, true, '" + writer.getSimpleBeanName() + "');");
                    String shfOut = new String("bi_rollover(evt, false, '" + writer.getSimpleBeanName() + "');");
                    onMouseOverJS = onMouseOverJS != null ? onMouseOverJS + shfOver : shfOver;
                    onMouseOutJS = onMouseOutJS != null ? onMouseOutJS + shfOut : shfOut;
                }
                if ((graphID = this.m_Detectiv.getPerspective().getReferenceObjectGraphID(this.m_id.getObjectID())) != -1 && this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID) == 2 && (l = writer.getReferenceObjects(this.m_id)) != null) {
                    context.put("svgHasReferenceObj", Boolean.TRUE);
                    StringBuilder strBuf = new StringBuilder("evt,");
                    for (int i = 0; i < l.size() - 1; ++i) {
                        strBuf.append("'" + (String)l.get(i) + "',");
                    }
                    strBuf.append("'" + (String)l.get(l.size() - 1) + "'");
                    onMouseOverJS = onMouseOverJS == null ? "bi_refObj_show_mOver(" + strBuf.toString() + ");" : onMouseOverJS + "bi_refObj_show_mOver(" + strBuf.toString() + ");";
                    onMouseOutJS = onMouseOutJS == null ? "bi_refObj_hide_mOut(" + strBuf.toString() + ");" : "bi_refObj_hide_mOut(" + strBuf.toString() + ");";
                }
                if (onMouseOverJS != null) {
                    writer.writeAttribute("onmouseover", onMouseOverJS);
                }
                if (onMouseOutJS != null) {
                    writer.writeAttribute("onmouseout", onMouseOutJS);
                }
                if (saTitle != null) {
                    writer.writeTitleElement(saTitle);
                }
            }
            writer.endElement();
        }
        if (bStartA) {
            if (bAnchorGroup) {
                writer.endElement();
            }
            writer.endElement();
        }
        this.m_polyLine = null;
    }

    @Override
    public void renderItToXML(Map context) throws IOException, Exception {
        String drillJS;
        GraphExportXMLWriter writer = (GraphExportXMLWriter)context.get("xmlWriter");
        VC vc = (VC)context.get("xmlVC");
        String link = null;
        boolean bLink = this.m_Detectiv.getPerspective().isDataLinkEnabled();
        if (bLink && ((link = this.m_Detectiv.getPerspective().getLink(this)) == null || link.length() < 1)) {
            bLink = false;
        }
        boolean bDrilling = (drillJS = writer.getDrillJS(this)) != null && drillJS.length() > 0;
        String clip = null;
        if (ObjClassID.stripExceptionalOffset(this.getObjectID()) == 357) {
            clip = DetMarker.writeBubbleClipRect(this.m_Detectiv, writer, context);
        }
        boolean bElementStarted = false;
        switch (this.m_nLineWidth) {
            case 0: 
            case 1: {
                if (this.m_lineStyle == 0) {
                    if (this.m_pt1 instanceof Point && this.m_pt2 instanceof Point) {
                        bElementStarted = writer.startElement(this.m_id, this.m_blackBox, vc.virtToDest((Point)this.m_pt1), vc.virtToDest((Point)this.m_pt2));
                        break;
                    }
                    bElementStarted = writer.startElement(this.m_id, this.m_blackBox, vc.virtToDest(this.m_pt1), vc.virtToDest(this.m_pt2));
                    break;
                }
                if (this.m_pt1 instanceof Point && this.m_pt2 instanceof Point) {
                    bElementStarted = writer.startElement(this.m_id, this.m_blackBox, vc.virtToDest((Point)this.m_pt1), vc.virtToDest((Point)this.m_pt2), 1, this.m_lineStyle, this.m_isMarker);
                    break;
                }
                bElementStarted = writer.startElement(this.m_id, this.m_blackBox, vc.virtToDest(this.m_pt1), vc.virtToDest(this.m_pt2), 1, this.m_lineStyle, this.m_isMarker);
                break;
            }
            default: {
                bElementStarted = this.m_pt1 instanceof Point && this.m_pt2 instanceof Point ? writer.startElement(this.m_id, this.m_blackBox, vc.virtToDest((Point)this.m_pt1), vc.virtToDest((Point)this.m_pt2), this.m_nLineWidth, this.m_lineStyle, this.m_isMarker) : writer.startElement(this.m_id, this.m_blackBox, vc.virtToDest(this.m_pt1), vc.virtToDest(this.m_pt2), this.m_nLineWidth, this.m_lineStyle, this.m_isMarker);
            }
        }
        if (bElementStarted) {
            int graphID;
            if (this.m_id.getObjectID() == 357) {
                graphID = this.m_Detectiv.getPerspective().getReferenceAssociation(this.m_id);
                int display = this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID);
                if (display == 2) {
                    writer.writeAttribute("v", "h");
                }
            }
            if (bDrilling) {
                writer.writeAttribute("drillJs", drillJS);
            }
            if (bLink) {
                writer.writeAttribute("link", link);
            }
            if (clip != null) {
                writer.writeAttribute("clip", clip);
            }
            if (!writer.hasAlt()) {
                String[] tooltipsArray = null;
                boolean bTooltipTemplate = writer.useTooltipTemplate(this.m_id);
                if (!bTooltipTemplate) {
                    tooltipsArray = this.m_Detectiv.getPerspective().getUserTooltipStrings(this);
                }
                if (bDrilling && !bTooltipTemplate && tooltipsArray == null) {
                    tooltipsArray = new String[]{writer.getDrillTooltip(this)};
                }
                if (tooltipsArray != null && tooltipsArray.length > 0) {
                    writer.writeTooltipAttribute(tooltipsArray);
                } else if (!bTooltipTemplate) {
                    writer.writeCachedAttribute("tt", "f", null);
                }
            }
            writer.writeVisualEffectsAttributes(this.m_visualEffectsMap);
            writer.writeCustomPropertyAttribute();
            writer.writeShapeAttributesElement();
            writer.writeFillChildren(this.m_id, this.m_blackBox);
            graphID = this.m_Detectiv.getPerspective().getReferenceObjectGraphID(this.m_id.getObjectID());
            if (graphID != -1 && this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID) == 2) {
                writer.writeReferenceObjectsElement(this.m_id);
            }
            writer.endElement();
        }
        this.m_polyLine = null;
    }

    public void setBeginPoint(Point aPoint) {
        this.m_pt1 = aPoint;
    }

    public void setEndPoint(Point aPoint) {
        this.m_pt2 = aPoint;
    }

    @Override
    public void setBounds(Rectangle rBounds) {
    }

    public DetLine hiliteable(boolean hiliteable) {
        this.m_bHiliteable = hiliteable;
        return this;
    }

    private Polygon calcLine(int nLineWidth, VC vc, boolean bWantEndcaps) {
        double dy;
        double dx;
        Polygon poly = new Polygon();
        Point pt0 = null;
        Point pt1 = null;
        Point pt = null;
        Point2D ptd0 = null;
        Point2D ptd1 = null;
        Point2D ptd = null;
        if (this.m_pt1 instanceof Point && this.m_pt2 instanceof Point) {
            if (((Point)this.m_pt1).x < ((Point)this.m_pt2).x) {
                pt0 = vc.virtToDest((Point)this.m_pt1);
                pt1 = vc.virtToDest((Point)this.m_pt2);
            } else {
                pt1 = vc.virtToDest((Point)this.m_pt1);
                pt0 = vc.virtToDest((Point)this.m_pt2);
            }
        } else if (this.m_pt1.getX() < this.m_pt2.getX()) {
            ptd0 = vc.virtToDest(this.m_pt1);
            ptd1 = vc.virtToDest(this.m_pt2);
        } else {
            ptd1 = vc.virtToDest(this.m_pt1);
            ptd0 = vc.virtToDest(this.m_pt2);
        }
        if (this.m_pt1 instanceof Point && this.m_pt2 instanceof Point) {
            PfjAssert.pfjAssert(pt0.x <= pt1.x);
        } else {
            PfjAssert.pfjAssert(ptd0.getX() <= ptd1.getX());
        }
        if (this.m_pt1 instanceof Point && this.m_pt2 instanceof Point) {
            dx = pt1.x - pt0.x;
            dy = pt1.y - pt0.y;
        } else {
            dx = ptd1.getX() - ptd0.getX();
            dy = ptd1.getY() - ptd0.getY();
        }
        double fAngleDeg = Math.atan2(dy, dx) * 57.29577951308232;
        if (bWantEndcaps) {
            double delta = 90.0;
            while (FP.lessThan(delta, 272.0)) {
                if (this.m_pt1 instanceof Point && this.m_pt2 instanceof Point) {
                    pt = vc.destToVirt(MathExt.polToCart(fAngleDeg + delta, (double)nLineWidth, pt0));
                    poly.addPoint(pt.x, pt.y);
                } else {
                    ptd = vc.destToVirt(MathExt.polToCart(fAngleDeg + delta, (double)nLineWidth, ptd0));
                    poly.addPoint((int)Math.round(ptd.getX()), (int)Math.round(ptd.getY()));
                }
                delta += 10.0;
            }
            delta = -90.0;
            while (FP.lessThan(delta, 92.0)) {
                if (this.m_pt1 instanceof Point && this.m_pt2 instanceof Point) {
                    pt = vc.destToVirt(MathExt.polToCart(fAngleDeg + delta, (double)nLineWidth, pt1));
                    poly.addPoint(pt.x, pt.y);
                } else {
                    ptd = vc.destToVirt(MathExt.polToCart(fAngleDeg + delta, (double)nLineWidth, ptd1));
                    poly.addPoint((int)Math.round(ptd.getX()), (int)Math.round(ptd.getY()));
                }
                delta += 10.0;
            }
        } else {
            double angle = (fAngleDeg + 90.0) * (Math.PI / 180);
            if (this.m_pt1 instanceof Point && this.m_pt2 instanceof Point) {
                int x0 = pt0.x + (int)Math.round((double)nLineWidth * Math.cos(angle));
                int y0 = pt0.y + (int)Math.round((double)nLineWidth * Math.sin(angle));
                poly.addPoint(x0, y0);
                angle = (fAngleDeg + 270.0) * (Math.PI / 180);
                int x1 = pt0.x + (int)Math.round((double)nLineWidth * Math.cos(angle));
                int y1 = pt0.y + (int)Math.round((double)nLineWidth * Math.sin(angle));
                poly.addPoint(x1, y1);
                angle = (fAngleDeg - 90.0) * (Math.PI / 180);
                int x2 = pt1.x + (int)Math.round((double)nLineWidth * Math.cos(angle));
                int y2 = pt1.y + (int)Math.round((double)nLineWidth * Math.sin(angle));
                poly.addPoint(x2, y2);
                angle = (fAngleDeg + 90.0) * (Math.PI / 180);
                int x3 = pt1.x + (int)Math.round((double)nLineWidth * Math.cos(angle));
                int y3 = pt1.y + (int)Math.round((double)nLineWidth * Math.sin(angle));
                poly.addPoint(x3, y3);
                poly.addPoint(x0, y0);
            } else {
                double xd0 = ptd0.getX() + (double)nLineWidth * Math.cos(angle);
                double yd0 = ptd0.getY() + (double)nLineWidth * Math.sin(angle);
                poly.addPoint((int)Math.round(xd0), (int)Math.round(yd0));
                angle = (fAngleDeg + 270.0) * (Math.PI / 180);
                double xd1 = ptd0.getX() + (double)nLineWidth * Math.cos(angle);
                double yd1 = ptd0.getY() + (double)nLineWidth * Math.sin(angle);
                poly.addPoint((int)Math.round(xd1), (int)Math.round(yd1));
                angle = (fAngleDeg - 90.0) * (Math.PI / 180);
                double xd2 = ptd1.getX() + (double)nLineWidth * Math.cos(angle);
                double yd2 = ptd1.getY() + (double)nLineWidth * Math.sin(angle);
                poly.addPoint((int)Math.round(xd2), (int)Math.round(yd2));
                angle = (fAngleDeg + 90.0) * (Math.PI / 180);
                double xd3 = ptd1.getX() + (double)nLineWidth * Math.cos(angle);
                double yd3 = ptd1.getY() + (double)nLineWidth * Math.sin(angle);
                poly.addPoint((int)Math.round(xd3), (int)Math.round(yd3));
                poly.addPoint((int)Math.round(xd0), (int)Math.round(yd0));
            }
            poly = vc.destToVirt(poly);
        }
        return poly;
    }

    @Override
    public Polygon getShape(VC vc) {
        return this.calcLine(Math.max(this.m_nLineWidth, 5), vc, false);
    }
}

