/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.io.Serializable;
import java.util.Vector;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.ZoomState;

public class ZoomStateList
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int UNZOOMED = 0;
    private Vector m_states;
    private int m_currentState;

    public ZoomStateList() {
        this.clearList();
    }

    public void addZoomState(ZoomState z) {
        for (int i = this.m_states.size() - 1; i > this.m_currentState; --i) {
            this.m_states.removeElementAt(i);
        }
        this.m_states.addElement(z);
        this.m_currentState = this.m_states.size() - 1;
    }

    public void clearList() {
        this.m_states = new Vector();
        this.addZoomState(ZoomState.UNZOOMED);
        this.m_currentState = 0;
    }

    public int getCurrentIndex() {
        return this.m_currentState;
    }

    public ZoomState getZoomState() {
        return this.getZoomState(this.m_currentState);
    }

    public ZoomState getZoomState(int i) {
        PfjAssert.pfjAssert(i >= 0 && i < this.m_states.size());
        ZoomState z = (ZoomState)this.m_states.elementAt(i);
        return z;
    }

    public boolean isValid() {
        boolean bValid = !this.m_states.isEmpty() && this.m_currentState >= 0 && this.m_currentState < this.m_states.size();
        return bValid;
    }

    public boolean isCurrentlyZoomed() {
        boolean bZoomed = this.isValid() && this.getZoomState().isZoomed();
        return bZoomed;
    }

    public boolean isValidIndex(int index) {
        boolean bValid = !this.m_states.isEmpty() && index >= 0 && index < this.m_states.size();
        return bValid;
    }

    public void setCurrentIndex(int i) {
        PfjAssert.pfjAssert(i >= 0 && i < this.m_states.size());
        if (i >= 0 && i < this.m_states.size()) {
            this.m_currentState = i;
        }
    }

    public String toString() {
        return "list = " + this.m_states.toString() + ", current state = " + this.m_currentState;
    }
}

