/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.Serializable;

public class VC
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_VX = 16000;
    public static final int DEFAULT_VY = 16000;
    private double m_dvWidth;
    private double m_dvHeight;
    private double m_vdWidth;
    private double m_vdHeight;
    private double m_dvXCoord;
    private double m_dvYCoord;
    private double m_vdXCoord;
    private double m_vdYCoord;
    private double m_dvXOffset;
    private double m_dvYOffset;
    private double m_vdXOffset;
    private double m_vdYOffset;
    private int m_destWidth;
    private int m_destHeight;
    private int m_virtWidth;
    private int m_virtHeight;

    public VC(double destWidth, double destHeight) {
        this(destWidth, destHeight, 32000.0, 32000.0);
    }

    public VC(double destWidth, double destHeight, double virtWidth, double virtHeight) {
        this.m_dvWidth = virtWidth / destWidth;
        this.m_dvHeight = virtHeight / destHeight;
        this.m_vdWidth = destWidth / virtWidth;
        this.m_vdHeight = destHeight / virtHeight;
        this.m_dvXCoord = virtWidth / destWidth;
        this.m_dvYCoord = -virtHeight / (destHeight - 1.0);
        this.m_vdXCoord = destWidth / virtWidth;
        this.m_vdYCoord = -(destHeight - 1.0) / virtHeight;
        this.m_dvXOffset = -virtWidth / 2.0;
        this.m_dvYOffset = virtHeight / 2.0;
        this.m_vdXOffset = destWidth / 2.0;
        this.m_vdYOffset = (destHeight - 1.0) / 2.0;
        this.m_virtWidth = (int)virtWidth;
        this.m_virtHeight = (int)virtHeight;
        this.m_destWidth = (int)destWidth;
        this.m_destHeight = (int)destHeight;
    }

    public VC(VC source) {
        this(source.m_destWidth, source.m_destHeight, source.m_virtWidth, source.m_virtHeight);
    }

    public Point destToVirt(int dx, int dy) {
        return this.destToVirt(new Point(dx, dy));
    }

    public Dimension destToVirt(Dimension d) {
        return new Dimension((int)Math.round((double)d.width * this.m_dvWidth), (int)Math.round((double)d.height * this.m_dvHeight));
    }

    public Point destToVirt(Point dest) {
        double x = this.dvX(dest.x);
        double y = this.dvY(dest.y);
        Point virt = new Point((int)Math.round(x), (int)Math.round(y));
        return virt;
    }

    public Point2D destToVirt(Point2D dest) {
        double x = this.dvX(dest.getX());
        double y = this.dvY(dest.getY());
        Point2D.Double virt = new Point2D.Double(x, y);
        return virt;
    }

    public Polygon destToVirt(Polygon dest) {
        Polygon virt = new Polygon();
        for (int i = 0; i < dest.npoints; ++i) {
            double x = this.dvX(dest.xpoints[i]);
            double y = this.dvY(dest.ypoints[i]);
            virt.addPoint((int)Math.round(x), (int)Math.round(y));
        }
        return virt;
    }

    public Rectangle destToVirt(Rectangle dest) {
        double x = this.dvX(dest.x);
        double y = this.dvY(dest.y + dest.height);
        double width = (double)dest.width * this.m_dvWidth;
        double height = (double)dest.height * this.m_dvHeight;
        Rectangle virt = new Rectangle((int)Math.round(x), (int)Math.round(y), (int)Math.round(width), (int)Math.round(height));
        return virt;
    }

    public int destToVirtHeight(int nHeight) {
        return (int)Math.round((double)nHeight * this.m_dvHeight);
    }

    public double destToVirtHeight(double nHeight) {
        return nHeight * this.m_dvHeight;
    }

    public int destToVirtWidth(int nWidth) {
        return (int)Math.round((double)nWidth * this.m_dvWidth);
    }

    public double destToVirtWidth(double nWidth) {
        return nWidth * this.m_dvWidth;
    }

    public int destToVirtX(int x) {
        return (int)Math.round(this.dvX(x));
    }

    public int destToVirtY(int y) {
        return (int)Math.round(this.dvY(y));
    }

    double dvX(double dx) {
        double vx = dx * this.m_dvXCoord + this.m_dvXOffset;
        return vx;
    }

    double dvY(double dy) {
        double vy = dy * this.m_dvYCoord + this.m_dvYOffset;
        return vy;
    }

    public Rectangle getDestCoords() {
        return new Rectangle(0, 0, this.m_destWidth, this.m_destHeight);
    }

    public Rectangle getVirtCoords() {
        return new Rectangle(-this.m_virtWidth / 2, -this.m_virtHeight / 2, this.m_virtWidth, this.m_virtHeight);
    }

    public Dimension getVirtDimension() {
        return new Dimension(this.m_virtWidth, this.m_virtHeight);
    }

    double vdX(double vx) {
        double dx = vx * this.m_vdXCoord + this.m_vdXOffset;
        return dx;
    }

    double vdY(double vy) {
        double dy = vy * this.m_vdYCoord + this.m_vdYOffset;
        return dy;
    }

    public Point virtToDest(int vx, int vy) {
        return this.virtToDest(new Point(vx, vy));
    }

    public Dimension virtToDest(Dimension d) {
        return new Dimension((int)Math.round((double)d.width * this.m_vdWidth), (int)Math.round((double)d.height * this.m_vdHeight));
    }

    public Point virtToDest(Point virt) {
        double x = this.vdX(virt.x);
        double y = this.vdY(virt.y);
        Point dest = new Point((int)Math.round(x), (int)Math.round(y));
        return dest;
    }

    public Point2D virtToDest(Point2D virt) {
        double x = this.vdX(virt.getX());
        double y = this.vdY(virt.getY());
        Point2D.Double dest = new Point2D.Double(x, y);
        return dest;
    }

    public Polygon virtToDest(Polygon virt) {
        Polygon dest = new Polygon();
        for (int i = 0; i < virt.npoints; ++i) {
            double x = this.vdX(virt.xpoints[i]);
            double y = this.vdY(virt.ypoints[i]);
            dest.addPoint((int)Math.round(x), (int)Math.round(y));
        }
        return dest;
    }

    public GeneralPath virtToDestPath(Polygon virt) {
        GeneralPath path = new GeneralPath();
        for (int i = 0; i < virt.npoints; ++i) {
            float x = (float)this.vdX(virt.xpoints[i]);
            float y = (float)this.vdY(virt.ypoints[i]);
            if (i == 0) {
                path.moveTo(x, y);
            }
            path.lineTo(x, y);
        }
        return path;
    }

    public Rectangle virtToDest(Rectangle virt) {
        double dTop = this.vdY(virt.y) - this.virtToDestHeight(virt.getHeight());
        double dBot = this.vdY(virt.y);
        int top = (int)Math.round(dTop);
        int bottom = (int)Math.round(dBot);
        int height = bottom - top;
        double dLeft = this.vdX(virt.x);
        double dRight = this.vdX(virt.x) + this.virtToDestWidth(virt.getWidth());
        int left = (int)Math.round(dLeft);
        int right = (int)Math.round(dRight);
        int width = right - left;
        Rectangle dest = new Rectangle(left, top, width, height);
        return dest;
    }

    public Rectangle virtToDestConstLength(Rectangle virt) {
        int top = (int)Math.round(this.vdY(virt.getMaxY()));
        int height = Math.round(this.virtToDestHeight(virt.height));
        int left = (int)Math.round(this.vdX(virt.x));
        int width = Math.round(this.virtToDestWidth(virt.width));
        Rectangle dest = new Rectangle(left, top, width, height);
        return dest;
    }

    public double virtToDestHeight(double fVHeight) {
        return fVHeight * this.m_vdHeight;
    }

    public int virtToDestHeight(int nVHeight) {
        return (int)Math.round((double)nVHeight * this.m_vdHeight);
    }

    public double virtToDestWidth(double fVWidth) {
        return fVWidth * this.m_vdWidth;
    }

    public int virtToDestWidth(int nVWidth) {
        return (int)Math.round((double)nVWidth * this.m_vdWidth);
    }

    public int virtToDestX(int x) {
        return (int)Math.round(this.vdX(x));
    }

    public double virtToDestX(double x) {
        return this.vdX(x);
    }

    public int virtToDestY(int y) {
        return (int)Math.round(this.vdY(y));
    }

    public double destToVirtX(double x) {
        return this.dvX(x);
    }

    public double destToVirtY(double y) {
        return this.dvY(y);
    }

    public double virtToDestY(double vy) {
        return this.vdY(vy);
    }
}

