/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.io.Serializable;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.PerspectiveBase;
import oracle.dss.graph.pfj.draw.IdentObj;

public class LookKeyObj
implements Serializable {
    private static final long serialVersionUID = 1L;
    Attr m_attr;
    private int m_attrID;
    private int m_objectID;
    private int m_seriesID;
    private int m_groupID;
    private int m_stackID;
    private int m_miscID;
    private int m_hashCode;

    protected LookKeyObj() {
        this.m_attr = null;
        this.m_attrID = -1;
        this.m_objectID = -1;
        this.m_seriesID = -1;
        this.m_groupID = -1;
        this.m_stackID = -1;
        this.m_miscID = -1;
        this.m_hashCode = -1;
    }

    private LookKeyObj(Attr attr, IdentObj id) {
        this.init(attr, id);
    }

    protected static LookKeyObj newSetInstance(Attr attr, IdentObj id) {
        return new LookKeyObj(attr, id);
    }

    protected static LookKeyObj getSetInstance(Attr attr, IdentObj id, LookKeyObj reuseKey) {
        return LookKeyObj._getInstance(attr, id, reuseKey);
    }

    protected static LookKeyObj getGetInstance(Attr attr, IdentObj id, PerspectiveBase pfj, LookKeyObj reuseKey) {
        int seriesID = pfj.getEffectiveSeriesIndex(id.getSeriesID());
        if (id.useSeriesLooping()) {
            seriesID %= pfj.getSeriesLooping();
        }
        LookKeyObj key = LookKeyObj._getInstance(attr, id, reuseKey);
        key.m_seriesID = seriesID;
        return key;
    }

    private static LookKeyObj _getInstance(Attr attr, IdentObj id, LookKeyObj key) {
        LookKeyObj ret = key;
        if (ret == null) {
            ret = new LookKeyObj(attr, id);
        } else {
            ret.init(attr, id);
        }
        return ret;
    }

    public void init(Attr attr, IdentObj id) {
        this.m_attr = attr;
        this.m_attrID = attr.getAttrID();
        this.m_objectID = id.getObjectID();
        this.m_seriesID = id.getSeriesID();
        this.m_groupID = id.getGroupID();
        this.m_stackID = id.getStackID();
        this.m_miscID = id.getMiscID();
        this.m_hashCode = -1;
    }

    public boolean equals(Object x) {
        if (!(x instanceof LookKeyObj)) {
            return false;
        }
        LookKeyObj xKey = (LookKeyObj)x;
        if (this.m_stackID != xKey.m_stackID) {
            return false;
        }
        if (this.m_miscID != xKey.m_miscID) {
            return false;
        }
        if (!this.m_attr.equals(xKey.m_attr)) {
            return false;
        }
        if (this.m_objectID != xKey.m_objectID) {
            return false;
        }
        if (this.m_seriesID != xKey.m_seriesID) {
            return false;
        }
        return this.m_groupID == xKey.m_groupID;
    }

    public int hashCode() {
        if (this.m_hashCode == -1) {
            this.m_hashCode = 17;
            this.m_hashCode = 31 * this.m_hashCode + this.m_attrID;
            this.m_hashCode = 31 * this.m_hashCode + this.m_objectID;
            this.m_hashCode = 31 * this.m_hashCode + this.m_seriesID;
            this.m_hashCode = 31 * this.m_hashCode + this.m_groupID;
        }
        return this.m_hashCode;
    }

    public String toString() {
        StringBuilder sb = DataviewUtils.getSharedStringBuilder();
        sb.append("*** ").append(this.m_attr.toString()).append("+1.0+").append(this.m_objectID);
        sb.append("+").append(this.m_seriesID).append("+").append(this.m_groupID).append("+");
        sb.append(this.m_stackID).append("+").append(this.m_miscID).append("+");
        return sb.toString();
    }

    public Attr getAttr() {
        return this.m_attr;
    }
}

