/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Rectangle;
import java.io.Serializable;
import oracle.dss.graph.pfj.LegendObj;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.IdentObj;

public class LegendScroller
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int PRESENCE_NEVER = 0;
    public static final int PRESENCE_SOMETIMES = 1;
    public static final int PRESENCE_ALWAYS = 2;
    protected int m_nScrollerThicknessHorz = 12;
    protected int m_nScrollerThicknessVert = 8;
    protected Perspective m_Perspective;
    protected LegendObj m_Legend;
    protected Rectangle m_rFrame;
    protected Rectangle m_rScroller;
    protected boolean m_bVert;
    protected int m_nTotal;
    protected int m_nCount;
    protected int m_nStart;

    public LegendScroller(Perspective perspective, LegendObj legend, Rectangle rFrame, boolean bVert) {
        this.m_Perspective = perspective;
        this.m_Legend = legend;
        this.m_rFrame = rFrame;
        this.m_bVert = bVert;
        this.m_nTotal = this.m_Legend.getNumItemsInLegend();
        this.m_nCount = this.m_Legend.getSeriesCount();
        this.m_nStart = this.m_Legend.getSeriesStart();
    }

    public void calc() {
        Rectangle rThumb;
        Rectangle rScroller;
        int nWidth;
        int nHeight;
        if (this.m_rFrame == null) {
            return;
        }
        this.adjustScrollerThickness();
        IdentObj idScroller = this.m_Perspective.getLegendScroller();
        IdentObj idThumb = this.m_Perspective.getLegendScrollerThumb();
        BlackBoxObj bbScroller = new BlackBoxObj(this.m_Perspective, idScroller);
        BlackBoxObj bbThumb = new BlackBoxObj(this.m_Perspective, idThumb);
        int nHigh = this.m_nTotal - (this.m_nStart + this.m_nCount);
        if (this.m_bVert) {
            nHeight = this.m_rFrame.height;
            nWidth = this.m_Perspective.m_VC.destToVirtWidth(this.m_nScrollerThicknessHorz);
            rScroller = new Rectangle(this.m_rFrame.x, this.m_rFrame.y, nWidth, nHeight);
        } else {
            nHeight = this.m_Perspective.m_VC.destToVirtHeight(this.m_nScrollerThicknessVert);
            nWidth = this.m_rFrame.width;
            rScroller = new Rectangle(this.m_rFrame.x, this.m_rFrame.y, nWidth, nHeight);
        }
        new DetRect(this.m_Perspective.m_Detectiv, idScroller, rScroller, (BlackBoxIF)bbScroller, null);
        this.m_Perspective.setRect(this.m_Perspective.getLegendScroller(), rScroller);
        int nExtra = this.m_nTotal - this.m_nCount;
        if (this.m_bVert) {
            int nThumbHeight = rScroller.height * this.m_nCount / this.m_nTotal;
            int nVirtHeightBounds = this.m_Perspective.m_VC.destToVirtHeight(this.m_nScrollerThicknessHorz);
            if (nThumbHeight < nVirtHeightBounds) {
                nThumbHeight = nVirtHeightBounds;
            }
            int nThumbCenter = nExtra == 0 ? rScroller.y + rScroller.height - nThumbHeight / 2 : rScroller.y + rScroller.height - nThumbHeight / 2 - this.m_nStart * (rScroller.height - nThumbHeight) / nExtra;
            rThumb = new Rectangle(rScroller.x, nThumbCenter - nThumbHeight / 2, nWidth, nThumbHeight);
        } else {
            int nThumbWidth = rScroller.width / this.m_nCount;
            int VirtWidthBounds = this.m_Perspective.m_VC.destToVirtWidth(this.m_nScrollerThicknessVert);
            if (nThumbWidth < VirtWidthBounds) {
                nThumbWidth = VirtWidthBounds;
            }
            int nThumbCenter = nExtra == 0 ? rScroller.x + nThumbWidth / 2 : rScroller.x + nThumbWidth / 2 + this.m_nStart * (rScroller.width - nThumbWidth) / nExtra;
            rThumb = new Rectangle(nThumbCenter - nThumbWidth / 2, rScroller.y, nThumbWidth, nHeight);
        }
        new DetRect(this.m_Perspective.m_Detectiv, idThumb, rThumb, (BlackBoxIF)bbThumb, rScroller);
    }

    protected void adjustScrollerThickness() {
        Rectangle rLegend = this.m_Perspective.getLegendRect();
        if (rLegend.height > 3250) {
            this.m_nScrollerThicknessVert = 10;
        }
        if (rLegend.width < 3250) {
            this.m_nScrollerThicknessHorz = 10;
        }
        if (rLegend.width < 2000) {
            this.m_nScrollerThicknessHorz = 8;
        }
    }

    public int getScrollerHeightVC() {
        int nHeight = this.m_Perspective.m_VC.destToVirtHeight(this.m_nScrollerThicknessVert);
        return nHeight;
    }

    public int getScrollerWidthVC() {
        int nWidth = this.m_Perspective.m_VC.destToVirtWidth(this.m_nScrollerThicknessHorz);
        return nWidth;
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }
}

