/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.io.Serializable;
import oracle.dss.graph.pfj.AxisDescriptor;
import oracle.dss.graph.pfj.DataFormat;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.PfjAssert;

public final class JGraphType
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final String JCHART_3D = "JChart_3D";
    static final String JCHART_3D_SURFACE = "JChart_3D_Surf";
    static final String JCHART_2D_BLA = "JChart_2D_BLA";
    static final String JCHART_2D_BOXPLOT = "JChart_2D_BoxPlot";
    static final String JCHART_2D_HILO = "JChart_2D_Hilo";
    static final String JCHART_2D_SCAT = "JChart_2D_Scat";
    static final String JCHART_2D_SPEC = "JChart_2D_Spec";
    static final String JCHART_2D_HIST = "JChart_2D_Hist";
    static final String JCHART_2D_PIE = "JChart_2D_Pie";
    static final String JCHART_2D_FUNNEL = "JChart_2D_Funnel";
    static final String JCHART_2D_PIEBAR = "JChart_2D_PieBar";
    static final String JCHART_2D_RADAR = "JChart_2D_Radar";
    static final String JCHART_2D_POLAR = "JChart_2D_Polar";
    static final String JCHART_2D_BREAKEVEN = "JChart_2D_Breakeven";
    static final String JCHART_2D_GANTT = "JChart_2D_Gantt";
    static final String JCHART_2D_PARETO = "JChart_2D_Pareto";
    static final String JCHART_2D_RESOURCE = "JChart_2D_Resource";
    static final String JCHART_2D_PPA = "JChart_2D_PPA";
    static final String JCHART_2D_BALSCORE = "JChart_2D_BalScore";
    static final String JCHART_2D_WATERFALL = "JChart_2D_Waterfall";
    public static final int ORIENT_HORZ = 1;
    public static final int ORIENT_VERT = 2;
    public static final int RESIZE_X = 0;
    public static final int RESIZE_Y = 1;
    public static final int RISER_UNSPECIFIED = 0;
    public static final int RISER_BAR = 1;
    public static final int RISER_MARKER = 2;
    public static final int RISER_AREA = 3;
    public static final int RISER_3D_BAR = 4;
    public static final int RISER_3D_FLOATING = 5;
    public static final int RISER_3D_CONN_SERIES = 6;
    public static final int RISER_3D_SURFACE = 7;
    public static final int RISER_3D_MARKER = 8;
    public static final int RISER_SLICE = 9;
    public static final int RISER_CELL = 10;
    public static final int RISER_3D_CONN_GROUPS = 11;
    public static final int PARETO_LINE_BAR = 12;
    public static final int SCALING_ABSOLUTE = 1;
    public static final int SCALING_STACKED = 2;
    public static final int SCALING_PERCENT = 3;
    public static final int SCALING_HIST = 4;
    public static final int SCALING_WATERFALL = 5;
    public static final int THREED_BAR = 0;
    public static final int THREED_PYRAMID = 1;
    public static final int THREED_OCTAGON = 2;
    public static final int THREED_CUBE = 4;
    public static final int THREED_DIAMOND = 5;
    public static final int THREED_AREASERIES = 6;
    public static final int THREED_RIBBONSERIES = 7;
    public static final int THREED_AREAGROUP = 9;
    public static final int THREED_RIBBONGROUP = 10;
    public static final int THREED_SURFACE = 12;
    public static final int THREED_SURFACESIDES = 13;
    public static final int THREED_SURFACEHONEYCOMB = 14;
    public static final int BARVERT_SIDESIDE = 17;
    public static final int BARVERT_STACKED = 18;
    public static final int BARVERT_SIDEDUAL = 19;
    public static final int BARVERT_STACKEDDUAL = 20;
    public static final int BARVERT_SIDEBIPOLAR = 21;
    public static final int BARVERT_STACKEDBIPOLAR = 22;
    public static final int BARVERT_PERCENT = 23;
    public static final int BARHORIZ_SIDESIDE = 24;
    public static final int BARHORIZ_STACKED = 25;
    public static final int BARHORIZ_SIDEDUAL = 26;
    public static final int BARHORIZ_STACKEDDUAL = 27;
    public static final int BARHORIZ_SIDEBIPOLAR = 28;
    public static final int BARHORIZ_STACKEDBIPOLAR = 29;
    public static final int BARHORIZ_PERCENT = 30;
    public static final int AREAVERT_ABS = 31;
    public static final int AREAVERT_STACKED = 32;
    public static final int AREAVERT_ABSBIPOLAR = 33;
    public static final int AREAVERT_STACKEDBIPOLAR = 34;
    public static final int AREAVERT_PERCENT = 35;
    public static final int AREAHORIZ_ABS = 36;
    public static final int AREAHORIZ_STACKED = 37;
    public static final int AREAHORIZ_ABSBIPOLAR = 38;
    public static final int AREAHORIZ_STACKEDBIPOLAR = 39;
    public static final int AREAHORIZ_PERCENT = 40;
    public static final int LINEVERT_ABS = 41;
    public static final int LINEVERT_STACKED = 42;
    public static final int LINEVERT_ABSDUAL = 43;
    public static final int LINEVERT_STACKEDDUAL = 44;
    public static final int LINEVERT_ABSBIPOLAR = 45;
    public static final int LINEVERT_STACKEDBIPOLAR = 46;
    public static final int LINEVERT_PERCENT = 47;
    public static final int LINEHORIZ_ABS = 48;
    public static final int LINEHORIZ_STACKED = 49;
    public static final int LINEHORIZ_ABSDUAL = 50;
    public static final int LINEHORIZ_STACKEDDUAL = 51;
    public static final int LINEHORIZ_ABSBIPOLAR = 52;
    public static final int LINEHORIZ_STACKEDBIPOLAR = 53;
    public static final int LINEHORIZ_PERCENT = 54;
    public static final int PIE = 55;
    public static final int PIE_RING = 56;
    public static final int PIE_MULT = 57;
    public static final int PIE_RINGMULT = 58;
    public static final int PIE_MULTPROP = 59;
    public static final int PIE_RINGMULTPROP = 60;
    public static final int SCATTER = 61;
    public static final int SCATTER_DUAL = 62;
    public static final int SCATTER_LABELS = 63;
    public static final int SCATTER_LABELSDUAL = 64;
    public static final int POLAR = 65;
    public static final int POLAR_DUAL = 66;
    public static final int RADAR_LINE = 67;
    public static final int RADAR_AREA = 68;
    public static final int RADAR_LINE_DUAL = 69;
    public static final int STOCKHILO = 73;
    public static final int STOCKHILO_DUAL = 74;
    public static final int STOCKHILO_BIPOLAR = 75;
    public static final int STOCKHILO_CLOSE = 76;
    public static final int STOCKHILO_CLOSEDUAL = 77;
    public static final int STOCKHILO_CLOSEBIPOLAR = 78;
    public static final int STOCKHILO_OPENCLOSE = 79;
    public static final int STOCKHILO_OPENCLOSEDUAL = 80;
    public static final int STOCKHILO_OPENCLOSEBIPOLAR = 81;
    public static final int STOCKHILO_VOLUME = 82;
    public static final int STOCKHILO_CLOSE_VOLUME = 88;
    public static final int STOCKHILO_OPENCLOSE_VOLUME = 83;
    public static final int STOCKHILO_CANDLE = 70;
    public static final int STOCKHILO_CANDLE_VOLUME = 71;
    public static final int STOCK_CANDLE = 72;
    public static final int STOCK_CANDLE_VOLUME = 84;
    public static final int HIST_VERT = 85;
    public static final int HIST_HORIZ = 86;
    public static final int SPECTRAL = 87;
    public static final int BUBBLE = 89;
    public static final int BUBBLE_LABELS = 90;
    public static final int BUBBLE_DUAL = 91;
    public static final int BUBBLE_LABELSDUAL = 92;
    public static final int PIE_BAR = 93;
    public static final int PIE_BAR_RING = 94;
    public static final int WATERFALL_VERT = 95;
    public static final int PARETO = 96;
    public static final int COMBOVERT_SIDESIDE = 97;
    public static final int COMBOVERT_SIDEDUAL = 98;
    public static final int LINE_SELECT_POINT = 99;
    public static final int FUNNEL = 100;
    public static final int BOXPLOT_FIVE_VALUE = 101;
    public static final int BOXPLOT_SEVEN_VALUE = 102;
    private static final int last_bibeans_graphType = 102;
    public static final int RESOURCE_RETURN = 103;
    public static final int PRODUCT_POSITIONING = 104;
    public static final int BALANCED_SCORECARD = 105;
    public static final int BREAKEVEN = 106;
    public static final int GANTT = 107;
    public static final int BARVERT_SIDESIDE_THREEY = 108;
    public static final int BARVERT_SIDESIDE_FOURY = 109;
    public static final int BARVERT_SIDESIDE_FIVEY = 110;
    public static final int WATERFALL_HORZ = 111;
    public static final int MAX_GRAPH_TYPES = 111;
    public static final JGraphType JGT_THREED_BAR = new JGraphType(0, "THREED_BAR", "JChart_3D", 4, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_PYRAMID = new JGraphType(1, "THREED_PYRAMID", "JChart_3D", 4, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_OCTAGON = new JGraphType(2, "THREED_OCTAGON", "JChart_3D", 4, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_CUBE = new JGraphType(4, "THREED_CUBE", "JChart_3D", 5, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_DIAMOND = new JGraphType(5, "THREED_DIAMOND", "JChart_3D", 5, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_AREASERIES = new JGraphType(6, "THREED_AREASERIES", "JChart_3D", 6, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_RIBBONSERIES = new JGraphType(7, "THREED_RIBBONSERIES", "JChart_3D", 6, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_AREAGROUP = new JGraphType(9, "THREED_AREAGROUP", "JChart_3D", 11, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_RIBBONGROUP = new JGraphType(10, "THREED_RIBBONGROUP", "JChart_3D", 11, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_SURFACE = new JGraphType(12, "THREED_SURFACE", "JChart_3D_Surf", 7, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_SURFACESIDES = new JGraphType(13, "THREED_SURFACESIDES", "JChart_3D_Surf", 7, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_SURFACEHONEYCOMB = new JGraphType(14, "THREED_SURFACEHONEYCOMB", "JChart_3D_Surf", 7, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_BARVERT_SIDESIDE = new JGraphType(17, "BARVERT_SIDESIDE", "JChart_2D_BLA", 1, false, false, 2, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_BARVERT_STACKED = new JGraphType(18, "BARVERT_STACKED", "JChart_2D_BLA", 1, false, false, 2, 2, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_BARVERT_SIDEDUAL = new JGraphType(19, "BARVERT_SIDEDUAL", "JChart_2D_BLA", 1, true, false, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_BARVERT_STACKEDDUAL = new JGraphType(20, "BARVERT_STACKEDDUAL", "JChart_2D_BLA", 1, true, false, 2, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_BARVERT_SIDEBIPOLAR = new JGraphType(21, "BARVERT_SIDEBIPOLAR", "JChart_2D_BLA", 1, true, true, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_BARVERT_STACKEDBIPOLAR = new JGraphType(22, "BARVERT_STACKEDBIPOLAR", "JChart_2D_BLA", 1, true, true, 2, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_BARVERT_PERCENT = new JGraphType(23, "BARVERT_PERCENT", "JChart_2D_BLA", 1, false, false, 2, 3, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_BARHORIZ_SIDESIDE = new JGraphType(24, "BARHORIZ_SIDESIDE", "JChart_2D_BLA", 1, false, false, 1, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_BARHORIZ_STACKED = new JGraphType(25, "BARHORIZ_STACKED", "JChart_2D_BLA", 1, false, false, 1, 2, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_BARHORIZ_SIDEDUAL = new JGraphType(26, "BARHORIZ_SIDEDUAL", "JChart_2D_BLA", 1, true, false, 1, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_BARHORIZ_STACKEDDUAL = new JGraphType(27, "BARHORIZ_STACKEDDUAL", "JChart_2D_BLA", 1, true, false, 1, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_BARHORIZ_SIDEBIPOLAR = new JGraphType(28, "BARHORIZ_SIDEBIPOLAR", "JChart_2D_BLA", 1, true, true, 1, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_BARHORIZ_STACKEDBIPOLAR = new JGraphType(29, "BARHORIZ_STACKEDBIPOLAR", "JChart_2D_BLA", 1, true, true, 1, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_BARHORIZ_PERCENT = new JGraphType(30, "BARHORIZ_PERCENT", "JChart_2D_BLA", 1, false, false, 1, 3, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_AREAVERT_ABS = new JGraphType(31, "AREAVERT_ABS", "JChart_2D_BLA", 3, false, false, 2, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_AREAVERT_STACKED = new JGraphType(32, "AREAVERT_STACKED", "JChart_2D_BLA", 3, false, false, 2, 2, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_AREAVERT_ABSBIPOLAR = new JGraphType(33, "AREAVERT_ABSBIPOLAR", "JChart_2D_BLA", 3, true, true, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_AREAVERT_STACKEDBIPOLAR = new JGraphType(34, "AREAVERT_STACKEDBIPOLAR", "JChart_2D_BLA", 3, true, true, 2, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_AREAVERT_PERCENT = new JGraphType(35, "AREAVERT_PERCENT", "JChart_2D_BLA", 3, false, false, 2, 3, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_AREAHORIZ_ABS = new JGraphType(36, "AREAHORIZ_ABS", "JChart_2D_BLA", 3, false, false, 1, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_AREAHORIZ_STACKED = new JGraphType(37, "AREAHORIZ_STACKED", "JChart_2D_BLA", 3, false, false, 1, 2, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_AREAHORIZ_ABSBIPOLAR = new JGraphType(38, "AREAHORIZ_ABSBIPOLAR", "JChart_2D_BLA", 3, true, true, 1, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_AREAHORIZ_STACKEDBIPOLAR = new JGraphType(39, "AREAHORIZ_STACKEDBIPOLAR", "JChart_2D_BLA", 3, true, true, 1, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_AREAHORIZ_PERCENT = new JGraphType(40, "AREAHORIZ_PERCENT", "JChart_2D_BLA", 3, false, false, 1, 3, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_LINEVERT_ABS = new JGraphType(41, "LINEVERT_ABS", "JChart_2D_BLA", 2, false, false, 2, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_LINEVERT_STACKED = new JGraphType(42, "LINEVERT_STACKED", "JChart_2D_BLA", 2, false, false, 2, 2, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_LINEVERT_ABSDUAL = new JGraphType(43, "LINEVERT_ABSDUAL", "JChart_2D_BLA", 2, true, false, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_LINEVERT_STACKEDDUAL = new JGraphType(44, "LINEVERT_STACKEDDUAL", "JChart_2D_BLA", 2, true, false, 2, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_LINEVERT_ABSBIPOLAR = new JGraphType(45, "LINEVERT_ABSBIPOLAR", "JChart_2D_BLA", 2, true, true, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_LINEVERT_STACKEDBIPOLAR = new JGraphType(46, "LINEVERT_STACKEDBIPOLAR", "JChart_2D_BLA", 2, true, true, 2, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_LINEVERT_PERCENT = new JGraphType(47, "LINEVERT_PERCENT", "JChart_2D_BLA", 2, false, false, 2, 3, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_LINEHORIZ_ABS = new JGraphType(48, "LINEHORIZ_ABS", "JChart_2D_BLA", 2, false, false, 1, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_LINEHORIZ_STACKED = new JGraphType(49, "LINEHORIZ_STACKED", "JChart_2D_BLA", 2, false, false, 1, 2, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_LINEHORIZ_ABSDUAL = new JGraphType(50, "LINEHORIZ_ABSDUAL", "JChart_2D_BLA", 2, true, false, 1, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_LINEHORIZ_STACKEDDUAL = new JGraphType(51, "LINEHORIZ_STACKEDDUAL", "JChart_2D_BLA", 2, true, false, 1, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_LINEHORIZ_ABSBIPOLAR = new JGraphType(52, "LINEHORIZ_ABSBIPOLAR", "JChart_2D_BLA", 2, true, true, 1, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_LINEHORIZ_STACKEDBIPOLAR = new JGraphType(53, "LINEHORIZ_STACKEDBIPOLAR", "JChart_2D_BLA", 2, true, true, 1, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_LINEHORIZ_PERCENT = new JGraphType(54, "LINEHORIZ_PERCENT", "JChart_2D_BLA", 2, false, false, 1, 3, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_PIE = new JGraphType(55, "PIE", "JChart_2D_Pie", 9, AxisDescriptor.AD_PIE);
    public static final JGraphType JGT_PIE_RING = new JGraphType(56, "PIE_RING", "JChart_2D_Pie", 9, AxisDescriptor.AD_PIE);
    public static final JGraphType JGT_PIE_MULT = new JGraphType(57, "PIE_MULT", "JChart_2D_Pie", 9, AxisDescriptor.AD_PIE);
    public static final JGraphType JGT_PIE_RINGMULT = new JGraphType(58, "PIE_RINGMULT", "JChart_2D_Pie", 9, AxisDescriptor.AD_PIE);
    public static final JGraphType JGT_PIE_MULTPROP = new JGraphType(59, "PIE_MULTPROP", "JChart_2D_Pie", 9, AxisDescriptor.AD_PIE);
    public static final JGraphType JGT_PIE_RINGMULTPROP = new JGraphType(60, "PIE_RINGMULTPROP", "JChart_2D_Pie", 9, AxisDescriptor.AD_PIE);
    public static final JGraphType JGT_FUNNEL = new JGraphType(100, "FUNNEL", "JChart_2D_Funnel", 9, AxisDescriptor.AD_PIE);
    public static final JGraphType JGT_SCATTER = new JGraphType(61, "SCATTER", "JChart_2D_Scat", DataFormat.DF_XY, 2, AxisDescriptor.AD_XY);
    public static final JGraphType JGT_LINE_SELECT_POINT = new JGraphType(99, "LINE_SELECT_POINT", "JChart_2D_Scat", DataFormat.DF_XY, 2, AxisDescriptor.AD_XY);
    public static final JGraphType JGT_SCATTER_DUAL = new JGraphType(62, "SCATTER_DUAL", "JChart_2D_Scat", DataFormat.DF_XY, 2, true, false, 2, 1, AxisDescriptor.AD_XY_DY);
    public static final JGraphType JGT_SCATTER_LABELS = new JGraphType(63, "SCATTER_LABELS", "JChart_2D_Scat", DataFormat.DF_XY_LBL, 2, AxisDescriptor.AD_XY);
    public static final JGraphType JGT_SCATTER_LABELSDUAL = new JGraphType(64, "SCATTER_LABELSDUAL", "JChart_2D_Scat", DataFormat.DF_XY_LBL, 2, true, false, 2, 1, AxisDescriptor.AD_XY_DY);
    public static final JGraphType JGT_POLAR = new JGraphType(65, "POLAR", "JChart_2D_Polar", DataFormat.DF_XY, 2, AxisDescriptor.AD_XY);
    public static final JGraphType JGT_POLAR_DUAL = new JGraphType(66, "POLAR_DUAL", "JChart_2D_Polar", DataFormat.DF_XY, 2, true, false, 2, 1, AxisDescriptor.AD_XY_DY);
    public static final JGraphType JGT_RADAR_LINE = new JGraphType(67, "RADAR_LINE", "JChart_2D_Radar", 2, false, false, 2, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_RADAR_AREA = new JGraphType(68, "RADAR_AREA", "JChart_2D_Radar", 3, false, false, 2, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_RADAR_LINE_DUAL = new JGraphType(69, "RADAR_LINE_DUAL", "JChart_2D_Radar", 2, true, false, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_GANTT = new JGraphType(107, "GANTT", "JChart_2D_Gantt", DataFormat.DF_GANTT, 2, AxisDescriptor.AD_XY);
    public static final JGraphType JGT_STOCKHILO = new JGraphType(73, "STOCKHILO", "JChart_2D_Hilo", DataFormat.DF_HL, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_STOCKHILO_DUAL = new JGraphType(74, "STOCKHILO_DUAL", "JChart_2D_Hilo", DataFormat.DF_HL, 1, true, false, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_BIPOLAR = new JGraphType(75, "STOCKHILO_BIPOLAR", "JChart_2D_Hilo", DataFormat.DF_HL, 1, true, true, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_CLOSE = new JGraphType(76, "STOCKHILO_CLOSE", "JChart_2D_Hilo", DataFormat.DF_HLC, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_STOCKHILO_CLOSEDUAL = new JGraphType(77, "STOCKHILO_CLOSEDUAL", "JChart_2D_Hilo", DataFormat.DF_HLC, 1, true, false, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_CLOSEBIPOLAR = new JGraphType(78, "STOCKHILO_CLOSEBIPOLAR", "JChart_2D_Hilo", DataFormat.DF_HLC, 1, true, true, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_OPENCLOSE = new JGraphType(79, "STOCKHILO_OPENCLOSE", "JChart_2D_Hilo", DataFormat.DF_OHLC, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_STOCKHILO_OPENCLOSEDUAL = new JGraphType(80, "STOCKHILO_OPENCLOSEDUAL", "JChart_2D_Hilo", DataFormat.DF_OHLC, 1, true, false, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_OPENCLOSEBIPOLAR = new JGraphType(81, "STOCKHILO_OPENCLOSEBIPOLAR", "JChart_2D_Hilo", DataFormat.DF_OHLC, 1, true, true, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_VOLUME = new JGraphType(82, "STOCKHILO_VOLUME", "JChart_2D_Hilo", DataFormat.DF_HL_VOL, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_CLOSE_VOLUME = new JGraphType(88, "STOCKHILO_CLOSE_VOLUME", "JChart_2D_Hilo", DataFormat.DF_HLC_VOL, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_OPENCLOSE_VOLUME = new JGraphType(83, "STOCKHILO_OPENCLOSE_VOLUME", "JChart_2D_Hilo", DataFormat.DF_OHLC_VOL, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_CANDLE = new JGraphType(70, "STOCKHILO_CANDLE", "JChart_2D_Hilo", DataFormat.DF_OHLC, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_STOCKHILO_CANDLE_VOLUME = new JGraphType(71, "STOCKHILO_CANDLE_VOLUME", "JChart_2D_Hilo", DataFormat.DF_OHLC_VOL, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_STOCK_CANDLE = new JGraphType(72, "STOCK_CANDLE", "JChart_2D_Hilo", DataFormat.DF_OC, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_STOCK_CANDLE_VOLUME = new JGraphType(84, "STOCK_CANDLE_VOLUME", "JChart_2D_Hilo", DataFormat.DF_OC_VOL, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_BOXPLOT_FIVE_VALUE = new JGraphType(101, "BOXPLOT_FIVE_VALUE", "JChart_2D_BoxPlot", DataFormat.DF_FV, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_BOXPLOT_SEVEN_VALUE = new JGraphType(102, "BOXPLOT_SEVEN_VALUE", "JChart_2D_BoxPlot", DataFormat.DF_SV, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_HIST_VERT = new JGraphType(85, "HIST_VERT", "JChart_2D_Hist", 1, false, false, 2, 4, AxisDescriptor.AD_XY);
    public static final JGraphType JGT_HIST_HORIZ = new JGraphType(86, "HIST_HORIZ", "JChart_2D_Hist", 1, false, false, 1, 4, AxisDescriptor.AD_XY);
    public static final JGraphType JGT_SPECTRAL = new JGraphType(87, "SPECTRAL", "JChart_2D_Spec", 2, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_BUBBLE = new JGraphType(89, "BUBBLE", "JChart_2D_Scat", DataFormat.DF_XYZ, 2, AxisDescriptor.AD_XYZ);
    public static final JGraphType JGT_BUBBLE_LABELS = new JGraphType(90, "BUBBLE_LABELS", "JChart_2D_Scat", DataFormat.DF_XYZ_LBL, 2, AxisDescriptor.AD_XYZ);
    public static final JGraphType JGT_BUBBLE_DUAL = new JGraphType(91, "BUBBLE_DUAL", "JChart_2D_Scat", DataFormat.DF_XYZ, 2, true, false, 2, 1, AxisDescriptor.AD_XYZ_DY);
    public static final JGraphType JGT_BUBBLE_LABELSDUAL = new JGraphType(92, "BUBBLE_LABELSDUAL", "JChart_2D_Scat", DataFormat.DF_XYZ_LBL, 2, true, false, 2, 1, AxisDescriptor.AD_XYZ_DY);
    public static final JGraphType JGT_PIE_BAR = new JGraphType(93, "PIE_BAR", "JChart_2D_PieBar", 9, AxisDescriptor.AD_PIE);
    public static final JGraphType JGT_PIE_BAR_RING = new JGraphType(94, "PIE_BAR_RING", "JChart_2D_PieBar", 9, AxisDescriptor.AD_PIE);
    public static final JGraphType JGT_RESOURCE_RETURN = new JGraphType(103, "RESOURCE_RETURN", "JChart_2D_Resource", DataFormat.DF_RESOURCE, 1, false, false, 2, 2, AxisDescriptor.AD_XY);
    public static final JGraphType JGT_PRODUCT_POSITIONING = new JGraphType(104, "PRODUCT_POSITIONING", "JChart_2D_PPA", DataFormat.DF_XYZ, 2, AxisDescriptor.AD_XYZ);
    public static final JGraphType JGT_BALANCED_SCORECARD = new JGraphType(105, "BALANCED_SCORECARD", "JChart_2D_BalScore", 1, false, false, 1, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_BREAKEVEN = new JGraphType(106, "BREAKEVEN", "JChart_2D_Breakeven", DataFormat.DF_BREAKEVEN, 2, AxisDescriptor.AD_XY);
    public static final JGraphType JGT_WATERFALL_VERT = new JGraphType(95, "WATERFALL_VERT", "JChart_2D_BLA", DataFormat.DF_GENERAL, 1, false, false, 2, 2, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_WATERFALL_HORZ = new JGraphType(111, "WATERFALL_HORZ", "JChart_2D_Waterfall", DataFormat.DF_GENERAL, 1, false, false, 1, 5, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_PARETO = new JGraphType(96, "PARETO", "JChart_2D_Pareto", 12, false, false, 2, 1, AxisDescriptor.AD_PARETO);
    public static final JGraphType JGT_BARVERT_SIDESIDE_THREEY = new JGraphType(108, "BARVERT_SIDESIDE", "JChart_2D_BLA", 1, false, false, 2, 1, AxisDescriptor.AD_STD_THREEY);
    public static final JGraphType JGT_BARVERT_SIDESIDE_FOURY = new JGraphType(109, "BARVERT_SIDESIDE", "JChart_2D_BLA", 1, false, false, 2, 1, AxisDescriptor.AD_STD_FOURY);
    public static final JGraphType JGT_BARVERT_SIDESIDE_FIVEY = new JGraphType(110, "BARVERT_SIDESIDE", "JChart_2D_BLA", 1, false, false, 2, 1, AxisDescriptor.AD_STD_FIVEY);
    public static final JGraphType JGT_COMBOVERT_SIDESIDE = new JGraphType(97, "COMBOVERT_SIDESIDE", "JChart_2D_BLA", 1, false, false, 2, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_COMBOVERT_SIDEDUAL = new JGraphType(98, "COMBOVERT_SIDEDUAL", "JChart_2D_BLA", 1, true, false, 2, 1, AxisDescriptor.AD_STD_DY);
    private int m_id;
    private String m_name;
    private String m_class;
    private DataFormat m_dataformat;
    private int m_riserType;
    private boolean m_bDualY;
    private boolean m_bBipolar;
    private int m_orientation;
    private int m_scalingMethod;
    private AxisDescriptor m_axisDescriptor;

    private JGraphType(int id, String name, String classname, int riserType, AxisDescriptor axisDescriptor) {
        this(id, name, classname, DataFormat.DF_GENERAL, riserType, false, false, 2, 1, axisDescriptor);
    }

    private JGraphType(int id, String name, String classname, int riserType, boolean bDualY, boolean bBipolar, int orientation, int scalingMethod, AxisDescriptor axisDescriptor) {
        this(id, name, classname, DataFormat.DF_GENERAL, riserType, bDualY, bBipolar, orientation, scalingMethod, axisDescriptor);
    }

    private JGraphType(int id, String name, String classname, DataFormat df, int riserType, AxisDescriptor axisDescriptor) {
        this(id, name, classname, df, riserType, false, false, 2, 1, axisDescriptor);
    }

    private JGraphType(int id, String name, String classname, DataFormat df, int riserType, boolean bDualY, boolean bBipolar, int orientation, int scalingMethod, AxisDescriptor axisDescriptor) {
        this.m_id = id;
        this.m_name = name;
        this.m_class = classname;
        this.m_dataformat = df;
        this.m_riserType = riserType;
        this.m_bDualY = bDualY;
        this.m_bBipolar = bBipolar;
        this.m_orientation = orientation;
        this.m_scalingMethod = scalingMethod;
        if (!bDualY || !axisDescriptor.hasY2()) {
            // empty if block
        }
        this.m_axisDescriptor = axisDescriptor;
    }

    public int hashCode() {
        return this.m_id;
    }

    public boolean equals(int id) {
        return id == this.m_id;
    }

    public boolean equals(Object x) {
        if (!(x instanceof JGraphType)) {
            return false;
        }
        JGraphType xJGraphType = (JGraphType)x;
        return this.m_id == xJGraphType.m_id;
    }

    public AxisDescriptor getAxisDescriptor() {
        return this.m_axisDescriptor;
    }

    public String getChartClass() {
        return this.m_class;
    }

    public String getChartName() {
        return this.m_name;
    }

    public DataFormat getDataFormat() {
        return this.m_dataformat;
    }

    public int getIntegerGraphType() {
        return this.m_id;
    }

    public static JGraphType getJGraphType(int IntegerGraphType) {
        JGraphType gt = null;
        switch (IntegerGraphType) {
            case 0: {
                gt = JGT_THREED_BAR;
                break;
            }
            case 1: {
                gt = JGT_THREED_PYRAMID;
                break;
            }
            case 2: {
                gt = JGT_THREED_OCTAGON;
                break;
            }
            case 4: {
                gt = JGT_THREED_CUBE;
                break;
            }
            case 5: {
                gt = JGT_THREED_DIAMOND;
                break;
            }
            case 6: {
                gt = JGT_THREED_AREASERIES;
                break;
            }
            case 7: {
                gt = JGT_THREED_RIBBONSERIES;
                break;
            }
            case 9: {
                gt = JGT_THREED_AREAGROUP;
                break;
            }
            case 10: {
                gt = JGT_THREED_RIBBONGROUP;
                break;
            }
            case 12: {
                gt = JGT_THREED_SURFACE;
                break;
            }
            case 13: {
                gt = JGT_THREED_SURFACESIDES;
                break;
            }
            case 14: {
                gt = JGT_THREED_SURFACEHONEYCOMB;
                break;
            }
            case 17: {
                gt = JGT_BARVERT_SIDESIDE;
                break;
            }
            case 97: {
                gt = JGT_COMBOVERT_SIDESIDE;
                break;
            }
            case 18: {
                gt = JGT_BARVERT_STACKED;
                break;
            }
            case 19: {
                gt = JGT_BARVERT_SIDEDUAL;
                break;
            }
            case 98: {
                gt = JGT_COMBOVERT_SIDEDUAL;
                break;
            }
            case 20: {
                gt = JGT_BARVERT_STACKEDDUAL;
                break;
            }
            case 21: {
                gt = JGT_BARVERT_SIDEBIPOLAR;
                break;
            }
            case 22: {
                gt = JGT_BARVERT_STACKEDBIPOLAR;
                break;
            }
            case 23: {
                gt = JGT_BARVERT_PERCENT;
                break;
            }
            case 24: {
                gt = JGT_BARHORIZ_SIDESIDE;
                break;
            }
            case 25: {
                gt = JGT_BARHORIZ_STACKED;
                break;
            }
            case 26: {
                gt = JGT_BARHORIZ_SIDEDUAL;
                break;
            }
            case 27: {
                gt = JGT_BARHORIZ_STACKEDDUAL;
                break;
            }
            case 28: {
                gt = JGT_BARHORIZ_SIDEBIPOLAR;
                break;
            }
            case 29: {
                gt = JGT_BARHORIZ_STACKEDBIPOLAR;
                break;
            }
            case 30: {
                gt = JGT_BARHORIZ_PERCENT;
                break;
            }
            case 31: {
                gt = JGT_AREAVERT_ABS;
                break;
            }
            case 32: {
                gt = JGT_AREAVERT_STACKED;
                break;
            }
            case 33: {
                gt = JGT_AREAVERT_ABSBIPOLAR;
                break;
            }
            case 34: {
                gt = JGT_AREAVERT_STACKEDBIPOLAR;
                break;
            }
            case 35: {
                gt = JGT_AREAVERT_PERCENT;
                break;
            }
            case 36: {
                gt = JGT_AREAHORIZ_ABS;
                break;
            }
            case 37: {
                gt = JGT_AREAHORIZ_STACKED;
                break;
            }
            case 38: {
                gt = JGT_AREAHORIZ_ABSBIPOLAR;
                break;
            }
            case 39: {
                gt = JGT_AREAHORIZ_STACKEDBIPOLAR;
                break;
            }
            case 40: {
                gt = JGT_AREAHORIZ_PERCENT;
                break;
            }
            case 41: {
                gt = JGT_LINEVERT_ABS;
                break;
            }
            case 42: {
                gt = JGT_LINEVERT_STACKED;
                break;
            }
            case 43: {
                gt = JGT_LINEVERT_ABSDUAL;
                break;
            }
            case 44: {
                gt = JGT_LINEVERT_STACKEDDUAL;
                break;
            }
            case 45: {
                gt = JGT_LINEVERT_ABSBIPOLAR;
                break;
            }
            case 46: {
                gt = JGT_LINEVERT_STACKEDBIPOLAR;
                break;
            }
            case 47: {
                gt = JGT_LINEVERT_PERCENT;
                break;
            }
            case 48: {
                gt = JGT_LINEHORIZ_ABS;
                break;
            }
            case 49: {
                gt = JGT_LINEHORIZ_STACKED;
                break;
            }
            case 50: {
                gt = JGT_LINEHORIZ_ABSDUAL;
                break;
            }
            case 51: {
                gt = JGT_LINEHORIZ_STACKEDDUAL;
                break;
            }
            case 52: {
                gt = JGT_LINEHORIZ_ABSBIPOLAR;
                break;
            }
            case 53: {
                gt = JGT_LINEHORIZ_STACKEDBIPOLAR;
                break;
            }
            case 54: {
                gt = JGT_LINEHORIZ_PERCENT;
                break;
            }
            case 55: {
                gt = JGT_PIE;
                break;
            }
            case 56: {
                gt = JGT_PIE_RING;
                break;
            }
            case 57: {
                gt = JGT_PIE_MULT;
                break;
            }
            case 58: {
                gt = JGT_PIE_RINGMULT;
                break;
            }
            case 59: {
                gt = JGT_PIE_MULTPROP;
                break;
            }
            case 60: {
                gt = JGT_PIE_RINGMULTPROP;
                break;
            }
            case 93: {
                gt = JGT_PIE_BAR;
                break;
            }
            case 94: {
                gt = JGT_PIE_BAR_RING;
                break;
            }
            case 100: {
                gt = JGT_FUNNEL;
                break;
            }
            case 61: {
                gt = JGT_SCATTER;
                break;
            }
            case 62: {
                gt = JGT_SCATTER_DUAL;
                break;
            }
            case 63: {
                gt = JGT_SCATTER_LABELS;
                break;
            }
            case 64: {
                gt = JGT_SCATTER_LABELSDUAL;
                break;
            }
            case 65: {
                gt = JGT_POLAR;
                break;
            }
            case 66: {
                gt = JGT_POLAR_DUAL;
                break;
            }
            case 67: {
                gt = JGT_RADAR_LINE;
                break;
            }
            case 68: {
                gt = JGT_RADAR_AREA;
                break;
            }
            case 69: {
                gt = JGT_RADAR_LINE_DUAL;
                break;
            }
            case 73: {
                gt = JGT_STOCKHILO;
                break;
            }
            case 74: {
                gt = JGT_STOCKHILO_DUAL;
                break;
            }
            case 75: {
                gt = JGT_STOCKHILO_BIPOLAR;
                break;
            }
            case 76: {
                gt = JGT_STOCKHILO_CLOSE;
                break;
            }
            case 77: {
                gt = JGT_STOCKHILO_CLOSEDUAL;
                break;
            }
            case 78: {
                gt = JGT_STOCKHILO_CLOSEBIPOLAR;
                break;
            }
            case 79: {
                gt = JGT_STOCKHILO_OPENCLOSE;
                break;
            }
            case 80: {
                gt = JGT_STOCKHILO_OPENCLOSEDUAL;
                break;
            }
            case 81: {
                gt = JGT_STOCKHILO_OPENCLOSEBIPOLAR;
                break;
            }
            case 82: {
                gt = JGT_STOCKHILO_VOLUME;
                break;
            }
            case 88: {
                gt = JGT_STOCKHILO_CLOSE_VOLUME;
                break;
            }
            case 83: {
                gt = JGT_STOCKHILO_OPENCLOSE_VOLUME;
                break;
            }
            case 70: {
                gt = JGT_STOCKHILO_CANDLE;
                break;
            }
            case 71: {
                gt = JGT_STOCKHILO_CANDLE_VOLUME;
                break;
            }
            case 72: {
                gt = JGT_STOCK_CANDLE;
                break;
            }
            case 84: {
                gt = JGT_STOCK_CANDLE_VOLUME;
                break;
            }
            case 101: {
                gt = JGT_BOXPLOT_FIVE_VALUE;
                break;
            }
            case 102: {
                gt = JGT_BOXPLOT_SEVEN_VALUE;
                break;
            }
            case 85: {
                gt = JGT_HIST_VERT;
                break;
            }
            case 86: {
                gt = JGT_HIST_HORIZ;
                break;
            }
            case 87: {
                gt = JGT_SPECTRAL;
                break;
            }
            case 89: {
                gt = JGT_BUBBLE;
                break;
            }
            case 90: {
                gt = JGT_BUBBLE_LABELS;
                break;
            }
            case 91: {
                gt = JGT_BUBBLE_DUAL;
                break;
            }
            case 92: {
                gt = JGT_BUBBLE_LABELSDUAL;
                break;
            }
            case 103: {
                gt = JGT_RESOURCE_RETURN;
                break;
            }
            case 104: {
                gt = JGT_PRODUCT_POSITIONING;
                break;
            }
            case 105: {
                gt = JGT_BALANCED_SCORECARD;
                break;
            }
            case 106: {
                gt = JGT_BREAKEVEN;
                break;
            }
            case 107: {
                gt = JGT_GANTT;
                break;
            }
            case 95: {
                gt = JGT_WATERFALL_VERT;
                break;
            }
            case 111: {
                gt = JGT_WATERFALL_HORZ;
                break;
            }
            case 96: {
                gt = JGT_PARETO;
                break;
            }
            case 108: {
                gt = JGT_BARVERT_SIDESIDE_THREEY;
                break;
            }
            case 109: {
                gt = JGT_BARVERT_SIDESIDE_FOURY;
                break;
            }
            case 110: {
                gt = JGT_BARVERT_SIDESIDE_FIVEY;
                break;
            }
            case 99: {
                gt = JGT_LINE_SELECT_POINT;
            }
        }
        if (gt != null && gt.m_id != IntegerGraphType) {
            PfjAssert.pfjAssert(gt.m_id == IntegerGraphType, "graphtype " + IntegerGraphType + " not found!");
        }
        return gt;
    }

    public int getOrientation() {
        return this.m_orientation;
    }

    public int getRiserType() {
        return this.m_riserType;
    }

    public int getScalingMethod() {
        return this.m_scalingMethod;
    }

    public boolean getCanSwitchDirection() {
        boolean bCanSwitch = false;
        if (this.getAxisDescriptor().hasX1() && this.getAxisDescriptor().hasY1()) {
            bCanSwitch = true;
        }
        return bCanSwitch;
    }

    public int getPreferredResizeDirection() {
        int nPreferred = 1;
        if (this.isOrientHorz()) {
            nPreferred = 0;
        }
        try {
            if (this.getAxisDescriptor().hasX1()) {
                nPreferred = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nPreferred;
    }

    public DataItem getPreferredResizeItem() {
        DataFormat df = this.getDataFormat();
        DataItem item = DataItem.DI_GENERAL;
        try {
            if (this.getAxisDescriptor().hasX1()) {
                item = df.getDataItem(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return item;
    }

    public boolean is3DConnectGroups() {
        return this.getRiserType() == 11;
    }

    public boolean is3DConnectSeries() {
        return this.getRiserType() == 6;
    }

    public boolean is3DFloating() {
        return this.getRiserType() == 5;
    }

    public boolean is3DRiser() {
        return this.getRiserType() == 4;
    }

    public boolean is3DSurface() {
        return this.getRiserType() == 7;
    }

    public boolean is3DRaisedOrigin() {
        return this.is3DFloating() || this.is3DRibbonType();
    }

    public boolean is3DRibbonType() {
        return this.m_id == 7 || this.m_id == 10;
    }

    public boolean is3DType() {
        boolean b3DType = this.m_class.equals(JCHART_3D) || this.m_class.equals(JCHART_3D_SURFACE);
        return b3DType;
    }

    public boolean isBalScore() {
        return this.m_class.equals(JCHART_2D_BALSCORE);
    }

    public boolean isBipolar() {
        return this.m_bBipolar;
    }

    public boolean isDualY() {
        return this.m_bDualY;
    }

    public boolean isThreeY() {
        return this.m_id == 108;
    }

    public boolean isFourY() {
        return this.m_id == 109;
    }

    public boolean isFiveY() {
        return this.m_id == 110;
    }

    public boolean isMultiY() {
        boolean bMultiY = this.isThreeY() || this.isFourY() || this.isFiveY();
        return bMultiY;
    }

    public boolean isExceptionalAllowed() {
        boolean bAllowed = true;
        if (this.isRiserArea() || this.is3DConnectGroups() || this.is3DConnectSeries() || this.is3DSurface()) {
            bAllowed = false;
        } else if (!(!this.isRiserMarker() || this.isScatter() || this.isBubble() || this.isPolar() || this.isSpectralMap())) {
            bAllowed = false;
        }
        if (!this.m_dataformat.equals(DataFormat.DF_GENERAL)) {
            bAllowed = false;
        }
        return bAllowed;
    }

    public boolean isOrientHorz() {
        boolean bHorz = this.m_orientation == 1;
        return bHorz;
    }

    public boolean isPercent() {
        return this.getScalingMethod() == 3;
    }

    public boolean isStacked() {
        return this.getScalingMethod() == 2;
    }

    public boolean isBLAType() {
        return this.m_class.equals(JCHART_2D_BLA) || this.m_class.equals(JCHART_2D_PARETO);
    }

    public boolean isBarType() {
        switch (this.m_id) {
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                return true;
            }
        }
        return false;
    }

    public boolean isVertAreaType() {
        switch (this.m_id) {
            case 31: {
                return true;
            }
        }
        return false;
    }

    public boolean isLAType() {
        switch (this.m_id) {
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return true;
            }
        }
        return false;
    }

    public boolean isLineType() {
        switch (this.m_id) {
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return true;
            }
        }
        return false;
    }

    public boolean isPieType() {
        return this.m_class.equals(JCHART_2D_PIE) || this.m_class.equals(JCHART_2D_PIEBAR);
    }

    public boolean isPieRelated() {
        switch (this.m_id) {
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                return true;
            }
        }
        return false;
    }

    public boolean isRingRelated() {
        switch (this.m_id) {
            case 56: 
            case 58: {
                return true;
            }
        }
        return false;
    }

    public boolean isPieBarType() {
        return this.m_class.equals(JCHART_2D_PIEBAR);
    }

    public boolean isRadarType() {
        return this.m_class.equals(JCHART_2D_RADAR);
    }

    public boolean isResourceReturn() {
        return this.m_class.equals(JCHART_2D_RESOURCE);
    }

    public boolean isWaterfall() {
        return this.m_id == 95 || this.m_id == 111;
    }

    public boolean isFunnelType() {
        return this.m_class.equals(JCHART_2D_FUNNEL);
    }

    public boolean isBoxPlotType() {
        return this.m_class.equals(JCHART_2D_BOXPLOT);
    }

    public boolean isRiserArea() {
        boolean bRiserArea = this.m_riserType == 3;
        return bRiserArea;
    }

    public boolean isRiserBar() {
        boolean bRiserBar = this.m_riserType == 1;
        return bRiserBar;
    }

    public boolean isRiserUnspecified() {
        boolean bRiserBar = this.m_riserType == 0;
        return bRiserBar;
    }

    public boolean isRiserLine() {
        boolean bRiserMarker = this.isRiserMarker();
        return bRiserMarker && (this.isBLAType() || this.isRadarType());
    }

    public boolean isRiserMarker() {
        boolean bRiserMarker = this.m_riserType == 2 || this.m_riserType == 8;
        return bRiserMarker;
    }

    public boolean isScalingAbs() {
        return this.m_scalingMethod == 1;
    }

    public boolean isScalingPercent() {
        return this.m_scalingMethod == 3;
    }

    public boolean isScalingStacked() {
        return this.m_scalingMethod == 2;
    }

    public boolean isScalingWaterfall() {
        return this.m_scalingMethod == 5;
    }

    public boolean isBubble() {
        return this.m_id == 89 || this.m_id == 90 || this.m_id == 91 || this.m_id == 92;
    }

    public boolean isLineSelectPoint() {
        return this.m_id == 99;
    }

    public boolean isSpectralMap() {
        return this.m_id == 87;
    }

    public boolean isPolar() {
        return this.m_id == 65 || this.m_id == 66;
    }

    public boolean isHistogram() {
        return this.m_id == 85 || this.m_id == 86;
    }

    public boolean isHoneyComb() {
        return this.m_id == 14;
    }

    public boolean isSurfaceWithSides() {
        return this.m_id == 13;
    }

    public boolean isThreeDSurface() {
        return this.m_id == 12 || this.m_id == 13 || this.m_id == 14;
    }

    public boolean isScatter() {
        return this.m_id == 61 || this.m_id == 62 || this.m_id == 63 || this.m_id == 64;
    }

    public boolean isScatterWithLabel() {
        return this.m_id == 63 || this.m_id == 64 || this.m_id == 90 || this.m_id == 92;
    }

    public boolean isStockCandleType() {
        return this.m_id == 70 || this.m_id == 71 || this.m_id == 72 || this.m_id == 84;
    }

    public boolean isStockType() {
        return this.m_class.equals(JCHART_2D_HILO);
    }

    public boolean isStockTypeWithVolume() {
        return this.m_class.equals(JCHART_2D_HILO) && (this.m_id == 82 || this.m_id == 88 || this.m_id == 83 || this.m_id == 71 || this.m_id == 84);
    }

    public String toString() {
        return this.m_name;
    }

    public boolean wantDepthEffect() {
        return this.isBLAType() || this.isScatter() || this.isBubble() || this.isPolar() || this.isBalScore();
    }

    public boolean isParetoType() {
        return this.m_class.equals(JCHART_2D_PARETO);
    }

    public boolean isCombo() {
        return this.m_id == 98 || this.m_id == 97;
    }
}

