/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import oracle.dss.graph.GraphConstants;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.DataFormat;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D_Circular;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public class JChart_2D_Radar
extends JChart_2D_Circular {
    private static final long serialVersionUID = 1L;

    @Override
    public void calc() {
        super.calc();
        this.m_Perspective.calcReferenceObjects(1);
        this.m_Perspective.calcAnnotations(GraphConstants.AnnotationLocation.BACK);
        if (this.m_nBaseType == 2) {
            if (this.m_Perspective.getConnectLineMarkers()) {
                this.drawLines(true);
            }
            this.drawMarkers();
        } else {
            this.drawRisers();
        }
        if (this.m_Perspective.getTransparentMarkers()) {
            this.drawTransparentMarkers(2);
        }
        this.drawLabels();
    }

    @Override
    public boolean wantLegend() {
        return true;
    }

    @Override
    protected String processDataTextTemplate(String[] dataItems, String dataTextTemplate) {
        String ResultString = dataItems[0];
        return ResultString;
    }

    protected void drawLabels() {
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        Vector<String> vectStrLabels = null;
        IdentObj id = this.m_Perspective.getDataText();
        DataFormat df = this.m_Access.getDataFormat();
        int nItems = df.getNumDataItems();
        Rectangle rClip = this.m_Perspective.getFrameRect(true);
        if (this.m_bDataTextDisplay) {
            int g;
            int s;
            vectStrLabels = new Vector<String>(this.m_nSeries * this.m_nGroups);
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                gEnum.reset();
                while (gEnum.hasMoreElements()) {
                    g = gEnum.nextGroup();
                    PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                    if (!this.m_dataOK[s][g]) continue;
                    vectStrLabels.addElement(this.m_DataLabel[s][g]);
                }
            }
            Dimension labelDim = new Dimension(5000, 1600);
            boolean bScatLabelFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(id);
            TextStyleObj textStyle = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(id), this.m_Perspective.getFontStyle(id), bScatLabelFontSizeAbsolute, this.m_Perspective.getFontSize(id), this.m_Perspective.getFontSizeVC(id), this.m_Perspective.getTextRotation(id), this.m_Perspective.getTextJustHoriz(id), this.m_Perspective.getTextJustVert(id), false, false, this.m_Perspective.getTextWrap(id), this.m_Perspective.getLocale());
            int nFontSizeVC = bScatLabelFontSizeAbsolute ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(id)) : this.m_Perspective.getFontSizeVC(id);
            Graphics gx = this.m_Perspective.getGraphicsContext();
            textStyle.formatAndAutofit(gx, this.m_Perspective, this.m_Perspective.getAutofit(new IdentObj(260, -3, -3)), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), nFontSizeVC, vectStrLabels, labelDim, this.m_Perspective.m_VC);
            sEnum.reset();
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                gEnum.reset();
                while (gEnum.hasMoreElements()) {
                    g = gEnum.nextGroup();
                    PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                    this.m_DataLabel[s][g] = this.m_Perspective.getCustomDataText(this.m_DataLabel[s][g], new IdentObj(id.getObjectID(), s, g));
                    if (!this.m_dataOK[s][g] || this.m_DataLabel[s][g] == null) continue;
                    BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
                    Rectangle rLabel = this.calcDataValuePosition(s, g, labelDim);
                    if (rLabel == null) continue;
                    IdentObj newID = new IdentObj(id.getObjectID(), s, g);
                    new DetLabel(this.m_Detectiv, newID, this.m_DataLabel[s][g], rLabel, textStyle, (BlackBoxIF)blackBox, false, rClip);
                }
            }
        }
    }

    @Override
    protected Rectangle calcDataValuePosition(int s, int g, Dimension labelDim) {
        int width = labelDim.width;
        int height = labelDim.height;
        int x1 = this.m_numXCoords[s][g];
        int y1 = this.m_numYCoords[s][g];
        Rectangle rDataValue = new Rectangle(x1, y1, width, height);
        return rDataValue;
    }

    @Override
    protected void drawLines(boolean bCircular) {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        int g = 0;
        int nWidth = 0;
        int nStyle = 0;
        boolean bCloseCircularLines = false;
        while (sEnum.hasMoreElements()) {
            Point pt2;
            Point pt1;
            BlackBoxIF blackBox;
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            if (this.m_seriesTypes[s] != 2) continue;
            IdentObj idSeries = new IdentObj(-3, s);
            nWidth = this.m_Perspective.getLineWidth(idSeries);
            if (nWidth == (Integer)Attr.SeriesLineWidthDefault.getDefault()) {
                int nWidthVert = this.m_Perspective.updateMargin(nWidth, true);
                int nWidthHoriz = this.m_Perspective.updateMargin(nWidth, false);
                nWidth = Math.min(nWidthVert, nWidthHoriz);
            }
            nStyle = this.m_Perspective.getLineStyle(idSeries);
            gEnum.reset();
            if (gEnum.hasMoreElements()) {
                bCloseCircularLines = true;
            }
            while (gEnum.hasMoreElements()) {
                g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                if (!gEnum.hasMoreElements()) continue;
                int gNext = gEnum.peekAtNextGroup();
                if (this.m_Perspective.isTimeAxis()) {
                    if (this.m_Perspective.getDateFrequency() == 3 && !this.m_dataOK[s][gNext]) {
                        while (gEnum.hasMoreElements() && !this.m_dataOK[s][gNext]) {
                            gNext = gEnum.nextGroup();
                            gNext = gEnum.peekAtNextGroup();
                        }
                    }
                }
                PfjAssert.pfjAssert(gNext >= 0 && gNext < this.m_nTotalGroups);
                if (!this.m_dataOK[s][g] || !this.m_dataOK[s][gNext]) continue;
                blackBox = this.assignSeriesColor(s, g);
                blackBox = blackBox.runRules(s, -3);
                blackBox.setTransparentBorderColor(false);
                if (blackBox.getFillColor() != null) {
                    blackBox.setBorderColor(blackBox.getFillColor());
                }
                pt1 = this.getCoords(s, g);
                pt2 = this.getCoords(s, gNext);
                boolean bDrawNormal = true;
                if (this.m_nFillMissingData != 0) {
                    boolean bFilledMissingData = this.m_Access.m_DataStorage.isMissingDataFilledIn(s, g);
                    int nNumSegments = this.m_Perspective.getNumMissingDataSegments();
                    if (bFilledMissingData && nNumSegments != 0) {
                        this.drawMissingLineData(nNumSegments, pt1, pt2, s, g, blackBox, nWidth, nStyle);
                        bDrawNormal = false;
                    }
                }
                if (!bDrawNormal || blackBox.getTransparentFillColor()) continue;
                new DetLine(this.m_Detectiv, new IdentObj(258, s, g), pt1.x, pt1.y, pt2.x, pt2.y, blackBox, null, nWidth, nStyle);
            }
            if (!bCircular || !this.m_dataOK[s][0] || !this.m_dataOK[s][g] || !bCloseCircularLines) continue;
            pt1 = this.getCoords(s, g);
            pt2 = this.getCoords(s, 0);
            blackBox = this.assignSeriesColor(s, g);
            if ((blackBox = blackBox.runRules(s, -3)).getFillColor() != null) {
                blackBox.setBorderColor(blackBox.getFillColor());
            }
            if (blackBox.getTransparentFillColor()) continue;
            new DetLine(this.m_Detectiv, new IdentObj(258, s, g), pt1.x, pt1.y, pt2.x, pt2.y, blackBox, null, nWidth, nStyle);
        }
    }
}

