/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.util.Iterator;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.KeyMap;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRInterface;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.javatools.annotations.Concealed;

public abstract class GraphContext {
    protected CommonGraph m_CommonGraph;

    public GraphContext(CommonGraph graph) {
        this.m_CommonGraph = graph;
    }

    protected KeyMap getKeyMap(int edge, int slice) {
        DataAccess dataAccess = this.m_CommonGraph.getDataAccess();
        KeyMap graphKey = new KeyMap();
        try {
            int layers = dataAccess.getLayerCount(edge);
            for (int i = 0; i < layers; ++i) {
                String key = dataAccess.getLayerMetadata(edge, i, "layerName").toString();
                Object value = dataAccess.getMemberMetadata(edge, i, slice, "valueRaw");
                if (value == null) {
                    value = dataAccess.getMemberMetadata(edge, i, slice, "value");
                }
                if (value != null) {
                    graphKey.put(key, value.toString());
                    continue;
                }
                graphKey.put(key, null);
            }
        }
        catch (Exception e) {
            return null;
        }
        return graphKey;
    }

    @Concealed
    protected int getSliceIndexFromAttributes(KeyMap attributes, int edge) {
        if (attributes == null || edge != 0 && edge != 1) {
            return -1;
        }
        QDR qdr = new QDR();
        Iterator iter = attributes.keySet().iterator();
        while (iter.hasNext()) {
            String dim = ((String)iter.next()).toString();
            String mem = attributes.get(dim);
            qdr.addDimMemberPair(dim, mem);
        }
        int slice = -1;
        try {
            slice = GraphContext.getSliceFromQdr(this.m_CommonGraph.getDataAccess(), qdr, edge, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return slice;
    }

    public static int getSliceFromQdr(DataAccess da, QDR sliceQDR, int edge, int[] startSlices, int[] endSlices) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        int slice;
        block2: {
            block1: {
                slice = -1;
                int[] slices = da.getSlicesFromQDR((QDRInterface)sliceQDR, startSlices, endSlices);
                if (slices == null) break block1;
                if (slices[edge] < 0) break block2;
                slice = slices[edge];
                break block2;
            }
            int startSlice = startSlices == null ? 0 : startSlices[edge];
            int endSlice = endSlices == null ? da.getEdgeExtent(edge) - 1 : endSlices[edge];
            for (int i = startSlice; i <= endSlice; ++i) {
                if (!sliceQDR.equals(da.getSliceQDR(edge, i, 0))) continue;
                slice = i;
                break;
            }
        }
        return slice;
    }
}

