/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.FontMetrics;
import java.util.Enumeration;
import java.util.Vector;
import oracle.dss.graph.pfj.FunnelSliceLabelContainer;
import oracle.dss.graph.pfj.FunnelStageLabelContainer;
import oracle.dss.graph.pfj.JChart_2D_Funnel;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.presutil.FontMetricsResolver;

public class FunnelLabelContainer {
    private FunnelSliceLabelContainer funnelSliceLabelContainer;
    private FunnelStageLabelContainer funnelStageLabelContainer;

    public FunnelLabelContainer(Perspective m_perspective, JChart_2D_Funnel m_chart) {
        this.funnelSliceLabelContainer = new FunnelSliceLabelContainer(m_perspective, m_chart);
        this.funnelStageLabelContainer = new FunnelStageLabelContainer(m_perspective, m_chart);
    }

    public Vector[] getLabels() {
        Vector[] labels = new Vector[]{this.funnelSliceLabelContainer.getLabels(), this.funnelStageLabelContainer.getLabels()};
        return labels;
    }

    public FunnelSliceLabelContainer getFunnelSliceLabelContainer() {
        return this.funnelSliceLabelContainer;
    }

    public FunnelStageLabelContainer getFunnelStageLabelContainer() {
        return this.funnelStageLabelContainer;
    }

    public static int getMaxWidth(FontMetrics fm, Vector labels, FontMetricsResolver fmr) {
        int maxWidth = 0;
        int width = 0;
        String label = null;
        Enumeration enumerator = labels.elements();
        while (enumerator.hasMoreElements()) {
            label = (String)enumerator.nextElement();
            width = FunnelLabelContainer.getWidth(fm, label, fmr);
            if (maxWidth >= width) continue;
            maxWidth = width;
        }
        return maxWidth;
    }

    public static int getWidth(FontMetrics fm, String label, FontMetricsResolver fmr) {
        return fmr.stringWidth(label, fm);
    }

    public static double getHeightFactor(double theta) {
        double radTheta = Math.toRadians(theta);
        double factor = 0.0;
        if (theta >= 0.0 && theta < 90.0) {
            factor = Math.sin(radTheta);
        } else if (theta >= 90.0 && theta < 180.0) {
            factor = Math.sin(Math.PI - radTheta);
        } else if (theta >= 180.0 && theta < 270.0) {
            factor = Math.cos(0.0 - radTheta);
        } else if (theta >= 270.0 && theta <= 360.0) {
            factor = Math.sin(Math.PI * 2 - radTheta);
        }
        return factor;
    }
}

