/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.util.ArrayList;
import java.util.List;
import oracle.dss.dataView.BoxPlotDataComponentHandle;
import oracle.dss.dataView.BubbleDataComponentHandle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.GroupComponentHandle;
import oracle.dss.dataView.ScatterDataComponentHandle;
import oracle.dss.dataView.SeriesComponentHandle;
import oracle.dss.dataView.StockDataComponentHandle;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.DataFilterImpl;
import oracle.dss.graph.DataType;
import oracle.dss.graph.KeyMap;
import oracle.dss.graph.pfj.GraphContext;

public class DataContext
extends GraphContext {
    KeyMap m_SeriesKeys;
    List<KeyMap> m_GroupKeys;
    ComponentHandle m_ComponentHandle;

    public DataContext(CommonGraph graph, int seriesIndex, int groupIndex) {
        super(graph);
        if (DataContext.isValidSeries(seriesIndex)) {
            this.m_SeriesKeys = this.getKeyMap(graph.isDataRowShownAsASeries() ? 1 : 0, seriesIndex);
        }
        if (DataContext.isValidGroup(groupIndex)) {
            this.m_GroupKeys = new ArrayList<KeyMap>();
            int columnIndex = groupIndex;
            for (int i = 0; i < this.m_CommonGraph.getPFJ().getNumColumnsInGroup(); ++i) {
                KeyMap keyMap = this.getKeyMap(graph.isDataRowShownAsASeries() ? 0 : 1, columnIndex);
                this.m_GroupKeys.add(keyMap);
                ++columnIndex;
            }
        }
        if (this.m_CommonGraph != null && seriesIndex >= 0 && groupIndex >= 0) {
            this.constructComponentHandle(seriesIndex, groupIndex);
        }
    }

    public DataContext(CommonGraph graph, KeyMap seriesKeys, List<KeyMap> groupKeys) {
        super(graph);
        this.m_SeriesKeys = seriesKeys;
        this.m_GroupKeys = groupKeys;
        if (this.m_CommonGraph != null && this.m_SeriesKeys != null && this.m_GroupKeys != null) {
            this.constructComponentHandle(this.getSeriesIndex(), this.getGroupIndex());
        }
    }

    public static ComponentHandle constructStockDataComponentHandle(CommonGraph commonGraph, int id, String name, Object comp, int row, int column, int groupIndex, int seriesIndex) {
        int graphCat = DataFilterImpl.getGraphCategory(commonGraph.getGraphType());
        int o = -1;
        int h = -1;
        int l = -1;
        int c = -1;
        int v = -1;
        switch (graphCat) {
            case 4: {
                o = 0;
                h = 1;
                l = 2;
                c = 3;
                v = 4;
                break;
            }
            case 5: {
                o = 0;
                h = 1;
                l = 2;
                c = 3;
                break;
            }
            case 6: {
                h = 0;
                l = 1;
                v = 2;
                break;
            }
            case 7: {
                o = 0;
                c = 1;
                v = 2;
                break;
            }
            case 8: {
                o = 0;
                c = 1;
                break;
            }
            case 9: {
                h = 0;
                l = 1;
                break;
            }
            case 10: {
                h = 0;
                l = 1;
                c = 2;
                break;
            }
            case 11: {
                h = 0;
                l = 1;
                c = 2;
                v = 3;
            }
        }
        return new StockDataComponentHandle(id, name, comp, row, column, groupIndex, seriesIndex, o, h, l, c, v);
    }

    public static ComponentHandle constructComponentHandle(CommonGraph commonGraph, int id, String name, Object comp, int seriesIndex, int groupIndex) {
        boolean seriesAreRows = commonGraph.isDataRowShownAsASeries();
        ComponentHandle componentHandle = null;
        if (DataContext.isValidSeries(seriesIndex) && DataContext.isValidGroup(groupIndex)) {
            int pfjRow = seriesAreRows ? seriesIndex : groupIndex * commonGraph.getPFJ().getNumColumnsInGroup();
            int pfjColumn = seriesAreRows ? groupIndex * commonGraph.getPFJ().getNumColumnsInGroup() : seriesIndex;
            int row = commonGraph.getPFJ().getDataGridCallback().getDataAccessRow(pfjRow, pfjColumn);
            int column = commonGraph.getPFJ().getDataGridCallback().getDataAccessColumn(pfjRow, pfjColumn);
            componentHandle = commonGraph.getPFJ().isChartScatter() ? new ScatterDataComponentHandle(id, name, comp, row, column, groupIndex, seriesIndex) : (commonGraph.getPFJ().isChartBubble() ? new BubbleDataComponentHandle(id, name, comp, row, column, groupIndex, seriesIndex) : (commonGraph.getPFJ().isChartStockType() ? DataContext.constructStockDataComponentHandle(commonGraph, id, name, comp, row, column, groupIndex, seriesIndex) : (commonGraph.getPFJ().isBoxPlotType() ? (commonGraph.getGraphType() == 101 ? new BoxPlotDataComponentHandle(id, name, comp, row, column, groupIndex, seriesIndex, 0, -1, 1, 2, 3, -1, 4) : new BoxPlotDataComponentHandle(id, name, comp, row, column, groupIndex, seriesIndex, 0, 1, 2, 3, 4, 5, 6)) : new DataComponentHandle(id, name, comp, row, column, groupIndex, seriesIndex))));
        } else if (!DataContext.isValidSeries(seriesIndex) && DataContext.isValidGroup(groupIndex)) {
            componentHandle = new GroupComponentHandle(id, name, comp, groupIndex);
        } else if (DataContext.isValidSeries(seriesIndex) && !DataContext.isValidGroup(groupIndex)) {
            componentHandle = new SeriesComponentHandle(id, name, comp, seriesIndex);
        }
        if (componentHandle != null) {
            componentHandle.setDataAccess(commonGraph.getDataAccess());
            if (componentHandle instanceof DataComponentHandle) {
                DataComponentHandle dataComponentHandle = (DataComponentHandle)componentHandle;
                dataComponentHandle.setSeriesAreRows(seriesAreRows);
            }
        }
        return componentHandle;
    }

    private void constructComponentHandle(int seriesIndex, int groupIndex) {
        this.m_ComponentHandle = DataContext.constructComponentHandle(this.m_CommonGraph, 0, "", null, seriesIndex, groupIndex);
    }

    public KeyMap getSeriesKey() {
        return this.m_SeriesKeys;
    }

    public int getSeriesIndex() {
        if (this.m_SeriesKeys == null || this.m_CommonGraph == null) {
            return -1;
        }
        return this.getSliceIndexFromAttributes(this.m_SeriesKeys, this.m_CommonGraph.isDataRowShownAsASeries() ? 1 : 0);
    }

    public String getSeriesId() {
        int index = this.getSeriesIndex();
        if (index >= 0) {
            return this.m_CommonGraph.getPFJ().getDataGridCallback().getSeriesSliceId(index);
        }
        return null;
    }

    public List<KeyMap> getGroupKeys() {
        return this.m_GroupKeys;
    }

    public int getGroupIndex() {
        if (this.m_GroupKeys == null || this.m_CommonGraph == null) {
            return -1;
        }
        int slice = this.getSliceIndexFromAttributes(this.m_GroupKeys.get(0), this.m_CommonGraph.isDataRowShownAsASeries() ? 0 : 1);
        if (slice >= 0) {
            return slice / this.m_CommonGraph.getPFJ().getNumColumnsInGroup();
        }
        return slice;
    }

    public String getGroupId() {
        int index = this.getGroupIndex();
        if (index >= 0) {
            return this.m_CommonGraph.getPFJ().getDataGridCallback().getGroupSliceId(index);
        }
        return null;
    }

    public Object getDataValue(DataType type) {
        if (this.m_ComponentHandle instanceof ScatterDataComponentHandle) {
            ScatterDataComponentHandle scatterHandle = (ScatterDataComponentHandle)this.m_ComponentHandle;
            if (type == DataType.X_VALUE) {
                return scatterHandle.getXValue("dataValue");
            }
            if (type == DataType.Y_VALUE) {
                return scatterHandle.getYValue("dataValue");
            }
            if (type == DataType.Z_VALUE && this.m_ComponentHandle instanceof BubbleDataComponentHandle) {
                return ((BubbleDataComponentHandle)this.m_ComponentHandle).getZValue("dataValue");
            }
        } else if (this.m_ComponentHandle instanceof StockDataComponentHandle) {
            StockDataComponentHandle stockHandle = (StockDataComponentHandle)this.m_ComponentHandle;
            if (type == DataType.CLOSE_VALUE) {
                return stockHandle.getCloseValue("dataValue");
            }
            if (type == DataType.OPEN_VALUE) {
                return stockHandle.getOpenValue("dataValue");
            }
            if (type == DataType.LOW_VALUE) {
                return stockHandle.getLowValue("dataValue");
            }
            if (type == DataType.HIGH_VALUE) {
                return stockHandle.getHighValue("dataValue");
            }
            if (type == DataType.VOLUME_VALUE) {
                return stockHandle.getVolumeValue("dataValue");
            }
        } else if (this.m_ComponentHandle instanceof BoxPlotDataComponentHandle) {
            BoxPlotDataComponentHandle boxHandle = (BoxPlotDataComponentHandle)this.m_ComponentHandle;
            if (type == DataType.MIN_VALUE) {
                return boxHandle.getMinValue("dataValue");
            }
            if (type == DataType.TEN_VALUE) {
                return boxHandle.getTenValue("dataValue");
            }
            if (type == DataType.Q1_VALUE) {
                return boxHandle.getQ1Value("dataValue");
            }
            if (type == DataType.MEDIAN_VALUE) {
                return boxHandle.getMedianValue("dataValue");
            }
            if (type == DataType.Q3_VALUE) {
                return boxHandle.getQ3Value("dataValue");
            }
            if (type == DataType.NINETY_VALUE) {
                return boxHandle.getNinetyValue("dataValue");
            }
            if (type == DataType.MAX_VALUE) {
                return boxHandle.getMaxValue("dataValue");
            }
        } else if (this.m_ComponentHandle instanceof DataComponentHandle && type == DataType.DEFAULT_VALUE) {
            return ((DataComponentHandle)this.m_ComponentHandle).getValue("dataValue");
        }
        return null;
    }

    private static boolean isValidSeries(int index) {
        return index >= 0;
    }

    private static boolean isValidGroup(int index) {
        return index >= 0;
    }
}

