/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.PFJ;
import oracle.dss.presutil.PresUtils;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public class Scrollbar {
    private PFJ m_pfj;
    private CommonGraph m_graph;
    private static final int NORMAL = 0;
    private static final int HOVER = 1;
    private static final int ACTIVE = 2;

    @Concealed
    public Scrollbar(CommonGraph graph) {
        this.m_pfj = graph.getPFJ();
        this.m_graph = graph;
    }

    public void resetStyle() {
    }

    protected ObjectNode getXML(boolean allProperties) {
        ObjectNode node = new ObjectNode(this.getComponentName());
        return this.getXML(allProperties, node) ? node : null;
    }

    protected boolean getXML(boolean allProperties, ObjectNode node) {
        boolean overallStyleOverridden = false;
        boolean styleOverridden = false;
        Color normal = this.getThemeColor();
        Color hover = this.getThemeHoverColor();
        Color active = this.getThemeActiveColor();
        if (normal != null || hover != null || active != null || allProperties) {
            if (normal != null || allProperties) {
                node.addProperty("normalColor", PresUtils.toHexStringWithAlpha(normal.getRGB()));
                styleOverridden = true;
            }
            if (hover != null || allProperties) {
                node.addProperty("hoverColor", PresUtils.toHexStringWithAlpha(normal.getRGB()));
                styleOverridden = true;
            }
            if (active != null || allProperties) {
                node.addProperty("activeColor", PresUtils.toHexStringWithAlpha(normal.getRGB()));
                styleOverridden = true;
            }
        }
        return overallStyleOverridden;
    }

    protected void setXML(ObjectNode node) {
        PropertyNode pNode = node.getProperty("normalColor");
        if (pNode != null) {
            this.setThemeColor(new Color(PresUtils.hexStringWithAlphaToInt(pNode.getValueAsString()), true));
        }
        if ((pNode = node.getProperty("hoverColor")) != null) {
            this.setThemeHoverColor(new Color(PresUtils.hexStringWithAlphaToInt(pNode.getValueAsString()), true));
        }
        if ((pNode = node.getProperty("activeColor")) != null) {
            this.setThemeActiveColor(new Color(PresUtils.hexStringWithAlphaToInt(pNode.getValueAsString()), true));
        }
    }

    public void setThemeColor(Color color) {
        this.m_pfj.setFillColor(this.m_pfj.getRangeSliderTheme(0), color);
    }

    public void setThemeHoverColor(Color color) {
        this.m_pfj.setFillColor(this.m_pfj.getRangeSliderTheme(1), color);
    }

    public void setThemeActiveColor(Color color) {
        this.m_pfj.setFillColor(this.m_pfj.getRangeSliderTheme(2), color);
    }

    public Color getThemeColor() {
        return this.m_pfj.getFillColor(this.m_pfj.getRangeSliderTheme(0));
    }

    public Color getThemeHoverColor() {
        return this.m_pfj.getFillColor(this.m_pfj.getRangeSliderTheme(1));
    }

    public Color getThemeActiveColor() {
        return this.m_pfj.getFillColor(this.m_pfj.getRangeSliderTheme(2));
    }

    @Concealed
    private String getComponentName() {
        return "Scrollbar";
    }
}

