/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.dataView.LocalXMLDataSource;
import oracle.dss.dataView.ModelAdapter;
import oracle.dss.dataView.ThickDataview;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.GraphFormatManager;
import oracle.dss.graph.GraphModel;
import oracle.dss.graph.GraphStyleManager;
import oracle.dss.graph.managers.GraphRuleFormatter;
import oracle.dss.graph.managers.GraphRuleStyles;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataMap;
import oracle.dss.util.DataSource;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.TypeNotSupportedException;
import oracle.javatools.annotations.Concealed;

@Concealed
public class GraphModelAdapter
extends ModelAdapter
implements GraphModel {
    private static final long serialVersionUID = 1L;
    protected Graph m_graphView;
    protected GraphFormatManager m_graphFormatManager = null;
    protected GraphStyleManager m_graphStyleManager = null;
    private static final String m_method_setsupporteddatalayerflags = "setSupportedDataLayerFlags ()";

    public GraphModelAdapter(Graph graphView) {
        this.m_graphView = graphView;
        ThickDataview view = this.m_graphView.getCommonGraph().getThickDataview();
        this.setGraphFormatManager(new GraphRuleFormatter(view != null));
        this.setGraphStyleManager(new GraphRuleStyles());
        this.initDefaults(new GraphDefaultValues());
    }

    public GraphModelAdapter(Graph graphView, DataSource dataSource) {
        super.setDataSource(dataSource);
        this.m_graphView = graphView;
        ThickDataview view = this.m_graphView.getCommonGraph().getThickDataview();
        this.setGraphFormatManager(new GraphRuleFormatter(view != null));
        this.setGraphStyleManager(new GraphRuleStyles());
        this.initDefaults(new GraphDefaultValues());
    }

    protected void initDefaults(GraphDefaultValues gdv) {
        super.initDefaults(gdv);
    }

    @Override
    public void setDataSource(DataSource ds) {
        if (ds == null) {
            super.setDataSource(new LocalXMLDataSource(new String[0], new String[0], new Double[0][0]));
        } else {
            super.setDataSource(ds);
        }
        if (this.dataDirectorFactory != null) {
            this.setDataDirector((DataDirector)this.dataDirectorFactory.createCubeDataDirector());
        }
    }

    @Override
    protected void setSupportedDataLayerFlags() {
        DataMap dataMap = this.getDataDirector().getSupportedDataMap();
        MetadataMap metaMap = this.getDataDirector().getSupportedMetadataMap();
        LayerMetadataMap layerMap = this.getDataDirector().getSupportedLayerMetadataMap();
        boolean typeSupported = false;
        if (dataMap == null) {
            this.m_graphView.getErrorHandler().trace("Current DataSource has a null DataMap", this.getClass().getName(), m_method_setsupporteddatalayerflags);
        }
        if (metaMap == null) {
            this.m_graphView.getErrorHandler().trace("Current DataSource has a null MetadataMap", this.getClass().getName(), m_method_setsupporteddatalayerflags);
        }
        if (layerMap == null) {
            this.m_graphView.getErrorHandler().trace("Current DataSource has a null LayerMetadataMap", this.getClass().getName(), m_method_setsupporteddatalayerflags);
        }
        if (!(typeSupported = dataMap != null ? dataMap.contains((Object)"dataValue") : false)) {
            this.m_graphView.getErrorHandler().error((Throwable)new TypeNotSupportedException("DataMap", "DATA_UNFORMATTED"), this.getClass().getName(), m_method_setsupporteddatalayerflags);
        }
        this.m_graphView.setDataUnformattedSupported(true);
        typeSupported = metaMap != null ? metaMap.contains((Object)"label") : false;
        if (!typeSupported) {
            this.m_graphView.getErrorHandler().error((Throwable)new TypeNotSupportedException("MetadataMap", "METADATA_LONGLABEL"), this.getClass().getName(), m_method_setsupporteddatalayerflags);
        }
        this.m_graphView.setMetadataLongLabelSupported(true);
        if (metaMap != null) {
            typeSupported = metaMap.contains((Object)"drillState");
        }
        this.m_graphView.setMetadataDrillSupported(typeSupported);
        typeSupported = metaMap != null ? metaMap.contains((Object)"mediumName") : false;
        this.m_graphView.setMetadataMediumLabelSupported(typeSupported);
        typeSupported = metaMap != null ? metaMap.contains((Object)"shortName") : false;
        this.m_graphView.setMetadataShortLabelSupported(typeSupported);
        typeSupported = metaMap != null ? metaMap.contains((Object)"viewStyle") : false;
        this.m_graphView.setMetadataViewStyleSupported(typeSupported);
        typeSupported = metaMap != null ? metaMap.contains((Object)"date") : false;
        this.m_graphView.setMetadataDateSupported(typeSupported);
        typeSupported = metaMap != null ? metaMap.contains((Object)"drillParentDate") : false;
        this.m_graphView.setMetadataDrillParentDateSupported(typeSupported);
        typeSupported = metaMap != null ? metaMap.contains((Object)"drillParentDateSpan") : false;
        this.m_graphView.setMetadataDrillParentDateSpanSupported(typeSupported);
        typeSupported = metaMap != null ? metaMap.contains((Object)"dateSpan") : false;
        this.m_graphView.setMetadataDateSpanSupported(typeSupported);
        typeSupported = metaMap != null ? metaMap.contains((Object)"value") : false;
        this.m_graphView.setMetadataValueSupported(typeSupported);
        typeSupported = layerMap != null ? layerMap.contains((Object)"dimShortName") : false;
        this.m_graphView.setLayerMetaShortLabelSupported(typeSupported);
        typeSupported = layerMap != null ? layerMap.contains((Object)"dimMediumName") : false;
        this.m_graphView.setLayerMetaMediumLabelSupported(typeSupported);
        typeSupported = layerMap != null ? layerMap.contains((Object)"layerLabel") : false;
        this.m_graphView.setLayerMetaLongLabelSupported(typeSupported);
        typeSupported = layerMap != null ? layerMap.contains((Object)"layerName") : false;
        this.m_graphView.setLayerMetaNameSupported(typeSupported);
        typeSupported = layerMap != null ? layerMap.contains((Object)"viewStyle") : false;
        this.m_graphView.setLayerMetaViewStyleSupported(typeSupported);
    }

    @Override
    @Concealed
    public DataMap getDataMap() {
        return new DataMap("dataValue");
    }

    @Override
    @Concealed
    public MetadataMap getMetadataMap(int edge) {
        String[] types = new String[]{"label", "mediumName", "shortName", "viewStyle", "value", "date", "dateSpan", "drillState", "drillParentDate", "drillParentDateSpan"};
        return new MetadataMap(types);
    }

    @Override
    @Concealed
    public LayerMetadataMap getLayerMetadataMap(int edge) {
        String[] types = new String[]{"layerLabel", "dimMediumName", "dimShortName", "layerName", "viewStyle"};
        return new LayerMetadataMap(types);
    }

    @Override
    public GraphFormatManager getGraphFormatManager() {
        return this.m_graphFormatManager;
    }

    @Override
    public void setGraphFormatManager(GraphFormatManager m) {
        super.setFormatManager(m);
        this.m_graphFormatManager = m;
    }

    @Override
    public GraphStyleManager getGraphStyleManager() {
        return this.m_graphStyleManager;
    }

    @Override
    public void setGraphStyleManager(GraphStyleManager m) {
        this.m_graphStyleManager = m;
    }

    @Override
    public Graph getGraphView() {
        return this.m_graphView;
    }
}

